/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

class ChunkBuffer
extends DataOutputStream {
    final ByteArrayOutputStream buffer;
    final CRC32 crc;

    ChunkBuffer(int initialSize) {
        this(new ByteArrayOutputStream(initialSize), new CRC32());
    }

    private ChunkBuffer(ByteArrayOutputStream buffer, CRC32 crc) {
        super(new CheckedOutputStream(buffer, crc));
        this.buffer = buffer;
        this.crc = crc;
    }

    public void endChunk(DataOutputStream target) throws IOException {
        this.flush();
        target.writeInt(this.buffer.size() - 4);
        this.buffer.writeTo(target);
        target.writeInt((int)this.crc.getValue());
        this.buffer.reset();
        this.crc.reset();
    }
}

