/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.anim8.FastPalette;
import com.github.tommyettinger.anim8.PNG8;
import java.io.OutputStream;

public class FastPNG8
extends PNG8 {
    public FastPNG8() {
        this(16384);
    }

    public FastPNG8(int initialBufferSize) {
        super(initialBufferSize);
        this.setCompression(2);
    }

    @Override
    public void write(OutputStream output, Pixmap pixmap, boolean computePalette, boolean dither, int threshold) {
        boolean clearPalette;
        boolean bl = clearPalette = this.palette == null;
        if (clearPalette) {
            this.palette = new FastPalette(pixmap, (double)threshold);
        } else if (computePalette) {
            this.palette.analyze(pixmap, (double)threshold);
        }
        this.palette.setDitherStrength(this.ditherStrength);
        if (dither) {
            this.writeDithered(output, pixmap);
        } else {
            this.writeSolid(output, pixmap);
        }
        if (clearPalette) {
            this.palette = null;
        }
    }

    @Override
    public void write(OutputStream output, Array<Pixmap> frames, int fps, boolean dither) {
        boolean clearPalette = this.palette == null;
        if (clearPalette) {
            this.palette = new FastPalette(frames);
        }
        this.palette.setDitherStrength(this.ditherStrength);
        if (dither) {
            this.write(output, frames, fps);
        } else {
            this.writeSolid(output, frames, fps);
        }
        if (clearPalette) {
            this.palette = null;
        }
    }
}

