/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.anim8.ConstantData;
import com.github.tommyettinger.anim8.PaletteReducer;

public class FastPalette
extends PaletteReducer {
    public FastPalette() {
        this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
    }

    public FastPalette(int[] rgbaPalette) {
        if (rgbaPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(rgbaPalette);
    }

    public FastPalette(int[] rgbaPalette, int limit) {
        if (rgbaPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(rgbaPalette, limit);
    }

    public FastPalette(Color[] colorPalette) {
        if (colorPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(colorPalette);
    }

    public FastPalette(Color[] colorPalette, int limit) {
        if (colorPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(colorPalette, limit);
    }

    public FastPalette(Pixmap pixmap) {
        if (pixmap == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.analyze(pixmap);
    }

    public FastPalette(Array<Pixmap> pixmaps) {
        if (pixmaps == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.analyze(pixmaps);
    }

    public FastPalette(int[] palette, byte[] preload) {
        this.exact(palette, preload);
    }

    public FastPalette(Pixmap pixmap, double threshold) {
        this.analyze(pixmap, threshold);
    }

    @Override
    public double differenceMatch(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    @Override
    public double differenceAnalyzing(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    @Override
    public double differenceHW(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceHW(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    @Override
    public double differenceMatch(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    @Override
    public double differenceAnalyzing(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    @Override
    public double differenceHW(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceHW(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    @Override
    public double differenceMatch(int r1, int g1, int b1, int r2, int g2, int b2) {
        return this.difference(r1, g1, b1, r2, g2, b2);
    }

    @Override
    public double differenceAnalyzing(int r1, int g1, int b1, int r2, int g2, int b2) {
        return this.difference(r1, g1, b1, r2, g2, b2);
    }

    @Override
    public double differenceHW(int r1, int g1, int b1, int r2, int g2, int b2) {
        return this.difference(r1, g1, b1, r2, g2, b2);
    }

    public double difference(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.difference(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double difference(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.difference(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double difference(int r1, int g1, int b1, int r2, int g2, int b2) {
        int rf = r1 - r2;
        int gf = g1 - g2;
        int bf = b1 - b2;
        return rf * rf + gf * gf + bf * bf;
    }
}

