/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.StreamUtils;
import com.github.tommyettinger.anim8.AnimationWriter;
import com.github.tommyettinger.anim8.ChunkBuffer;
import com.github.tommyettinger.anim8.Dithered;
import com.github.tommyettinger.anim8.OtherMath;
import com.github.tommyettinger.anim8.PaletteReducer;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNG8
implements AnimationWriter,
Dithered,
Disposable {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int PLTE = 1347179589;
    private static final int TRNS = 1951551059;
    private static final int acTL = 1633899596;
    private static final int fcTL = 1717785676;
    private static final int fdAT = 1717846356;
    private static final byte COLOR_INDEXED = 3;
    private static final byte COMPRESSION_DEFLATE = 0;
    private static final byte INTERLACE_NONE = 0;
    private static final byte FILTER_NONE = 0;
    private final ChunkBuffer buffer;
    private final Deflater deflater;
    private ByteArray curLineBytes;
    private boolean flipY = true;
    public PaletteReducer palette;
    protected Dithered.DitherAlgorithm ditherAlgorithm = Dithered.DitherAlgorithm.OVERBOARD;
    protected float ditherStrength = 1.0f;

    @Override
    public PaletteReducer getPalette() {
        return this.palette;
    }

    @Override
    public void setPalette(PaletteReducer palette) {
        this.palette = palette;
    }

    @Override
    public Dithered.DitherAlgorithm getDitherAlgorithm() {
        return this.ditherAlgorithm;
    }

    @Override
    public void setDitherAlgorithm(Dithered.DitherAlgorithm ditherAlgorithm) {
        if (ditherAlgorithm != null) {
            this.ditherAlgorithm = ditherAlgorithm;
        }
    }

    public float getDitherStrength() {
        return this.ditherStrength;
    }

    public void setDitherStrength(float ditherStrength) {
        this.ditherStrength = Math.max(0.0f, ditherStrength);
    }

    public PNG8() {
        this(16384);
    }

    public PNG8(int initialBufferSize) {
        this.buffer = new ChunkBuffer(initialBufferSize);
        this.deflater = new Deflater();
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void setCompression(int level) {
        this.deflater.setLevel(level);
    }

    public void write(FileHandle file, Pixmap pixmap) {
        this.write(file, pixmap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Pixmap pixmap, boolean computePalette) {
        OutputStream output = file.write(false);
        try {
            this.write(output, pixmap, computePalette);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Pixmap pixmap, boolean computePalette, boolean dither) {
        OutputStream output = file.write(false);
        try {
            this.write(output, pixmap, computePalette, dither);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Pixmap pixmap, boolean computePalette, boolean dither, int threshold) {
        OutputStream output = file.write(false);
        try {
            this.write(output, pixmap, computePalette, dither, threshold);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void write(OutputStream output, Pixmap pixmap) {
        this.writePrecisely(output, pixmap, true);
    }

    public void write(OutputStream output, Pixmap pixmap, boolean computePalette) {
        if (computePalette) {
            this.writePrecisely(output, pixmap, true);
        } else {
            this.write(output, pixmap, false, true);
        }
    }

    public void write(OutputStream output, Pixmap pixmap, boolean computePalette, boolean dither) {
        this.write(output, pixmap, computePalette, dither, 400);
    }

    public void write(OutputStream output, Pixmap pixmap, boolean computePalette, boolean dither, int threshold) {
        boolean clearPalette;
        boolean bl = clearPalette = this.palette == null;
        if (clearPalette) {
            this.palette = new PaletteReducer(pixmap, (double)threshold);
        } else if (computePalette) {
            this.palette.analyze(pixmap, (double)threshold);
        }
        this.palette.setDitherStrength(this.ditherStrength);
        if (dither) {
            this.writeDithered(output, pixmap);
        } else {
            this.writeSolid(output, pixmap);
        }
        if (clearPalette) {
            this.palette = null;
        }
    }

    public void writeDithered(OutputStream output, Pixmap pixmap) {
        if (this.ditherAlgorithm == null) {
            this.writeSolid(output, pixmap);
            return;
        }
        switch (this.ditherAlgorithm) {
            case NONE: {
                this.writeSolid(output, pixmap);
                break;
            }
            case GRADIENT_NOISE: {
                this.writeGradientDithered(output, pixmap);
                break;
            }
            case ROBERTS: {
                this.writeRobertsDithered(output, pixmap);
                break;
            }
            case PATTERN: {
                this.writePatternDithered(output, pixmap);
                break;
            }
            case CHAOTIC_NOISE: {
                this.writeChaoticNoiseDithered(output, pixmap);
                break;
            }
            case DIFFUSION: {
                this.writeDiffusionDithered(output, pixmap);
                break;
            }
            case BLUE_NOISE: {
                this.writeBlueNoiseDithered(output, pixmap);
                break;
            }
            case SCATTER: {
                this.writeScatterDithered(output, pixmap);
                break;
            }
            case WOVEN: {
                this.writeWovenDithered(output, pixmap);
                break;
            }
            case DODGY: {
                this.writeDodgyDithered(output, pixmap);
                break;
            }
            case LOAF: {
                this.writeLoafDithered(output, pixmap);
                break;
            }
            case NEUE: {
                this.writeNeueDithered(output, pixmap);
                break;
            }
            case WREN: {
                this.writeWrenDithered(output, pixmap);
                break;
            }
            case BURKES: {
                this.writeBurkesDithered(output, pixmap);
                break;
            }
            case OCEANIC: {
                this.writeOceanicDithered(output, pixmap);
                break;
            }
            case SEASIDE: {
                this.writeSeasideDithered(output, pixmap);
                break;
            }
            default: {
                this.writeOverboardDithered(output, pixmap);
            }
        }
    }

    public void writePrecisely(FileHandle file, Pixmap pixmap, boolean ditherFallback) {
        this.writePrecisely(file, pixmap, ditherFallback, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrecisely(FileHandle file, Pixmap pixmap, boolean ditherFallback, int threshold) {
        OutputStream output = file.write(false);
        try {
            this.writePrecisely(output, pixmap, ditherFallback, threshold);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrecisely(FileHandle file, Pixmap pixmap, int[] exactPalette, boolean ditherFallback, int threshold) {
        OutputStream output = file.write(false);
        try {
            this.writePrecisely(output, pixmap, exactPalette, ditherFallback, threshold);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void writePrecisely(OutputStream output, Pixmap pixmap, boolean ditherFallback) {
        this.writePrecisely(output, pixmap, ditherFallback, 400);
    }

    public void writePrecisely(OutputStream output, Pixmap pixmap, boolean ditherFallback, int threshold) {
        this.writePrecisely(output, pixmap, null, ditherFallback, threshold);
    }

    public void writePrecisely(OutputStream output, Pixmap pixmap, int[] exactPalette, boolean ditherFallback, int threshold) {
        int[] paletteArray;
        int color;
        IntIntMap colorToIndex = new IntIntMap(256);
        colorToIndex.put(0, 0);
        int hasTransparent = 0;
        int w = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (exactPalette == null) {
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    if ((color & 0xFE) != 254 && !colorToIndex.containsKey(color)) {
                        if (hasTransparent == 0 && colorToIndex.size >= 256) {
                            this.write(output, pixmap, true, ditherFallback, threshold);
                            return;
                        }
                        hasTransparent = 1;
                        continue;
                    }
                    if (colorToIndex.containsKey(color)) continue;
                    colorToIndex.put(color, colorToIndex.size & 0xFF);
                    if (colorToIndex.size == 257 && hasTransparent == 0) {
                        colorToIndex.remove(0, 0);
                    }
                    if (colorToIndex.size <= 256) continue;
                    this.write(output, pixmap, true, ditherFallback, threshold);
                    return;
                }
            }
            paletteArray = new int[colorToIndex.size];
            for (IntIntMap.Entry ent : colorToIndex) {
                paletteArray[ent.value] = ent.key;
            }
        } else {
            hasTransparent = exactPalette[0] == 0 ? 1 : 0;
            paletteArray = exactPalette;
            for (int i = hasTransparent; i < paletteArray.length; ++i) {
                colorToIndex.put(paletteArray[i], i);
            }
        }
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            if (hasTransparent == 1) {
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int lineLen = pixmap.getWidth();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(lineLen);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(lineLen);
            }
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    curLine[px] = (byte)colorToIndex.get(color, 0);
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, lineLen);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePreciseSection(FileHandle file, Pixmap pixmap, int[] exactPalette, int startX, int startY, int width, int height) {
        OutputStream output = file.write(false);
        try {
            this.writePreciseSection(output, pixmap, exactPalette, startX, startY, width, height);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void writePreciseSection(OutputStream output, Pixmap pixmap, int[] exactPalette, int startX, int startY, int width, int height) {
        int[] paletteArray;
        int color;
        IntIntMap colorToIndex = new IntIntMap(256);
        colorToIndex.put(0, 0);
        int hasTransparent = 0;
        int w = startX + width;
        int h = startY + height;
        if (exactPalette == null) {
            for (int y = startY; y < h; ++y) {
                int py = this.flipY ? pixmap.getHeight() - y - 1 : y;
                for (int px = startX; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    if ((color & 0xFE) != 254 && !colorToIndex.containsKey(color)) {
                        if (hasTransparent == 0 && colorToIndex.size >= 256) {
                            throw new IllegalArgumentException("Too many colors to write precisely!");
                        }
                        hasTransparent = 1;
                        continue;
                    }
                    if (colorToIndex.containsKey(color)) continue;
                    colorToIndex.put(color, colorToIndex.size & 0xFF);
                    if (colorToIndex.size == 257 && hasTransparent == 0) {
                        colorToIndex.remove(0, 0);
                    }
                    if (colorToIndex.size <= 256) continue;
                    throw new IllegalArgumentException("Too many colors to write precisely!");
                }
            }
            paletteArray = new int[colorToIndex.size];
            for (IntIntMap.Entry ent : colorToIndex) {
                paletteArray[ent.value] = ent.key;
            }
        } else {
            hasTransparent = exactPalette[0] == 0 ? 1 : 0;
            paletteArray = exactPalette;
            for (int i = hasTransparent; i < paletteArray.length; ++i) {
                colorToIndex.put(paletteArray[i], i);
            }
        }
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            if (hasTransparent == 1) {
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(width);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(width);
            }
            for (int y = startY; y < h; ++y) {
                int py = this.flipY ? pixmap.getHeight() - y - 1 : y;
                for (int px = startX; px < w; ++px) {
                    color = pixmap.getPixel(px, py);
                    curLine[px - startX] = (byte)colorToIndex.get(color, 0);
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, width);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeSolid(OutputStream output, Pixmap pixmap) {
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int lineLen = pixmap.getWidth();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(lineLen);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(lineLen);
            }
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, lineLen);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeGradientDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            float strength = 60.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float adj = (float)px * 0.06711056f + (float)y * 0.00583715f;
                    adj -= (float)((int)adj);
                    adj *= 52.982918f;
                    adj -= (float)((int)adj);
                    adj = (adj - 0.5f) * strength;
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + adj), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + adj), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + adj), 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeRobertsDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            float populationBias = this.palette.populationBias;
            float str = 32.0f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    float theta = (float)((long)px * -4521708957497675121L + (long)y * -7935046062780286179L >>> 41) * 7.490141E-7f;
                    rr = Math.min(Math.max((int)((float)rr + MathUtils.cos((float)theta) * str + 0.5f), 0), 255);
                    gg = Math.min(Math.max((int)((float)gg + MathUtils.cos((float)(theta + 1.04f)) * str + 0.5f), 0), 255);
                    bb = Math.min(Math.max((int)((float)bb + MathUtils.cos((float)(theta + 2.09f)) * str + 0.5f), 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeLoafDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            float strength = this.ditherStrength * this.palette.populationBias;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int adj = (int)((float)(((px + y & 1) << 5) - 16) * strength);
                    int rr = Math.min(Math.max((color >>> 24) + adj, 0), 255);
                    int gg = Math.min(Math.max((color >>> 16 & 0xFF) + adj, 0), 255);
                    int bb = Math.min(Math.max((color >>> 8 & 0xFF) + adj, 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeBlueNoiseDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            float strength = 60.0f * this.palette.ditherStrength / (this.palette.populationBias * OtherMath.cbrtPositive(this.palette.colorCount));
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    float adj = (float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                    adj = adj * strength / (12.0f + Math.abs(adj));
                    rr = Math.min(Math.max((int)(adj + (float)rr + 0.5f), 0), 255);
                    adj = (float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                    adj = adj * strength / (12.0f + Math.abs(adj));
                    gg = Math.min(Math.max((int)(adj + (float)gg + 0.5f), 0), 255);
                    adj = (float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                    adj = adj * strength / (12.0f + Math.abs(adj));
                    bb = Math.min(Math.max((int)(adj + (float)bb + 0.5f), 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeChaoticNoiseDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            double strength = (double)(this.palette.ditherStrength * this.palette.populationBias) * 1.5;
            long s = -4521708957497675121L;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int rr = color >>> 24;
                    int gg = color >>> 16 & 0xFF;
                    int bb = color >>> 8 & 0xFF;
                    byte paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    double adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                    adj *= adj * adj;
                    long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                    s = (s ^ (long)(rr + gg + bb)) * -3372029247567499371L + -7935046062780286179L;
                    rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                    gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                    bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                    curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeDiffusionDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float w1 = this.palette.ditherStrength * 4.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.005859375f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                    gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                    bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writePatternDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            float errorMul = this.palette.ditherStrength * 0.5f / this.palette.populationBias;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                for (int px = 0; px < w; ++px) {
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    int er = 0;
                    int eg = 0;
                    int eb = 0;
                    int cr = color >>> 24;
                    int cg = color >>> 16 & 0xFF;
                    int cb = color >>> 8 & 0xFF;
                    for (int i = 0; i < 16; ++i) {
                        int usedIndex;
                        int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                        int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                        int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                        this.palette.candidates[i] = usedIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                        int used = paletteArray[this.palette.candidates[i]];
                        this.palette.candidates[i | 0x10] = PaletteReducer.shrink(used);
                        er += cr - (used >>> 24);
                        eg += cg - (used >>> 16 & 0xFF);
                        eb += cb - (used >>> 8 & 0xFF);
                    }
                    PaletteReducer.sort16(this.palette.candidates);
                    curLine[px] = (byte)this.palette.candidates[PaletteReducer.thresholdMatrix16[px & 3 | (y & 3) << 2]];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeScatterDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float w1 = this.palette.ditherStrength * 3.5f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float tbn = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                    float er = curErrorRed[px] * tbn;
                    float eg = curErrorGreen[px] * tbn;
                    float eb = curErrorBlue[px] * tbn;
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.011230469f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                    gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                    bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeNeueDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float w1 = this.palette.ditherStrength * 7.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 32.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
            float limit = (float)Math.pow(80.0, 1.635 - (double)this.palette.populationBias);
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                    adj = Math.min(Math.max(adj * strength, -limit), limit);
                    float er = adj + curErrorRed[px];
                    float eg = adj + curErrorGreen[px];
                    float eb = adj + curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.0014038086f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                    gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                    bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeDodgyDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float populationBias = this.palette.populationBias;
            float w1 = 25.0f * this.ditherStrength * populationBias * populationBias;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 0.25f * this.ditherStrength / (populationBias * populationBias);
            float limit = 5.0f + 90.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            float dmul = 0.0029296875f;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorRed[px];
                    float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorGreen[px];
                    float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = dmul * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = dmul * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = dmul * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeWovenDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float populationBias = this.palette.populationBias;
            float w1 = (float)(20.0 * Math.sqrt(this.ditherStrength) * (double)populationBias * (double)populationBias * (double)populationBias * (double)populationBias);
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 48.0f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
            float limit = 5.0f + 130.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = Math.min(Math.max(((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorRed[px];
                    float eg = Math.min(Math.max(((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorGreen[px];
                    float eb = Math.min(Math.max(((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.0048828125f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.0048828125f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.0048828125f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeWrenOriginalDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float populationBias = this.palette.populationBias;
            float w1 = (float)(32.0 * (double)this.ditherStrength * (double)(populationBias * populationBias));
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 0.2f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
            float limit = 5.0f + 125.0f / (float)Math.sqrt((double)this.palette.colorCount + 1.5);
            float dmul = 0.00390625f;
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorRed[px], -limit), limit);
                    float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorGreen[px], -limit), limit);
                    float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorBlue[px], -limit), limit);
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = 0.00390625f * (float)((color >>> 24) - (used >>> 24));
                    float gdiff = 0.00390625f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                    float bdiff = 0.00390625f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                        int n4 = px - 1;
                        nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                        int n5 = px - 1;
                        nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                    }
                    if (px < w - 1) {
                        int n = px + 1;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                        int n6 = px + 1;
                        nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                        int n7 = px + 1;
                        nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                    int n8 = px;
                    nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                    int n9 = px;
                    nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeWrenDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float populationBias = this.palette.populationBias;
            float partialDitherStrength = 0.4f * this.ditherStrength * (populationBias * populationBias);
            float strength = 40.0f * this.ditherStrength / (populationBias * populationBias);
            float blueStrength = 0.15f * this.ditherStrength / (populationBias * populationBias);
            float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int by = 0; by < h; ++by) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int y = this.flipY ? h - by - 1 : by;
                for (int x = 0; x < w; ++x) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(x, y);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[x] = 0;
                        continue;
                    }
                    float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (by & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 1) * -4521708957497675121L + (long)(by + 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorRed[x];
                    float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (by & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 3) * -4521708957497675121L + (long)(by - 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorGreen[x];
                    float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (by & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 2) * -4521708957497675121L + (long)(by - 4) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorBlue[x];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[x] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = (float)((color >>> 24) - (used >>> 24)) * partialDitherStrength;
                    float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * partialDitherStrength;
                    float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * partialDitherStrength;
                    float r1 = rdiff * 16.0f / (float)Math.sqrt(2048.0f + rdiff * rdiff);
                    float g1 = gdiff * 16.0f / (float)Math.sqrt(2048.0f + gdiff * gdiff);
                    float b1 = bdiff * 16.0f / (float)Math.sqrt(2048.0f + bdiff * bdiff);
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (x < w - 1) {
                        int n = x + 1;
                        curErrorRed[n] = curErrorRed[n] + r4;
                        int n2 = x + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4;
                        int n3 = x + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4;
                        if (x < w - 2) {
                            int n4 = x + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2;
                            int n5 = x + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2;
                            int n6 = x + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2;
                        }
                    }
                    if (by + 1 >= h) continue;
                    if (x > 0) {
                        int n = x - 1;
                        nextErrorRed[n] = nextErrorRed[n] + r2;
                        int n7 = x - 1;
                        nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                        int n8 = x - 1;
                        nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                        if (x > 1) {
                            int n9 = x - 2;
                            nextErrorRed[n9] = nextErrorRed[n9] + r1;
                            int n10 = x - 2;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                            int n11 = x - 2;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                        }
                    }
                    int n = x;
                    nextErrorRed[n] = nextErrorRed[n] + r4;
                    int n12 = x;
                    nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                    int n13 = x;
                    nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                    if (x >= w - 1) continue;
                    int n14 = x + 1;
                    nextErrorRed[n14] = nextErrorRed[n14] + r2;
                    int n15 = x + 1;
                    nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                    int n16 = x + 1;
                    nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                    if (x >= w - 2) continue;
                    int n17 = x + 2;
                    nextErrorRed[n17] = nextErrorRed[n17] + r1;
                    int n18 = x + 2;
                    nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                    int n19 = x + 2;
                    nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeOverboardDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            int y;
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            int flipDir;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            int n = flipDir = this.flipY ? -1 : 1;
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            float populationBias = this.palette.populationBias;
            float strength = this.ditherStrength * 0.5f * (populationBias * populationBias);
            float noiseStrength = 2.0f / populationBias;
            float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            int by = 0;
            int n2 = y = this.flipY ? h - 1 : 0;
            while (by < h) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                for (int x = 0; x < w; ++x) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(x, y);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[x] = 0;
                        continue;
                    }
                    float er = 0.0f;
                    float eg = 0.0f;
                    float eb = 0.0f;
                    switch (x << 1 & 2 | y & 1) {
                        case 0: {
                            er += (float)((x ^ y) % 9 - 4);
                            er += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                            eg += ((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                            eg += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                            eb += ((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                            eb += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                            break;
                        }
                        case 1: {
                            er += ((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                            er += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                            eg += ((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                            eg += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                            eb += (float)((x ^ y) % 11 - 5);
                            eb += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                            break;
                        }
                        case 2: {
                            er += ((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                            er += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                            eg += (float)((x ^ y) % 11 - 5);
                            eg += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                            eb += (float)((x ^ y) % 9 - 4);
                            eb += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                            break;
                        }
                        default: {
                            er += (float)((x ^ y) % 11 - 5);
                            er += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                            eg += (float)((x ^ y) % 9 - 4);
                            eg += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                            eb += ((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                            eb += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        }
                    }
                    er = er * noiseStrength + curErrorRed[x];
                    eg = eg * noiseStrength + curErrorGreen[x];
                    eb = eb * noiseStrength + curErrorBlue[x];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + Math.min(Math.max(er, -limit), limit) + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + Math.min(Math.max(eg, -limit), limit) + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + Math.min(Math.max(eb, -limit), limit) + 0.5f), 0), 255);
                    curLine[x] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    float rdiff = (float)((color >>> 24) - (used >>> 24)) * strength;
                    float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * strength;
                    float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * strength;
                    float r1 = rdiff * 16.0f / (45.0f + Math.abs(rdiff));
                    float g1 = gdiff * 16.0f / (45.0f + Math.abs(gdiff));
                    float b1 = bdiff * 16.0f / (45.0f + Math.abs(bdiff));
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (x < w - 1) {
                        int n3 = x + 1;
                        curErrorRed[n3] = curErrorRed[n3] + r4;
                        int n4 = x + 1;
                        curErrorGreen[n4] = curErrorGreen[n4] + g4;
                        int n5 = x + 1;
                        curErrorBlue[n5] = curErrorBlue[n5] + b4;
                        if (x < w - 2) {
                            int n6 = x + 2;
                            curErrorRed[n6] = curErrorRed[n6] + r2;
                            int n7 = x + 2;
                            curErrorGreen[n7] = curErrorGreen[n7] + g2;
                            int n8 = x + 2;
                            curErrorBlue[n8] = curErrorBlue[n8] + b2;
                        }
                    }
                    if (by + 1 >= h) continue;
                    if (x > 0) {
                        int n9 = x - 1;
                        nextErrorRed[n9] = nextErrorRed[n9] + r2;
                        int n10 = x - 1;
                        nextErrorGreen[n10] = nextErrorGreen[n10] + g2;
                        int n11 = x - 1;
                        nextErrorBlue[n11] = nextErrorBlue[n11] + b2;
                        if (x > 1) {
                            int n12 = x - 2;
                            nextErrorRed[n12] = nextErrorRed[n12] + r1;
                            int n13 = x - 2;
                            nextErrorGreen[n13] = nextErrorGreen[n13] + g1;
                            int n14 = x - 2;
                            nextErrorBlue[n14] = nextErrorBlue[n14] + b1;
                        }
                    }
                    int n15 = x;
                    nextErrorRed[n15] = nextErrorRed[n15] + r4;
                    int n16 = x;
                    nextErrorGreen[n16] = nextErrorGreen[n16] + g4;
                    int n17 = x;
                    nextErrorBlue[n17] = nextErrorBlue[n17] + b4;
                    if (x >= w - 1) continue;
                    int n18 = x + 1;
                    nextErrorRed[n18] = nextErrorRed[n18] + r2;
                    int n19 = x + 1;
                    nextErrorGreen[n19] = nextErrorGreen[n19] + g2;
                    int n20 = x + 1;
                    nextErrorBlue[n20] = nextErrorBlue[n20] + b2;
                    if (x >= w - 2) continue;
                    int n21 = x + 2;
                    nextErrorRed[n21] = nextErrorRed[n21] + r1;
                    int n22 = x + 2;
                    nextErrorGreen[n22] = nextErrorGreen[n22] + g1;
                    int n23 = x + 2;
                    nextErrorBlue[n23] = nextErrorBlue[n23] + b1;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
                ++by;
                y += flipDir;
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeBurkesDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            float s = 0.175f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias * this.palette.populationBias);
            float strength = s * 0.29f / (0.19f + s);
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    int rdiff = (color >>> 24) - (used >>> 24);
                    int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                    int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                    float r1 = (float)rdiff * strength;
                    float g1 = (float)gdiff * strength;
                    float b1 = (float)bdiff * strength;
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (px < w - 1) {
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + r4;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4;
                        if (px < w - 2) {
                            int n4 = px + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2;
                            int n5 = px + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2;
                            int n6 = px + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2;
                        }
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + r2;
                        int n7 = px - 1;
                        nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                        int n8 = px - 1;
                        nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                        if (px > 1) {
                            int n9 = px - 2;
                            nextErrorRed[n9] = nextErrorRed[n9] + r1;
                            int n10 = px - 2;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                            int n11 = px - 2;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                        }
                    }
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + r4;
                    int n12 = px;
                    nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                    int n13 = px;
                    nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                    if (px >= w - 1) continue;
                    int n14 = px + 1;
                    nextErrorRed[n14] = nextErrorRed[n14] + r2;
                    int n15 = px + 1;
                    nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                    int n16 = px + 1;
                    nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                    if (px >= w - 2) continue;
                    int n17 = px + 2;
                    nextErrorRed[n17] = nextErrorRed[n17] + r1;
                    int n18 = px + 2;
                    nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                    int n19 = px + 2;
                    nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeOceanicDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        float[] noise = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            float s = 0.175f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias * this.palette.populationBias);
            float strength = s * 0.29f / (0.19f + s);
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    float modifier;
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    int rdiff = (color >>> 24) - (used >>> 24);
                    int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                    int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                    float r1 = (float)rdiff * strength;
                    float g1 = (float)gdiff * strength;
                    float b1 = (float)bdiff * strength;
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (px < w - 1) {
                        modifier = noise[px + 1 & 0x3F | py << 6 & 0xFC0];
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + r4 * modifier;
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4 * modifier;
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4 * modifier;
                        if (px < w - 2) {
                            modifier = noise[px + 2 & 0x3F | py << 6 & 0xFC0];
                            int n4 = px + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2 * modifier;
                            int n5 = px + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2 * modifier;
                            int n6 = px + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2 * modifier;
                        }
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        modifier = noise[px - 1 & 0x3F | ny << 6 & 0xFC0];
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + r2 * modifier;
                        int n7 = px - 1;
                        nextErrorGreen[n7] = nextErrorGreen[n7] + g2 * modifier;
                        int n8 = px - 1;
                        nextErrorBlue[n8] = nextErrorBlue[n8] + b2 * modifier;
                        if (px > 1) {
                            modifier = noise[px - 2 & 0x3F | ny << 6 & 0xFC0];
                            int n9 = px - 2;
                            nextErrorRed[n9] = nextErrorRed[n9] + r1 * modifier;
                            int n10 = px - 2;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g1 * modifier;
                            int n11 = px - 2;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b1 * modifier;
                        }
                    }
                    modifier = noise[px & 0x3F | ny << 6 & 0xFC0];
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + r4 * modifier;
                    int n12 = px;
                    nextErrorGreen[n12] = nextErrorGreen[n12] + g4 * modifier;
                    int n13 = px;
                    nextErrorBlue[n13] = nextErrorBlue[n13] + b4 * modifier;
                    if (px >= w - 1) continue;
                    modifier = noise[px + 1 & 0x3F | ny << 6 & 0xFC0];
                    int n14 = px + 1;
                    nextErrorRed[n14] = nextErrorRed[n14] + r2 * modifier;
                    int n15 = px + 1;
                    nextErrorGreen[n15] = nextErrorGreen[n15] + g2 * modifier;
                    int n16 = px + 1;
                    nextErrorBlue[n16] = nextErrorBlue[n16] + b2 * modifier;
                    if (px >= w - 2) continue;
                    modifier = noise[px + 2 & 0x3F | ny << 6 & 0xFC0];
                    int n17 = px + 2;
                    nextErrorRed[n17] = nextErrorRed[n17] + r1 * modifier;
                    int n18 = px + 2;
                    nextErrorGreen[n18] = nextErrorGreen[n18] + g1 * modifier;
                    int n19 = px + 2;
                    nextErrorBlue[n19] = nextErrorBlue[n19] + b1 * modifier;
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeSeasideDithered(OutputStream output, Pixmap pixmap) {
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        float[] noiseA = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS;
        float[] noiseB = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS_B;
        float[] noiseC = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS_C;
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            byte[] curLine;
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            float s = 0.13f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias);
            float strength = s * 0.29f / (0.18f + s);
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            if (this.curLineBytes == null) {
                this.curLineBytes = new ByteArray(w);
                curLine = this.curLineBytes.items;
            } else {
                curLine = this.curLineBytes.ensureCapacity(w);
            }
            for (int y = 0; y < h; ++y) {
                System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
                int py = this.flipY ? h - y - 1 : y;
                int ny = y + 1;
                for (int px = 0; px < w; ++px) {
                    byte paletteIndex;
                    int color = pixmap.getPixel(px, py);
                    if ((color & 0x80) == 0 && hasTransparent) {
                        curLine[px] = 0;
                        continue;
                    }
                    float er = curErrorRed[px];
                    float eg = curErrorGreen[px];
                    float eb = curErrorBlue[px];
                    int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                    int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                    int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                    curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    int used = paletteArray[paletteIndex & 0xFF];
                    int rdiff = (color >>> 24) - (used >>> 24);
                    int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                    int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                    int modifier = px & 0x3F | py << 6 & 0xFC0;
                    float r1 = (float)rdiff * strength * noiseA[modifier];
                    float g1 = (float)gdiff * strength * noiseB[modifier];
                    float b1 = (float)bdiff * strength * noiseC[modifier];
                    float r2 = r1 + r1;
                    float g2 = g1 + g1;
                    float b2 = b1 + b1;
                    float r4 = r2 + r2;
                    float g4 = g2 + g2;
                    float b4 = b2 + b2;
                    if (px < w - 1) {
                        modifier = px + 1 & 0x3F | py << 6 & 0xFC0;
                        int n = px + 1;
                        curErrorRed[n] = curErrorRed[n] + r4 * noiseA[modifier];
                        int n2 = px + 1;
                        curErrorGreen[n2] = curErrorGreen[n2] + g4 * noiseB[modifier];
                        int n3 = px + 1;
                        curErrorBlue[n3] = curErrorBlue[n3] + b4 * noiseC[modifier];
                        if (px < w - 2) {
                            modifier = px + 2 & 0x3F | py << 6 & 0xFC0;
                            int n4 = px + 2;
                            curErrorRed[n4] = curErrorRed[n4] + r2 * noiseA[modifier];
                            int n5 = px + 2;
                            curErrorGreen[n5] = curErrorGreen[n5] + g2 * noiseB[modifier];
                            int n6 = px + 2;
                            curErrorBlue[n6] = curErrorBlue[n6] + b2 * noiseC[modifier];
                        }
                        if (px < w - 3) {
                            modifier = px + 3 & 0x3F | py << 6 & 0xFC0;
                            int n7 = px + 2;
                            curErrorRed[n7] = curErrorRed[n7] + r1 * noiseA[modifier];
                            int n8 = px + 2;
                            curErrorGreen[n8] = curErrorGreen[n8] + g1 * noiseB[modifier];
                            int n9 = px + 2;
                            curErrorBlue[n9] = curErrorBlue[n9] + b1 * noiseC[modifier];
                        }
                    }
                    if (ny >= h) continue;
                    if (px > 0) {
                        modifier = px - 1 & 0x3F | ny << 6 & 0xFC0;
                        int n = px - 1;
                        nextErrorRed[n] = nextErrorRed[n] + r2 * noiseA[modifier];
                        int n10 = px - 1;
                        nextErrorGreen[n10] = nextErrorGreen[n10] + g2 * noiseB[modifier];
                        int n11 = px - 1;
                        nextErrorBlue[n11] = nextErrorBlue[n11] + b2 * noiseC[modifier];
                        if (px > 1) {
                            modifier = px - 2 & 0x3F | ny << 6 & 0xFC0;
                            int n12 = px - 2;
                            nextErrorRed[n12] = nextErrorRed[n12] + r1 * noiseA[modifier];
                            int n13 = px - 2;
                            nextErrorGreen[n13] = nextErrorGreen[n13] + g1 * noiseB[modifier];
                            int n14 = px - 2;
                            nextErrorBlue[n14] = nextErrorBlue[n14] + b1 * noiseC[modifier];
                        }
                    }
                    modifier = px & 0x3F | ny << 6 & 0xFC0;
                    int n = px;
                    nextErrorRed[n] = nextErrorRed[n] + r4 * noiseA[modifier];
                    int n15 = px;
                    nextErrorGreen[n15] = nextErrorGreen[n15] + g4 * noiseB[modifier];
                    int n16 = px;
                    nextErrorBlue[n16] = nextErrorBlue[n16] + b4 * noiseC[modifier];
                    if (px >= w - 1) continue;
                    modifier = px + 1 & 0x3F | ny << 6 & 0xFC0;
                    int n17 = px + 1;
                    nextErrorRed[n17] = nextErrorRed[n17] + r2 * noiseA[modifier];
                    int n18 = px + 1;
                    nextErrorGreen[n18] = nextErrorGreen[n18] + g2 * noiseB[modifier];
                    int n19 = px + 1;
                    nextErrorBlue[n19] = nextErrorBlue[n19] + b2 * noiseC[modifier];
                    if (px >= w - 2) continue;
                    modifier = px + 2 & 0x3F | ny << 6 & 0xFC0;
                    int n20 = px + 2;
                    nextErrorRed[n20] = nextErrorRed[n20] + r1 * noiseA[modifier];
                    int n21 = px + 2;
                    nextErrorGreen[n21] = nextErrorGreen[n21] + g1 * noiseB[modifier];
                    int n22 = px + 2;
                    nextErrorBlue[n22] = nextErrorBlue[n22] + b1 * noiseC[modifier];
                }
                deflaterOutput.write(0);
                deflaterOutput.write(curLine, 0, w);
            }
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    @Override
    public void write(FileHandle file, Array<Pixmap> frames) {
        this.write(file, frames, 30, true);
    }

    @Override
    public void write(FileHandle file, Array<Pixmap> frames, int fps) {
        this.write(file, frames, fps, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileHandle file, Array<Pixmap> frames, int fps, boolean dither) {
        OutputStream output = file.write(false);
        try {
            this.write(output, frames, fps, dither);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)output);
        }
    }

    public void write(OutputStream output, Array<Pixmap> frames, int fps, boolean dither) {
        boolean clearPalette = this.palette == null;
        if (clearPalette) {
            this.palette = new PaletteReducer(frames);
        }
        this.palette.setDitherStrength(this.ditherStrength);
        if (dither) {
            this.write(output, frames, fps);
        } else {
            this.writeSolid(output, frames, fps);
        }
        if (clearPalette) {
            this.palette = null;
        }
    }

    public void writeSolid(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    @Override
    public void write(OutputStream output, Array<Pixmap> frames, int fps) {
        if (this.ditherAlgorithm == null) {
            this.writeSolid(output, frames, fps);
            return;
        }
        switch (this.ditherAlgorithm) {
            case NONE: {
                this.writeSolid(output, frames, fps);
                break;
            }
            case GRADIENT_NOISE: {
                this.writeGradientDithered(output, frames, fps);
                break;
            }
            case ROBERTS: {
                this.writeRobertsDithered(output, frames, fps);
                break;
            }
            case PATTERN: {
                this.writePatternDithered(output, frames, fps);
                break;
            }
            case CHAOTIC_NOISE: {
                this.writeChaoticNoiseDithered(output, frames, fps);
                break;
            }
            case DIFFUSION: {
                this.writeDiffusionDithered(output, frames, fps);
                break;
            }
            case SCATTER: {
                this.writeScatterDithered(output, frames, fps);
                break;
            }
            case BLUE_NOISE: {
                this.writeBlueNoiseDithered(output, frames, fps);
                break;
            }
            case WOVEN: {
                this.writeWovenDithered(output, frames, fps);
                break;
            }
            case DODGY: {
                this.writeDodgyDithered(output, frames, fps);
                break;
            }
            case LOAF: {
                this.writeLoafDithered(output, frames, fps);
                break;
            }
            case NEUE: {
                this.writeNeueDithered(output, frames, fps);
                break;
            }
            case WREN: {
                this.writeWrenDithered(output, frames, fps);
                break;
            }
            case BURKES: {
                this.writeBurkesDithered(output, frames, fps);
                break;
            }
            case OCEANIC: {
                this.writeOceanicDithered(output, frames, fps);
                break;
            }
            case SEASIDE: {
                this.writeSeasideDithered(output, frames, fps);
                break;
            }
            default: {
                this.writeOverboardDithered(output, frames, fps);
            }
        }
    }

    public void writeGradientDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float strength = 60.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float pos = (float)px * 0.06711056f + (float)y * 0.00583715f;
                        pos -= (float)((int)pos);
                        pos *= 52.982918f;
                        pos -= (float)((int)pos);
                        pos = (pos - 0.5f) * strength;
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + pos), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + pos), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + pos), 0), 255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeRobertsDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float populationBias = this.palette.populationBias;
            float str = 32.0f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        float theta = (float)((long)px * -4521708957497675121L + (long)y * -7935046062780286179L >>> 41) * 7.490141E-7f;
                        rr = Math.min(Math.max((int)((float)rr + MathUtils.cos((float)theta) * str + 0.5f), 0), 255);
                        gg = Math.min(Math.max((int)((float)gg + MathUtils.cos((float)(theta + 1.04f)) * str + 0.5f), 0), 255);
                        bb = Math.min(Math.max((int)((float)bb + MathUtils.cos((float)(theta + 2.09f)) * str + 0.5f), 0), 255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeLoafDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float strength = this.ditherStrength * this.palette.populationBias;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int adj = (int)((float)(((px + y & 1) << 5) - 16) * strength);
                        int rr = Math.min(Math.max((color >>> 24) + adj, 0), 255);
                        int gg = Math.min(Math.max((color >>> 16 & 0xFF) + adj, 0), 255);
                        int bb = Math.min(Math.max((color >>> 8 & 0xFF) + adj, 0), 255);
                        int rgb555 = rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3;
                        curLine[px] = paletteMapping[rgb555];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeBlueNoiseDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float strength = 60.0f * this.palette.ditherStrength / (this.palette.populationBias * OtherMath.cbrtPositive(this.palette.colorCount));
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        float adj = (float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                        adj = adj * strength / (12.0f + Math.abs(adj));
                        rr = Math.min(Math.max((int)(adj + (float)rr + 0.5f), 0), 255);
                        adj = (float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                        adj = adj * strength / (12.0f + Math.abs(adj));
                        gg = Math.min(Math.max((int)(adj + (float)gg + 0.5f), 0), 255);
                        adj = (float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                        adj = adj * strength / (12.0f + Math.abs(adj));
                        bb = Math.min(Math.max((int)(adj + (float)bb + 0.5f), 0), 255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeChaoticNoiseDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            double strength = (double)(this.palette.ditherStrength * this.palette.populationBias) * 1.5;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                long s = -4521708957497675121L * (long)seq;
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int rr = color >>> 24;
                        int gg = color >>> 16 & 0xFF;
                        int bb = color >>> 8 & 0xFF;
                        byte paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        double adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                        adj *= adj * adj;
                        long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                        s = (s ^ (long)(rr + gg + bb)) * -3372029247567499371L + -7935046062780286179L;
                        rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                        gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                        bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                        curLine[px] = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeDiffusionDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float w1 = this.palette.ditherStrength * 4.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = curErrorRed[px];
                        float eg = curErrorGreen[px];
                        float eb = curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = 0.005859375f * (float)((color >>> 24) - (used >>> 24));
                        float gdiff = 0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                        float bdiff = 0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                        rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                        gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                        bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writePatternDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            dataOutput.write(SIGNATURE);
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(width);
            this.buffer.writeInt(height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float errorMul = this.palette.ditherStrength * 0.5f / this.palette.populationBias;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(width);
                this.buffer.writeInt(height);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(width);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(width);
                }
                for (int y = 0; y < height; ++y) {
                    int py = this.flipY ? height - y - 1 : y;
                    for (int px = 0; px < width; ++px) {
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        int er = 0;
                        int eg = 0;
                        int eb = 0;
                        int cr = color >>> 24;
                        int cg = color >>> 16 & 0xFF;
                        int cb = color >>> 8 & 0xFF;
                        for (int c = 0; c < 16; ++c) {
                            int usedIndex;
                            int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                            int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                            int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                            this.palette.candidates[c] = usedIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                            int used = paletteArray[this.palette.candidates[c]];
                            this.palette.candidates[c | 0x10] = PaletteReducer.shrink(used);
                            er += cr - (used >>> 24);
                            eg += cg - (used >>> 16 & 0xFF);
                            eb += cb - (used >>> 8 & 0xFF);
                        }
                        PaletteReducer.sort16(this.palette.candidates);
                        curLine[px] = (byte)this.palette.candidates[PaletteReducer.thresholdMatrix16[px & 3 | (y & 3) << 2]];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, width);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeScatterDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float w1 = this.palette.ditherStrength * 3.5f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float tbn = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                        float er = curErrorRed[px] * tbn;
                        float eg = curErrorGreen[px] * tbn;
                        float eb = curErrorBlue[px] * tbn;
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = 0.011230469f * (float)((color >>> 24) - (used >>> 24));
                        float gdiff = 0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                        float bdiff = 0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                        rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                        gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                        bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeNeueDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float w1 = this.palette.ditherStrength * 7.0f;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 32.0f * this.palette.ditherStrength / (this.palette.populationBias * this.palette.populationBias);
            float limit = (float)Math.pow(80.0, 1.635 - (double)this.palette.populationBias);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float adj = ((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                        adj = Math.min(Math.max(adj * strength, -limit), limit);
                        float er = adj + curErrorRed[px];
                        float eg = adj + curErrorGreen[px];
                        float eb = adj + curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = 0.0014038086f * (float)((color >>> 24) - (used >>> 24));
                        float gdiff = 0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                        float bdiff = 0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                        rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                        gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                        bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeDodgyDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float populationBias = this.palette.populationBias;
            float w1 = 25.0f * this.ditherStrength * populationBias * populationBias;
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 0.25f * this.ditherStrength / (populationBias * populationBias);
            float limit = 5.0f + 90.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            float dmul = 0.0029296875f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorRed[px];
                        float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorGreen[px];
                        float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = dmul * (float)((color >>> 24) - (used >>> 24));
                        float gdiff = dmul * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                        float bdiff = dmul * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeWovenDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float populationBias = this.palette.populationBias;
            float w1 = (float)(20.0 * Math.sqrt(this.ditherStrength) * (double)populationBias * (double)populationBias * (double)populationBias * (double)populationBias);
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 48.0f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
            float limit = 5.0f + 130.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = Math.min(Math.max(((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorRed[px];
                        float eg = Math.min(Math.max(((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorGreen[px];
                        float eb = Math.min(Math.max(((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = 0.0048828125f * (float)((color >>> 24) - (used >>> 24));
                        float gdiff = 0.0048828125f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                        float bdiff = 0.0048828125f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeWrenOriginalDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float populationBias = this.palette.populationBias;
            float w1 = (float)(32.0 * (double)this.ditherStrength * (double)(populationBias * populationBias));
            float w3 = w1 * 3.0f;
            float w5 = w1 * 5.0f;
            float w7 = w1 * 7.0f;
            float strength = 0.2f * this.ditherStrength / (populationBias * populationBias * populationBias * populationBias);
            float limit = 5.0f + 125.0f / (float)Math.sqrt((double)this.palette.colorCount + 1.5);
            float dmul = 0.00390625f;
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int y = 0; y < h; ++y) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int py = this.flipY ? h - y - 1 : y;
                    int ny = y + 1;
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorRed[px], -limit), limit);
                        float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorGreen[px], -limit), limit);
                        float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 3.0517578E-5f - 128.0f)) * strength + curErrorBlue[px], -limit), limit);
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = 0.00390625f * (float)((color >>> 24) - (used >>> 24));
                        float gdiff = 0.00390625f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                        float bdiff = 0.00390625f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                        if (px < w - 1) {
                            int n = px + 1;
                            curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                            int n2 = px + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                            int n3 = px + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            int n = px - 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                            int n4 = px - 1;
                            nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                            int n5 = px - 1;
                            nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                        }
                        if (px < w - 1) {
                            int n = px + 1;
                            nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                            int n6 = px + 1;
                            nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                            int n7 = px + 1;
                            nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                        }
                        int n = px;
                        nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                        int n8 = px;
                        nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                        int n9 = px;
                        nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeWrenDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float populationBias = this.palette.populationBias;
            float partialDitherStrength = 0.4f * this.ditherStrength * (populationBias * populationBias);
            float strength = 40.0f * this.ditherStrength / (populationBias * populationBias);
            float blueStrength = 0.15f * this.ditherStrength / (populationBias * populationBias);
            float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                for (int by = 0; by < h; ++by) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    int y = this.flipY ? h - by - 1 : by;
                    for (int x = 0; x < w; ++x) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(x, y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[x] = 0;
                            continue;
                        }
                        float er = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (by & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 1) * -4521708957497675121L + (long)(by + 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorRed[x];
                        float eg = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (by & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 3) * -4521708957497675121L + (long)(by - 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorGreen[x];
                        float eb = Math.min(Math.max(((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (by & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 2) * -4521708957497675121L + (long)(by - 4) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorBlue[x];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[x] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = (float)((color >>> 24) - (used >>> 24)) * partialDitherStrength;
                        float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * partialDitherStrength;
                        float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * partialDitherStrength;
                        float r1 = rdiff * 16.0f / (float)Math.sqrt(2048.0f + rdiff * rdiff);
                        float g1 = gdiff * 16.0f / (float)Math.sqrt(2048.0f + gdiff * gdiff);
                        float b1 = bdiff * 16.0f / (float)Math.sqrt(2048.0f + bdiff * bdiff);
                        float r2 = r1 + r1;
                        float g2 = g1 + g1;
                        float b2 = b1 + b1;
                        float r4 = r2 + r2;
                        float g4 = g2 + g2;
                        float b4 = b2 + b2;
                        if (x < w - 1) {
                            int n = x + 1;
                            curErrorRed[n] = curErrorRed[n] + r4;
                            int n2 = x + 1;
                            curErrorGreen[n2] = curErrorGreen[n2] + g4;
                            int n3 = x + 1;
                            curErrorBlue[n3] = curErrorBlue[n3] + b4;
                            if (x < w - 2) {
                                int n4 = x + 2;
                                curErrorRed[n4] = curErrorRed[n4] + r2;
                                int n5 = x + 2;
                                curErrorGreen[n5] = curErrorGreen[n5] + g2;
                                int n6 = x + 2;
                                curErrorBlue[n6] = curErrorBlue[n6] + b2;
                            }
                        }
                        if (by + 1 >= h) continue;
                        if (x > 0) {
                            int n = x - 1;
                            nextErrorRed[n] = nextErrorRed[n] + r2;
                            int n7 = x - 1;
                            nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                            int n8 = x - 1;
                            nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                            if (x > 1) {
                                int n9 = x - 2;
                                nextErrorRed[n9] = nextErrorRed[n9] + r1;
                                int n10 = x - 2;
                                nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                                int n11 = x - 2;
                                nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                            }
                        }
                        int n = x;
                        nextErrorRed[n] = nextErrorRed[n] + r4;
                        int n12 = x;
                        nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                        int n13 = x;
                        nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                        if (x >= w - 1) continue;
                        int n14 = x + 1;
                        nextErrorRed[n14] = nextErrorRed[n14] + r2;
                        int n15 = x + 1;
                        nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                        int n16 = x + 1;
                        nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                        if (x >= w - 2) continue;
                        int n17 = x + 2;
                        nextErrorRed[n17] = nextErrorRed[n17] + r1;
                        int n18 = x + 2;
                        nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                        int n19 = x + 2;
                        nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeOverboardDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            int flipDir;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            int n = flipDir = this.flipY ? -1 : 1;
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            float populationBias = this.palette.populationBias;
            float strength = this.ditherStrength * 0.5f * (populationBias * populationBias);
            float noiseStrength = 2.0f / populationBias;
            float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.palette.colorCount + 1.5f);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                int y;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                int by = 0;
                int n2 = y = this.flipY ? h - 1 : 0;
                while (by < h) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    for (int x = 0; x < w; ++x) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(x, y);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[x] = 0;
                            continue;
                        }
                        float er = 0.0f;
                        float eg = 0.0f;
                        float eb = 0.0f;
                        switch (x << 1 & 2 | y & 1) {
                            case 0: {
                                er += (float)((x ^ y) % 9 - 4);
                                er += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                                eg += ((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                                eg += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                                eb += ((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                                eb += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                                break;
                            }
                            case 1: {
                                er += ((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                                er += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                                eg += ((float)PaletteReducer.TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                                eg += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                                eb += (float)((x ^ y) % 11 - 5);
                                eb += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                                break;
                            }
                            case 2: {
                                er += ((float)PaletteReducer.TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                                er += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                                eg += (float)((x ^ y) % 11 - 5);
                                eg += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                                eb += (float)((x ^ y) % 9 - 4);
                                eb += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                                break;
                            }
                            default: {
                                er += (float)((x ^ y) % 11 - 5);
                                er += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                                eg += (float)((x ^ y) % 9 - 4);
                                eg += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                                eb += ((float)PaletteReducer.TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                                eb += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                            }
                        }
                        er = er * noiseStrength + curErrorRed[x];
                        eg = eg * noiseStrength + curErrorGreen[x];
                        eb = eb * noiseStrength + curErrorBlue[x];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + Math.min(Math.max(er, -limit), limit) + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + Math.min(Math.max(eg, -limit), limit) + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + Math.min(Math.max(eb, -limit), limit) + 0.5f), 0), 255);
                        curLine[x] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        float rdiff = (float)((color >>> 24) - (used >>> 24)) * strength;
                        float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * strength;
                        float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * strength;
                        float r1 = rdiff * 16.0f / (45.0f + Math.abs(rdiff));
                        float g1 = gdiff * 16.0f / (45.0f + Math.abs(gdiff));
                        float b1 = bdiff * 16.0f / (45.0f + Math.abs(bdiff));
                        float r2 = r1 + r1;
                        float g2 = g1 + g1;
                        float b2 = b1 + b1;
                        float r4 = r2 + r2;
                        float g4 = g2 + g2;
                        float b4 = b2 + b2;
                        if (x < w - 1) {
                            int n3 = x + 1;
                            curErrorRed[n3] = curErrorRed[n3] + r4;
                            int n4 = x + 1;
                            curErrorGreen[n4] = curErrorGreen[n4] + g4;
                            int n5 = x + 1;
                            curErrorBlue[n5] = curErrorBlue[n5] + b4;
                            if (x < w - 2) {
                                int n6 = x + 2;
                                curErrorRed[n6] = curErrorRed[n6] + r2;
                                int n7 = x + 2;
                                curErrorGreen[n7] = curErrorGreen[n7] + g2;
                                int n8 = x + 2;
                                curErrorBlue[n8] = curErrorBlue[n8] + b2;
                            }
                        }
                        if (by + 1 >= h) continue;
                        if (x > 0) {
                            int n9 = x - 1;
                            nextErrorRed[n9] = nextErrorRed[n9] + r2;
                            int n10 = x - 1;
                            nextErrorGreen[n10] = nextErrorGreen[n10] + g2;
                            int n11 = x - 1;
                            nextErrorBlue[n11] = nextErrorBlue[n11] + b2;
                            if (x > 1) {
                                int n12 = x - 2;
                                nextErrorRed[n12] = nextErrorRed[n12] + r1;
                                int n13 = x - 2;
                                nextErrorGreen[n13] = nextErrorGreen[n13] + g1;
                                int n14 = x - 2;
                                nextErrorBlue[n14] = nextErrorBlue[n14] + b1;
                            }
                        }
                        int n15 = x;
                        nextErrorRed[n15] = nextErrorRed[n15] + r4;
                        int n16 = x;
                        nextErrorGreen[n16] = nextErrorGreen[n16] + g4;
                        int n17 = x;
                        nextErrorBlue[n17] = nextErrorBlue[n17] + b4;
                        if (x >= w - 1) continue;
                        int n18 = x + 1;
                        nextErrorRed[n18] = nextErrorRed[n18] + r2;
                        int n19 = x + 1;
                        nextErrorGreen[n19] = nextErrorGreen[n19] + g2;
                        int n20 = x + 1;
                        nextErrorBlue[n20] = nextErrorBlue[n20] + b2;
                        if (x >= w - 2) continue;
                        int n21 = x + 2;
                        nextErrorRed[n21] = nextErrorRed[n21] + r1;
                        int n22 = x + 2;
                        nextErrorGreen[n22] = nextErrorGreen[n22] + g1;
                        int n23 = x + 2;
                        nextErrorBlue[n23] = nextErrorBlue[n23] + b1;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    ++by;
                    y += flipDir;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeBurkesDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            int flipDir = this.flipY ? -1 : 1;
            float s = 0.175f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias * this.palette.populationBias);
            float strength = s * 0.29f / (0.19f + s);
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                int py;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                int by = 0;
                int n = py = this.flipY ? h - 1 : 0;
                while (by < h) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = curErrorRed[px];
                        float eg = curErrorGreen[px];
                        float eb = curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        int rdiff = (color >>> 24) - (used >>> 24);
                        int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                        int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                        float r1 = (float)rdiff * strength;
                        float g1 = (float)gdiff * strength;
                        float b1 = (float)bdiff * strength;
                        float r2 = r1 + r1;
                        float g2 = g1 + g1;
                        float b2 = b1 + b1;
                        float r4 = r2 + r2;
                        float g4 = g2 + g2;
                        float b4 = b2 + b2;
                        if (px < w - 1) {
                            int n2 = px + 1;
                            curErrorRed[n2] = curErrorRed[n2] + r4;
                            int n3 = px + 1;
                            curErrorGreen[n3] = curErrorGreen[n3] + g4;
                            int n4 = px + 1;
                            curErrorBlue[n4] = curErrorBlue[n4] + b4;
                            if (px < w - 2) {
                                int n5 = px + 2;
                                curErrorRed[n5] = curErrorRed[n5] + r2;
                                int n6 = px + 2;
                                curErrorGreen[n6] = curErrorGreen[n6] + g2;
                                int n7 = px + 2;
                                curErrorBlue[n7] = curErrorBlue[n7] + b2;
                            }
                        }
                        if (by + 1 >= h) continue;
                        if (px > 0) {
                            int n8 = px - 1;
                            nextErrorRed[n8] = nextErrorRed[n8] + r2;
                            int n9 = px - 1;
                            nextErrorGreen[n9] = nextErrorGreen[n9] + g2;
                            int n10 = px - 1;
                            nextErrorBlue[n10] = nextErrorBlue[n10] + b2;
                            if (px > 1) {
                                int n11 = px - 2;
                                nextErrorRed[n11] = nextErrorRed[n11] + r1;
                                int n12 = px - 2;
                                nextErrorGreen[n12] = nextErrorGreen[n12] + g1;
                                int n13 = px - 2;
                                nextErrorBlue[n13] = nextErrorBlue[n13] + b1;
                            }
                        }
                        int n14 = px;
                        nextErrorRed[n14] = nextErrorRed[n14] + r4;
                        int n15 = px;
                        nextErrorGreen[n15] = nextErrorGreen[n15] + g4;
                        int n16 = px;
                        nextErrorBlue[n16] = nextErrorBlue[n16] + b4;
                        if (px >= w - 1) continue;
                        int n17 = px + 1;
                        nextErrorRed[n17] = nextErrorRed[n17] + r2;
                        int n18 = px + 1;
                        nextErrorGreen[n18] = nextErrorGreen[n18] + g2;
                        int n19 = px + 1;
                        nextErrorBlue[n19] = nextErrorBlue[n19] + b2;
                        if (px >= w - 2) continue;
                        int n20 = px + 2;
                        nextErrorRed[n20] = nextErrorRed[n20] + r1;
                        int n21 = px + 2;
                        nextErrorGreen[n21] = nextErrorGreen[n21] + g1;
                        int n22 = px + 2;
                        nextErrorBlue[n22] = nextErrorBlue[n22] + b1;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    ++by;
                    py += flipDir;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeOceanicDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        float[] noise = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            int flipDir = this.flipY ? -1 : 1;
            float s = 0.175f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias * this.palette.populationBias);
            float strength = s * 0.29f / (0.19f + s);
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                int py;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                int by = 0;
                int n = py = this.flipY ? h - 1 : 0;
                while (by < h) {
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    for (int px = 0; px < w; ++px) {
                        int ny;
                        float modifier;
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = curErrorRed[px];
                        float eg = curErrorGreen[px];
                        float eb = curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        int rdiff = (color >>> 24) - (used >>> 24);
                        int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                        int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                        float r1 = (float)rdiff * strength;
                        float g1 = (float)gdiff * strength;
                        float b1 = (float)bdiff * strength;
                        float r2 = r1 + r1;
                        float g2 = g1 + g1;
                        float b2 = b1 + b1;
                        float r4 = r2 + r2;
                        float g4 = g2 + g2;
                        float b4 = b2 + b2;
                        if (px < w - 1) {
                            modifier = noise[px + 1 & 0x3F | py << 6 & 0xFC0];
                            int n2 = px + 1;
                            curErrorRed[n2] = curErrorRed[n2] + r4 * modifier;
                            int n3 = px + 1;
                            curErrorGreen[n3] = curErrorGreen[n3] + g4 * modifier;
                            int n4 = px + 1;
                            curErrorBlue[n4] = curErrorBlue[n4] + b4 * modifier;
                            if (px < w - 2) {
                                modifier = noise[px + 2 & 0x3F | py << 6 & 0xFC0];
                                int n5 = px + 2;
                                curErrorRed[n5] = curErrorRed[n5] + r2 * modifier;
                                int n6 = px + 2;
                                curErrorGreen[n6] = curErrorGreen[n6] + g2 * modifier;
                                int n7 = px + 2;
                                curErrorBlue[n7] = curErrorBlue[n7] + b2 * modifier;
                            }
                        }
                        if ((ny = by + 1) >= h) continue;
                        if (px > 0) {
                            modifier = noise[px - 1 & 0x3F | ny << 6 & 0xFC0];
                            int n8 = px - 1;
                            nextErrorRed[n8] = nextErrorRed[n8] + r2 * modifier;
                            int n9 = px - 1;
                            nextErrorGreen[n9] = nextErrorGreen[n9] + g2 * modifier;
                            int n10 = px - 1;
                            nextErrorBlue[n10] = nextErrorBlue[n10] + b2 * modifier;
                            if (px > 1) {
                                modifier = noise[px - 2 & 0x3F | ny << 6 & 0xFC0];
                                int n11 = px - 2;
                                nextErrorRed[n11] = nextErrorRed[n11] + r1 * modifier;
                                int n12 = px - 2;
                                nextErrorGreen[n12] = nextErrorGreen[n12] + g1 * modifier;
                                int n13 = px - 2;
                                nextErrorBlue[n13] = nextErrorBlue[n13] + b1 * modifier;
                            }
                        }
                        modifier = noise[px & 0x3F | ny << 6 & 0xFC0];
                        int n14 = px;
                        nextErrorRed[n14] = nextErrorRed[n14] + r4 * modifier;
                        int n15 = px;
                        nextErrorGreen[n15] = nextErrorGreen[n15] + g4 * modifier;
                        int n16 = px;
                        nextErrorBlue[n16] = nextErrorBlue[n16] + b4 * modifier;
                        if (px >= w - 1) continue;
                        modifier = noise[px + 1 & 0x3F | ny << 6 & 0xFC0];
                        int n17 = px + 1;
                        nextErrorRed[n17] = nextErrorRed[n17] + r2 * modifier;
                        int n18 = px + 1;
                        nextErrorGreen[n18] = nextErrorGreen[n18] + g2 * modifier;
                        int n19 = px + 1;
                        nextErrorBlue[n19] = nextErrorBlue[n19] + b2 * modifier;
                        if (px >= w - 2) continue;
                        modifier = noise[px + 2 & 0x3F | ny << 6 & 0xFC0];
                        int n20 = px + 2;
                        nextErrorRed[n20] = nextErrorRed[n20] + r1 * modifier;
                        int n21 = px + 2;
                        nextErrorGreen[n21] = nextErrorGreen[n21] + g1 * modifier;
                        int n22 = px + 2;
                        nextErrorBlue[n22] = nextErrorBlue[n22] + b1 * modifier;
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    ++by;
                    py += flipDir;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void writeSeasideDithered(OutputStream output, Array<Pixmap> frames, int fps) {
        Pixmap pixmap = (Pixmap)frames.first();
        int[] paletteArray = this.palette.paletteArray;
        byte[] paletteMapping = this.palette.paletteMapping;
        float[] noiseA = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS;
        float[] noiseB = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS_B;
        float[] noiseC = PaletteReducer.TRI_BLUE_NOISE_MULTIPLIERS_C;
        DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutput = new DataOutputStream(output);
        try {
            float[] nextErrorBlue;
            float[] curErrorBlue;
            float[] nextErrorGreen;
            float[] curErrorGreen;
            float[] nextErrorRed;
            float[] curErrorRed;
            dataOutput.write(SIGNATURE);
            int w = pixmap.getWidth();
            int h = pixmap.getHeight();
            int flipDir = this.flipY ? -1 : 1;
            float s = 0.13f * this.ditherStrength * (this.palette.populationBias * this.palette.populationBias);
            float strength = s * 0.29f / (0.18f + s);
            if (this.palette.curErrorRedFloats == null) {
                this.palette.curErrorRedFloats = new FloatArray(w);
                curErrorRed = this.palette.curErrorRedFloats.items;
                this.palette.nextErrorRedFloats = new FloatArray(w);
                nextErrorRed = this.palette.nextErrorRedFloats.items;
                this.palette.curErrorGreenFloats = new FloatArray(w);
                curErrorGreen = this.palette.curErrorGreenFloats.items;
                this.palette.nextErrorGreenFloats = new FloatArray(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.items;
                this.palette.curErrorBlueFloats = new FloatArray(w);
                curErrorBlue = this.palette.curErrorBlueFloats.items;
                this.palette.nextErrorBlueFloats = new FloatArray(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.items;
            } else {
                curErrorRed = this.palette.curErrorRedFloats.ensureCapacity(w);
                nextErrorRed = this.palette.nextErrorRedFloats.ensureCapacity(w);
                curErrorGreen = this.palette.curErrorGreenFloats.ensureCapacity(w);
                nextErrorGreen = this.palette.nextErrorGreenFloats.ensureCapacity(w);
                curErrorBlue = this.palette.curErrorBlueFloats.ensureCapacity(w);
                nextErrorBlue = this.palette.nextErrorBlueFloats.ensureCapacity(w);
                Arrays.fill(nextErrorRed, 0, w, 0.0f);
                Arrays.fill(nextErrorGreen, 0, w, 0.0f);
                Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            }
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(w);
            this.buffer.writeInt(h);
            this.buffer.writeByte(8);
            this.buffer.writeByte(3);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1347179589);
            for (int i = 0; i < paletteArray.length; ++i) {
                int p = paletteArray[i];
                this.buffer.write(p >>> 24);
                this.buffer.write(p >>> 16);
                this.buffer.write(p >>> 8);
            }
            this.buffer.endChunk(dataOutput);
            boolean hasTransparent = false;
            if (paletteArray[0] == 0) {
                hasTransparent = true;
                this.buffer.writeInt(1951551059);
                this.buffer.write(0);
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1633899596);
            this.buffer.writeInt(frames.size);
            this.buffer.writeInt(0);
            this.buffer.endChunk(dataOutput);
            int seq = 0;
            for (int i = 0; i < frames.size; ++i) {
                int py;
                byte[] curLine;
                this.buffer.writeInt(1717785676);
                this.buffer.writeInt(seq++);
                this.buffer.writeInt(w);
                this.buffer.writeInt(h);
                this.buffer.writeInt(0);
                this.buffer.writeInt(0);
                this.buffer.writeShort(1);
                this.buffer.writeShort(fps);
                this.buffer.writeByte(0);
                this.buffer.writeByte(0);
                this.buffer.endChunk(dataOutput);
                if (i == 0) {
                    this.buffer.writeInt(1229209940);
                } else {
                    pixmap = (Pixmap)frames.get(i);
                    this.buffer.writeInt(1717846356);
                    this.buffer.writeInt(seq++);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                }
                this.deflater.reset();
                if (this.curLineBytes == null) {
                    this.curLineBytes = new ByteArray(w);
                    curLine = this.curLineBytes.items;
                } else {
                    curLine = this.curLineBytes.ensureCapacity(w);
                }
                int by = 0;
                int n = py = this.flipY ? h - 1 : 0;
                while (by < h) {
                    int ny = by + 1;
                    System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
                    System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
                    System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
                    Arrays.fill(nextErrorRed, 0.0f);
                    Arrays.fill(nextErrorGreen, 0.0f);
                    Arrays.fill(nextErrorBlue, 0.0f);
                    for (int px = 0; px < w; ++px) {
                        byte paletteIndex;
                        int color = pixmap.getPixel(px, py);
                        if ((color & 0x80) == 0 && hasTransparent) {
                            curLine[px] = 0;
                            continue;
                        }
                        float er = curErrorRed[px];
                        float eg = curErrorGreen[px];
                        float eb = curErrorBlue[px];
                        int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                        int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                        int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                        curLine[px] = paletteIndex = paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                        int used = paletteArray[paletteIndex & 0xFF];
                        int rdiff = (color >>> 24) - (used >>> 24);
                        int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                        int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                        int modifier = px & 0x3F | py << 6 & 0xFC0;
                        float r1 = (float)rdiff * strength * noiseA[modifier];
                        float g1 = (float)gdiff * strength * noiseB[modifier];
                        float b1 = (float)bdiff * strength * noiseC[modifier];
                        float r2 = r1 + r1;
                        float g2 = g1 + g1;
                        float b2 = b1 + b1;
                        float r4 = r2 + r2;
                        float g4 = g2 + g2;
                        float b4 = b2 + b2;
                        if (px < w - 1) {
                            modifier = px + 1 & 0x3F | py << 6 & 0xFC0;
                            int n2 = px + 1;
                            curErrorRed[n2] = curErrorRed[n2] + r4 * noiseA[modifier];
                            int n3 = px + 1;
                            curErrorGreen[n3] = curErrorGreen[n3] + g4 * noiseB[modifier];
                            int n4 = px + 1;
                            curErrorBlue[n4] = curErrorBlue[n4] + b4 * noiseC[modifier];
                            if (px < w - 2) {
                                modifier = px + 2 & 0x3F | py << 6 & 0xFC0;
                                int n5 = px + 2;
                                curErrorRed[n5] = curErrorRed[n5] + r2 * noiseA[modifier];
                                int n6 = px + 2;
                                curErrorGreen[n6] = curErrorGreen[n6] + g2 * noiseB[modifier];
                                int n7 = px + 2;
                                curErrorBlue[n7] = curErrorBlue[n7] + b2 * noiseC[modifier];
                            }
                            if (px < w - 3) {
                                modifier = px + 3 & 0x3F | py << 6 & 0xFC0;
                                int n8 = px + 2;
                                curErrorRed[n8] = curErrorRed[n8] + r1 * noiseA[modifier];
                                int n9 = px + 2;
                                curErrorGreen[n9] = curErrorGreen[n9] + g1 * noiseB[modifier];
                                int n10 = px + 2;
                                curErrorBlue[n10] = curErrorBlue[n10] + b1 * noiseC[modifier];
                            }
                        }
                        if (ny >= h) continue;
                        if (px > 0) {
                            modifier = px - 1 & 0x3F | ny << 6 & 0xFC0;
                            int n11 = px - 1;
                            nextErrorRed[n11] = nextErrorRed[n11] + r2 * noiseA[modifier];
                            int n12 = px - 1;
                            nextErrorGreen[n12] = nextErrorGreen[n12] + g2 * noiseB[modifier];
                            int n13 = px - 1;
                            nextErrorBlue[n13] = nextErrorBlue[n13] + b2 * noiseC[modifier];
                            if (px > 1) {
                                modifier = px - 2 & 0x3F | ny << 6 & 0xFC0;
                                int n14 = px - 2;
                                nextErrorRed[n14] = nextErrorRed[n14] + r1 * noiseA[modifier];
                                int n15 = px - 2;
                                nextErrorGreen[n15] = nextErrorGreen[n15] + g1 * noiseB[modifier];
                                int n16 = px - 2;
                                nextErrorBlue[n16] = nextErrorBlue[n16] + b1 * noiseC[modifier];
                            }
                        }
                        modifier = px & 0x3F | ny << 6 & 0xFC0;
                        int n17 = px;
                        nextErrorRed[n17] = nextErrorRed[n17] + r4 * noiseA[modifier];
                        int n18 = px;
                        nextErrorGreen[n18] = nextErrorGreen[n18] + g4 * noiseB[modifier];
                        int n19 = px;
                        nextErrorBlue[n19] = nextErrorBlue[n19] + b4 * noiseC[modifier];
                        if (px >= w - 1) continue;
                        modifier = px + 1 & 0x3F | ny << 6 & 0xFC0;
                        int n20 = px + 1;
                        nextErrorRed[n20] = nextErrorRed[n20] + r2 * noiseA[modifier];
                        int n21 = px + 1;
                        nextErrorGreen[n21] = nextErrorGreen[n21] + g2 * noiseB[modifier];
                        int n22 = px + 1;
                        nextErrorBlue[n22] = nextErrorBlue[n22] + b2 * noiseC[modifier];
                        if (px >= w - 2) continue;
                        modifier = px + 2 & 0x3F | ny << 6 & 0xFC0;
                        int n23 = px + 2;
                        nextErrorRed[n23] = nextErrorRed[n23] + r1 * noiseA[modifier];
                        int n24 = px + 2;
                        nextErrorGreen[n24] = nextErrorGreen[n24] + g1 * noiseB[modifier];
                        int n25 = px + 2;
                        nextErrorBlue[n25] = nextErrorBlue[n25] + b1 * noiseC[modifier];
                    }
                    deflaterOutput.write(0);
                    deflaterOutput.write(curLine, 0, w);
                    ++by;
                    py += flipDir;
                }
                deflaterOutput.finish();
                this.buffer.endChunk(dataOutput);
            }
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }
        catch (IOException e) {
            Gdx.app.error("anim8", e.getMessage());
        }
    }

    public void dispose() {
        this.deflater.end();
    }

    protected static OrderedMap<String, byte[]> readChunks(InputStream inStream) throws IOException {
        DataInputStream in = new DataInputStream(inStream);
        if (in.readLong() != -8552249625308161526L) {
            throw new IOException("PNG signature not found!");
        }
        OrderedMap chunks = new OrderedMap(10);
        boolean trucking = true;
        while (trucking) {
            try {
                int length = in.readInt();
                if (length < 0) {
                    throw new IOException("Sorry, that file is too long.");
                }
                byte[] typeBytes = new byte[4];
                in.readFully(typeBytes);
                byte[] data = new byte[length];
                in.readFully(data);
                int crc = in.readInt();
                String type = new String(typeBytes, "UTF8");
                chunks.put((Object)type, (Object)data);
            }
            catch (EOFException eofe) {
                trucking = false;
            }
        }
        in.close();
        return chunks;
    }

    protected static void writeChunks(OutputStream outStream, OrderedMap<String, byte[]> chunks) {
        DataOutputStream out = new DataOutputStream(outStream);
        CRC32 crc = new CRC32();
        try {
            out.writeLong(-8552249625308161526L);
            for (ObjectMap.Entry ent : chunks.entries()) {
                out.writeInt(((byte[])ent.value).length);
                byte[] k = ((String)ent.key).getBytes("UTF8");
                out.write(k);
                crc.update(k, 0, k.length);
                out.write((byte[])ent.value);
                crc.update((byte[])ent.value, 0, ((byte[])ent.value).length);
                out.writeInt((int)crc.getValue());
                crc.reset();
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void swapPalette(FileHandle input, FileHandle output, int[] palette) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            int p = 0;
            for (int i = 0; i < palette.length && p < pal.length - 2; ++i) {
                int rgba = palette[i];
                pal[p++] = (byte)(rgba >>> 24);
                pal[p++] = (byte)(rgba >>> 16);
                pal[p++] = (byte)(rgba >>> 8);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void editPalette(FileHandle input, FileHandle output, Interpolation editor) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            for (int p = 0; p < pal.length - 2; p += 3) {
                pal[p] = (byte)editor.apply(0.0f, 255.999f, (float)(pal[p] & 0xFF) / 255.0f);
                pal[p + 1] = (byte)editor.apply(0.0f, 255.999f, (float)(pal[p + 1] & 0xFF) / 255.0f);
                pal[p + 2] = (byte)editor.apply(0.0f, 255.999f, (float)(pal[p + 2] & 0xFF) / 255.0f);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void centralizePalette(FileHandle input, FileHandle output) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            for (int p = 0; p < pal.length; ++p) {
                pal[p] = OtherMath.centralize(pal[p]);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void centralizePalette(FileHandle input, FileHandle output, float amount) {
        try {
            InputStream inputStream = input.read();
            OrderedMap<String, byte[]> chunks = PNG8.readChunks(inputStream);
            byte[] pal = (byte[])chunks.get((Object)"PLTE");
            if (pal == null) {
                output.write(inputStream, false);
                return;
            }
            for (int p = 0; p < pal.length; ++p) {
                pal[p] = (byte)MathUtils.lerp((float)(pal[p] & 0xFF), (float)(OtherMath.centralize(pal[p]) & 0xFF), (float)amount);
            }
            PNG8.writeChunks(output.write(false), chunks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

