/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.anim8.ConstantData;
import com.github.tommyettinger.anim8.Dithered;
import com.github.tommyettinger.anim8.OtherMath;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class PaletteReducer {
    public static final int[] SNUGGLY = new int[]{0, 255, 0x111111FF, 537464319, 0x222222FF, 355210495, 0x333333FF, 0x444444FF, 0x555555FF, 1550018047, 0x666666FF, 0x777777FF, -2004317953, -1717986817, -1431655681, -1145324545, -977289729, -858993409, -572662273, -286331137, -1, -1625679105, -165075969, -177051905, -1453896961, -784259073, -174949121, -1841551617, -145216513, -1354883585, -581359873, -1116646657, -1282771969, -1151720705, -695508993, -777416193, -227005441, 1983912959, 2119910143, 1479743487, -239893249, -814340097, -288708865, -191614209, -1806099201, 1026036223, -1804184577, -1502469889, -659922433, -189843201, -795661825, -1383323393, 1733631487, -255443457, -1314622465, -726388993, -1230424833, 2020683519, -253607425, -488931329, -370823425, -1768661249, -2021250817, -757517057, 1212948479, -386254849, -1026915585, -369588993, -1194378753, -1447021569, -1868157441, 1466574079, -1057864961, -386219265, 1889284351, 1552099071, 2109488895, -1981532161, -1879427073, 2026910207, -1765900289, -1612283649, 507647743, 1253392127, -1493590529, 576396799, 628367615, 899362815, 885402879, 749479423, 1022834175, 1754294271, 920597247, 596321535, 2077719807, 2007792383, 1375370239, -1478115585, 920024831, 1005292799, -1965641729, 918386943, 747461887, 832925439, 712464127, 1241103103, 694637055, 1019979007, -1392974593, 987545599, 1014920191, 559369983, 2042344447, 423837695, 1492774143, 917809919, 1072423935, 1235328767, 697603583, 1691937535, 868079871, 986573567, 662345215, -1529090049, 765776383, 644054783, 1518705919, 713803007, 967635711, 508259583, 1941236479, 1754841599, -1816073985, 764342527, 813156351, 1064018687, 593010175, 372596479, 560251903, 795930623, 1737617663, 541167103, 626650879, -1868576001, 405098495, 558351359, 1736296959, 489791487, 591261695, 1347930879, 1752166399, 337087487, -1768361473, 269508863, 218968575, 387431423, 505146367, 1246141951, 1279881727, 1346563583, 1869322495, -1987858689, 1008585727, -977539329, 1918877695, 1312012287, 1884286719, 823820031, 1649709311, -1787301633, 1377627647, -1180438273, 1108714751, 1043356415, -1618685185, 1849671423, 1965223423, 1345355519, -1855403265, 772823039, -1756106497, 1780008447, 1578604543, -1775963905, -1907964673, -1015222017, 1293053183, 1899466751, -1118244353, -1843606785, -1255936769, -2145802753, -1287140865, -2058187009, 722350335, -1217739521, -668602625, -1407404033, -1721000705, -846475009, 1880519935, -413602305, -1774741249, -291181313, -870332417, -276173569, -181735681, -1521442049, -682898433, -289346817, -227547649, -1844017921, -912079873, -220860929, 1849320959, 1175665919, -232668417, -1189046785, -1249334785, -668884737, -730811137, 1645496831, -900685057, -196036353, -1491505665, 2132235263, -1858705153, -165244417, -921144833, -1103201537, -1538099713, -467569665, 1479360511, -225462017, -615348481, -193747969, 2118999551, -1290254081, -1301182977, -1860550913, -145456897, -165389825, -719237633, -257115137, -1889178113, -1405333505, -933993985, -712141313, 1932868351, 1578309887, 1041241087, -680495361, -297053441, -535158273, -1055186945, 2081954559};
    public static final int[] AURORA = new int[]{0, 0x10101FF, 0x131313FF, 0x252525FF, 0x373737FF, 0x494949FF, 0x5B5B5BFF, 0x6E6E6EFF, -2139062017, -1835887873, -1532713729, -1229539585, -909522433, -606348289, -303174145, -1, 0x7F7FFF, 0x3FBFBFFF, 0xFFFFFF, -1073741825, -2122186753, 65535, 0x3F3FBFFF, Short.MAX_VALUE, 0xF0F50FF, 0x7F007FFF, -1086341121, -184486401, -41811969, -4142081, -8289793, -16776961, -1086373889, 0x7F0000FF, 1427379455, 2134835455, -1082179585, -8453889, -4226561, -16385, -65281, -1077985281, 0x7F7F00FF, 0x7F00FF, 0x3FBF3FFF, 0xFF00FF, -1342197761, -1129332481, -878016001, -1499426561, 2123666687, 1854048255, 2121163007, -1603706881, -1065848065, -796232449, -509903361, -341144321, -172385281, -154619905, -169749761, 1463499775, 1933655295, -1907010049, -1418497025, -946892801, -475288577, -120399105, -473453569, -996248577, -1888266241, 1935096831, 992813055, 1094788095, 1936931839, -1886431233, -1566419457, -1246399745, -943222785, -623203329, -303183873, -941380609, -1412984833, -1900128769, 1938774015, 1484603135, 1179661055, 421400575, 592459775, 995572735, 1348751615, 997411327, 1469011967, 1940616191, 1690338047, -1882746881, -1562860801, -503776513, -1259418881, -1411136001, -2018210049, 1350393855, 258557695, 506274815, 591480575, 997422079, 1688972287, -1882732545, -1411128321, -940445185, -1093472001, -1412963329, -1464214273, -1884567553, 1469040639, 1467191295, 995587071, 253308415, 522140671, 993744895, 1229550591, 1465356287, 1936632575, 1987496703, -1886402561, -1414798337, -790955777, -471597057, -1416640513, -1890072577, 1935118335, 1463514111, 1008942335, 1177700095, 1916826367, -1890086913, -1420317697, -1418482689, -340991489, -2296321, -473439233, -507915521, -677331201, -946882049, -931290881, -1017474561, 1260926975, 840311807, 671751935, 1075319295, 1645740287, -1525413121, -635432705, -716027137, -12842241, -178638081, -10329345, -155373057, -5948161, -677703681, -630322433, -1269169921, -1605696001, 1597117695, 1397754623, 1650589951, -1937745153, -1399586561, -1313797377, -422225153, -2813697, -1422593, -922795521, -1678752001, -1763960321, 1942488575, 1789396479, 1013847295, 674498047, 541460735, 207359231, 345376255, 181865215, 350620415, 2113893375, 1274043135, 12915967, 95703295, 478957311, 305672959, 311984383, 113545727, 14576383, 770418943, 1023321599, 1795149311, -1846804481, 1441202175, 2111303935, 148821503, 278716159, 89808127, 372003583, 255294975, 4889855, 845453055, 5437183, 409648639, 595123455, 1771947007, 0x4AA4FFFF, -1867448321, 1522925567, -1095107841, 0xBFFFFF, 0x7FFFFF, 1266534655, 2020536575, 1247477759, 1648490239, 1010628095, 270326527, 1097215, 588289279, 203507967, 1343271167, 1611714815, -2026712321, -1673396225, 0x7F00FFFF, -1117585409, -1181614081, -676986881, -675022081, -121176833, -428605441, -11337729, -635379457, -1121320961, -1122974209, -1944797441, 1511554047, 1679058175, 1090544383, 839534335, 1427716095, -1608940801, -939493121, -11485185, -9779713, -90129921, -63271681, -434210561, -1123010049, -1741402625, -1860945921};
    public static final int[] BIG_PALETTE = new int[]{0, 255, -1, 0x80808FF, 0x101010FF, 0x181818FF, 0x202020FF, 0x292929FF, 0x313131FF, 0x393939FF, 0x414141FF, 0x4A4A4AFF, 0x525252FF, 0x5A5A5AFF, 0x626262FF, 0x6A6A6AFF, 0x737373FF, 0x7B7B7BFF, -2088532993, -1953788929, -1802201857, -1667457793, -1532713729, -1397969665, -1263225601, -1111638529, -976894465, -842150401, -707406337, -555819265, -421075201, -286331137, -151587073, -232408577, -472172289, -1383438849, 2000124927, 869845503, 729598463, -172737025, -933533697, 932916991, -214962689, -1393056257, 424167423, -1868706049, 1883359231, -853705217, 2020945151, -222124801, 1276591615, -1083653889, -845993985, -1790952705, -887044609, 1993962495, 1401264895, 975077119, -564386817, -403161345, -1230607361, 722147071, -1924167681, 1055975935, -535155457, 965538303, 1243407103, -848200449, -1692495617, 1790326015, 728585471, -1514606849, 286210815, -1973433089, -282753793, -1903415553, -320952577, 1664372223, -930753281, -1725970689, -676517121, -1487452929, -447101185, 1694009599, 1637655551, 1699845375, -311285505, -1155379969, -910325249, 1160058367, -1285388545, -181195777, 1151661055, 1380248319, -2075844609, -242647297, -1236496385, 1892497663, 1451913471, -1932071681, 490104319, -1820464385, -211383297, -1750780161, -1889897729, -376574209, -1339756801, 523607295, -1250931457, -1961073665, -345056001, 627254271, 1337962751, 1751425279, -767534593, -1597722881, 471787775, 642325503, -1501582593, -2109888001, 936178175, 930213375, -1772412673, -240941569, 1376852735, -1448901121, 1257585663, 967212031, -1795953921, 558986751, -2104691713, 1965156607, -1708910337, -1615054081, -1569029121, -558896129, 1360425471, -1453527809, 659666175, -813016833, 2102416639, 695937023, 2010559999, 1618197503, 1260104191, -395025921, -437157121, 1381180671, -1013530881, -1957517057, -1620237057, 1947738111, -981358593, 1001814271, 660900863, 2085743615, -1321261569, -548626689, -1596114177, 2123656703, -339416321, 1530430463, -1283198209, 678149119, -576363777, -1922735361, 931804159, -716641025, 1526121215, 1888405503, 1413264383, -261854977, -1474008065, 1500326911, -878396161, 890456831, -1486704641, -198288129, -1283184641, -2143598593, -277300737, -1354386689, 986547711, 695768319, 454658303, -1067899649, -309680129, -1476968449, -2102952961, -2075496449, -1105124353, 865324031, -793090049, 488290815, -1368555265, 1850043647, 833433087, 610361855, 2058347263, 1583008255, -1220120577, 1787507455, -1344489217, 1161323519, -1670131201, 1931393535, -1264177409, -1721213697, -224279041, -1434466817, 954832639, 647209471, 826838015, 0x111212FF, -1793245185, -1849917441, 405684223, -2023322625, -767284225, 1034539263, -590251265, 608165631, 1631067135, -913667073, -2056224257, 784676095, 763325439, 1959124735, 353854719, 1936845567, -614759169, 1973632511, -570898689, 1431731711, -1348669441, -1773804545, -960088833, -1972875521, 1813468671, -915346433, 850308607, 1214617599, -225430785, -1336517377, -1546418689, 456267519, -2039173889, 1864011007, -262127105, 850978303, 643492095, 1918510335, -777809409, -1802731521, 954087935, 697527039, 1545263615, 1897798399, -261057025, -2051713025, 1550018047, -944247809, 738545151, -1671830017, -64974337, -623372033, -1450681345, 1882611455, -427628801, 1623765247, 1248964351, -89704449, -1118413825, -113451009, -1091592705, 826486783, -1734627841, 1833018367, 813301247, 2087197695, -373317377, 1058679039, -1251366657, 872108799, 631731711, 374501887, -2069233665, 1766060287, -1975966721, -1004101377, -1865458177, 1803383551, -707593985, 1059611903, -1401489409, -370011649, -1163828225, -2058392065, -123865857, -1036849665, 1759755263, 1418510335, 1026140671, -764385537, -1912117761, 1063009279, -1498039553, 319498239, 2103293695, -567384577, -1920917249, -103175937, 1008203775, 1429419775, -930826497, -1893946369, 717389823, 493716223, 386228991, -1588384769, -615927553, -1662426369, 2023128831, 1329756415, -1877739265, -1492635905, -893686785, -1737917441, 1878967807, 1554501631, 1212793087, -427200513, -1506707969, 1282819583, -1278228993, 606420479, -1938241537, -145854209, -1650776833, 1766605823, -643906561, -1539260673, 802982143, 612864511, 472677631, -1234423297, 1897348607, -261701633, -2052027905, 1599900159, -1053607937, -640323073, 271107583, 992742655, -1451063041, 1915322367, 1690426879, 1365693695, -89950209, -1118927873, 1469009919, -1075130113, 842944511, -1684875265, 1898825727, -1397479681, 2070237183, -373764097, 1074807551, -1218522881, 871862527, 715300863, 575247103, -913950721, -1976284161, -1865772033, 69016319, 1836489215, 1125352191, -649052161, -386959617, 1313150463, -1164143617, -2042195457, 1826417407, 1518462975, 1444419583, -764833281, 1655265279, 1079468031, -1464998145, -2125538049, -568488961, -1160894465, -1937876481, -103556097, 1445746175, -914759425, 800894207, 677684991, -593543937, -1605478145, 864421887, -600450817, -1679450881, 305539583, 2056300799, 1396021759, -261404929, 1616780799, -894001409, 638656511, -1721720321, 1928853247, -82162945, 1671297535, 1362355711, 1848779263, -427581953, -1491101441, 1824808703, 1282502143, -1245121281, 672815359, -1871974401, -146499073, -924244225, -1667800321, 1766221567, -610996225, -1490623233, 869775615, 763345151, -289849345, 672439551, -1251449857, 1017122047, -229119745, -1509972737, 508573439, -2035632385, 1649520127, -1054121729, 1886856191, -640636929, 992555007, -1417956865, 1963696383, 1515584511, -2075448577, -107108097, -1102927361, 1994286335, 1485535999, 909537023, -1979503617, -1414435841, 2086630911, -340787713, -1169360897, 921879551, 865782015, -2932225, 775599359, -914264577, -1976930817, 1153109247, 677987071, -1832533249, 186069503, 1886175487, -649499393, 2140154367, -404049665, 1312898815, -1147813889, -1992903169, -1721486593, 1443903231, -748701185, 2147052287, 1671792383, 1129349631, -1540475393, -1177849089, 589367807, -1921416193, 1478456575, 934664447, 878234623, -610568449, -1605927425, 1272252927, 847465727, -1663054081, 372328191, 2106053119, 1495055359, -261785601, -1935004161, 1599753215, -877671169, -1688942337, -1401079297, 1848460799, -411383553, 1841271295, 1332384511, -1135984897, -130891265, -941262593, 876156159, -1668116225, 1815906559, 1003546367, 963960831, -306872577, 990909183, -1251898113, 1000232703, -1493509889, 558585855, -1985814273, 1749144319, -1055291905, -1698418433, 1869895423, -624305921, 1025658111, -1385113089, -1097449473, -2075765761, -90843649, -1070804993, 1994038271, 1535484671, 1009225215, -748402945, -738230529, 1146232319, -1414751233, 251991039, 2102827775, 1038873599, -602257153, -19953921, 991746303, 1395203839, -914646529, -1944743937, 1119379199, 728066047, -1782714369, 335956479, 1969219583, -650144513, -1495387649, 2123194623, -387652609, 1329291007, -1114904065, -1928013313, -810531841, -1738514433, -716185089, 2129962239, 1704964607, 1229300735, -394375681, -1540989953, 1382819327, -1178163713, 589178879, -1905153281, -163556865, 1095102719, 1765943551, -610949633, -1573215489, 1255302655, 880768511, -1613234689, 489186047, -2105804289, -262364417, -1292291585, -1935185153, -167842305, 1616211967, -844695297, -1623134465, -1088352513, -540391425, 338209023, -1401328897, 1864525311, -378670337, 1874444031, 1415624703, -57125889, -1136367361, 1619340287, -958353409, 168818175, 875968511, -1635010049, 1865067519, 2103128575, -307252993, 990260479, -1218989057, 1357737215, 1016693503, 658733055, 1864562943, -2027343105, -1715375361, 185861631, 1886289663, 1074817279, -666758145, -287028481, 189382911, -1114475265, -2059503873, 2027211519, 1601948159, -765496065, 1822372351, -738477825, 0x444F45FF, -1381644289, -2125873153, -1888208385, -20333825, 1394884351, -898448641, 1152683775, 811502335, -1622983425, -634602753, -1512343041, 422384127, 2139655167, 1378909951, -262269185, -33666049, -827556097, 554110207, -1722251521, -2131765505, 1788271359, 1345505279, -411467777, -1542291969, 2025403903, 1382568703, -1161833217, 622215423, -1855598081, -180978177, -1601355521, 1765625343, -594685697, -1541224705, 1255053823, 964205567, 655720703, -1252178433, -246428673, -1326087937, 658906111, -1935501057, 1665962751, -1105705473, -557414657, 958405119, -1401776897, 1941039871, 1532157439, -74217217, -1137078529, -2083243777, 1602379519, -925179649, 909137407, -1585323009, -1331214593, 2102811647, -290988289, -1186539009, 1357488895, 1083419647, 792172799, -898150913, -2027924225, 861938943, -1715690497, 0xC111CFF, 1919329279, -667136001, -287273473, 674424063, 1312302591, -1098079745, -2026792449, 2093807871, 0x666FF1FF, -766075649, -1913767169, 1822189823, -722146305, 1162438655, -1348668673, -2060196609, -1591864577, -1061139457, -1888458753, -20780289, 1427725311, -865735681, 1219344895, 945008383, -560966401, -1623366657, 1048194303, -1512657409, 438972415, -2122271745, 1461428223, -279357185, -50686977, 643169279, 1632710655, -811160065, -1689342977, 1797402111, -395203841, 2008445439, 1399027711, -1772750337, -1153623809, -182147585, -824553473, -1601604865, 1781886719, -545129473, 1321780991, 1081065983, -257271041, -1252495105, 1234449407, -214240257, -1326401537, 658718719, -1902394625, 1732097535, 1936341247, -541017857, 974861823, -1368802049, -2093204993, -57886977, -1104825345, -2100266497, 1635616511, 975467519, -749199873, -587902209, -1331462913, 2119139327, 1424217087, 1200280575, 975158015, -898466817, -2012908033, 1403927039, 861687295, -1682583297, 285487615, 1985661439, -684492545, -2088550145, -287653121, 1328826111, -1081816065, -1978483457, -1722465281, -733428481, -1930788353, 1838650367, 1228966143, -378396161, -1592442369, -1078163969, 555095039, -1872130305, 1509875455, -198299649, 1319494655, 1111741183, -578058497, -1607301377, 1556626943, 1064721151, -1479549441, 505629439, -2072585217, -279869953, -1835185921, -51000321, 1632392703, -794895873, -1640181249, 371624959, -1385214721, 1796820223, -379136769, 2024907007, 1465555967, -24370177, -1170715393, -841576961, 236508927, 892150015, -1585210113, 1814466559, 1421931519, 1231153151, -257584897, -1236297985, 1692615167, 1234200063, -1293227777, 708665087, -1835930369, 1831066111, -2078731265, -1598664961, 1936089855, -524687617, 1007439871, -1336155137, 390439935, -1064807169, -2093589249, -41753857, 242035711, -2100581377, 1685433599, -766289921, -604924673, 1179004159, -1315067393, -2142985217, 1367276543, 1343956991, -898980353, 1811760127, 1386901503, 911700223, -1632830209, 2085154815, -1640555521, -669016321, -1378855937, -2088800513, -271322113, 1345021183, -1032260097, 409057535, -761111553, -1722782721, 411513855, -701371393, -1931037185, 1871691007, 1328589567, -395419393, 1449080575, -1061702145, 571484927, -1839221505, -215719681, -1534983169, 1294399487, 1748251903, -561728769, -1575245057, 1539668223, 1097957631, 605251071, -1252908545, -263868929, -1158981633, -1835435521, -34668801, 1665497087, -1575290881, 427674623, -474258689, -1385596929, 547502847, -346685953, 2074790911, 1548664831, -41391873, -1171361025, 1702379775, -825114369, 891895295, -1552235009, -1248067329, 2102214911, -258031617, -1220494081, 1675592191, 1267437311, 808680959, -882170113, -2079310593, -1598913537, 0xA0A0AFF, 1952418047, -701746945, 429448703, -204118017, 691193599, -1065122817, -2077589761, 666648831, 292181503, -2050696961, 68435199, 1751831551, -766738177, 1938966783, -605304065, 1195527935, -1298868993, -2093889537, -1872344321, 1360020479, -866202113, 1420139519, 995005183, -528143617, -1657648897, -1379103489, 471997183, -2072406017, 1410958591, -280283393, 414510591, 726916607, 1648822271, -761426177, -1706651649, 752305663, 444883455, -1897929217, 154096639, 1954932223, 1746146047, -395866881, -2136190977, 1465605631, -1045437697, -1789797377, -217544449, -1551936513, 1747801599, -545595905, 1572907263, 1181328895, -190894593, -1253223169, -248392193, -1176005121, 725231615, -1819106049, 1715051007, 382729471, 762376959, 1969164287, -474507009, 907157759, -1369333761, 837962239, 564030975, -1745161729, 290088959, 2141255423, 1664804095, -2127488001, -41772801, -1155950593, -1933158913, 1702128383, -808849409, 941578751, -1502745089, -1265017857, 2101830911, -225055745, -1171856385, 1692054527, 1334032127, 941596159, -899195137, 978531327, -1582452225, 2002103551, -719168001, -2022107905, -204365569, 1294675711, -1048793601, -2045992705, 666466303, 1845135871, 426015231, 1049752063, 1868233471};
    public static final int[] HALTONIC = new int[]{0, 0x10101FF, -16843009, 0x7B7B7BFF, 0x555555FF, -1431655681, 0x333333FF, -522133249, -926365441, -1095020801, 531536639, -1027888641, -1268033281, 2088944383, -226337793, -716073985, -1940759297, 1794071039, 524524543, 2033324287, 993616639, 383201023, -1254111489, -1283405825, -303855105, -2078226689, 689377535, 1775555583, 1980898559, 531180287, 1686449407, 2051202047, -363176193, 2118028543, -1191561729, 1326832383, -1136762369, -1584312065, -1682102785, -258620673, -4042753, 2071788799, -1679244289, -497105665, 1031384575, -1069405441, 638475775, -163208193, -122886913, -1333321729, 1113074943, 1419216895, -484728065, 505555711, -1281559041, -1944887297, 1909166847, -1217940481, 2119184639, 1080465407, 1344997119, -542346241, -1038473473, -318872065, 2120541439, -1076744449, -627863553, -1902843649, -1596026113, -1939101185, 375586047, -900797185, -2003195137, 616323071, 1745528831, -26704385, 773746431, -2024368641, -1742987009, 1198669567, -186298369, 1897352447, -973558785, 1975502847, -230934529, -59512321, -1992663041, 1330693631, -530172417, -1341284353, -384840961, 513604607, 892926463, -476636161, 1342264319, 766693119, -1267890433, -29101313, 1341755647, 1128608255, -485157377, -543011841, 1115875071, 1449291775, -122121729, 1258894079, -680925441, -1871897089, -720288513, 1991702783, 1308093695, 378754559, -1211597313, 1695319039, 183054591, -306767105, 2024699903, 135411455, 635827455, 1514373887, -1308689665, -361034753, -210583041, -1558939137, 1054567167, -1539174145, -1295910145, -1365801729, -399411713, -114958337, -1424797697, -1069644801, 293566207, -421388801, 1798854911, -1997729025, 1043629823, 1035670783, -749395457, -1031574017, 609117695, -1406535937, -417703681, 287812607, -796466945, 1231756543, -763455745, -2026554625, -754389505, 1564191487, 290851839, 1184548607, -304825857, -1532878081, 1218927871, -1150151681, -71632129, 2034766335, -2088743169, -1308916225, 1640328703, -1657359873, 538350591, 407615999, 1527121663, -1420389633, 151725055, -1487324417, 349679103, -1402211841, -871465217, 462468351, -1515631361, 642058751, -376111617, -1042061313, 488035839, 475823615, -814134017, -151022081, 2065336575, 1756798207, -1428490241, 1713758719, 573769983, 1900543743, -546668545, -167894273, -1229860097, 904496895, 745133311, 1835256063, 839134719, -190671873, 570691071, -218447105, -4476161, -1656783617, -2039918849, -750036993, 1529750783, -221282049, 283881471, 2069904639, -35280897, -1273493249, -1472246785, -1037978369, -1778080513, -2021488641, 1058805503, 1520959231, 1426681087, 513352447, 51400959, -1568366081, 606399999, -1882123777, 1208781823, 1912496383, -31653121, -6659841, -733298945, -25453825, 1754357503, -1627401729, -1414759169, 1142145023, -113343489, 2056664063, -1604619265, -2086419457, 307055359, 964562687, 1795077631, -1755835393, -20511489, -1139514625, -1610030849, 1099466495, 1489698559, 1316639743, 2047344639, -1924219649, -30255105, -1536436737, -1334181889, -1869317889, -60013825, 1597195007, 1785372159, -10283521, -1655254273, 1736615935, -1786829569, -795887105};
    public static final float[][] OKLAB = new float[4][32768];
    public static final byte[] TRI_BLUE_NOISE = ConstantData.TRI_BLUE_NOISE;
    public static final byte[] TRI_BLUE_NOISE_B = ConstantData.TRI_BLUE_NOISE_B;
    public static final byte[] TRI_BLUE_NOISE_C = ConstantData.TRI_BLUE_NOISE_C;
    public static final float[] TRI_BLUE_NOISE_MULTIPLIERS = ConstantData.TRI_BLUE_NOISE_MULTIPLIERS;
    public static final float[] TRI_BLUE_NOISE_MULTIPLIERS_B = ConstantData.TRI_BLUE_NOISE_MULTIPLIERS_B;
    public static final float[] TRI_BLUE_NOISE_MULTIPLIERS_C = ConstantData.TRI_BLUE_NOISE_MULTIPLIERS_C;
    public final byte[] paletteMapping = new byte[32768];
    public final int[] paletteArray = new int[256];
    protected transient FloatArray curErrorRedFloats;
    protected transient FloatArray nextErrorRedFloats;
    protected transient FloatArray curErrorGreenFloats;
    protected transient FloatArray nextErrorGreenFloats;
    protected transient FloatArray curErrorBlueFloats;
    protected transient FloatArray nextErrorBlueFloats;
    public int colorCount;
    protected float ditherStrength = 1.0f;
    protected float populationBias = 0.5f;
    protected static final int[] thresholdMatrix8;
    protected static final int[] thresholdMatrix16;
    protected static final int[] thresholdMatrix64;
    protected final transient int[] candidates = new int[32];
    protected static final Comparator<IntIntMap.Entry> entryComparator;
    protected static final IntComparator lightnessComparator;
    protected static final IntComparator hueComparator;
    protected static boolean bigPaletteLoaded;
    protected static char[] bigPaletteMapping;

    public static int shrink(int color) {
        return color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F;
    }

    public static int stretch(int color) {
        return color << 17 & 0xF8000000 | color << 12 & 0x7000000 | color << 14 & 0xF80000 | color << 9 & 0x70000 | color << 11 & 0xF800 | color << 6 & 0x700 | 0xFF;
    }

    public static float forwardLight(float L) {
        return (float)Math.sqrt(L * L * L);
    }

    public static float reverseLight(float L) {
        int ix = NumberUtils.floatToRawIntBits((float)L);
        float x0 = L;
        ix = (ix >>> 2) + (ix >>> 4);
        ix += ix >>> 4;
        ix += (ix >>> 8) + 709965728;
        L = NumberUtils.intBitsToFloat((int)ix);
        L = 0.33333334f * (2.0f * L + x0 / (L * L));
        L = 0.33333334f * (1.9999999f * L + x0 / (L * L));
        return L * L;
    }

    public static int oklabToRGB(float L, float A, float B, float alpha) {
        L = PaletteReducer.reverseLight(L);
        float l = L + 0.39633778f * A + 0.21580376f * B;
        float m = L - 0.105561346f * A - 0.06385417f * B;
        float s = L - 0.08948418f * A - 1.2914855f * B;
        l *= l * l;
        m *= m * m;
        s *= s * s;
        int r = (int)(Math.sqrt(Math.min(Math.max(4.0767245f * l - 3.307217f * m + 0.23075905f * s, 0.0f), 1.0f)) * (double)255.999f);
        int g = (int)(Math.sqrt(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m - 0.34113443f * s, 0.0f), 1.0f)) * (double)255.999f);
        int b = (int)(Math.sqrt(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m + 1.7068626f * s, 0.0f), 1.0f)) * (double)255.999f);
        return r << 24 | g << 16 | b << 8 | (int)(alpha * 255.999f);
    }

    public static int[] colorsFrom(Pixmap pixmap) {
        return PaletteReducer.colorsFrom(pixmap, 256);
    }

    public static int[] colorsFrom(Pixmap pixmap, int limit) {
        int color;
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(256);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y) & 0xF8F8F880;
                if ((color & 0x80) == 0) continue;
                color |= color >>> 5 & 0x7070700 | 0xFF;
                counts.getAndIncrement(color, 0, 1);
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        int colorCount = Math.min(limit, es.size + 1);
        int[] colorArray = new int[colorCount];
        int i = 1;
        for (IntIntMap.Entry e : es) {
            colorArray[i] = color = e.key;
            if (++i < limit) continue;
            break;
        }
        return colorArray;
    }

    public void writePreloadFile(FileHandle file) {
        file.writeBytes(this.paletteMapping, false);
    }

    public static byte[] loadPreloadFile(FileHandle file) {
        return file.readBytes();
    }

    public PaletteReducer() {
        this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
    }

    public PaletteReducer(int[] rgbaPalette) {
        if (rgbaPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(rgbaPalette);
    }

    public PaletteReducer(int[] rgbaPalette, int limit) {
        if (rgbaPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(rgbaPalette, limit);
    }

    public PaletteReducer(Color[] colorPalette) {
        if (colorPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(colorPalette);
    }

    public PaletteReducer(Color[] colorPalette, int limit) {
        if (colorPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(colorPalette, limit);
    }

    public PaletteReducer(Pixmap pixmap) {
        if (pixmap == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.analyze(pixmap);
    }

    public PaletteReducer(Array<Pixmap> pixmaps) {
        if (pixmaps == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.analyze(pixmaps);
    }

    public PaletteReducer(int[] palette, byte[] preload) {
        this.exact(palette, preload);
    }

    public PaletteReducer(Pixmap pixmap, double threshold) {
        this.analyze(pixmap, threshold);
    }

    public double differenceMatch(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double differenceAnalyzing(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double differenceHW(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceHW(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double differenceMatch(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double differenceAnalyzing(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double differenceHW(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceHW(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double differenceMatch(int r1, int g1, int b1, int r2, int g2, int b2) {
        int idx1 = r1 << 7 & 0x7C00 | g1 << 2 & 0x3E0 | b1 >>> 3;
        int idx2 = r2 << 7 & 0x7C00 | g2 << 2 & 0x3E0 | b2 >>> 3;
        double dL = (double)(OKLAB[0][idx1] - OKLAB[0][idx2]) * 512.0;
        double dA = (double)(OKLAB[1][idx1] - OKLAB[1][idx2]) * 512.0;
        double dB = (double)(OKLAB[2][idx1] - OKLAB[2][idx2]) * 512.0;
        return dL * dL + dA * dA + dB * dB;
    }

    public double differenceAnalyzing(int r1, int g1, int b1, int r2, int g2, int b2) {
        int idx1 = r1 << 7 & 0x7C00 | g1 << 2 & 0x3E0 | b1 >>> 3;
        int idx2 = r2 << 7 & 0x7C00 | g2 << 2 & 0x3E0 | b2 >>> 3;
        double dL = (double)(OKLAB[0][idx1] - OKLAB[0][idx2]) * 512.0;
        double dA = (double)(OKLAB[1][idx1] - OKLAB[1][idx2]) * 512.0;
        double dB = (double)(OKLAB[2][idx1] - OKLAB[2][idx2]) * 512.0;
        return dL * dL + dA * dA + dB * dB;
    }

    public double differenceHW(int r1, int g1, int b1, int r2, int g2, int b2) {
        int idx1 = r1 << 7 & 0x7C00 | g1 << 2 & 0x3E0 | b1 >>> 3;
        int idx2 = r2 << 7 & 0x7C00 | g2 << 2 & 0x3E0 | b2 >>> 3;
        double dL = (double)(OKLAB[0][idx1] - OKLAB[0][idx2]) * 512.0;
        double dA = (double)(OKLAB[1][idx1] - OKLAB[1][idx2]) * 512.0;
        double dB = (double)(OKLAB[2][idx1] - OKLAB[2][idx2]) * 512.0;
        return dL * dL + dA * dA + dB * dB;
    }

    public void setDefaultPalette() {
        this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
    }

    public void exact(int[] rgbaPalette) {
        this.exact(rgbaPalette, 256);
    }

    public void exact(int[] rgbaPalette, int limit) {
        int plen;
        if (rgbaPalette == null || rgbaPalette.length < 2 || limit < 2) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        this.colorCount = plen = Math.min(Math.min(256, limit), rgbaPalette.length);
        this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        for (int i = 0; i < plen; ++i) {
            int color = rgbaPalette[i];
            if ((color & 0x80) == 0) continue;
            this.paletteArray[i] = color;
            this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = 1.0E100;
                    for (int i = 1; i < plen; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceMatch(this.paletteArray[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i;
                    }
                }
            }
        }
    }

    public void exact(int[] palette, byte[] preload) {
        if (palette == null || preload == null) {
            System.arraycopy(SNUGGLY, 0, this.paletteArray, 0, 256);
            System.arraycopy(ConstantData.ENCODED_SNUGGLY, 0, this.paletteMapping, 0, 32768);
            this.colorCount = 256;
            this.populationBias = (float)Math.exp(-0.00439453125);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.colorCount = Math.min(256, palette.length);
        System.arraycopy(palette, 0, this.paletteArray, 0, this.colorCount);
        System.arraycopy(preload, 0, this.paletteMapping, 0, 32768);
        this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
    }

    public void exact(Color[] colorPalette) {
        this.exact(colorPalette, 256);
    }

    public void exact(Color[] colorPalette, int limit) {
        int plen;
        if (colorPalette == null || colorPalette.length < 2 || limit < 2) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        this.colorCount = plen = Math.min(Math.min(256, colorPalette.length), limit);
        this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        for (int i = 0; i < plen; ++i) {
            int color;
            this.paletteArray[i] = color = Color.rgba8888((Color)colorPalette[i]);
            this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = 2.147483647E9;
                    for (int i = 1; i < plen; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceMatch(this.paletteArray[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i;
                    }
                }
            }
        }
    }

    private static void swap(int[] items, int first, int second) {
        int firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(int[] items, int from, int mid, int to, IntComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                PaletteReducer.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = PaletteReducer.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = PaletteReducer.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                PaletteReducer.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                PaletteReducer.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                PaletteReducer.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        PaletteReducer.inPlaceMerge(items, from, firstCut, mid, comp);
        PaletteReducer.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(int[] items, int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(int[] items, int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(int[] items, IntComparator c) {
        PaletteReducer.sort(items, 0, items.length, c);
    }

    public static void sort(int[] items, int from, int to, IntComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in IntComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    PaletteReducer.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        PaletteReducer.sort(items, from, mid, c);
        PaletteReducer.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        PaletteReducer.inPlaceMerge(items, from, mid, to, c);
    }

    public void analyze(Pixmap pixmap) {
        this.analyze(pixmap, 100.0);
    }

    public void analyze(Pixmap pixmap, double threshold) {
        this.analyze(pixmap, threshold, 256);
    }

    public void analyze(Pixmap pixmap, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.min(0.45, Math.pow(limit + 16, 1.45) * 2.0E-4);
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(limit);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y) & 0xF8F8F880;
                if ((color & 0x80) == 0) continue;
                color |= color >>> 5 & 0x7070700 | 0xFF;
                counts.getAndIncrement(color, 0, 1);
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block4: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    if (this.differenceAnalyzing(color, this.paletteArray[j]) < threshold) continue block4;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i2 = 1; i2 < this.colorCount; ++i2) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(this.paletteArray[i2], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i2;
                    }
                }
            }
        }
    }

    public void analyzeHueWise(Pixmap pixmap, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 3), 256);
        threshold /= Math.pow(limit, 1.35) * 4.3E-5;
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(limit);
        IntArray enc = new IntArray(width * height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y) & 0xF8F8F880;
                if ((color & 0x80) == 0) continue;
                color |= color >>> 5 & 0x7070700 | 0xFF;
                counts.getAndIncrement(color, 0, 1);
                if (((x & y) * 5 & 0x1F) >= 3) continue;
                enc.add(PaletteReducer.shrink(color));
            }
        }
        int cs = counts.size;
        if (cs < limit) {
            Array es = new Array(cs);
            for (IntIntMap.Entry e : counts) {
                IntIntMap.Entry e2 = new IntIntMap.Entry();
                e2.key = e.key;
                e2.value = e.value;
                es.add((Object)e2);
            }
            es.sort(entryComparator);
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            int[] ei = enc.items;
            PaletteReducer.sort(ei, 0, enc.size, hueComparator);
            this.paletteArray[1] = -1;
            this.paletteArray[2] = 255;
            i = 3;
            int encs = enc.size;
            int segments = Math.min(encs, limit - 3) + 1 >> 1;
            int e = 0;
            double lightPieces = Math.ceil(Math.log(limit));
            int s = 0;
            while (i < limit) {
                if (e > (e %= encs)) {
                    ++segments;
                    lightPieces += 1.0;
                    threshold *= 0.9;
                }
                s %= segments;
                int segStart = e;
                int segEnd = Math.min(segStart + (int)Math.ceil((double)encs / (double)segments), encs);
                int segLen = segEnd - segStart;
                PaletteReducer.sort(ei, segStart, segLen, lightnessComparator);
                block5: for (int li = 0; (double)li < lightPieces && li < segLen && i < limit; ++i, ++li) {
                    int start = e;
                    int end = Math.min(encs, start + (int)Math.ceil((double)segLen / lightPieces));
                    int len = end - start;
                    float totalL = 0.0f;
                    float totalA = 0.0f;
                    float totalB = 0.0f;
                    while (e < end) {
                        int index = ei[e];
                        totalL += OKLAB[0][index];
                        totalA += OKLAB[1][index];
                        totalB += OKLAB[2][index];
                        ++e;
                    }
                    color = PaletteReducer.oklabToRGB(OtherMath.barronSpline(totalL / (float)len, 3.0f, 0.5f), totalA /= (float)len, totalB /= (float)len, 1.0f);
                    for (int j = 3; j < i; ++j) {
                        if (this.differenceHW(color, this.paletteArray[j]) < threshold) break block5;
                    }
                    this.paletteArray[i] = color;
                    this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                }
                ++s;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i2 = 1; i2 < this.colorCount; ++i2) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceHW(this.paletteArray[i2], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i2;
                    }
                }
            }
        }
    }

    public void analyzeFast(Pixmap pixmap, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.min(0.45, Math.pow(limit + 16, 1.45) * 2.0E-4);
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(limit);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y) & 0xF8F8F880;
                if ((color & 0x80) == 0) continue;
                color |= color >>> 5 & 0x7070700 | 0xFF;
                counts.getAndIncrement(color, 0, 1);
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block4: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    if (this.differenceAnalyzing(color, this.paletteArray[j]) < threshold) continue block4;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        if (this.colorCount <= 1) {
            return;
        }
        int numUnassigned = 1;
        int iterations = 0;
        byte[] buffer = Arrays.copyOf(this.paletteMapping, 32768);
        while (numUnassigned != 0) {
            numUnassigned = 0;
            for (int r = 0; r < 32; ++r) {
                for (int g = 0; g < 32; ++g) {
                    for (int b = 0; b < 32; ++b) {
                        byte bt;
                        int c2 = r << 10 | g << 5 | b;
                        if (buffer[c2] != 0) continue;
                        if (iterations++ != 2) {
                            byte bt2;
                            if (b < 31 && (bt2 = this.paletteMapping[c2 + 1]) != 0) {
                                buffer[c2] = bt2;
                                continue;
                            }
                            if (g < 31 && (bt = this.paletteMapping[c2 + 32]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (r < 31 && (bt = this.paletteMapping[c2 + 1024]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (b > 0 && (bt = this.paletteMapping[c2 - 1]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (g > 0 && (bt = this.paletteMapping[c2 - 32]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            if (r > 0 && (bt = this.paletteMapping[c2 - 1024]) != 0) {
                                buffer[c2] = bt;
                                continue;
                            }
                            ++numUnassigned;
                            continue;
                        }
                        iterations = 0;
                        if (b < 31 && (bt = this.paletteMapping[c2 + 1]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g < 31 && (bt = this.paletteMapping[c2 + 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (r < 31 && (bt = this.paletteMapping[c2 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && (bt = this.paletteMapping[c2 - 1]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g > 0 && (bt = this.paletteMapping[c2 - 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (r > 0 && (bt = this.paletteMapping[c2 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && g < 31 && (bt = this.paletteMapping[c2 + 1 + 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && r < 31 && (bt = this.paletteMapping[c2 + 1 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g < 31 && r < 31 && (bt = this.paletteMapping[c2 + 32 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && g > 0 && (bt = this.paletteMapping[c2 - 1 - 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && r > 0 && (bt = this.paletteMapping[c2 - 1 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g > 0 && r > 0 && (bt = this.paletteMapping[c2 - 32 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && g > 0 && (bt = this.paletteMapping[c2 + 1 - 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b < 31 && r > 0 && (bt = this.paletteMapping[c2 + 1 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g < 31 && r > 0 && (bt = this.paletteMapping[c2 + 32 - 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && g < 31 && (bt = this.paletteMapping[c2 - 1 + 32]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (b > 0 && r < 31 && (bt = this.paletteMapping[c2 - 1 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        if (g > 0 && r < 31 && (bt = this.paletteMapping[c2 - 32 + 1024]) != 0) {
                            buffer[c2] = bt;
                            continue;
                        }
                        ++numUnassigned;
                    }
                }
            }
            System.arraycopy(buffer, 0, this.paletteMapping, 0, 32768);
        }
    }

    public void analyzeMC(Pixmap pixmap, int limit) {
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntArray bin = new IntArray(width * height);
        IntIntMap counts = new IntIntMap(limit);
        int hasTransparent = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y) & 0xF8F8F880;
                if ((color & 0x80) != 0) {
                    color |= color >>> 5 & 0x7070700 | 0xFF;
                    bin.add(color);
                    counts.getAndIncrement(color, 0, 1);
                    continue;
                }
                hasTransparent = 1;
            }
        }
        if (counts.size > (limit = Math.max(2 - hasTransparent, Math.min(limit - hasTransparent, 256)))) {
            int i;
            double b;
            double g;
            double r;
            int numCuts = 32 - Integer.numberOfLeadingZeros(limit - 1);
            int end = bin.size;
            int[] in = bin.items;
            int[] out = new int[end];
            int[] bufR = new int[32];
            int[] bufG = new int[32];
            int[] bufB = new int[32];
            for (int stage = 0; stage < numCuts; ++stage) {
                int size = bin.size >>> stage;
                int offset = 0;
                end = 0;
                for (int part = 1 << stage; part > 0; --part) {
                    int rangeB;
                    int rangeG;
                    int r2;
                    int rangeR;
                    int i2;
                    end = part == 1 ? bin.size : (end += size);
                    Arrays.fill(bufR, 0);
                    Arrays.fill(bufG, 0);
                    Arrays.fill(bufB, 0);
                    for (i2 = offset; i2 < end; ++i2) {
                        int ii = in[i2];
                        int n = ii >>> 27;
                        bufR[n] = bufR[n] + 1;
                        int n2 = ii >>> 19 & 0x1F;
                        bufG[n2] = bufG[n2] + 1;
                        int n3 = ii >>> 11 & 0x1F;
                        bufB[n3] = bufB[n3] + 1;
                    }
                    for (rangeR = 32; rangeR > 0 && bufR[rangeR - 1] == 0; --rangeR) {
                    }
                    for (r2 = 0; r2 < rangeR && bufR[r2] == 0; ++r2, --rangeR) {
                    }
                    for (rangeG = 32; rangeG > 0 && bufG[rangeG - 1] == 0; --rangeG) {
                    }
                    for (r2 = 0; r2 < rangeG && bufG[r2] == 0; ++r2, --rangeG) {
                    }
                    for (rangeB = 32; rangeB > 0 && bufB[rangeB - 1] == 0; --rangeB) {
                    }
                    for (r2 = 0; r2 < rangeB && bufB[r2] == 0; ++r2, --rangeB) {
                    }
                    if (rangeG >= rangeR && rangeG >= rangeB) {
                        for (i2 = 1; i2 < 32; ++i2) {
                            int n = i2;
                            bufG[n] = bufG[n] + bufG[i2 - 1];
                        }
                        for (i2 = end - 1; i2 >= offset; --i2) {
                            int n = in[i2] >>> 19 & 0x1F;
                            int n4 = bufG[n] - 1;
                            bufG[n] = n4;
                            out[offset + n4] = in[i2];
                        }
                    } else if (rangeR >= rangeG && rangeR >= rangeB) {
                        for (i2 = 1; i2 < 32; ++i2) {
                            int n = i2;
                            bufR[n] = bufR[n] + bufR[i2 - 1];
                        }
                        for (i2 = end - 1; i2 >= offset; --i2) {
                            int n = in[i2] >>> 27;
                            int n5 = bufR[n] - 1;
                            bufR[n] = n5;
                            out[offset + n5] = in[i2];
                        }
                    } else {
                        for (i2 = 1; i2 < 32; ++i2) {
                            int n = i2;
                            bufB[n] = bufB[n] + bufB[i2 - 1];
                        }
                        for (i2 = end - 1; i2 >= offset; --i2) {
                            int n = in[i2] >>> 11 & 0x1F;
                            int n6 = bufB[n] - 1;
                            bufB[n] = n6;
                            out[offset + n6] = in[i2];
                        }
                    }
                    offset += size;
                }
            }
            int jump = out.length >>> numCuts;
            int mid = 0;
            int assigned = 0;
            double fr = 270.0 / ((double)jump * 31.0);
            int n = (1 << numCuts) - 1;
            while (assigned < n) {
                r = 0.0;
                g = 0.0;
                b = 0.0;
                for (int i3 = mid + jump - 1; i3 >= mid; --i3) {
                    color = out[i3];
                    r += (double)(color >>> 27);
                    g += (double)(color >>> 19 & 0x1F);
                    b += (double)(color >>> 11 & 0x1F);
                }
                this.paletteArray[assigned] = Math.min(Math.max((int)((r - 7.0) * fr), 0), 255) << 24 | Math.min(Math.max((int)((g - 7.0) * fr), 0), 255) << 16 | Math.min(Math.max((int)((b - 7.0) * fr), 0), 255) << 8 | 0xFF;
                ++assigned;
                mid += jump;
            }
            int j2 = out.length - (mid - jump);
            r = 0.0;
            g = 0.0;
            b = 0.0;
            double fr2 = 270.0 / ((double)j2 * 31.0);
            for (int i4 = out.length - 1; i4 >= mid; --i4) {
                color = out[i4];
                r += (double)(color >>> 27);
                g += (double)(color >>> 19 & 0x1F);
                b += (double)(color >>> 11 & 0x1F);
            }
            this.paletteArray[assigned++] = Math.min(Math.max((int)((r - 7.0) * fr2), 0), 255) << 24 | Math.min(Math.max((int)((g - 7.0) * fr2), 0), 255) << 16 | Math.min(Math.max((int)((b - 7.0) * fr2), 0), 255) << 8 | 0xFF;
            block20: for (i = limit; i < assigned; ++i) {
                int currentCount = counts.get(this.paletteArray[i], 0);
                for (int j = 0; j < limit; ++j) {
                    if (counts.get(this.paletteArray[j], 0) >= currentCount) continue;
                    int temp = this.paletteArray[j];
                    this.paletteArray[j] = this.paletteArray[i];
                    this.paletteArray[i] = temp;
                    continue block20;
                }
            }
            if (hasTransparent == 1) {
                int min = Integer.MAX_VALUE;
                int worst = 0;
                for (int i5 = 0; i5 < limit; ++i5) {
                    int currentCount = counts.get(this.paletteArray[i5], 0);
                    if (currentCount >= min) continue;
                    min = currentCount;
                    worst = i5;
                }
                if (worst != 0) {
                    this.paletteArray[worst] = this.paletteArray[0];
                }
                this.paletteArray[0] = 0;
            }
            for (i = hasTransparent; i < limit; ++i) {
                color = this.paletteArray[i];
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
            }
            this.colorCount = limit;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            IntIntMap.Keys it = counts.keys();
            Arrays.fill(this.paletteArray, 0);
            for (int i = hasTransparent; i < limit && it.hasNext; ++i) {
                this.paletteArray[i] = color = it.next();
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
            }
            this.colorCount = counts.size + hasTransparent;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.POSITIVE_INFINITY;
                    for (int i = 1; i < this.colorCount; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(this.paletteArray[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i;
                    }
                }
            }
        }
    }

    public void alterBigPalette(int[] palette) {
        if (bigPaletteMapping == null) {
            bigPaletteMapping = new char[32768];
        }
        int plen = palette.length;
        if (palette != BIG_PALETTE) {
            System.arraycopy(palette, 0, BIG_PALETTE, 0, Math.min(plen, BIG_PALETTE.length));
        }
        if (plen < BIG_PALETTE.length) {
            Arrays.fill(BIG_PALETTE, plen, 1024, 0);
        }
        for (int i = 0; i < plen; ++i) {
            int color = palette[i];
            if ((color & 0x80) == 0) continue;
            PaletteReducer.bigPaletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (char)i;
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (bigPaletteMapping[c2] != '\u0000') continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = 1.0E100;
                    for (int i = 1; i < plen; ++i) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceMatch(BIG_PALETTE[i], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        PaletteReducer.bigPaletteMapping[c2] = (char)i;
                    }
                }
            }
        }
        bigPaletteLoaded = true;
    }

    public void writeBigPalette(FileHandle filename) {
        if (Gdx.files != null && bigPaletteMapping != null) {
            (filename == null ? Gdx.files.local("BigPaletteMapping.dat") : filename).writeString(new String(bigPaletteMapping), false, "UTF8");
        }
    }

    public void loadBigPalette(FileHandle file, int[] palette) {
        int plen = palette.length;
        System.arraycopy(palette, 0, BIG_PALETTE, 0, Math.min(plen, BIG_PALETTE.length));
        if (plen < BIG_PALETTE.length) {
            Arrays.fill(BIG_PALETTE, plen, 1024, 0);
        }
        if (bigPaletteMapping == null) {
            bigPaletteMapping = new char[32768];
        }
        file.readString("UTF8").getChars(0, 32768, bigPaletteMapping, 0);
        bigPaletteLoaded = true;
    }

    public void buildBigPalette() {
        FileHandle dat;
        if (bigPaletteLoaded) {
            return;
        }
        if (bigPaletteMapping == null) {
            bigPaletteMapping = new char[32768];
        }
        if (!(dat = Gdx.files.classpath("BigPaletteMapping.dat")).exists()) {
            this.alterBigPalette(BIG_PALETTE);
            return;
        }
        dat.readString("UTF8").getChars(0, 32768, bigPaletteMapping, 0);
        bigPaletteLoaded = true;
    }

    public void analyzeReductive(Pixmap pixmap) {
        this.analyzeReductive(pixmap, 100.0);
    }

    public void analyzeReductive(Pixmap pixmap, double threshold) {
        this.analyzeReductive(pixmap, threshold, 256);
    }

    public void analyzeReductive(Pixmap pixmap, double threshold, int limit) {
        int i;
        int color;
        this.buildBigPalette();
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.min(0.3, Math.pow(limit + 16, 1.45) * 1.3333E-4);
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        IntIntMap counts = new IntIntMap(limit);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = pixmap.getPixel(x, y) & 0xF8F8F880;
                if ((color & 0x80) == 0) continue;
                color = BIG_PALETTE[bigPaletteMapping[PaletteReducer.shrink(color)]];
                counts.getAndIncrement(color, 0, 1);
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block4: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    if (this.differenceAnalyzing(color, this.paletteArray[j]) < threshold) continue block4;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i2 = 1; i2 < this.colorCount; ++i2) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(this.paletteArray[i2], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i2;
                    }
                }
            }
        }
    }

    public int blend(int rgba1, int rgba2, float preference) {
        int a1 = rgba1 & 0xFF;
        int a2 = rgba2 & 0xFF;
        if ((a1 & 0x80) == 0) {
            return rgba2;
        }
        if ((a2 & 0x80) == 0) {
            return rgba1;
        }
        rgba1 = PaletteReducer.shrink(rgba1);
        rgba2 = PaletteReducer.shrink(rgba2);
        float L = OKLAB[0][rgba1] + (OKLAB[0][rgba2] - OKLAB[0][rgba1]) * preference;
        float A = OKLAB[1][rgba1] + (OKLAB[1][rgba2] - OKLAB[1][rgba1]) * preference;
        float B = OKLAB[2][rgba1] + (OKLAB[2][rgba2] - OKLAB[2][rgba1]) * preference;
        return PaletteReducer.oklabToRGB(L, A, B, ((float)a1 + (float)(a2 - a1) * preference) * 0.003921569f);
    }

    public void analyze(Array<Pixmap> pixmaps) {
        this.analyze((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, 100.0, 256);
    }

    public void analyze(Array<Pixmap> pixmaps, double threshold) {
        this.analyze((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, 256);
    }

    public void analyze(Array<Pixmap> pixmaps, double threshold, int limit) {
        this.analyze((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, limit);
    }

    public void analyze(Pixmap[] pixmaps, int pixmapCount, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.min(0.45, Math.pow(limit + 16, 1.45) * 2.0E-4);
        IntIntMap counts = new IntIntMap(limit);
        int[] reds = new int[limit];
        int[] greens = new int[limit];
        int[] blues = new int[limit];
        for (int i2 = 0; i2 < pixmapCount && i2 < pixmaps.length; ++i2) {
            Pixmap pixmap = pixmaps[i2];
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    color = pixmap.getPixel(x, y) & 0xF8F8F880;
                    if ((color & 0x80) == 0) continue;
                    color |= color >>> 5 & 0x7070700 | 0xFF;
                    counts.getAndIncrement(color, 0, 1);
                }
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block5: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    double diff = this.differenceAnalyzing(color, this.paletteArray[j]);
                    if (diff < threshold) continue block5;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i3 = 1; i3 < this.colorCount; ++i3) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(reds[i3], greens[i3], blues[i3], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i3;
                    }
                }
            }
        }
    }

    public void analyzeHueWise(Array<Pixmap> pixmaps) {
        this.analyzeHueWise((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, 100.0, 256);
    }

    public void analyzeHueWise(Array<Pixmap> pixmaps, double threshold) {
        this.analyzeHueWise((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, 256);
    }

    public void analyzeHueWise(Array<Pixmap> pixmaps, double threshold, int limit) {
        this.analyzeHueWise((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, limit);
    }

    public void analyzeHueWise(Pixmap[] pixmaps, int pixmapCount, double threshold, int limit) {
        int i;
        int color;
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 3), 256);
        threshold /= Math.pow(limit, 1.35) * 4.3E-5;
        int w0 = pixmaps[0].getWidth();
        int h0 = pixmaps[0].getHeight();
        IntIntMap counts = new IntIntMap(limit);
        IntArray enc = new IntArray(w0 * h0 * pixmapCount / 10);
        int[] reds = new int[limit];
        int[] greens = new int[limit];
        int[] blues = new int[limit];
        for (int i2 = 0; i2 < pixmapCount && i2 < pixmaps.length; ++i2) {
            Pixmap pixmap = pixmaps[i2];
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    color = pixmap.getPixel(x, y) & 0xF8F8F880;
                    if ((color & 0x80) == 0) continue;
                    color |= color >>> 5 & 0x7070700 | 0xFF;
                    counts.getAndIncrement(color, 0, 1);
                    if (((x & y) * 5 - i2 & 0x1F) >= 3) continue;
                    enc.add(PaletteReducer.shrink(color));
                }
            }
        }
        int cs = counts.size;
        if (cs < limit) {
            Array es = new Array(cs);
            for (IntIntMap.Entry e : counts) {
                IntIntMap.Entry e2 = new IntIntMap.Entry();
                e2.key = e.key;
                e2.value = e.value;
                es.add((Object)e2);
            }
            es.sort(entryComparator);
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
        } else {
            int[] ei = enc.items;
            PaletteReducer.sort(ei, 0, enc.size, hueComparator);
            this.paletteArray[1] = -1;
            reds[1] = 255;
            greens[1] = 255;
            blues[1] = 255;
            this.paletteArray[2] = 255;
            reds[2] = 0;
            greens[2] = 0;
            blues[2] = 0;
            i = 3;
            int encs = enc.size;
            int segments = Math.min(encs, limit - 3) + 1 >> 1;
            int e = 0;
            double lightPieces = Math.ceil(Math.log(limit));
            int s = 0;
            while (i < limit) {
                if (e > (e %= encs)) {
                    ++segments;
                    lightPieces += 1.0;
                    threshold *= 0.9;
                }
                s %= segments;
                int segStart = e;
                int segEnd = Math.min(segStart + (int)Math.ceil((double)encs / (double)segments), encs);
                int segLen = segEnd - segStart;
                PaletteReducer.sort(ei, segStart, segLen, lightnessComparator);
                block6: for (int li = 0; (double)li < lightPieces && li < segLen && i < limit; ++i, ++li) {
                    int start = e;
                    int end = Math.min(encs, start + (int)Math.ceil((double)segLen / lightPieces));
                    int len = end - start;
                    float totalL = 0.0f;
                    float totalA = 0.0f;
                    float totalB = 0.0f;
                    while (e < end) {
                        int index = ei[e];
                        totalL += OKLAB[0][index];
                        totalA += OKLAB[1][index];
                        totalB += OKLAB[2][index];
                        ++e;
                    }
                    color = PaletteReducer.oklabToRGB(OtherMath.barronSpline(totalL / (float)len, 3.0f, 0.5f), totalA /= (float)len, totalB /= (float)len, 1.0f);
                    for (int j = 3; j < i; ++j) {
                        if (this.differenceHW(color, this.paletteArray[j]) < threshold) break block6;
                    }
                    this.paletteArray[i] = color;
                    this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                    reds[i] = color >>> 24;
                    greens[i] = color >>> 16 & 0xFF;
                    blues[i] = color >>> 8 & 0xFF;
                }
                ++s;
            }
            this.colorCount = i;
        }
        this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i3 = 1; i3 < this.colorCount; ++i3) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceHW(reds[i3], greens[i3], blues[i3], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i3;
                    }
                }
            }
        }
    }

    public void analyzeReductive(Array<Pixmap> pixmaps) {
        this.analyzeReductive((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, 100.0, 256);
    }

    public void analyzeReductive(Array<Pixmap> pixmaps, double threshold) {
        this.analyzeReductive((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, 256);
    }

    public void analyzeReductive(Array<Pixmap> pixmaps, double threshold, int limit) {
        this.analyzeReductive((Pixmap[])pixmaps.toArray(Pixmap.class), pixmaps.size, threshold, limit);
    }

    public void analyzeReductive(Pixmap[] pixmaps, int pixmapCount, double threshold, int limit) {
        int i;
        int color;
        this.buildBigPalette();
        Arrays.fill(this.paletteArray, 0);
        Arrays.fill(this.paletteMapping, (byte)0);
        limit = Math.min(Math.max(limit, 2), 256);
        threshold /= Math.min(0.3, Math.pow(limit + 16, 1.45) * 1.3333E-4);
        IntIntMap counts = new IntIntMap(limit);
        int[] reds = new int[limit];
        int[] greens = new int[limit];
        int[] blues = new int[limit];
        for (int i2 = 0; i2 < pixmapCount && i2 < pixmaps.length; ++i2) {
            Pixmap pixmap = pixmaps[i2];
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    color = pixmap.getPixel(x, y) & 0xF8F8F880;
                    if ((color & 0x80) == 0) continue;
                    color = BIG_PALETTE[bigPaletteMapping[PaletteReducer.shrink(color)]];
                    counts.getAndIncrement(color, 0, 1);
                }
            }
        }
        int cs = counts.size;
        Array es = new Array(cs);
        for (IntIntMap.Entry e : counts) {
            IntIntMap.Entry e2 = new IntIntMap.Entry();
            e2.key = e.key;
            e2.value = e.value;
            es.add((Object)e2);
        }
        es.sort(entryComparator);
        if (cs < limit) {
            i = 1;
            for (IntIntMap.Entry e : es) {
                this.paletteArray[i] = color = e.key;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        } else {
            i = 1;
            int c = 0;
            block5: while (i < limit && c < cs) {
                color = ((IntIntMap.Entry)es.get((int)c++)).key;
                for (int j = 1; j < i; ++j) {
                    double diff = this.differenceAnalyzing(color, this.paletteArray[j]);
                    if (diff < threshold) continue block5;
                }
                this.paletteArray[i] = color;
                this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] = (byte)i;
                reds[i] = color >>> 24;
                greens[i] = color >>> 16 & 0xFF;
                blues[i] = color >>> 8 & 0xFF;
                ++i;
            }
            this.colorCount = i;
            this.populationBias = (float)Math.exp(-1.375 / (double)this.colorCount);
        }
        for (int r = 0; r < 32; ++r) {
            int rr = r << 3 | r >>> 2;
            for (int g = 0; g < 32; ++g) {
                int gg = g << 3 | g >>> 2;
                for (int b = 0; b < 32; ++b) {
                    int c2 = r << 10 | g << 5 | b;
                    if (this.paletteMapping[c2] != 0) continue;
                    int bb = b << 3 | b >>> 2;
                    double dist = Double.MAX_VALUE;
                    for (int i3 = 1; i3 < this.colorCount; ++i3) {
                        double d;
                        double d2 = dist;
                        dist = Math.min(dist, this.differenceAnalyzing(reds[i3], greens[i3], blues[i3], rr, gg, bb));
                        if (!(d2 > d)) continue;
                        this.paletteMapping[c2] = (byte)i3;
                    }
                }
            }
        }
    }

    public float getDitherStrength() {
        return this.ditherStrength;
    }

    public void setDitherStrength(float ditherStrength) {
        this.ditherStrength = Math.max(0.0f, ditherStrength);
    }

    public float getPopulationBias() {
        return this.populationBias;
    }

    public void setPopulationBias(float populationBias) {
        this.populationBias = populationBias;
    }

    public Pixmap reduce(Pixmap pixmap) {
        return this.reduceOverboard(pixmap);
    }

    public Pixmap reduce(Pixmap pixmap, Dithered.DitherAlgorithm ditherAlgorithm) {
        if (pixmap == null) {
            return null;
        }
        if (ditherAlgorithm == null) {
            return this.reduceOverboard(pixmap);
        }
        switch (ditherAlgorithm) {
            case NONE: {
                return this.reduceSolid(pixmap);
            }
            case GRADIENT_NOISE: {
                return this.reduceJimenez(pixmap);
            }
            case PATTERN: {
                return this.reduceKnoll(pixmap);
            }
            case CHAOTIC_NOISE: {
                return this.reduceChaoticNoise(pixmap);
            }
            case DIFFUSION: {
                return this.reduceFloydSteinberg(pixmap);
            }
            case BLUE_NOISE: {
                return this.reduceBlueNoise(pixmap);
            }
            case SCATTER: {
                return this.reduceScatter(pixmap);
            }
            case ROBERTS: {
                return this.reduceRoberts(pixmap);
            }
            case WOVEN: {
                return this.reduceWoven(pixmap);
            }
            case DODGY: {
                return this.reduceDodgy(pixmap);
            }
            case LOAF: {
                return this.reduceLoaf(pixmap);
            }
            case NEUE: {
                return this.reduceNeue(pixmap);
            }
            case BURKES: {
                return this.reduceBurkes(pixmap);
            }
            case WREN: {
                return this.reduceWren(pixmap);
            }
            case OCEANIC: {
                return this.reduceOceanic(pixmap);
            }
            case SEASIDE: {
                return this.reduceSeaside(pixmap);
            }
        }
        return this.reduceOverboard(pixmap);
    }

    public Pixmap reduceSolid(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = color >>> 24;
                int gg = color >>> 16 & 0xFF;
                int bb = color >>> 8 & 0xFF;
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceSierraLite(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float ditherStrength = this.ditherStrength * 20.0f;
        float halfDitherStrength = ditherStrength * 0.5f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float er = curErrorRed[px];
                float eg = curErrorGreen[px];
                float eb = curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                int used = this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = 0.0087890625f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.0087890625f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.0087890625f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * ditherStrength;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * ditherStrength;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * ditherStrength;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * halfDitherStrength;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * halfDitherStrength;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * halfDitherStrength;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * halfDitherStrength;
                int n6 = px;
                nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * halfDitherStrength;
                int n7 = px;
                nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * halfDitherStrength;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceFloydSteinberg(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = this.ditherStrength * 4.0f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + curErrorRed[px] + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + curErrorGreen[px] + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + curErrorBlue[px] + 0.5f), 0), 255);
                int used = this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = 0.005859375f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.005859375f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.005859375f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceJimenez(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float strength = 60.0f * this.ditherStrength / (this.populationBias * this.populationBias);
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float adj = (float)px * 0.06711056f + (float)y * 0.00583715f;
                adj -= (float)((int)adj);
                adj *= 52.982918f;
                adj -= (float)((int)adj);
                adj -= 0.5f;
                adj *= strength;
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + (adj += 0.5f)), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + adj), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + adj), 0), 255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceIgneous(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = 6.0f * this.ditherStrength * this.populationBias * this.populationBias;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 60.0f * this.ditherStrength / (this.populationBias * this.populationBias);
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float adj = (float)px * 0.06711056f + (float)y * 0.00583715f;
                adj -= (float)((int)adj);
                adj *= 52.982918f;
                adj -= (float)((int)adj);
                adj -= 0.5f;
                float er = (adj *= strength) + curErrorRed[px];
                float eg = adj + curErrorGreen[px];
                float eb = adj + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = 0.0029296875f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.0029296875f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.0029296875f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceRoberts(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float str = 32.0f * this.ditherStrength / (this.populationBias * this.populationBias * this.populationBias * this.populationBias);
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = color >>> 24;
                int gg = color >>> 16 & 0xFF;
                int bb = color >>> 8 & 0xFF;
                float theta = (float)((long)px * -4521708957497675121L + (long)y * -7935046062780286179L >>> 41) * 7.490141E-7f;
                rr = Math.min(Math.max((int)((float)rr + MathUtils.cos((float)theta) * str + 0.5f), 0), 255);
                gg = Math.min(Math.max((int)((float)gg + MathUtils.cos((float)(theta + 1.04f)) * str + 0.5f), 0), 255);
                bb = Math.min(Math.max((int)((float)bb + MathUtils.cos((float)(theta + 2.09f)) * str + 0.5f), 0), 255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceLoaf(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float strength = this.ditherStrength * this.populationBias;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int adj = (int)((float)(((px + y & 1) << 5) - 16) * strength);
                int rr = Math.min(Math.max((color >>> 24) + adj, 0), 255);
                int gg = Math.min(Math.max((color >>> 16 & 0xFF) + adj, 0), 255);
                int bb = Math.min(Math.max((color >>> 8 & 0xFF) + adj, 0), 255);
                int rgb555 = rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3;
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rgb555] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceWoven(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = (float)(20.0 * Math.sqrt(this.ditherStrength) * (double)this.populationBias * (double)this.populationBias * (double)this.populationBias * (double)this.populationBias);
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 48.0f * this.ditherStrength / (this.populationBias * this.populationBias * this.populationBias * this.populationBias);
        float limit = 5.0f + 110.0f / (float)Math.sqrt((float)this.colorCount + 1.5f);
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float er = Math.min(Math.max(((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorRed[px];
                float eg = Math.min(Math.max(((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorGreen[px];
                float eb = Math.min(Math.max(((float)((long)(px - 4) * -4521708957497675121L + (long)(y + 2) * -7935046062780286179L >>> 41) * 1.4901161E-7f - 0.625f) * strength, -limit), limit) + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = 0.0048828125f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.0048828125f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.0048828125f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceWrenOriginal(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = (float)(32.0 * (double)this.ditherStrength * (double)(this.populationBias * this.populationBias));
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 0.2f * this.ditherStrength / (this.populationBias * this.populationBias * this.populationBias * this.populationBias);
        float limit = 5.0f + 125.0f / (float)Math.sqrt((double)this.colorCount + 1.5);
        float dmul = 0.00390625f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float er = Math.min(Math.max(((float)TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 1.5258789E-5f - 64.0f)) * strength + curErrorRed[px], -limit), limit);
                float eg = Math.min(Math.max(((float)TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 1.5258789E-5f - 64.0f)) * strength + curErrorGreen[px], -limit), limit);
                float eb = Math.min(Math.max(((float)TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f + ((float)((long)(px + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 1.5258789E-5f - 64.0f)) * strength + curErrorBlue[px], -limit), limit);
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = 0.00390625f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.00390625f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.00390625f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceWren(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float partialDitherStrength = 0.4f * this.ditherStrength * (this.populationBias * this.populationBias);
        float strength = 40.0f * this.ditherStrength / (this.populationBias * this.populationBias);
        float blueStrength = 0.15f * this.ditherStrength / (this.populationBias * this.populationBias);
        float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.colorCount + 1.5f);
        for (int y = 0; y < h; ++y) {
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int x = 0; x < lineLen; ++x) {
                int color = pixmap.getPixel(x, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(x, y, 0);
                    continue;
                }
                float er = Math.min(Math.max(((float)TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 1) * -4521708957497675121L + (long)(y + 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorRed[x];
                float eg = Math.min(Math.max(((float)TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 3) * -4521708957497675121L + (long)(y - 1) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorGreen[x];
                float eb = Math.min(Math.max(((float)TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * blueStrength + ((float)((long)(x + 2) * -4521708957497675121L + (long)(y - 4) * -7935046062780286179L >>> 41) * 7.4505806E-8f - 0.3125f) * strength, -limit), limit) + curErrorBlue[x];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(x, y, used);
                float rdiff = (float)((color >>> 24) - (used >>> 24)) * partialDitherStrength;
                float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * partialDitherStrength;
                float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * partialDitherStrength;
                float r1 = rdiff * 16.0f / (float)Math.sqrt(2048.0f + rdiff * rdiff);
                float g1 = gdiff * 16.0f / (float)Math.sqrt(2048.0f + gdiff * gdiff);
                float b1 = bdiff * 16.0f / (float)Math.sqrt(2048.0f + bdiff * bdiff);
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (x < lineLen - 1) {
                    int n = x + 1;
                    curErrorRed[n] = curErrorRed[n] + r4;
                    int n2 = x + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4;
                    int n3 = x + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4;
                    if (x < lineLen - 2) {
                        int n4 = x + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2;
                        int n5 = x + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2;
                        int n6 = x + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2;
                    }
                }
                if (y + 1 >= h) continue;
                if (x > 0) {
                    int n = x - 1;
                    nextErrorRed[n] = nextErrorRed[n] + r2;
                    int n7 = x - 1;
                    nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                    int n8 = x - 1;
                    nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                    if (x > 1) {
                        int n9 = x - 2;
                        nextErrorRed[n9] = nextErrorRed[n9] + r1;
                        int n10 = x - 2;
                        nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                        int n11 = x - 2;
                        nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                    }
                }
                int n = x;
                nextErrorRed[n] = nextErrorRed[n] + r4;
                int n12 = x;
                nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                int n13 = x;
                nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                if (x >= lineLen - 1) continue;
                int n14 = x + 1;
                nextErrorRed[n14] = nextErrorRed[n14] + r2;
                int n15 = x + 1;
                nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                int n16 = x + 1;
                nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                if (x >= lineLen - 2) continue;
                int n17 = x + 2;
                nextErrorRed[n17] = nextErrorRed[n17] + r1;
                int n18 = x + 2;
                nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                int n19 = x + 2;
                nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceBlueNoise(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float strength = 60.0f * this.ditherStrength / (this.populationBias * OtherMath.cbrtPositive(this.colorCount));
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float adj = (float)TRI_BLUE_NOISE_B[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                adj = adj * strength / (12.0f + Math.abs(adj)) + 0.5f;
                int rr = Math.min(Math.max((int)(adj + (float)(color >>> 24)), 0), 255);
                adj = (float)TRI_BLUE_NOISE_C[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                adj = adj * strength / (12.0f + Math.abs(adj)) + 0.5f;
                int gg = Math.min(Math.max((int)(adj + (float)(color >>> 16 & 0xFF)), 0), 255);
                adj = (float)TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f;
                adj = adj * strength / (12.0f + Math.abs(adj)) + 0.5f;
                int bb = Math.min(Math.max((int)(adj + (float)(color >>> 8 & 0xFF)), 0), 255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceChaoticNoise(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        double strength = (double)(this.ditherStrength * this.populationBias) * 1.5;
        long s = -4521708957497675121L;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int rr = color >>> 24;
                int gg = color >>> 16 & 0xFF;
                int bb = color >>> 8 & 0xFF;
                int used = this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF];
                double adj = ((float)TRI_BLUE_NOISE[px & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.007843138f;
                adj *= adj * adj;
                long l = ((s ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L >> 15) + ((s ^ 0xFFFFFFFFFFFFFFFFL ^ 0xDB4F0B9175AE2165L) * -3335678366873096957L >> 15);
                s = (s ^ (long)(rr + gg + bb)) * -3372029247567499371L + -7935046062780286179L;
                rr = Math.min(Math.max((int)((double)rr + (adj += (double)((float)(px + y & 1) - 0.5f) * 2.6645352591003757E-15 * strength * (double)(l + (s >> 15))) * (double)(rr - (used >>> 24))), 0), 255);
                gg = Math.min(Math.max((int)((double)gg + adj * (double)(gg - (used >>> 16 & 0xFF))), 0), 255);
                bb = Math.min(Math.max((int)((double)bb + adj * (double)(bb - (used >>> 8 & 0xFF))), 0), 255);
                pixmap.drawPixel(px, y, this.paletteArray[this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceScatter(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = this.ditherStrength * 3.5f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                float tbn = TRI_BLUE_NOISE_MULTIPLIERS[px & 0x3F | y << 6 & 0xFC0];
                float er = curErrorRed[px] * tbn;
                float eg = curErrorGreen[px] * tbn;
                float eb = curErrorBlue[px] * tbn;
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, y, used);
                float rdiff = 0.011230469f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.011230469f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.011230469f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceNeue(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = this.ditherStrength * 7.0f;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 32.0f * this.ditherStrength / (this.populationBias * this.populationBias * this.populationBias);
        float limit = (float)Math.pow(80.0, 1.635 - (double)this.populationBias);
        for (int py = 0; py < h; ++py) {
            int ny = py + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, py, 0);
                    continue;
                }
                float adj = ((float)TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * 0.005f;
                adj = Math.min(Math.max(adj * strength, -limit), limit);
                float er = adj + curErrorRed[px];
                float eg = adj + curErrorGreen[px];
                float eb = adj + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, py, used);
                float rdiff = 0.0014038086f * (float)((color >>> 24) - (used >>> 24));
                float gdiff = 0.0014038086f * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = 0.0014038086f * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                rdiff *= 1.25f / (0.25f + Math.abs(rdiff));
                gdiff *= 1.25f / (0.25f + Math.abs(gdiff));
                bdiff *= 1.25f / (0.25f + Math.abs(bdiff));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceDodgy(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float w1 = 25.0f * this.ditherStrength * this.populationBias * this.populationBias;
        float w3 = w1 * 3.0f;
        float w5 = w1 * 5.0f;
        float w7 = w1 * 7.0f;
        float strength = 0.25f * this.ditherStrength / (this.populationBias * this.populationBias);
        float limit = 5.0f + 90.0f / (float)Math.sqrt((float)this.colorCount + 1.5f);
        float dmul = 0.0029296875f;
        for (int py = 0; py < h; ++py) {
            int ny = py + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, py, 0);
                    continue;
                }
                float er = Math.min(Math.max(((float)TRI_BLUE_NOISE[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorRed[px];
                float eg = Math.min(Math.max(((float)TRI_BLUE_NOISE_B[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorGreen[px];
                float eb = Math.min(Math.max(((float)TRI_BLUE_NOISE_C[px & 0x3F | (py & 0x3F) << 6] + 0.5f) * strength, -limit), limit) + curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, py, used);
                float rdiff = dmul * (float)((color >>> 24) - (used >>> 24));
                float gdiff = dmul * (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF));
                float bdiff = dmul * (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF));
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + rdiff * w7;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + gdiff * w7;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + bdiff * w7;
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w3;
                    int n4 = px - 1;
                    nextErrorGreen[n4] = nextErrorGreen[n4] + gdiff * w3;
                    int n5 = px - 1;
                    nextErrorBlue[n5] = nextErrorBlue[n5] + bdiff * w3;
                }
                if (px < lineLen - 1) {
                    int n = px + 1;
                    nextErrorRed[n] = nextErrorRed[n] + rdiff * w1;
                    int n6 = px + 1;
                    nextErrorGreen[n6] = nextErrorGreen[n6] + gdiff * w1;
                    int n7 = px + 1;
                    nextErrorBlue[n7] = nextErrorBlue[n7] + bdiff * w1;
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + rdiff * w5;
                int n8 = px;
                nextErrorGreen[n8] = nextErrorGreen[n8] + gdiff * w5;
                int n9 = px;
                nextErrorBlue[n9] = nextErrorBlue[n9] + bdiff * w5;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceOverboard(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        float strength = this.ditherStrength * 0.5f * (this.populationBias * this.populationBias);
        float noiseStrength = 2.0f / this.populationBias;
        float limit = 5.0f + 125.0f / (float)Math.sqrt((float)this.colorCount + 1.5f);
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int y = 0; y < h; ++y) {
            int ny = y + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int x = 0; x < lineLen; ++x) {
                int color = pixmap.getPixel(x, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(x, y, 0);
                    continue;
                }
                float er = 0.0f;
                float eg = 0.0f;
                float eb = 0.0f;
                switch (x << 1 & 2 | y & 1) {
                    case 0: {
                        er += (float)((x ^ y) % 9 - 4);
                        er += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eg += ((float)TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                        eg += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eb += ((float)TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                        eb += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                        break;
                    }
                    case 1: {
                        er += ((float)TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                        er += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eg += ((float)TRI_BLUE_NOISE_B[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                        eg += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                        eb += (float)((x ^ y) % 11 - 5);
                        eb += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                        break;
                    }
                    case 2: {
                        er += ((float)TRI_BLUE_NOISE[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.015625f;
                        er += (float)((long)y * -4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 1.4305115E-6f;
                        eg += (float)((x ^ y) % 11 - 5);
                        eg += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                        eb += (float)((x ^ y) % 9 - 4);
                        eb += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        break;
                    }
                    default: {
                        er += (float)((x ^ y) % 11 - 5);
                        er += (float)((long)y * 4521708957497675121L + (long)x * 7935046062780286179L >> 41) * 7.1525574E-7f;
                        eg += (float)((x ^ y) % 9 - 4);
                        eg += (float)((long)x * -4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                        eb += ((float)TRI_BLUE_NOISE_C[x & 0x3F | (y & 0x3F) << 6] + 0.5f) * 0.03125f;
                        eb += (float)((long)x * 4521708957497675121L + (long)y * -7935046062780286179L >> 41) * 9.536743E-7f;
                    }
                }
                er = er * noiseStrength + curErrorRed[x];
                eg = eg * noiseStrength + curErrorGreen[x];
                eb = eb * noiseStrength + curErrorBlue[x];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + Math.min(Math.max(er, -limit), limit) + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + Math.min(Math.max(eg, -limit), limit) + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + Math.min(Math.max(eb, -limit), limit) + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(x, y, used);
                float rdiff = (float)((color >>> 24) - (used >>> 24)) * strength;
                float gdiff = (float)((color >>> 16 & 0xFF) - (used >>> 16 & 0xFF)) * strength;
                float bdiff = (float)((color >>> 8 & 0xFF) - (used >>> 8 & 0xFF)) * strength;
                float r1 = rdiff * 16.0f / (45.0f + Math.abs(rdiff));
                float g1 = gdiff * 16.0f / (45.0f + Math.abs(gdiff));
                float b1 = bdiff * 16.0f / (45.0f + Math.abs(bdiff));
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (x < lineLen - 1) {
                    int n = x + 1;
                    curErrorRed[n] = curErrorRed[n] + r4;
                    int n2 = x + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4;
                    int n3 = x + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4;
                    if (x < lineLen - 2) {
                        int n4 = x + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2;
                        int n5 = x + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2;
                        int n6 = x + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2;
                    }
                }
                if (ny >= h) continue;
                if (x > 0) {
                    int n = x - 1;
                    nextErrorRed[n] = nextErrorRed[n] + r2;
                    int n7 = x - 1;
                    nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                    int n8 = x - 1;
                    nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                    if (x > 1) {
                        int n9 = x - 2;
                        nextErrorRed[n9] = nextErrorRed[n9] + r1;
                        int n10 = x - 2;
                        nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                        int n11 = x - 2;
                        nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                    }
                }
                int n = x;
                nextErrorRed[n] = nextErrorRed[n] + r4;
                int n12 = x;
                nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                int n13 = x;
                nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                if (x >= lineLen - 1) continue;
                int n14 = x + 1;
                nextErrorRed[n14] = nextErrorRed[n14] + r2;
                int n15 = x + 1;
                nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                int n16 = x + 1;
                nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                if (x >= lineLen - 2) continue;
                int n17 = x + 2;
                nextErrorRed[n17] = nextErrorRed[n17] + r1;
                int n18 = x + 2;
                nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                int n19 = x + 2;
                nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceBurkes(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        float s = 0.175f * this.ditherStrength * (this.populationBias * this.populationBias * this.populationBias);
        float strength = s * 0.29f / (0.19f + s);
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(lineLen);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(lineLen);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(lineLen);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(lineLen);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(lineLen);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(lineLen);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(lineLen);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(lineLen);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(lineLen);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int py = 0; py < h; ++py) {
            int ny = py + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, lineLen);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, lineLen);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, lineLen);
            Arrays.fill(nextErrorRed, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorGreen, 0, lineLen, 0.0f);
            Arrays.fill(nextErrorBlue, 0, lineLen, 0.0f);
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, py, 0);
                    continue;
                }
                float er = curErrorRed[px];
                float eg = curErrorGreen[px];
                float eb = curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, py, used);
                int rdiff = (color >>> 24) - (used >>> 24);
                int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                float r1 = (float)rdiff * strength;
                float g1 = (float)gdiff * strength;
                float b1 = (float)bdiff * strength;
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (px < lineLen - 1) {
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + r4;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4;
                    if (px < lineLen - 2) {
                        int n4 = px + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2;
                        int n5 = px + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2;
                        int n6 = px + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2;
                    }
                }
                if (ny >= h) continue;
                if (px > 0) {
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + r2;
                    int n7 = px - 1;
                    nextErrorGreen[n7] = nextErrorGreen[n7] + g2;
                    int n8 = px - 1;
                    nextErrorBlue[n8] = nextErrorBlue[n8] + b2;
                    if (px > 1) {
                        int n9 = px - 2;
                        nextErrorRed[n9] = nextErrorRed[n9] + r1;
                        int n10 = px - 2;
                        nextErrorGreen[n10] = nextErrorGreen[n10] + g1;
                        int n11 = px - 2;
                        nextErrorBlue[n11] = nextErrorBlue[n11] + b1;
                    }
                }
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + r4;
                int n12 = px;
                nextErrorGreen[n12] = nextErrorGreen[n12] + g4;
                int n13 = px;
                nextErrorBlue[n13] = nextErrorBlue[n13] + b4;
                if (px >= lineLen - 1) continue;
                int n14 = px + 1;
                nextErrorRed[n14] = nextErrorRed[n14] + r2;
                int n15 = px + 1;
                nextErrorGreen[n15] = nextErrorGreen[n15] + g2;
                int n16 = px + 1;
                nextErrorBlue[n16] = nextErrorBlue[n16] + b2;
                if (px >= lineLen - 2) continue;
                int n17 = px + 2;
                nextErrorRed[n17] = nextErrorRed[n17] + r1;
                int n18 = px + 2;
                nextErrorGreen[n18] = nextErrorGreen[n18] + g1;
                int n19 = px + 2;
                nextErrorBlue[n19] = nextErrorBlue[n19] + b1;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceOceanic(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int w = pixmap.getWidth();
        int h = pixmap.getHeight();
        float[] noise = TRI_BLUE_NOISE_MULTIPLIERS;
        float s = 0.175f * this.ditherStrength * (this.populationBias * this.populationBias * this.populationBias);
        float strength = s * 0.29f / (0.19f + s);
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int py = 0; py < h; ++py) {
            int ny = py + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            for (int px = 0; px < w; ++px) {
                float modifier;
                int color = pixmap.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, py, 0);
                    continue;
                }
                float er = curErrorRed[px];
                float eg = curErrorGreen[px];
                float eb = curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, py, used);
                int rdiff = (color >>> 24) - (used >>> 24);
                int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                float r1 = (float)rdiff * strength;
                float g1 = (float)gdiff * strength;
                float b1 = (float)bdiff * strength;
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (px < w - 1) {
                    modifier = noise[px + 1 & 0x3F | py << 6 & 0xFC0];
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + r4 * modifier;
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4 * modifier;
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4 * modifier;
                    if (px < w - 2) {
                        modifier = noise[px + 2 & 0x3F | py << 6 & 0xFC0];
                        int n4 = px + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2 * modifier;
                        int n5 = px + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2 * modifier;
                        int n6 = px + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2 * modifier;
                    }
                }
                if (ny >= h) continue;
                if (px > 0) {
                    modifier = noise[px - 1 & 0x3F | ny << 6 & 0xFC0];
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + r2 * modifier;
                    int n7 = px - 1;
                    nextErrorGreen[n7] = nextErrorGreen[n7] + g2 * modifier;
                    int n8 = px - 1;
                    nextErrorBlue[n8] = nextErrorBlue[n8] + b2 * modifier;
                    if (px > 1) {
                        modifier = noise[px - 2 & 0x3F | ny << 6 & 0xFC0];
                        int n9 = px - 2;
                        nextErrorRed[n9] = nextErrorRed[n9] + r1 * modifier;
                        int n10 = px - 2;
                        nextErrorGreen[n10] = nextErrorGreen[n10] + g1 * modifier;
                        int n11 = px - 2;
                        nextErrorBlue[n11] = nextErrorBlue[n11] + b1 * modifier;
                    }
                }
                modifier = noise[px & 0x3F | ny << 6 & 0xFC0];
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + r4 * modifier;
                int n12 = px;
                nextErrorGreen[n12] = nextErrorGreen[n12] + g4 * modifier;
                int n13 = px;
                nextErrorBlue[n13] = nextErrorBlue[n13] + b4 * modifier;
                if (px >= w - 1) continue;
                modifier = noise[px + 1 & 0x3F | ny << 6 & 0xFC0];
                int n14 = px + 1;
                nextErrorRed[n14] = nextErrorRed[n14] + r2 * modifier;
                int n15 = px + 1;
                nextErrorGreen[n15] = nextErrorGreen[n15] + g2 * modifier;
                int n16 = px + 1;
                nextErrorBlue[n16] = nextErrorBlue[n16] + b2 * modifier;
                if (px >= w - 2) continue;
                modifier = noise[px + 2 & 0x3F | ny << 6 & 0xFC0];
                int n17 = px + 2;
                nextErrorRed[n17] = nextErrorRed[n17] + r1 * modifier;
                int n18 = px + 2;
                nextErrorGreen[n18] = nextErrorGreen[n18] + g1 * modifier;
                int n19 = px + 2;
                nextErrorBlue[n19] = nextErrorBlue[n19] + b1 * modifier;
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceSeaside(Pixmap pixmap) {
        float[] nextErrorBlue;
        float[] curErrorBlue;
        float[] nextErrorGreen;
        float[] curErrorGreen;
        float[] nextErrorRed;
        float[] curErrorRed;
        boolean hasTransparent = this.paletteArray[0] == 0;
        int w = pixmap.getWidth();
        int h = pixmap.getHeight();
        float[] noiseA = TRI_BLUE_NOISE_MULTIPLIERS;
        float[] noiseB = TRI_BLUE_NOISE_MULTIPLIERS_B;
        float[] noiseC = TRI_BLUE_NOISE_MULTIPLIERS_C;
        float s = 0.13f * this.ditherStrength * (this.populationBias * this.populationBias);
        float strength = s * 0.29f / (0.18f + s);
        if (this.curErrorRedFloats == null) {
            this.curErrorRedFloats = new FloatArray(w);
            curErrorRed = this.curErrorRedFloats.items;
            this.nextErrorRedFloats = new FloatArray(w);
            nextErrorRed = this.nextErrorRedFloats.items;
            this.curErrorGreenFloats = new FloatArray(w);
            curErrorGreen = this.curErrorGreenFloats.items;
            this.nextErrorGreenFloats = new FloatArray(w);
            nextErrorGreen = this.nextErrorGreenFloats.items;
            this.curErrorBlueFloats = new FloatArray(w);
            curErrorBlue = this.curErrorBlueFloats.items;
            this.nextErrorBlueFloats = new FloatArray(w);
            nextErrorBlue = this.nextErrorBlueFloats.items;
        } else {
            curErrorRed = this.curErrorRedFloats.ensureCapacity(w);
            nextErrorRed = this.nextErrorRedFloats.ensureCapacity(w);
            curErrorGreen = this.curErrorGreenFloats.ensureCapacity(w);
            nextErrorGreen = this.nextErrorGreenFloats.ensureCapacity(w);
            curErrorBlue = this.curErrorBlueFloats.ensureCapacity(w);
            nextErrorBlue = this.nextErrorBlueFloats.ensureCapacity(w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
        }
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int py = 0; py < h; ++py) {
            int ny = py + 1;
            System.arraycopy(nextErrorRed, 0, curErrorRed, 0, w);
            System.arraycopy(nextErrorGreen, 0, curErrorGreen, 0, w);
            System.arraycopy(nextErrorBlue, 0, curErrorBlue, 0, w);
            Arrays.fill(nextErrorRed, 0, w, 0.0f);
            Arrays.fill(nextErrorGreen, 0, w, 0.0f);
            Arrays.fill(nextErrorBlue, 0, w, 0.0f);
            for (int px = 0; px < w; ++px) {
                int color = pixmap.getPixel(px, py);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, py, 0);
                    continue;
                }
                float er = curErrorRed[px];
                float eg = curErrorGreen[px];
                float eb = curErrorBlue[px];
                int rr = Math.min(Math.max((int)((float)(color >>> 24) + er + 0.5f), 0), 255);
                int gg = Math.min(Math.max((int)((float)(color >>> 16 & 0xFF) + eg + 0.5f), 0), 255);
                int bb = Math.min(Math.max((int)((float)(color >>> 8 & 0xFF) + eb + 0.5f), 0), 255);
                byte paletteIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3];
                int used = this.paletteArray[paletteIndex & 0xFF];
                pixmap.drawPixel(px, py, used);
                int rdiff = (color >>> 24) - (used >>> 24);
                int gdiff = (color >>> 16 & 0xFF) - (used >>> 16 & 0xFF);
                int bdiff = (color >>> 8 & 0xFF) - (used >>> 8 & 0xFF);
                int modifier = px & 0x3F | py << 6 & 0xFC0;
                float r1 = (float)rdiff * strength * noiseA[modifier];
                float g1 = (float)gdiff * strength * noiseB[modifier];
                float b1 = (float)bdiff * strength * noiseC[modifier];
                float r2 = r1 + r1;
                float g2 = g1 + g1;
                float b2 = b1 + b1;
                float r4 = r2 + r2;
                float g4 = g2 + g2;
                float b4 = b2 + b2;
                if (px < w - 1) {
                    modifier = px + 1 & 0x3F | py << 6 & 0xFC0;
                    int n = px + 1;
                    curErrorRed[n] = curErrorRed[n] + r4 * noiseA[modifier];
                    int n2 = px + 1;
                    curErrorGreen[n2] = curErrorGreen[n2] + g4 * noiseB[modifier];
                    int n3 = px + 1;
                    curErrorBlue[n3] = curErrorBlue[n3] + b4 * noiseC[modifier];
                    if (px < w - 2) {
                        modifier = px + 2 & 0x3F | py << 6 & 0xFC0;
                        int n4 = px + 2;
                        curErrorRed[n4] = curErrorRed[n4] + r2 * noiseA[modifier];
                        int n5 = px + 2;
                        curErrorGreen[n5] = curErrorGreen[n5] + g2 * noiseB[modifier];
                        int n6 = px + 2;
                        curErrorBlue[n6] = curErrorBlue[n6] + b2 * noiseC[modifier];
                    }
                    if (px < w - 3) {
                        modifier = px + 3 & 0x3F | py << 6 & 0xFC0;
                        int n7 = px + 2;
                        curErrorRed[n7] = curErrorRed[n7] + r1 * noiseA[modifier];
                        int n8 = px + 2;
                        curErrorGreen[n8] = curErrorGreen[n8] + g1 * noiseB[modifier];
                        int n9 = px + 2;
                        curErrorBlue[n9] = curErrorBlue[n9] + b1 * noiseC[modifier];
                    }
                }
                if (ny >= h) continue;
                if (px > 0) {
                    modifier = px - 1 & 0x3F | ny << 6 & 0xFC0;
                    int n = px - 1;
                    nextErrorRed[n] = nextErrorRed[n] + r2 * noiseA[modifier];
                    int n10 = px - 1;
                    nextErrorGreen[n10] = nextErrorGreen[n10] + g2 * noiseB[modifier];
                    int n11 = px - 1;
                    nextErrorBlue[n11] = nextErrorBlue[n11] + b2 * noiseC[modifier];
                    if (px > 1) {
                        modifier = px - 2 & 0x3F | ny << 6 & 0xFC0;
                        int n12 = px - 2;
                        nextErrorRed[n12] = nextErrorRed[n12] + r1 * noiseA[modifier];
                        int n13 = px - 2;
                        nextErrorGreen[n13] = nextErrorGreen[n13] + g1 * noiseB[modifier];
                        int n14 = px - 2;
                        nextErrorBlue[n14] = nextErrorBlue[n14] + b1 * noiseC[modifier];
                    }
                }
                modifier = px & 0x3F | ny << 6 & 0xFC0;
                int n = px;
                nextErrorRed[n] = nextErrorRed[n] + r4 * noiseA[modifier];
                int n15 = px;
                nextErrorGreen[n15] = nextErrorGreen[n15] + g4 * noiseB[modifier];
                int n16 = px;
                nextErrorBlue[n16] = nextErrorBlue[n16] + b4 * noiseC[modifier];
                if (px >= w - 1) continue;
                modifier = px + 1 & 0x3F | ny << 6 & 0xFC0;
                int n17 = px + 1;
                nextErrorRed[n17] = nextErrorRed[n17] + r2 * noiseA[modifier];
                int n18 = px + 1;
                nextErrorGreen[n18] = nextErrorGreen[n18] + g2 * noiseB[modifier];
                int n19 = px + 1;
                nextErrorBlue[n19] = nextErrorBlue[n19] + b2 * noiseC[modifier];
                if (px >= w - 2) continue;
                modifier = px + 2 & 0x3F | ny << 6 & 0xFC0;
                int n20 = px + 2;
                nextErrorRed[n20] = nextErrorRed[n20] + r1 * noiseA[modifier];
                int n21 = px + 2;
                nextErrorGreen[n21] = nextErrorGreen[n21] + g1 * noiseB[modifier];
                int n22 = px + 2;
                nextErrorBlue[n22] = nextErrorBlue[n22] + b1 * noiseC[modifier];
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    protected static void compareSwap(int[] ints, int a, int b) {
        if (OKLAB[0][ints[a | 0x10]] > OKLAB[0][ints[b | 0x10]]) {
            int t = ints[a];
            int st = ints[a | 0x10];
            ints[a] = ints[b];
            ints[a | 0x10] = ints[b | 0x10];
            ints[b] = t;
            ints[b | 0x10] = st;
        }
    }

    static void sort8(int[] i8) {
        PaletteReducer.compareSwap(i8, 0, 1);
        PaletteReducer.compareSwap(i8, 2, 3);
        PaletteReducer.compareSwap(i8, 0, 2);
        PaletteReducer.compareSwap(i8, 1, 3);
        PaletteReducer.compareSwap(i8, 1, 2);
        PaletteReducer.compareSwap(i8, 4, 5);
        PaletteReducer.compareSwap(i8, 6, 7);
        PaletteReducer.compareSwap(i8, 4, 6);
        PaletteReducer.compareSwap(i8, 5, 7);
        PaletteReducer.compareSwap(i8, 5, 6);
        PaletteReducer.compareSwap(i8, 0, 4);
        PaletteReducer.compareSwap(i8, 1, 5);
        PaletteReducer.compareSwap(i8, 1, 4);
        PaletteReducer.compareSwap(i8, 2, 6);
        PaletteReducer.compareSwap(i8, 3, 7);
        PaletteReducer.compareSwap(i8, 3, 6);
        PaletteReducer.compareSwap(i8, 2, 4);
        PaletteReducer.compareSwap(i8, 3, 5);
        PaletteReducer.compareSwap(i8, 3, 4);
    }

    static void sort16(int[] i16) {
        PaletteReducer.compareSwap(i16, 0, 1);
        PaletteReducer.compareSwap(i16, 2, 3);
        PaletteReducer.compareSwap(i16, 4, 5);
        PaletteReducer.compareSwap(i16, 6, 7);
        PaletteReducer.compareSwap(i16, 8, 9);
        PaletteReducer.compareSwap(i16, 10, 11);
        PaletteReducer.compareSwap(i16, 12, 13);
        PaletteReducer.compareSwap(i16, 14, 15);
        PaletteReducer.compareSwap(i16, 0, 2);
        PaletteReducer.compareSwap(i16, 4, 6);
        PaletteReducer.compareSwap(i16, 8, 10);
        PaletteReducer.compareSwap(i16, 12, 14);
        PaletteReducer.compareSwap(i16, 1, 3);
        PaletteReducer.compareSwap(i16, 5, 7);
        PaletteReducer.compareSwap(i16, 9, 11);
        PaletteReducer.compareSwap(i16, 13, 15);
        PaletteReducer.compareSwap(i16, 0, 4);
        PaletteReducer.compareSwap(i16, 8, 12);
        PaletteReducer.compareSwap(i16, 1, 5);
        PaletteReducer.compareSwap(i16, 9, 13);
        PaletteReducer.compareSwap(i16, 2, 6);
        PaletteReducer.compareSwap(i16, 10, 14);
        PaletteReducer.compareSwap(i16, 3, 7);
        PaletteReducer.compareSwap(i16, 11, 15);
        PaletteReducer.compareSwap(i16, 0, 8);
        PaletteReducer.compareSwap(i16, 1, 9);
        PaletteReducer.compareSwap(i16, 2, 10);
        PaletteReducer.compareSwap(i16, 3, 11);
        PaletteReducer.compareSwap(i16, 4, 12);
        PaletteReducer.compareSwap(i16, 5, 13);
        PaletteReducer.compareSwap(i16, 6, 14);
        PaletteReducer.compareSwap(i16, 7, 15);
        PaletteReducer.compareSwap(i16, 5, 10);
        PaletteReducer.compareSwap(i16, 6, 9);
        PaletteReducer.compareSwap(i16, 3, 12);
        PaletteReducer.compareSwap(i16, 13, 14);
        PaletteReducer.compareSwap(i16, 7, 11);
        PaletteReducer.compareSwap(i16, 1, 2);
        PaletteReducer.compareSwap(i16, 4, 8);
        PaletteReducer.compareSwap(i16, 1, 4);
        PaletteReducer.compareSwap(i16, 7, 13);
        PaletteReducer.compareSwap(i16, 2, 8);
        PaletteReducer.compareSwap(i16, 11, 14);
        PaletteReducer.compareSwap(i16, 2, 4);
        PaletteReducer.compareSwap(i16, 5, 6);
        PaletteReducer.compareSwap(i16, 9, 10);
        PaletteReducer.compareSwap(i16, 11, 13);
        PaletteReducer.compareSwap(i16, 3, 8);
        PaletteReducer.compareSwap(i16, 7, 12);
        PaletteReducer.compareSwap(i16, 6, 8);
        PaletteReducer.compareSwap(i16, 10, 12);
        PaletteReducer.compareSwap(i16, 3, 5);
        PaletteReducer.compareSwap(i16, 7, 9);
        PaletteReducer.compareSwap(i16, 3, 4);
        PaletteReducer.compareSwap(i16, 5, 6);
        PaletteReducer.compareSwap(i16, 7, 8);
        PaletteReducer.compareSwap(i16, 9, 10);
        PaletteReducer.compareSwap(i16, 11, 12);
        PaletteReducer.compareSwap(i16, 6, 7);
        PaletteReducer.compareSwap(i16, 8, 9);
    }

    public Pixmap reduceKnoll(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float errorMul = this.ditherStrength * 0.5f / this.populationBias;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int er = 0;
                int eg = 0;
                int eb = 0;
                int cr = color >>> 24;
                int cg = color >>> 16 & 0xFF;
                int cb = color >>> 8 & 0xFF;
                for (int i = 0; i < 16; ++i) {
                    int used;
                    int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                    int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                    int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                    int usedIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                    this.candidates[i] = used = this.paletteArray[usedIndex];
                    this.candidates[i | 0x10] = PaletteReducer.shrink(used);
                    er += cr - (used >>> 24);
                    eg += cg - (used >>> 16 & 0xFF);
                    eb += cb - (used >>> 8 & 0xFF);
                }
                PaletteReducer.sort16(this.candidates);
                pixmap.drawPixel(px, y, this.candidates[thresholdMatrix16[px & 3 | (y & 3) << 2]]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public Pixmap reduceKnollRoberts(Pixmap pixmap) {
        boolean hasTransparent = this.paletteArray[0] == 0;
        int lineLen = pixmap.getWidth();
        int h = pixmap.getHeight();
        Pixmap.Blending blending = pixmap.getBlending();
        pixmap.setBlending(Pixmap.Blending.None);
        float errorMul = this.ditherStrength * this.populationBias * 1.25f;
        for (int y = 0; y < h; ++y) {
            for (int px = 0; px < lineLen; ++px) {
                int color = pixmap.getPixel(px, y);
                if ((color & 0x80) == 0 && hasTransparent) {
                    pixmap.drawPixel(px, y, 0);
                    continue;
                }
                int er = 0;
                int eg = 0;
                int eb = 0;
                int cr = color >>> 24;
                int cg = color >>> 16 & 0xFF;
                int cb = color >>> 8 & 0xFF;
                for (int c = 0; c < 8; ++c) {
                    int used;
                    int rr = Math.min(Math.max((int)((float)cr + (float)er * errorMul), 0), 255);
                    int gg = Math.min(Math.max((int)((float)cg + (float)eg * errorMul), 0), 255);
                    int bb = Math.min(Math.max((int)((float)cb + (float)eb * errorMul), 0), 255);
                    int usedIndex = this.paletteMapping[rr << 7 & 0x7C00 | gg << 2 & 0x3E0 | bb >>> 3] & 0xFF;
                    this.candidates[c] = used = this.paletteArray[usedIndex];
                    this.candidates[c | 0x10] = PaletteReducer.shrink(used);
                    er += cr - (used >>> 24);
                    eg += cg - (used >>> 16 & 0xFF);
                    eb += cb - (used >>> 8 & 0xFF);
                }
                PaletteReducer.sort8(this.candidates);
                pixmap.drawPixel(px, y, this.candidates[thresholdMatrix8[(int)((double)px * 14.039021329973542 + (double)y * 0.4045084971874737) & 3 ^ (px & 3 | (y & 1) << 2)]]);
            }
        }
        pixmap.setBlending(blending);
        return pixmap;
    }

    public byte randomColorIndex(Random random) {
        return this.paletteMapping[random.nextInt() >>> 17];
    }

    public int randomColor(Random random) {
        return this.paletteArray[this.paletteMapping[random.nextInt() >>> 17] & 0xFF];
    }

    public int reduceSingle(int color) {
        if ((color & 0x80) == 0) {
            return 0;
        }
        return this.paletteArray[this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F] & 0xFF];
    }

    public byte reduceIndex(int color) {
        if ((color & 0x80) == 0) {
            return 0;
        }
        return this.paletteMapping[color >>> 17 & 0x7C00 | color >>> 14 & 0x3E0 | color >>> 11 & 0x1F];
    }

    public float reduceFloat(float packedColor) {
        int color = NumberUtils.floatToIntBits((float)packedColor);
        if (color >= 0) {
            return 0.0f;
        }
        return NumberUtils.intBitsToFloat((int)Integer.reverseBytes(this.paletteArray[this.paletteMapping[color << 7 & 0x7C00 | color >>> 6 & 0x3E0 | color >>> 19] & 0xFF] & 0xFFFFFFFE));
    }

    public Color reduceInPlace(Color color) {
        if (color.a < 0.5f) {
            return color.set(0);
        }
        return color.set(this.paletteArray[this.paletteMapping[(int)((double)color.r * 32256.0) & 0x7C00 | (int)((double)color.g * 1008.0) & 0x3E0 | (int)((double)color.r * 31.5)] & 0xFF]);
    }

    public PaletteReducer alterColorsLightness(Interpolation lightness) {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            palette[idx] = PaletteReducer.oklabToRGB(lightness.apply(OKLAB[0][s]), OKLAB[1][s], OKLAB[2][s], (float)(palette[idx] & 0xFE) / 254.0f);
        }
        return this;
    }

    public PaletteReducer alterColorsOklab(Interpolation lightness, Interpolation greenToRed, Interpolation blueToYellow) {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            float L = lightness.apply(OKLAB[0][s]);
            float A = greenToRed.apply(-1.0f, 1.0f, OKLAB[1][s] * 0.5f + 0.5f);
            float B = blueToYellow.apply(-1.0f, 1.0f, OKLAB[2][s] * 0.5f + 0.5f);
            palette[idx] = PaletteReducer.oklabToRGB(L, A, B, (float)(palette[idx] & 0xFE) / 254.0f);
        }
        return this;
    }

    public PaletteReducer hueShift() {
        int[] palette = this.paletteArray;
        for (int idx = 0; idx < this.colorCount; ++idx) {
            int s = PaletteReducer.shrink(palette[idx]);
            float L = OKLAB[0][s];
            float A = OKLAB[1][s] + (L - 0.5f) * 0.04f;
            float B = OKLAB[2][s] + (L - 0.5f) * 0.08f;
            palette[idx] = PaletteReducer.oklabToRGB(L, A, B, (float)(palette[idx] & 0xFE) / 254.0f);
        }
        return this;
    }

    static {
        int idx = 0;
        for (int ri = 0; ri < 32; ++ri) {
            float rf = (float)((double)(ri * ri) * 0.0010405827263267429);
            for (int gi = 0; gi < 32; ++gi) {
                float gf = (float)((double)(gi * gi) * 0.0010405827263267429);
                for (int bi = 0; bi < 32; ++bi) {
                    float bf = (float)((double)(bi * bi) * 0.0010405827263267429);
                    float lf = OtherMath.cbrtPositive(0.4121656f * rf + 0.5362752f * gf + 0.051457565f * bf);
                    float mf = OtherMath.cbrtPositive(0.2118591f * rf + 0.68071896f * gf + 0.10740658f * bf);
                    float sf = OtherMath.cbrtPositive(0.088309795f * rf + 0.28184742f * gf + 0.63026136f * bf);
                    PaletteReducer.OKLAB[0][idx] = PaletteReducer.forwardLight(0.21045426f * lf + 0.7936178f * mf - 0.004072047f * sf);
                    PaletteReducer.OKLAB[1][idx] = 1.9779985f * lf - 2.4285922f * mf + 0.4505937f * sf;
                    PaletteReducer.OKLAB[2][idx] = 0.025904037f * lf + 0.78277177f * mf - 0.80867577f * sf;
                    PaletteReducer.OKLAB[3][idx] = OtherMath.atan2(OKLAB[2][idx], OKLAB[1][idx]);
                    ++idx;
                }
            }
        }
        thresholdMatrix8 = new int[]{0, 4, 2, 6, 3, 7, 1, 5};
        thresholdMatrix16 = new int[]{0, 12, 3, 15, 8, 4, 11, 7, 2, 14, 1, 13, 10, 6, 9, 5};
        thresholdMatrix64 = new int[]{0, 48, 12, 60, 3, 51, 15, 63, 32, 16, 44, 28, 35, 19, 47, 31, 8, 56, 4, 52, 11, 59, 7, 55, 40, 24, 36, 20, 43, 27, 39, 23, 2, 50, 14, 62, 1, 49, 13, 61, 34, 18, 46, 30, 33, 17, 45, 29, 10, 58, 6, 54, 9, 57, 5, 53, 42, 26, 38, 22, 41, 25, 37, 21};
        entryComparator = new Comparator<IntIntMap.Entry>(){

            @Override
            public int compare(IntIntMap.Entry o1, IntIntMap.Entry o2) {
                return o2.value - o1.value;
            }
        };
        lightnessComparator = new IntComparator(){

            @Override
            public int compare(int k1, int k2) {
                return NumberUtils.floatToIntBits((float)(OKLAB[0][k2] - OKLAB[0][k1]));
            }
        };
        hueComparator = new IntComparator(){

            @Override
            public int compare(int k1, int k2) {
                return NumberUtils.floatToIntBits((float)(OKLAB[3][k2] - OKLAB[3][k1]));
            }
        };
        bigPaletteLoaded = false;
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

