/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.anim8;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.anim8.ConstantData;
import com.github.tommyettinger.anim8.OtherMath;
import com.github.tommyettinger.anim8.PaletteReducer;

public class QualityPalette
extends PaletteReducer {
    public QualityPalette() {
        this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
    }

    public QualityPalette(int[] rgbaPalette) {
        if (rgbaPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(rgbaPalette);
    }

    public QualityPalette(int[] rgbaPalette, int limit) {
        if (rgbaPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(rgbaPalette, limit);
    }

    public QualityPalette(Color[] colorPalette) {
        if (colorPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(colorPalette);
    }

    public QualityPalette(Color[] colorPalette, int limit) {
        if (colorPalette == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.exact(colorPalette, limit);
    }

    public QualityPalette(Pixmap pixmap) {
        if (pixmap == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.analyze(pixmap);
    }

    public QualityPalette(Array<Pixmap> pixmaps) {
        if (pixmaps == null) {
            this.exact(SNUGGLY, ConstantData.ENCODED_SNUGGLY);
            return;
        }
        this.analyze(pixmaps);
    }

    public QualityPalette(int[] palette, byte[] preload) {
        this.exact(palette, preload);
    }

    public QualityPalette(Pixmap pixmap, double threshold) {
        this.analyze(pixmap, threshold);
    }

    @Override
    public double differenceMatch(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    @Override
    public double differenceAnalyzing(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    @Override
    public double differenceHW(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.differenceHW(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    @Override
    public double differenceMatch(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceMatch(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    @Override
    public double differenceAnalyzing(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceAnalyzing(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    @Override
    public double differenceHW(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.differenceHW(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    @Override
    public double differenceMatch(int r1, int g1, int b1, int r2, int g2, int b2) {
        return this.difference(r1, g1, b1, r2, g2, b2);
    }

    @Override
    public double differenceAnalyzing(int r1, int g1, int b1, int r2, int g2, int b2) {
        return this.difference(r1, g1, b1, r2, g2, b2);
    }

    @Override
    public double differenceHW(int r1, int g1, int b1, int r2, int g2, int b2) {
        return this.difference(r1, g1, b1, r2, g2, b2);
    }

    public static double forwardLight(double L) {
        return Math.sqrt(L * L * L);
    }

    public static double reverseLight(double L) {
        return Math.pow(L, 0.6666666666666666);
    }

    public double difference(int color1, int color2) {
        if (((color1 ^ color2) & 0x80) == 128) {
            return Double.MAX_VALUE;
        }
        return this.difference(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, color2 >>> 24, color2 >>> 16 & 0xFF, color2 >>> 8 & 0xFF);
    }

    public double difference(int color1, int r2, int g2, int b2) {
        if ((color1 & 0x80) == 0) {
            return Double.MAX_VALUE;
        }
        return this.difference(color1 >>> 24, color1 >>> 16 & 0xFF, color1 >>> 8 & 0xFF, r2, g2, b2);
    }

    public double difference(int r1, int g1, int b1, int r2, int g2, int b2) {
        float r = (float)r1 * 0.003921569f;
        r *= r;
        float g = (float)g1 * 0.003921569f;
        g *= g;
        float b = (float)b1 * 0.003921569f;
        b *= b;
        float l = OtherMath.cbrtPositive(0.4121656f * r + 0.5362752f * g + 0.051457565f * b);
        float m = OtherMath.cbrtPositive(0.2118591f * r + 0.68071896f * g + 0.10740658f * b);
        float s = OtherMath.cbrtPositive(0.088309795f * r + 0.28184742f * g + 0.63026136f * b);
        float L1 = QualityPalette.forwardLight(0.21045426f * l + 0.7936178f * m - 0.004072047f * s);
        float A1 = 1.9779985f * l - 2.4285922f * m + 0.4505937f * s;
        float B1 = 0.025904037f * l + 0.78277177f * m - 0.80867577f * s;
        r = (float)r2 * 0.003921569f;
        r *= r;
        g = (float)g2 * 0.003921569f;
        g *= g;
        b = (float)b2 * 0.003921569f;
        b *= b;
        l = OtherMath.cbrtPositive(0.4121656f * r + 0.5362752f * g + 0.051457565f * b);
        m = OtherMath.cbrtPositive(0.2118591f * r + 0.68071896f * g + 0.10740658f * b);
        s = OtherMath.cbrtPositive(0.088309795f * r + 0.28184742f * g + 0.63026136f * b);
        float L2 = QualityPalette.forwardLight(0.21045426f * l + 0.7936178f * m - 0.004072047f * s);
        float A2 = 1.9779985f * l - 2.4285922f * m + 0.4505937f * s;
        float B2 = 0.025904037f * l + 0.78277177f * m - 0.80867577f * s;
        double L = (double)(L1 - L2) * 512.0;
        double A = (double)(A1 - A2) * 512.0;
        double B = (double)(B1 - B2) * 512.0;
        return L * L + A * A + B * B;
    }
}

