/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.MathTools;
import java.util.Random;

public class AlternateRandom
extends Random {
    public long stateA;
    public long stateB;
    public long stateC;
    public long stateD;
    public long stateE;

    private static long seedFromMath() {
        return (long)((Math.random() - 0.5) * 4.503599627370496E15) ^ (long)((Math.random() - 0.5) * 1.8446744073709552E19);
    }

    public AlternateRandom() {
        this.stateA = AlternateRandom.seedFromMath();
        this.stateB = AlternateRandom.seedFromMath();
        this.stateC = AlternateRandom.seedFromMath();
        this.stateD = AlternateRandom.seedFromMath();
        this.stateE = AlternateRandom.seedFromMath();
    }

    public AlternateRandom(long seed) {
        this.setSeed(seed);
    }

    public AlternateRandom(long a, long b, long c, long d, long e) {
        this.stateA = a;
        this.stateB = b;
        this.stateC = c;
        this.stateD = d;
        this.stateE = e;
    }

    @Override
    public void setSeed(long seed) {
        this.stateA = seed;
        seed ^= seed >>> 32;
        seed *= -4710160504952957587L;
        seed ^= seed >>> 29;
        seed *= -4710160504952957587L;
        seed ^= seed >>> 32;
        seed *= -4710160504952957587L;
        seed ^= seed >>> 29;
        this.stateB = seed;
        this.stateC = seed ^ 0x3943D8696D4A3CDCL;
        this.stateD = seed ^ 0xFFFFFFFFFFFFFFFFL;
        this.stateE = seed ^ 0xC6BC279692B5C323L;
    }

    @Override
    public long nextLong() {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return this.stateE;
    }

    @Override
    public int next(int bits) {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return (int)this.stateE >>> 32 - bits;
    }

    @Override
    public int nextInt() {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return (int)this.stateE;
    }

    @Override
    public int nextInt(int bound) {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return (int)((long)bound * (this.stateE & 0xFFFFFFFFL) >> 32) & ~(bound >> 31);
    }

    @Override
    public boolean nextBoolean() {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return this.stateE < 0L;
    }

    @Override
    public float nextFloat() {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return (float)(this.stateE >>> 40) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        this.stateE = fa ^ fc;
        return (double)(this.stateE >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        long fa = this.stateA;
        long fb = this.stateB;
        long fc = this.stateC;
        long fd = this.stateD;
        long fe = this.stateE;
        this.stateA = fe * -1065810590584100411L;
        this.stateB = fa << 44 | fa >>> 20;
        this.stateC = fb + fd;
        this.stateD = fd + -7046029254386353131L;
        long bits = this.stateE = fa ^ fc;
        return MathTools.probit(BitConversion.longBitsToDouble(1022L - (long)Long.numberOfTrailingZeros(bits) << 52 | bits >>> 12));
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            long r = this.nextLong();
            long n = Math.min(bytes.length - i, 8);
            while (n-- > 0L) {
                bytes[i++] = (byte)r;
                r >>>= 8;
            }
        }
    }

    public String serializeToString() {
        StringBuilder sb = new StringBuilder(55);
        Base.SIMPLE64.appendUnsigned(sb, this.stateA);
        Base.SIMPLE64.appendUnsigned(sb, this.stateB);
        Base.SIMPLE64.appendUnsigned(sb, this.stateC);
        Base.SIMPLE64.appendUnsigned(sb, this.stateD);
        Base.SIMPLE64.appendUnsigned(sb, this.stateE);
        return sb.toString();
    }

    public AlternateRandom deserializeFromString(String data) {
        if (data == null || data.length() < 55) {
            return this;
        }
        this.stateA = Base.SIMPLE64.readLong(data, 0, 11);
        this.stateB = Base.SIMPLE64.readLong(data, 11, 22);
        this.stateC = Base.SIMPLE64.readLong(data, 22, 33);
        this.stateD = Base.SIMPLE64.readLong(data, 33, 44);
        this.stateE = Base.SIMPLE64.readLong(data, 44, 55);
        return this;
    }

    public AlternateRandom copy() {
        return new AlternateRandom(this.stateA, this.stateB, this.stateC, this.stateD, this.stateE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternateRandom random = (AlternateRandom)o;
        if (this.stateA != random.stateA) {
            return false;
        }
        if (this.stateB != random.stateB) {
            return false;
        }
        if (this.stateC != random.stateC) {
            return false;
        }
        if (this.stateD != random.stateD) {
            return false;
        }
        return this.stateE == random.stateE;
    }

    public int hashCode() {
        int result = (int)(this.stateA ^ this.stateA >>> 32);
        result = 31 * result + (int)(this.stateB ^ this.stateB >>> 32);
        result = 31 * result + (int)(this.stateC ^ this.stateC >>> 32);
        result = 31 * result + (int)(this.stateD ^ this.stateD >>> 32);
        result = 31 * result + (int)(this.stateE ^ this.stateE >>> 32);
        return result;
    }

    public String toString() {
        return "AlternateRandom{stateA=" + this.stateA + ", stateB=" + this.stateB + ", stateC=" + this.stateC + ", stateD=" + this.stateD + ", stateE=" + this.stateE + '}';
    }
}

