/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.AlternateRandom;
import java.util.Arrays;
import java.util.Random;

public final class ArrayTools {
    private static final char[] letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff', '\u0100', '\u0101', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u0108', '\u0109', '\u010a', '\u010b', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', '\u0111', '\u0112', '\u0113', '\u0114', '\u0115', '\u0116', '\u0117', '\u0118', '\u0119', '\u011a', '\u011b', '\u011c', '\u011d', '\u011e', '\u011f', '\u0120', '\u0121', '\u0122', '\u0123', '\u0124', '\u0125', '\u0126', '\u0127', '\u0128', '\u0129', '\u012a', '\u012b', '\u012c', '\u012d', '\u012e', '\u012f', '\u0130', '\u0131', '\u0134', '\u0135', '\u0136', '\u0137', '\u0138', '\u0139', '\u013a', '\u013b', '\u013c', '\u013d', '\u013e', '\u013f', '\u0140', '\u0141', '\u0142', '\u0143', '\u0144', '\u0145', '\u0146', '\u0147', '\u0148', '\u0149', '\u014c', '\u014d', '\u014e', '\u014f', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0156', '\u0157', '\u0158', '\u0159', '\u015a', '\u015b', '\u015c', '\u015d', '\u015e', '\u015f', '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u0166', '\u0167', '\u0168', '\u0169', '\u016a', '\u016b', '\u016c', '\u016d', '\u016e', '\u016f', '\u0170', '\u0171', '\u0172', '\u0173', '\u0174', '\u0175', '\u0176', '\u0177', '\u0178', '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u01fe', '\u01ff', '\u0218', '\u0219', '\u021a', '\u021b', '\u0393', '\u0394', '\u0398', '\u039b', '\u039e', '\u03a0', '\u03a3', '\u03a6', '\u03a8', '\u03a9', '\u03b1', '\u03b2', '\u03b3'};
    private static final String[] greekLowerCase = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
    private static final String[] greekUpperCase = new String[]{"ALPHA", "BETA", "GAMMA", "DELTA", "EPSILON", "ZETA", "ETA", "THETA", "IOTA", "KAPPA", "LAMBDA", "MU", "NU", "XI", "OMICRON", "PI", "RHO", "SIGMA", "TAU", "UPSILON", "PHI", "CHI", "PSI", "OMEGA"};
    private static final String[] demonsLowerCase = new String[]{"baal", "agares", "vassago", "samigina", "marbas", "valefor", "amon", "barbatos", "paimon", "buer", "gusion", "sitri", "beleth", "leraje", "eligos", "zepar", "botis", "bathin", "sallos", "purson", "marax", "ipos", "aim", "naberius", "glasya_labolas", "bune", "ronove", "berith", "astaroth", "forneus", "foras", "asmoday", "gaap", "furfur", "marchosias", "stolas", "phenex", "halphas", "malphas", "raum", "focalor", "vepar", "sabnock", "shax", "vine", "bifrons", "vual", "haagenti", "crocell", "furcas", "balam", "alloces", "caim", "murmur", "orobas", "gremory", "ose", "amy", "orias", "vapula", "zagan", "valac", "andras", "flauros", "andrealphus", "kimaris", "amdusias", "belial", "decarabia", "seere", "dantalion", "andromalius"};
    private static final String[] demonsUpperCase = new String[]{"BAAL", "AGARES", "VASSAGO", "SAMIGINA", "MARBAS", "VALEFOR", "AMON", "BARBATOS", "PAIMON", "BUER", "GUSION", "SITRI", "BELETH", "LERAJE", "ELIGOS", "ZEPAR", "BOTIS", "BATHIN", "SALLOS", "PURSON", "MARAX", "IPOS", "AIM", "NABERIUS", "GLASYA_LABOLAS", "BUNE", "RONOVE", "BERITH", "ASTAROTH", "FORNEUS", "FORAS", "ASMODAY", "GAAP", "FURFUR", "MARCHOSIAS", "STOLAS", "PHENEX", "HALPHAS", "MALPHAS", "RAUM", "FOCALOR", "VEPAR", "SABNOCK", "SHAX", "VINE", "BIFRONS", "VUAL", "HAAGENTI", "CROCELL", "FURCAS", "BALAM", "ALLOCES", "CAIM", "MURMUR", "OROBAS", "GREMORY", "OSE", "AMY", "ORIAS", "VAPULA", "ZAGAN", "VALAC", "ANDRAS", "FLAUROS", "ANDREALPHUS", "KIMARIS", "AMDUSIAS", "BELIAL", "DECARABIA", "SEERE", "DANTALION", "ANDROMALIUS"};
    private static final String[] chemistryLowerCase = new String[]{"hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminium", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "caesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium", "darmstadtium", "roentgenium", "copernicium", "nihonium", "flerovium", "moscovium", "livermorium", "tennessine", "oganesson"};
    private static final String[] chemistryUpperCase = new String[]{"HYDROGEN", "HELIUM", "LITHIUM", "BERYLLIUM", "BORON", "CARBON", "NITROGEN", "OXYGEN", "FLUORINE", "NEON", "SODIUM", "MAGNESIUM", "ALUMINIUM", "SILICON", "PHOSPHORUS", "SULFUR", "CHLORINE", "ARGON", "POTASSIUM", "CALCIUM", "SCANDIUM", "TITANIUM", "VANADIUM", "CHROMIUM", "MANGANESE", "IRON", "COBALT", "NICKEL", "COPPER", "ZINC", "GALLIUM", "GERMANIUM", "ARSENIC", "SELENIUM", "BROMINE", "KRYPTON", "RUBIDIUM", "STRONTIUM", "YTTRIUM", "ZIRCONIUM", "NIOBIUM", "MOLYBDENUM", "TECHNETIUM", "RUTHENIUM", "RHODIUM", "PALLADIUM", "SILVER", "CADMIUM", "INDIUM", "TIN", "ANTIMONY", "TELLURIUM", "IODINE", "XENON", "CAESIUM", "BARIUM", "LANTHANUM", "CERIUM", "PRASEODYMIUM", "NEODYMIUM", "PROMETHIUM", "SAMARIUM", "EUROPIUM", "GADOLINIUM", "TERBIUM", "DYSPROSIUM", "HOLMIUM", "ERBIUM", "THULIUM", "YTTERBIUM", "LUTETIUM", "HAFNIUM", "TANTALUM", "TUNGSTEN", "RHENIUM", "OSMIUM", "IRIDIUM", "PLATINUM", "GOLD", "MERCURY", "THALLIUM", "LEAD", "BISMUTH", "POLONIUM", "ASTATINE", "RADON", "FRANCIUM", "RADIUM", "ACTINIUM", "THORIUM", "PROTACTINIUM", "URANIUM", "NEPTUNIUM", "PLUTONIUM", "AMERICIUM", "CURIUM", "BERKELIUM", "CALIFORNIUM", "EINSTEINIUM", "FERMIUM", "MENDELEVIUM", "NOBELIUM", "LAWRENCIUM", "RUTHERFORDIUM", "DUBNIUM", "SEABORGIUM", "BOHRIUM", "HASSIUM", "MEITNERIUM", "DARMSTADTIUM", "ROENTGENIUM", "COPERNICIUM", "NIHONIUM", "FLEROVIUM", "MOSCOVIUM", "LIVERMORIUM", "TENNESSINE", "OGANESSON"};
    private static final String[] allSymbols = new String[greekLowerCase.length + greekUpperCase.length + demonsLowerCase.length + demonsUpperCase.length + chemistryLowerCase.length + chemistryUpperCase.length];
    public static Random RANDOM;
    private static final char[] emptyChars;
    private static final int[] emptyInts;
    private static final char[][] emptyChars2D;
    private static final boolean[][] emptyBooleans2D;
    private static final int[][] emptyInts2D;
    private static final long[][] emptyLongs2D;
    private static final float[][] emptyFloats2D;
    private static final double[][] emptyDoubles2D;
    private static final String[] emptyStrings;

    private ArrayTools() {
    }

    public static int[] range(int end) {
        if (end <= 0) {
            return emptyInts;
        }
        int[] r = new int[end];
        for (int i = 0; i < end; ++i) {
            r[i] = i;
        }
        return r;
    }

    public static int[] range(int[] buffer) {
        int len;
        if (buffer == null || (len = buffer.length) == 0) {
            return buffer;
        }
        for (int i = 0; i < len; ++i) {
            buffer[i] = i;
        }
        return buffer;
    }

    public static int[] range(int start, int end) {
        if (end - start <= 0) {
            return emptyInts;
        }
        int[] r = new int[end - start];
        int i = 0;
        int n = start;
        while (n < end) {
            r[i] = n++;
            ++i;
        }
        return r;
    }

    public static char[] charSpan(char start, char end) {
        if (end - start <= 0) {
            return emptyChars;
        }
        if (end == '\uffff') {
            char[] r = new char[65536 - start];
            int i = 0;
            for (char n = start; n < end; n = (char)(n + '\u0001')) {
                r[i] = n;
                i = (char)(i + 1);
            }
            r[65535 - start] = 65535;
            return r;
        }
        char[] r = new char[end - start + 1];
        int i = 0;
        for (char n = start; n <= end; n = (char)(n + '\u0001')) {
            r[i] = n;
            i = (char)(i + 1);
        }
        return r;
    }

    public static char[] charSpan(char[] buffer) {
        int end;
        if (buffer == null || (end = Math.min(buffer.length - 1, 65535)) < 0) {
            return buffer;
        }
        int i = 0;
        while (end >= 0) {
            buffer[i] = i;
            i = (char)(i + 1);
            --end;
        }
        return buffer;
    }

    public static char[] charSpan(int end) {
        if (end < 0) {
            return emptyChars;
        }
        char[] r = new char[end + 1];
        int i = 0;
        while (end >= 0) {
            r[i] = i;
            i = (char)(i + 1);
            --end;
        }
        return r;
    }

    public static char[] letterSpan(int charCount) {
        if (charCount <= 0) {
            return emptyChars;
        }
        char[] r = new char[Math.min(charCount, 256)];
        System.arraycopy(letters, 0, r, 0, r.length);
        return r;
    }

    public static char[] letterSpan(int start, int charCount) {
        if (charCount <= 0 || start < 0 || start >= 256) {
            return emptyChars;
        }
        char[] r = new char[Math.min(charCount, 256 - start)];
        System.arraycopy(letters, start, r, 0, r.length);
        return r;
    }

    public static char letterAt(int index) {
        return letters[index & 0xFF];
    }

    public static String[] stringSpan(int stringCount) {
        if (stringCount <= 0) {
            return emptyStrings;
        }
        String[] r = new String[Math.min(stringCount, allSymbols.length)];
        System.arraycopy(allSymbols, 0, r, 0, r.length);
        return r;
    }

    public static String[] stringSpan(int start, int charCount) {
        if (charCount <= 0 || start < 0 || start >= allSymbols.length) {
            return emptyStrings;
        }
        String[] r = new String[Math.min(charCount, allSymbols.length - start)];
        System.arraycopy(allSymbols, start, r, 0, r.length);
        return r;
    }

    public static String stringAt(int index) {
        return allSymbols[(index & 0x3FF) % allSymbols.length];
    }

    public static String greekLetterAt(int index) {
        return greekLowerCase[(index & 0x3FF) % greekLowerCase.length];
    }

    public static String demonNameAt(int index) {
        return demonsLowerCase[(index & 0x3FF) % demonsLowerCase.length];
    }

    public static String chemicalElementAt(int index) {
        return chemistryLowerCase[(index & 0x3FF) % chemistryLowerCase.length];
    }

    public static String[] greekLetters(int start, int length, boolean upperCase) {
        start = (start % 24 + 24) % 24;
        return ArrayTools.stringSpan(start + (upperCase ? 24 : 0), Math.min(length, 24 - start));
    }

    public static String[] demonNames(int start, int length, boolean upperCase) {
        start = (start % 72 + 72) % 72;
        return ArrayTools.stringSpan(start + (upperCase ? 72 : 0) + 48, Math.min(length, 72 - start));
    }

    public static String[] chemicalElements(int start, int length, boolean upperCase) {
        start = (start % 118 + 118) % 118;
        return ArrayTools.stringSpan(start + (upperCase ? 118 : 0) + 48 + 144, Math.min(length, 118 - start));
    }

    public static char[][] copy(char[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyChars2D;
        }
        char[][] target = new char[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new char[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    public static double[][] copy(double[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyDoubles2D;
        }
        double[][] target = new double[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new double[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    public static float[][] copy(float[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyFloats2D;
        }
        float[][] target = new float[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new float[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    public static int[][] copy(int[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyInts2D;
        }
        int[][] target = new int[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new int[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    public static long[][] copy(long[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyLongs2D;
        }
        long[][] target = new long[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new long[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    public static boolean[][] copy(boolean[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyBooleans2D;
        }
        boolean[][] target = new boolean[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new boolean[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    public static char[][] insert(char[][] source, char[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static double[][] insert(double[][] source, double[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static float[][] insert(float[][] source, float[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static int[][] insert(int[][] source, int[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static long[][] insert(long[][] source, long[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static boolean[][] insert(boolean[][] source, boolean[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static <T> T[][] insert(T[][] source, T[][] target, int x, int y) {
        if (source == null || target == null) {
            return target;
        }
        if (source.length < 1 || source[0].length < 1) {
            return target;
        }
        for (int i = 0; i < source.length && x + i < target.length; ++i) {
            System.arraycopy(source[i], 0, target[x + i], y, Math.min(source[i].length, target[x + i].length - y));
        }
        return target;
    }

    public static char[][] set(char[][] source, char[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static float[][] set(float[][] source, float[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static double[][] set(double[][] source, double[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static int[][] set(int[][] source, int[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static long[][] set(long[][] source, long[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static boolean[][] set(boolean[][] source, boolean[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static <T> T[][] set(T[][] source, T[][] target) {
        if (source == null || target == null || source.length == 0) {
            return target;
        }
        int minWidth = Math.min(source.length, target.length);
        for (int i = 0; i < minWidth; ++i) {
            System.arraycopy(source[i], 0, target[i], 0, Math.min(source[i].length, target[i].length));
        }
        return target;
    }

    public static char[][] section(char[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new char[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new char[0][0];
        }
        char[][] result = new char[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static byte[][] section(byte[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new byte[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new byte[0][0];
        }
        byte[][] result = new byte[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static short[][] section(short[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new short[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new short[0][0];
        }
        short[][] result = new short[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static int[][] section(int[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new int[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new int[0][0];
        }
        int[][] result = new int[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static long[][] section(long[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new long[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new long[0][0];
        }
        long[][] result = new long[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static boolean[][] section(boolean[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new boolean[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new boolean[0][0];
        }
        boolean[][] result = new boolean[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static float[][] section(float[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new float[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new float[0][0];
        }
        float[][] result = new float[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static double[][] section(double[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return new double[0][0];
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return new double[0][0];
        }
        double[][] result = new double[minWidth][minHeight];
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            System.arraycopy(source[x], startY, result[i], 0, minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static <T> T[][] section(T[][] source, int startX, int startY, int width, int height) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            return (Object[][])Arrays.copyOf(source, 0);
        }
        int minWidth = Math.min(source.length - startX, width);
        int minHeight = Math.min(source[0].length - startY, height);
        if (minWidth == 0 || minHeight == 0) {
            return (Object[][])Arrays.copyOf(source, 0);
        }
        Object[][] result = (Object[][])Arrays.copyOf(source, minWidth);
        int i = 0;
        int x = startX;
        while (i < minWidth) {
            result[i] = Arrays.copyOfRange(source[x], startY, startY + minHeight);
            ++i;
            ++x;
        }
        return result;
    }

    public static char[][] sequentialFill(char[][] modifying, char ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static byte[][] sequentialFill(byte[][] modifying, byte ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static short[][] sequentialFill(short[][] modifying, short ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static int[][] sequentialFill(int[][] modifying, int ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static long[][] sequentialFill(long[][] modifying, long ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static boolean[][] sequentialFill(boolean[][] modifying, boolean ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static float[][] sequentialFill(float[][] modifying, float ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static double[][] sequentialFill(double[][] modifying, double ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    @SafeVarargs
    public static <T> T[][] sequentialFill(T[][] modifying, T ... contents) {
        if (modifying == null || contents == null) {
            return modifying;
        }
        int limit = contents.length;
        if (limit == 0) {
            return modifying;
        }
        int ci = 0;
        for (int x = 0; x < modifying.length; ++x) {
            for (int y = 0; y < modifying[x].length; ++y) {
                modifying[x][y] = contents[ci++];
                if (ci != limit) continue;
                ci = 0;
            }
        }
        return modifying;
    }

    public static char[][] fill(char contents, int width, int height) {
        char[][] next = new char[width][height];
        for (int x = 0; x < width; ++x) {
            Arrays.fill(next[x], contents);
        }
        return next;
    }

    public static float[][] fill(float contents, int width, int height) {
        float[][] next = new float[width][height];
        for (int x = 0; x < width; ++x) {
            Arrays.fill(next[x], contents);
        }
        return next;
    }

    public static double[][] fill(double contents, int width, int height) {
        double[][] next = new double[width][height];
        for (int x = 0; x < width; ++x) {
            Arrays.fill(next[x], contents);
        }
        return next;
    }

    public static int[][] fill(int contents, int width, int height) {
        int[][] next = new int[width][height];
        for (int x = 0; x < width; ++x) {
            Arrays.fill(next[x], contents);
        }
        return next;
    }

    public static long[][] fill(long contents, int width, int height) {
        long[][] next = new long[width][height];
        for (int x = 0; x < width; ++x) {
            Arrays.fill(next[x], contents);
        }
        return next;
    }

    public static byte[][] fill(byte contents, int width, int height) {
        byte[][] next = new byte[width][height];
        for (int x = 0; x < width; ++x) {
            Arrays.fill(next[x], contents);
        }
        return next;
    }

    public static boolean[][] fill(boolean contents, int width, int height) {
        boolean[][] next = new boolean[width][height];
        if (contents) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(next[x], true);
            }
        }
        return next;
    }

    public static boolean[][] fill(boolean[][] array2d, boolean value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static char[][] fill(char[][] array2d, char value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static float[][] fill(float[][] array2d, float value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static double[][] fill(double[][] array2d, double value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static int[][] fill(int[][] array2d, int value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static long[][] fill(long[][] array2d, long value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static byte[][] fill(byte[][] array2d, byte value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static <T> T[][] fill(T[][] array2d, T value) {
        int width = array2d.length;
        for (int i = 0; i < width; ++i) {
            Arrays.fill(array2d[i], value);
        }
        return array2d;
    }

    public static boolean[][][] fill(boolean[][][] array3d, boolean value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static char[][][] fill(char[][][] array3d, char value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static float[][][] fill(float[][][] array3d, float value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static double[][][] fill(double[][][] array3d, double value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static int[][][] fill(int[][][] array3d, int value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static long[][][] fill(long[][][] array3d, long value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static byte[][][] fill(byte[][][] array3d, byte value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static <T> T[][][] fill(T[][][] array3d, T value) {
        int height;
        int depth = array3d.length;
        int width = depth == 0 ? 0 : array3d[0].length;
        int n = height = width == 0 ? 0 : array3d[0][0].length;
        if (depth > 0 && width > 0) {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Arrays.fill(array3d[i][j], value);
                }
            }
        }
        return array3d;
    }

    public static boolean[][] fill(boolean[][] array2d, boolean value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static char[][] fill(char[][] array2d, char value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static float[][] fill(float[][] array2d, float value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static double[][] fill(double[][] array2d, double value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static int[][] fill(int[][] array2d, int value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static long[][] fill(long[][] array2d, long value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static <T> T[][] fill(T[][] array2d, T value, int startX, int startY, int endX, int endY) {
        int width = array2d.length;
        int height = width == 0 ? 0 : array2d[0].length;
        for (int x = startX; x <= endX && x < width; ++x) {
            for (int y = startY; y <= endY && y < height; ++y) {
                array2d[x][y] = value;
            }
        }
        return array2d;
    }

    public static long[] reverse(long[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            long t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static boolean[] reverse(boolean[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            boolean t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static char[] reverse(char[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            char t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static float[] reverse(float[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            float t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static double[] reverse(double[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            double t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static int[] reverse(int[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            int t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static byte[] reverse(byte[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            byte t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static <T> T[] reverse(T[] data) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        int i = 0;
        for (int j = sz - 1; i < j; ++i, --j) {
            T t = data[j];
            data[j] = data[i];
            data[i] = t;
        }
        return data;
    }

    public static long[] shuffle(long[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static long[] shuffle(long[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            long t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static long[] shuffle(long[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            long temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static boolean[] shuffle(boolean[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static boolean[] shuffle(boolean[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            boolean t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static boolean[] shuffle(boolean[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            boolean temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static char[] shuffle(char[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static char[] shuffle(char[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            char t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static char[] shuffle(char[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            char temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static float[] shuffle(float[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static float[] shuffle(float[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            float t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static float[] shuffle(float[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            float temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static double[] shuffle(double[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static double[] shuffle(double[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            double t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static double[] shuffle(double[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            double temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static int[] shuffle(int[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static int[] shuffle(int[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            int t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static int[] shuffle(int[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            int temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static short[] shuffle(short[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static short[] shuffle(short[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            short t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static short[] shuffle(short[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            short temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static byte[] shuffle(byte[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static byte[] shuffle(byte[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            byte t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static byte[] shuffle(byte[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            byte temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static <T> T[] shuffle(T[] data) {
        return ArrayTools.shuffle(data, RANDOM);
    }

    public static <T> T[] shuffle(T[] data, Random rand) {
        int sz;
        if (data == null || (sz = data.length) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = sz - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            T t = data[i];
            data[i] = data[j];
            data[j] = t;
        }
        return data;
    }

    public static <T> T[] shuffle(T[] data, Random rand, int offset, int length) {
        if (data == null || data.length == 0) {
            return data;
        }
        offset = Math.min(Math.max(0, offset), data.length);
        length = Math.min(data.length - offset, Math.max(0, length));
        if (rand == null) {
            rand = RANDOM;
        }
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + rand.nextInt(i + 1 - offset);
            T temp = data[i];
            data[i] = data[ii];
            data[ii] = temp;
        }
        return data;
    }

    public static boolean[][] shuffle2D(boolean[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static boolean[][] shuffle2D(boolean[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            boolean t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static char[][] shuffle2D(char[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static char[][] shuffle2D(char[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            char t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static long[][] shuffle2D(long[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static long[][] shuffle2D(long[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            long t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static int[][] shuffle2D(int[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static int[][] shuffle2D(int[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            int t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static byte[][] shuffle2D(byte[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static byte[][] shuffle2D(byte[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            byte t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static short[][] shuffle2D(short[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static short[][] shuffle2D(short[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            short t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static float[][] shuffle2D(float[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static float[][] shuffle2D(float[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            float t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static double[][] shuffle2D(double[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static double[][] shuffle2D(double[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            double t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    public static <T> T[][] shuffle2D(T[][] data) {
        return ArrayTools.shuffle2D(data, RANDOM);
    }

    public static <T> T[][] shuffle2D(T[][] data, Random rand) {
        int wide;
        int sz;
        if (data == null || data[0] == null || (sz = data.length * (wide = data[0].length)) <= 0) {
            return data;
        }
        if (rand == null) {
            rand = RANDOM;
        }
        int ix = wide - 1;
        int iy = data.length - 1;
        int i = sz - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int jy = j / wide;
            int jx = j - jy * wide;
            T t = data[iy][ix];
            data[iy][ix] = data[jy][jx];
            data[jy][jx] = t;
            if (ix == 0) {
                ix = wide;
                --iy;
            }
            --i;
            --ix;
        }
        return data;
    }

    static {
        int ins = 0;
        System.arraycopy(greekLowerCase, 0, allSymbols, 0, greekLowerCase.length);
        System.arraycopy(greekUpperCase, 0, allSymbols, ins += greekLowerCase.length, greekUpperCase.length);
        System.arraycopy(demonsLowerCase, 0, allSymbols, ins += greekUpperCase.length, demonsLowerCase.length);
        System.arraycopy(demonsUpperCase, 0, allSymbols, ins += demonsLowerCase.length, demonsUpperCase.length);
        System.arraycopy(chemistryLowerCase, 0, allSymbols, ins += demonsUpperCase.length, chemistryLowerCase.length);
        System.arraycopy(chemistryUpperCase, 0, allSymbols, ins += chemistryLowerCase.length, chemistryUpperCase.length);
        RANDOM = new AlternateRandom();
        emptyChars = new char[0];
        emptyInts = new int[0];
        emptyChars2D = new char[0][0];
        emptyBooleans2D = new boolean[0][0];
        emptyInts2D = new int[0][0];
        emptyLongs2D = new long[0][0];
        emptyFloats2D = new float[0][0];
        emptyDoubles2D = new double[0][0];
        emptyStrings = new String[0];
    }
}

