/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.digital.RyuDouble;
import com.github.tommyettinger.digital.RyuFloat;
import com.github.tommyettinger.digital.TextTools;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Base {
    public static final Base BASE2 = new Base("01", true, '$', '+', '-');
    public static final Base BASE8 = new Base("01234567", true, '$', '+', '-');
    public static final Base BASE10 = new Base("0123456789", true, '$', '+', '-');
    public static final Base BASE16 = new Base("0123456789ABCDEF", true, 'p', '+', '-');
    public static final Base BASE36 = new Base("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", true, '$', '+', '-');
    public static final Base BASE64 = new Base("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", false, '=', '*', '-');
    public static final Base URI_SAFE = new Base("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-", false, '$', '*', '!');
    public static final Base SIMPLE64 = new Base("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!?", false, '$', '+', '-');
    public static final Base BASE86 = new Base("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'/!@#$%^&*()[]{}<>:?;|_=", false, '\\', '+', '-');
    private static final List<Base> BASES = Arrays.asList(BASE2, BASE8, BASE10, BASE16, BASE36, BASE64, URI_SAFE, SIMPLE64, BASE86);
    public final char[] toEncoded;
    public final int[] fromEncoded;
    public final char paddingChar;
    public final char positiveSign;
    public final char negativeSign;
    public final boolean caseInsensitive;
    public final int base;
    private final int length1Byte;
    private final int length2Byte;
    private final int length4Byte;
    private final int length8Byte;
    private final transient char[] progress;
    private static final long[][] long2D = new long[0][0];
    private static final int[][] int2D = new int[0][0];
    private static final short[][] short2D = new short[0][0];
    private static final byte[][] byte2D = new byte[0][0];
    private static final char[][] char2D = new char[0][0];
    private static final double[][] double2D = new double[0][0];
    private static final float[][] float2D = new float[0][0];

    public static List<Base> values() {
        return BASES;
    }

    public Base(String digits) {
        this(digits, true, '$', '+', '-');
    }

    public Base(String digits, boolean caseInsensitive, char padding, char positiveSign, char negativeSign) {
        this.paddingChar = padding;
        this.caseInsensitive = caseInsensitive;
        this.positiveSign = positiveSign;
        this.negativeSign = negativeSign;
        this.toEncoded = digits.toCharArray();
        this.base = this.toEncoded.length;
        this.fromEncoded = new int[128];
        Arrays.fill(this.fromEncoded, -1);
        for (int i = 0; i < this.base; ++i) {
            char to = this.toEncoded[i];
            this.fromEncoded[to & 0x7F] = i;
            if (!caseInsensitive) continue;
            this.fromEncoded[Character.toLowerCase((char)to) & 0x7F] = i;
        }
        double logBase = 1.0 / Math.log(this.base);
        this.length1Byte = (int)Math.ceil(Math.log(256.0) * logBase);
        this.length2Byte = (int)Math.ceil(Math.log(65536.0) * logBase);
        this.length4Byte = (int)Math.ceil(Math.log(4.294967296E9) * logBase);
        this.length8Byte = (int)Math.ceil(Math.log(1.8446744073709552E19) * logBase);
        this.progress = new char[Math.max(this.length8Byte + 1, 32)];
    }

    public Base(Base other) {
        this.paddingChar = other.paddingChar;
        this.caseInsensitive = other.caseInsensitive;
        this.positiveSign = other.positiveSign;
        this.negativeSign = other.negativeSign;
        this.base = other.base;
        this.toEncoded = Arrays.copyOf(other.toEncoded, this.base);
        this.fromEncoded = Arrays.copyOf(other.fromEncoded, 128);
        this.length1Byte = other.length1Byte;
        this.length2Byte = other.length2Byte;
        this.length4Byte = other.length4Byte;
        this.length8Byte = other.length8Byte;
        this.progress = new char[Math.max(this.length8Byte + 1, 32)];
    }

    public static Base scrambledBase(Random random) {
        char[] options = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789?!@#$%^&*-|=+;".toCharArray();
        for (int i = options.length - 1; i > 0; --i) {
            int ii = random.nextInt(i + 1);
            char temp = options[i];
            options[i] = options[ii];
            options[ii] = temp;
        }
        char pad = options[options.length - 3];
        char plus = options[options.length - 2];
        char minus = options[options.length - 1];
        Base base = new Base("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789?!@#$%^&*-", false, pad, plus, minus);
        System.arraycopy(options, 0, base.toEncoded, 0, 72);
        Arrays.fill(base.fromEncoded, -1);
        for (int i = 0; i < base.base; ++i) {
            base.fromEncoded[base.toEncoded[i] & 0x7F] = i;
        }
        return base;
    }

    public Base scramble(Random random) {
        int i;
        Base base = new Base(this);
        Arrays.fill(base.fromEncoded, -1);
        for (i = base.toEncoded.length - 1; i > 0; --i) {
            int ii = random.nextInt(i + 1);
            char temp = base.toEncoded[i];
            base.toEncoded[i] = base.toEncoded[ii];
            base.toEncoded[ii] = temp;
        }
        for (i = 0; i < base.base; ++i) {
            base.fromEncoded[base.toEncoded[i] & 0x7F] = i;
        }
        return base;
    }

    public String serializeToString() {
        return String.valueOf(this.toEncoded) + (this.caseInsensitive ? (char)'1' : '0') + this.paddingChar + this.positiveSign + this.negativeSign;
    }

    public static Base deserializeFromString(String data) {
        int len = data.length();
        if (len >= 5) {
            return new Base(data.substring(0, len - 4), data.charAt(len - 4) != '0', data.charAt(len - 3), data.charAt(len - 2), data.charAt(len - 1));
        }
        throw new IllegalArgumentException("The given data does not store a serialized Base.");
    }

    public String unsigned(long number) {
        int len = this.length8Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            long quotient = (number >>> 1) / (long)halfBase;
            this.progress[len - i] = this.toEncoded[(int)(number - quotient * (long)this.base)];
            number = quotient;
        }
        return String.valueOf(this.progress, 0, this.length8Byte);
    }

    public StringBuilder appendUnsigned(StringBuilder builder, long number) {
        int len = this.length8Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            long quotient = (number >>> 1) / (long)halfBase;
            this.progress[len - i] = this.toEncoded[(int)(number - quotient * (long)this.base)];
            number = quotient;
        }
        return builder.append(this.progress, 0, this.length8Byte);
    }

    public String signed(long number) {
        int run = this.length8Byte;
        long sign = number >> -1;
        number = -(number + sign ^ sign);
        while (true) {
            this.progress[run] = this.toEncoded[(int)(-(number % (long)this.base))];
            if ((number /= (long)this.base) == 0L) break;
            --run;
        }
        if (sign != 0L) {
            this.progress[--run] = this.negativeSign;
        }
        return String.valueOf(this.progress, run, this.length8Byte + 1 - run);
    }

    public StringBuilder appendSigned(StringBuilder builder, long number) {
        int run = this.length8Byte;
        long sign = number >> -1;
        number = -(number + sign ^ sign);
        while (true) {
            this.progress[run] = this.toEncoded[(int)(-(number % (long)this.base))];
            if ((number /= (long)this.base) == 0L) break;
            --run;
        }
        if (sign != 0L) {
            this.progress[--run] = this.negativeSign;
        }
        return builder.append(this.progress, run, this.length8Byte + 1 - run);
    }

    public long readLong(CharSequence cs) {
        return this.readLong(cs, 0, cs == null ? 0 : cs.length());
    }

    public long readLong(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0L;
        }
        char c = cs.charAt(start);
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length8Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length8Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0L;
            }
            len = 1;
            lim = this.length8Byte;
        }
        long data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs.charAt(i) & 0x7F];
            if (h < 0) {
                return data * (long)len;
            }
            data *= (long)this.base;
            data += (long)h;
        }
        return data * (long)len;
    }

    public long readLong(char[] cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || cs == null || (len = cs.length) - start <= 0 || end > len) {
            return 0L;
        }
        char c = cs[start];
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length8Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length8Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0L;
            }
            len = 1;
            lim = this.length8Byte;
        }
        long data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs[i] & 0x7F];
            if (h < 0) {
                return data * (long)len;
            }
            data *= (long)this.base;
            data += (long)h;
        }
        return data * (long)len;
    }

    public String unsigned(int number) {
        int len = this.length4Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = (number >>> 1) / halfBase;
            this.progress[len - i] = this.toEncoded[number - quotient * this.base | 0];
            number = quotient;
        }
        return String.valueOf(this.progress, 0, this.length4Byte);
    }

    public StringBuilder appendUnsigned(StringBuilder builder, int number) {
        int len = this.length4Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = (number >>> 1) / halfBase;
            this.progress[len - i] = this.toEncoded[number - quotient * this.base | 0];
            number = quotient;
        }
        return builder.append(this.progress, 0, this.length4Byte);
    }

    public String signed(int number) {
        int run = this.length8Byte;
        int sign = number >> -1;
        number = -(number + sign ^ sign);
        while (true) {
            this.progress[run] = this.toEncoded[-(number % this.base)];
            if ((number /= this.base) == 0) break;
            --run;
        }
        if (sign != 0) {
            this.progress[--run] = this.negativeSign;
        }
        return String.valueOf(this.progress, run, this.length8Byte + 1 - run);
    }

    public StringBuilder appendSigned(StringBuilder builder, int number) {
        int run = this.length8Byte;
        int sign = number >> -1;
        number = -(number + sign ^ sign);
        while (true) {
            this.progress[run] = this.toEncoded[-(number % this.base)];
            if ((number /= this.base) == 0) break;
            --run;
        }
        if (sign != 0) {
            this.progress[--run] = this.negativeSign;
        }
        return builder.append(this.progress, run, this.length8Byte + 1 - run);
    }

    public int readInt(CharSequence cs) {
        return this.readInt(cs, 0, cs == null ? 0 : cs.length());
    }

    public int readInt(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length4Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length4Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0;
            }
            len = 1;
            lim = this.length4Byte;
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs.charAt(i) & 0x7F];
            if (h < 0) {
                return data * len;
            }
            data *= this.base;
            data += h;
        }
        return data * len;
    }

    public int readInt(char[] cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || cs == null || (len = cs.length) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs[start];
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length4Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length4Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0;
            }
            len = 1;
            lim = this.length4Byte;
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs[i] & 0x7F];
            if (h < 0) {
                return data * len;
            }
            data *= this.base;
            data += h;
        }
        return data * len;
    }

    public String unsigned(short number) {
        int len = this.length2Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = ((number & 0xFFFF) >>> 1) / halfBase;
            this.progress[len - i] = this.toEncoded[(number & 0xFFFF) - quotient * this.base];
            number = (short)quotient;
        }
        return String.valueOf(this.progress, 0, this.length2Byte);
    }

    public StringBuilder appendUnsigned(StringBuilder builder, short number) {
        int len = this.length2Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = ((number & 0xFFFF) >>> 1) / halfBase;
            this.progress[len - i] = this.toEncoded[(number & 0xFFFF) - quotient * this.base];
            number = (short)quotient;
        }
        return builder.append(this.progress, 0, this.length2Byte);
    }

    public String signed(short number) {
        int run = this.length8Byte;
        int sign = number >> -1;
        number = (short)(-(number + sign ^ sign));
        while (true) {
            this.progress[run] = this.toEncoded[-(number % this.base)];
            if ((number = (short)(number / this.base)) == 0) break;
            --run;
        }
        if (sign != 0) {
            this.progress[--run] = this.negativeSign;
        }
        return String.valueOf(this.progress, run, this.length8Byte + 1 - run);
    }

    public StringBuilder appendSigned(StringBuilder builder, short number) {
        int run = this.length8Byte;
        int sign = number >> -1;
        number = (short)(-(number + sign ^ sign));
        while (true) {
            this.progress[run] = this.toEncoded[-(number % this.base)];
            if ((number = (short)(number / this.base)) == 0) break;
            --run;
        }
        if (sign != 0) {
            this.progress[--run] = this.negativeSign;
        }
        return builder.append(this.progress, run, this.length8Byte + 1 - run);
    }

    public short readShort(CharSequence cs) {
        return this.readShort(cs, 0, cs == null ? 0 : cs.length());
    }

    public short readShort(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length2Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length2Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0;
            }
            len = 1;
            lim = this.length2Byte;
        }
        short data = (short)h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs.charAt(i) & 0x7F];
            if (h < 0) {
                return (short)(data * len);
            }
            data = (short)(data * this.base);
            data = (short)(data + h);
        }
        return (short)(data * len);
    }

    public short readShort(char[] cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || cs == null || (len = cs.length) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs[start];
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length2Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length2Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0;
            }
            len = 1;
            lim = this.length2Byte;
        }
        short data = (short)h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs[i] & 0x7F];
            if (h < 0) {
                return (short)(data * len);
            }
            data = (short)(data * this.base);
            data = (short)(data + h);
        }
        return (short)(data * len);
    }

    public String unsigned(byte number) {
        int len = this.length1Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = ((number & 0xFF) >>> 1) / halfBase;
            this.progress[len - i] = this.toEncoded[(number & 0xFF) - quotient * this.base];
            number = (byte)quotient;
        }
        return String.valueOf(this.progress, 0, this.length1Byte);
    }

    public StringBuilder appendUnsigned(StringBuilder builder, byte number) {
        int len = this.length1Byte - 1;
        int halfBase = this.base >>> 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = ((number & 0xFF) >>> 1) / halfBase;
            this.progress[len - i] = this.toEncoded[(number & 0xFF) - quotient * this.base];
            number = (byte)quotient;
        }
        return builder.append(this.progress, 0, this.length1Byte);
    }

    public String signed(byte number) {
        int run = this.length8Byte;
        int sign = number >> -1;
        number = (byte)(-(number + sign ^ sign));
        while (true) {
            this.progress[run] = this.toEncoded[-(number % this.base)];
            if ((number = (byte)(number / this.base)) == 0) break;
            --run;
        }
        if (sign != 0) {
            this.progress[--run] = this.negativeSign;
        }
        return String.valueOf(this.progress, run, this.length8Byte + 1 - run);
    }

    public StringBuilder appendSigned(StringBuilder builder, byte number) {
        int run = this.length8Byte;
        int sign = number >> -1;
        number = (byte)(-(number + sign ^ sign));
        while (true) {
            this.progress[run] = this.toEncoded[-(number % this.base)];
            if ((number = (byte)(number / this.base)) == 0) break;
            --run;
        }
        if (sign != 0) {
            this.progress[--run] = this.negativeSign;
        }
        return builder.append(this.progress, run, this.length8Byte + 1 - run);
    }

    public byte readByte(CharSequence cs) {
        return this.readByte(cs, 0, cs == null ? 0 : cs.length());
    }

    public byte readByte(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length1Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length1Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0;
            }
            len = 1;
            lim = this.length1Byte;
        }
        byte data = (byte)h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs.charAt(i) & 0x7F];
            if (h < 0) {
                return (byte)(data * len);
            }
            data = (byte)(data * this.base);
            data = (byte)(data + h);
        }
        return (byte)(data * len);
    }

    public byte readByte(char[] cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || cs == null || (len = cs.length) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs[start];
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length1Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length1Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return 0;
            }
            len = 1;
            lim = this.length1Byte;
        }
        byte data = (byte)h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs[i] & 0x7F];
            if (h < 0) {
                return (byte)(data * len);
            }
            data = (byte)(data * this.base);
            data = (byte)(data + h);
        }
        return (byte)(data * len);
    }

    public String unsigned(double number) {
        return '.' + this.unsigned(BitConversion.doubleToRawLongBits(number));
    }

    public StringBuilder appendUnsigned(StringBuilder builder, double number) {
        return this.appendUnsigned(builder.append('.'), BitConversion.doubleToRawLongBits(number));
    }

    public String signed(double number) {
        return this.signed(BitConversion.doubleToReversedLongBits(number));
    }

    public StringBuilder appendSigned(StringBuilder builder, double number) {
        return this.appendSigned(builder, BitConversion.doubleToReversedLongBits(number));
    }

    public String general(double number) {
        int i = RyuDouble.general(number, this.progress);
        return String.valueOf(this.progress, 0, i);
    }

    public StringBuilder appendGeneral(StringBuilder builder, double number) {
        return RyuDouble.appendGeneral(builder, number, this.progress);
    }

    public String friendly(double number) {
        int i = RyuDouble.friendly(number, this.progress);
        return String.valueOf(this.progress, 0, i);
    }

    public StringBuilder appendFriendly(StringBuilder builder, double number) {
        return RyuDouble.appendFriendly(builder, number, this.progress);
    }

    public String scientific(double number) {
        int i = RyuDouble.scientific(number, this.progress);
        return String.valueOf(this.progress, 0, i);
    }

    public StringBuilder appendScientific(StringBuilder builder, double number) {
        return RyuDouble.appendScientific(builder, number, this.progress);
    }

    public String decimal(double number) {
        return RyuDouble.decimal(number);
    }

    public String decimal(double number, int lengthLimit) {
        return RyuDouble.decimal(number, lengthLimit);
    }

    public String decimal(double number, int lengthLimit, int precision) {
        return RyuDouble.decimal(number, lengthLimit, precision);
    }

    public StringBuilder appendDecimal(StringBuilder builder, double number) {
        return RyuDouble.appendDecimal(builder, number);
    }

    public StringBuilder appendDecimal(StringBuilder builder, double number, int lengthLimit) {
        return RyuDouble.appendDecimal(builder, number, lengthLimit);
    }

    public StringBuilder appendDecimal(StringBuilder builder, double number, int lengthLimit, int precision) {
        return RyuDouble.appendDecimal(builder, number, lengthLimit, precision);
    }

    public double readDoubleExact(CharSequence cs) {
        return this.readDoubleExact(cs, 0, cs == null ? 0 : cs.length());
    }

    public double readDoubleExact(CharSequence cs, int start, int end) {
        if (cs == null || cs.length() == 0) {
            return 0.0;
        }
        if (cs.charAt(start) == '.') {
            return BitConversion.longBitsToDouble(this.readLong(cs, start + 1, end));
        }
        return BitConversion.reversedLongBitsToDouble(this.readLong(cs, start, end));
    }

    public double readDoubleExact(char[] cs, int start, int end) {
        if (cs == null || cs.length == 0) {
            return 0.0;
        }
        if (cs[start] == '.') {
            return BitConversion.longBitsToDouble(this.readLong(cs, start + 1, end));
        }
        return BitConversion.reversedLongBitsToDouble(this.readLong(cs, start, end));
    }

    public double readDouble(CharSequence str) {
        return this.readDouble(str, 0, Integer.MAX_VALUE);
    }

    public double readDouble(CharSequence str, int begin, int end) {
        char ith;
        int i;
        int start;
        block45: {
            block44: {
                if (str == null || (begin = Math.max(begin, 0)) >= end) break block44;
                end = Math.min(str.length(), end);
                if (str.length() >= end - begin) break block45;
            }
            return 0.0;
        }
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        while (str.charAt(begin) <= ' ') {
            ++begin;
        }
        if (begin >= end) {
            return 0.0;
        }
        char first = str.charAt(begin);
        int n = start = first == '-' || first == '+' ? begin + 1 : begin;
        if (end - start >= 1 && str.charAt(start) == 'N') {
            return Double.NaN;
        }
        if (end - start >= 1 && str.charAt(start) == 'I') {
            return first == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        --end;
        for (i = start; i < end; ++i) {
            ith = str.charAt(i);
            if (ith >= '0' && ith <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Double.parseDouble(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                hasDecPoint = true;
                continue;
            }
            if (ith == 'e' || ith == 'E') {
                if (hasExp) {
                    try {
                        return Double.parseDouble(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                if (!foundDigit) {
                    try {
                        return Double.parseDouble(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (ith == '+' || ith == '-') {
                if (!allowSigns) {
                    try {
                        return Double.parseDouble(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            try {
                return Double.parseDouble(str.toString().substring(begin, i));
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        if (i <= end) {
            ith = str.charAt(i);
            if (ith >= '0' && ith <= '9') {
                try {
                    return Double.parseDouble(str.toString().substring(begin, i + 1));
                }
                catch (Exception ignored) {
                    return 0.0;
                }
            }
            if (ith == 'e' || ith == 'E') {
                try {
                    return Double.parseDouble(str.toString().substring(begin, i));
                }
                catch (Exception ignored) {
                    return 0.0;
                }
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Double.parseDouble(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                try {
                    return Double.parseDouble(str.toString().substring(begin, foundDigit ? i + 1 : i));
                }
                catch (Exception ignored) {
                    return 0.0;
                }
            }
            try {
                return Double.parseDouble(str.toString().substring(begin, i));
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        if (!allowSigns && foundDigit) {
            try {
                return Double.parseDouble(str.toString().substring(begin, i));
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public double readDouble(char[] str, int begin, int end) {
        char ith;
        int i;
        int start;
        if (str == null || (begin = Math.max(begin, 0)) >= end || str.length < (end = Math.min(str.length, end)) - begin) {
            return 0.0;
        }
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        while (str[begin] <= ' ') {
            ++begin;
        }
        if (begin >= end) {
            return 0.0;
        }
        char first = str[begin];
        int n = start = first == '-' || first == '+' ? begin + 1 : begin;
        if (end - start >= 1 && str[start] == 'N') {
            return Double.NaN;
        }
        if (end - start >= 1 && str[start] == 'I') {
            return first == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        --end;
        for (i = start; i < end; ++i) {
            ith = str[i];
            if (ith >= '0' && ith <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Double.parseDouble(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                hasDecPoint = true;
                continue;
            }
            if (ith == 'e' || ith == 'E') {
                if (hasExp) {
                    try {
                        return Double.parseDouble(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                if (!foundDigit) {
                    try {
                        return Double.parseDouble(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (ith == '+' || ith == '-') {
                if (!allowSigns) {
                    try {
                        return Double.parseDouble(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            try {
                return Double.parseDouble(String.valueOf(str, begin, i - begin));
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        if (i <= end) {
            ith = str[i];
            if (ith >= '0' && ith <= '9') {
                try {
                    return Double.parseDouble(String.valueOf(str, begin, i + 1 - begin));
                }
                catch (Exception ignored) {
                    return 0.0;
                }
            }
            if (ith == 'e' || ith == 'E') {
                try {
                    return Double.parseDouble(String.valueOf(str, begin, i - begin));
                }
                catch (Exception ignored) {
                    return 0.0;
                }
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Double.parseDouble(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0;
                    }
                }
                try {
                    return Double.parseDouble(String.valueOf(str, begin, (foundDigit ? i + 1 : i) - begin));
                }
                catch (Exception ignored) {
                    return 0.0;
                }
            }
            try {
                return Double.parseDouble(String.valueOf(str, begin, i - begin));
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        if (!allowSigns && foundDigit) {
            try {
                return Double.parseDouble(String.valueOf(str, begin, i - begin));
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public String unsigned(float number) {
        return '.' + this.unsigned(BitConversion.floatToRawIntBits(number));
    }

    public StringBuilder appendUnsigned(StringBuilder builder, float number) {
        return this.appendUnsigned(builder.append('.'), BitConversion.floatToRawIntBits(number));
    }

    public String signed(float number) {
        return this.signed(BitConversion.floatToReversedIntBits(number));
    }

    public StringBuilder appendSigned(StringBuilder builder, float number) {
        return this.appendSigned(builder, BitConversion.floatToReversedIntBits(number));
    }

    public String general(float number) {
        int i = RyuFloat.general(number, this.progress);
        return String.valueOf(this.progress, 0, i);
    }

    public StringBuilder appendGeneral(StringBuilder builder, float number) {
        return RyuFloat.appendGeneral(builder, number, this.progress);
    }

    public String friendly(float number) {
        int i = RyuFloat.friendly(number, this.progress);
        return String.valueOf(this.progress, 0, i);
    }

    public StringBuilder appendFriendly(StringBuilder builder, float number) {
        return RyuFloat.appendFriendly(builder, number, this.progress);
    }

    public String scientific(float number) {
        int i = RyuFloat.scientific(number, this.progress);
        return String.valueOf(this.progress, 0, i);
    }

    public StringBuilder appendScientific(StringBuilder builder, float number) {
        return RyuFloat.appendScientific(builder, number, this.progress);
    }

    public String decimal(float number) {
        return RyuFloat.decimal(number);
    }

    public String decimal(float number, int lengthLimit) {
        return RyuFloat.decimal(number, lengthLimit);
    }

    public String decimal(float number, int lengthLimit, int precision) {
        return RyuFloat.decimal(number, lengthLimit, precision);
    }

    public StringBuilder appendDecimal(StringBuilder builder, float number) {
        return RyuFloat.appendDecimal(builder, number);
    }

    public StringBuilder appendDecimal(StringBuilder builder, float number, int lengthLimit) {
        return RyuFloat.appendDecimal(builder, number, lengthLimit);
    }

    public StringBuilder appendDecimal(StringBuilder builder, float number, int lengthLimit, int precision) {
        return RyuFloat.appendDecimal(builder, number, lengthLimit, precision);
    }

    public float readFloatExact(CharSequence cs) {
        return this.readFloatExact(cs, 0, cs == null ? 0 : cs.length());
    }

    public float readFloatExact(CharSequence cs, int start, int end) {
        if (cs == null || cs.length() == 0) {
            return 0.0f;
        }
        if (cs.charAt(start) == '.') {
            return BitConversion.intBitsToFloat(this.readInt(cs, start + 1, end));
        }
        return BitConversion.reversedIntBitsToFloat(this.readInt(cs, start, end));
    }

    public float readFloatExact(char[] cs, int start, int end) {
        if (cs == null || cs.length == 0) {
            return 0.0f;
        }
        if (cs[start] == '.') {
            return BitConversion.intBitsToFloat(this.readInt(cs, start + 1, end));
        }
        return BitConversion.reversedIntBitsToFloat(this.readInt(cs, start, end));
    }

    public float readFloat(CharSequence str) {
        return this.readFloat(str, 0, Integer.MAX_VALUE);
    }

    public float readFloat(CharSequence str, int begin, int end) {
        char ith;
        int i;
        int start;
        block45: {
            block44: {
                if (str == null || (begin = Math.max(begin, 0)) >= end) break block44;
                end = Math.min(str.length(), end);
                if (str.length() >= end - begin) break block45;
            }
            return 0.0f;
        }
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        while (str.charAt(begin) <= ' ') {
            ++begin;
        }
        if (begin >= end) {
            return 0.0f;
        }
        char first = str.charAt(begin);
        int n = start = first == '-' || first == '+' ? begin + 1 : begin;
        if (end - start >= 1 && str.charAt(start) == 'N') {
            return Float.NaN;
        }
        if (end - start >= 1 && str.charAt(start) == 'I') {
            return first == '-' ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        --end;
        for (i = start; i < end; ++i) {
            ith = str.charAt(i);
            if (ith >= '0' && ith <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Float.parseFloat(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                hasDecPoint = true;
                continue;
            }
            if (ith == 'e' || ith == 'E') {
                if (hasExp) {
                    try {
                        return Float.parseFloat(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                if (!foundDigit) {
                    try {
                        return Float.parseFloat(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (ith == '+' || ith == '-') {
                if (!allowSigns) {
                    try {
                        return Float.parseFloat(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            try {
                return Float.parseFloat(str.toString().substring(begin, i));
            }
            catch (Exception ignored) {
                return 0.0f;
            }
        }
        if (i <= end) {
            ith = str.charAt(i);
            if (ith >= '0' && ith <= '9') {
                try {
                    return Float.parseFloat(str.toString().substring(begin, i + 1));
                }
                catch (Exception ignored) {
                    return 0.0f;
                }
            }
            if (ith == 'e' || ith == 'E') {
                try {
                    return Float.parseFloat(str.toString().substring(begin, i));
                }
                catch (Exception ignored) {
                    return 0.0f;
                }
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Float.parseFloat(str.toString().substring(begin, i));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                try {
                    return Float.parseFloat(str.toString().substring(begin, foundDigit ? i + 1 : i));
                }
                catch (Exception ignored) {
                    return 0.0f;
                }
            }
            try {
                return Float.parseFloat(str.toString().substring(begin, i));
            }
            catch (Exception ignored) {
                return 0.0f;
            }
        }
        if (!allowSigns && foundDigit) {
            try {
                return Float.parseFloat(str.toString().substring(begin, i));
            }
            catch (Exception ignored) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public float readFloat(char[] str, int begin, int end) {
        char ith;
        int i;
        int start;
        if (str == null || (begin = Math.max(begin, 0)) >= end || str.length < (end = Math.min(str.length, end)) - begin) {
            return 0.0f;
        }
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        while (str[begin] <= ' ') {
            ++begin;
        }
        if (begin >= end) {
            return 0.0f;
        }
        char first = str[begin];
        int n = start = first == '-' || first == '+' ? begin + 1 : begin;
        if (end - start >= 1 && str[start] == 'N') {
            return Float.NaN;
        }
        if (end - start >= 1 && str[start] == 'I') {
            return first == '-' ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        --end;
        for (i = start; i < end; ++i) {
            ith = str[i];
            if (ith >= '0' && ith <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Float.parseFloat(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                hasDecPoint = true;
                continue;
            }
            if (ith == 'e' || ith == 'E') {
                if (hasExp) {
                    try {
                        return Float.parseFloat(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                if (!foundDigit) {
                    try {
                        return Float.parseFloat(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (ith == '+' || ith == '-') {
                if (!allowSigns) {
                    try {
                        return Float.parseFloat(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            try {
                return Float.parseFloat(String.valueOf(str, begin, i - begin));
            }
            catch (Exception ignored) {
                return 0.0f;
            }
        }
        if (i <= end) {
            ith = str[i];
            if (ith >= '0' && ith <= '9') {
                try {
                    return Float.parseFloat(String.valueOf(str, begin, i + 1 - begin));
                }
                catch (Exception ignored) {
                    return 0.0f;
                }
            }
            if (ith == 'e' || ith == 'E') {
                try {
                    return Float.parseFloat(String.valueOf(str, begin, i - begin));
                }
                catch (Exception ignored) {
                    return 0.0f;
                }
            }
            if (ith == '.') {
                if (hasDecPoint || hasExp) {
                    try {
                        return Float.parseFloat(String.valueOf(str, begin, i - begin));
                    }
                    catch (Exception ignored) {
                        return 0.0f;
                    }
                }
                try {
                    return Float.parseFloat(String.valueOf(str, begin, (foundDigit ? i + 1 : i) - begin));
                }
                catch (Exception ignored) {
                    return 0.0f;
                }
            }
            try {
                return Float.parseFloat(String.valueOf(str, begin, i - begin));
            }
            catch (Exception ignored) {
                return 0.0f;
            }
        }
        if (!allowSigns && foundDigit) {
            try {
                return Float.parseFloat(String.valueOf(str, begin, i - begin));
            }
            catch (Exception ignored) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public String unsigned(char number) {
        int len = this.length2Byte - 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = number / this.base;
            this.progress[len - i] = this.toEncoded[(number & 0xFFFF) - quotient * this.base];
            number = (char)quotient;
        }
        return String.valueOf(this.progress, 0, this.length2Byte);
    }

    public StringBuilder appendUnsigned(StringBuilder builder, char number) {
        int len = this.length2Byte - 1;
        for (int i = 0; i <= len; ++i) {
            int quotient = number / this.base;
            this.progress[len - i] = this.toEncoded[(number & 0xFFFF) - quotient * this.base];
            number = (char)quotient;
        }
        return builder.append(this.progress, 0, this.length2Byte);
    }

    public String signed(char number) {
        int run = this.length8Byte;
        while (true) {
            this.progress[run] = this.toEncoded[number % this.base];
            if ((number = (char)(number / this.base)) == '\u0000') break;
            --run;
        }
        return String.valueOf(this.progress, run, this.length8Byte + 1 - run);
    }

    public StringBuilder appendSigned(StringBuilder builder, char number) {
        int run = this.length8Byte;
        while (true) {
            this.progress[run] = this.toEncoded[number % this.base];
            if ((number = (char)(number / this.base)) == '\u0000') break;
            --run;
        }
        return builder.append(this.progress, run, this.length8Byte + 1 - run);
    }

    public char readChar(CharSequence cs) {
        return this.readChar(cs, 0, cs == null ? 0 : cs.length());
    }

    public char readChar(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return '\u0000';
        }
        char c = cs.charAt(start);
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length2Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length2Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return '\u0000';
            }
            len = 1;
            lim = this.length2Byte;
        }
        char data = (char)h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs.charAt(i) & 0x7F];
            if (h < 0) {
                return (char)(data * len);
            }
            data = (char)(data * this.base);
            data = (char)(data + h);
        }
        return (char)(data * len);
    }

    public char readChar(char[] cs, int start, int end) {
        int lim;
        int h;
        int len;
        if (start < 0 || end <= 0 || end - start <= 0 || cs == null || (len = cs.length) - start <= 0 || end > len) {
            return '\u0000';
        }
        char c = cs[start];
        if (c == this.negativeSign) {
            len = -1;
            h = 0;
            lim = this.length2Byte + 1;
        } else if (c == this.positiveSign) {
            len = 1;
            h = 0;
            lim = this.length2Byte + 1;
        } else {
            h = this.fromEncoded[c & 0x7F];
            if (h < 0) {
                return '\u0000';
            }
            len = 1;
            lim = this.length2Byte;
        }
        char data = (char)h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            h = this.fromEncoded[cs[i] & 0x7F];
            if (h < 0) {
                return (char)(data * len);
            }
            data = (char)(data * this.base);
            data = (char)(data + h);
        }
        return (char)(data * len);
    }

    public long[] longSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new long[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new long[]{this.readLong(source, startIndex, endIndex)};
        }
        long[] splat = new long[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readLong(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readLong(source, idx + dl, Math.min(source.length(), endIndex)) : this.readLong(source, idx + dl, idx2);
        return splat;
    }

    public long[] longSplit(String source, String delimiter) {
        return this.longSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public int[] intSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new int[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new int[]{this.readInt(source, startIndex, endIndex)};
        }
        int[] splat = new int[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readInt(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readInt(source, idx + dl, Math.min(source.length(), endIndex)) : this.readInt(source, idx + dl, idx2);
        return splat;
    }

    public int[] intSplit(String source, String delimiter) {
        return this.intSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public short[] shortSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new short[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new short[]{this.readShort(source, startIndex, endIndex)};
        }
        short[] splat = new short[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readShort(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readShort(source, idx + dl, Math.min(source.length(), endIndex)) : this.readShort(source, idx + dl, idx2);
        return splat;
    }

    public short[] shortSplit(String source, String delimiter) {
        return this.shortSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public byte[] byteSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new byte[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new byte[]{this.readByte(source, startIndex, endIndex)};
        }
        byte[] splat = new byte[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readByte(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readByte(source, idx + dl, Math.min(source.length(), endIndex)) : this.readByte(source, idx + dl, idx2);
        return splat;
    }

    public byte[] byteSplit(String source, String delimiter) {
        return this.byteSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public char[] charSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new char[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new char[]{this.readChar(source, startIndex, endIndex)};
        }
        char[] splat = new char[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readChar(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readChar(source, idx + dl, Math.min(source.length(), endIndex)) : this.readChar(source, idx + dl, idx2);
        return splat;
    }

    public char[] charSplit(String source, String delimiter) {
        return this.charSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public double[] doubleSplitExact(String source, String delimiter, int startIndex, int endIndex) {
        if (delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new double[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new double[]{this.readDoubleExact(source, startIndex, endIndex)};
        }
        double[] splat = new double[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readDoubleExact(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readDoubleExact(source, idx + dl, Math.min(source.length(), endIndex)) : this.readDoubleExact(source, idx + dl, idx2);
        return splat;
    }

    public double[] doubleSplitExact(String source, String delimiter) {
        return this.doubleSplitExact(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public double[] doubleSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new double[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new double[]{this.readDouble(source, startIndex, endIndex)};
        }
        double[] splat = new double[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readDouble(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readDouble(source, idx + dl, Math.min(source.length(), endIndex)) : this.readDouble(source, idx + dl, idx2);
        return splat;
    }

    public double[] doubleSplit(String source, String delimiter) {
        return this.doubleSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public float[] floatSplitExact(String source, String delimiter, int startIndex, int endIndex) {
        if (delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new float[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new float[]{this.readFloatExact(source, startIndex, endIndex)};
        }
        float[] splat = new float[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readFloatExact(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readFloatExact(source, idx + dl, Math.min(source.length(), endIndex)) : this.readFloatExact(source, idx + dl, idx2);
        return splat;
    }

    public float[] floatSplitExact(String source, String delimiter) {
        return this.floatSplitExact(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public float[] floatSplit(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new float[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new float[]{this.readFloat(source, startIndex, endIndex)};
        }
        float[] splat = new float[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = this.readFloat(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? this.readFloat(source, idx + dl, Math.min(source.length(), endIndex)) : this.readFloat(source, idx + dl, idx2);
        return splat;
    }

    public float[] floatSplit(String source, String delimiter) {
        return this.floatSplit(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public String join(String delimiter, long[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, long[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String join(String delimiter, int[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, int[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String join(String delimiter, short[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, short[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String join(String delimiter, byte[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, byte[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String join(String delimiter, char[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, char[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String joinExact(String delimiter, double[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoinedExact(StringBuilder sb, String delimiter, double[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String joinExact(String delimiter, float[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoinedExact(StringBuilder sb, String delimiter, float[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendSigned(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[i]);
        }
        return sb;
    }

    public String join(String delimiter, double[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendGeneral(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, double[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendGeneral(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[i]);
        }
        return sb;
    }

    public String joinDecimal(String delimiter, int lengthLimit, double[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendDecimal(sb, elements[0], lengthLimit);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendDecimal(sb, elements[i], lengthLimit);
        }
        return sb.toString();
    }

    public StringBuilder appendJoinedDecimal(StringBuilder sb, String delimiter, int lengthLimit, double[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendDecimal(sb, elements[0], lengthLimit);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendDecimal(sb, elements[i], lengthLimit);
        }
        return sb;
    }

    public String join(String delimiter, float[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendGeneral(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[i]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, float[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendGeneral(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[i]);
        }
        return sb;
    }

    public String joinDecimal(String delimiter, int lengthLimit, float[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        this.appendDecimal(sb, elements[0], lengthLimit);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendDecimal(sb, elements[i], lengthLimit);
        }
        return sb.toString();
    }

    public StringBuilder appendJoinedDecimal(StringBuilder sb, String delimiter, int lengthLimit, float[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        this.appendDecimal(sb, elements[0], lengthLimit);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            this.appendDecimal(sb, elements[i], lengthLimit);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, long[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, int[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, short[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, byte[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, char[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoinedExact2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, double[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoinedExact(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoinedDecimal2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, int lengthLimit, double[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoinedDecimal(sb, minorDelimiter, lengthLimit, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, double[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoinedExact2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, float[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoinedExact(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoinedDecimal2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, int lengthLimit, float[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoinedDecimal(sb, minorDelimiter, lengthLimit, elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined2D(StringBuilder sb, String majorDelimiter, String minorDelimiter, float[][] elements) {
        if (majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (elements == null || elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(majorDelimiter);
            this.appendJoined(sb, minorDelimiter, elements[i]);
        }
        return sb;
    }

    public long[][] longSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return long2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (long[][])Arrays.copyOf(long2D, 0);
        }
        long[][] splat = (long[][])Arrays.copyOf(long2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.longSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.longSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.longSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public long[][] longSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.longSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public int[][] intSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return int2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (int[][])Arrays.copyOf(int2D, 0);
        }
        int[][] splat = (int[][])Arrays.copyOf(int2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.intSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.intSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.intSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public int[][] intSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.intSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public short[][] shortSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return short2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (short[][])Arrays.copyOf(short2D, 0);
        }
        short[][] splat = (short[][])Arrays.copyOf(short2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.shortSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.shortSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.shortSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public short[][] shortSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.shortSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public byte[][] byteSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return byte2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (byte[][])Arrays.copyOf(byte2D, 0);
        }
        byte[][] splat = (byte[][])Arrays.copyOf(byte2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.byteSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.byteSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.byteSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public byte[][] byteSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.byteSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public char[][] charSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return char2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (char[][])Arrays.copyOf(char2D, 0);
        }
        char[][] splat = (char[][])Arrays.copyOf(char2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.charSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.charSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.charSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public char[][] charSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.charSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public double[][] doubleSplitExact2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return double2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (double[][])Arrays.copyOf(double2D, 0);
        }
        double[][] splat = (double[][])Arrays.copyOf(double2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.doubleSplitExact(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.doubleSplitExact(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.doubleSplitExact(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public double[][] doubleSplitExact2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.doubleSplitExact2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public double[][] doubleSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return double2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (double[][])Arrays.copyOf(double2D, 0);
        }
        double[][] splat = (double[][])Arrays.copyOf(double2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.doubleSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.doubleSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.doubleSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public double[][] doubleSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.doubleSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public float[][] floatSplitExact2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return float2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (float[][])Arrays.copyOf(float2D, 0);
        }
        float[][] splat = (float[][])Arrays.copyOf(float2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.floatSplitExact(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.floatSplitExact(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.floatSplitExact(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public float[][] floatSplitExact2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.floatSplitExact2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public float[][] floatSplit2D(String source, String majorDelimiter, String minorDelimiter, int startIndex, int endIndex) {
        if (source == null || majorDelimiter == null || minorDelimiter == null || majorDelimiter.equals(minorDelimiter) || majorDelimiter.isEmpty() || minorDelimiter.isEmpty()) {
            throw new IllegalArgumentException("The delimiters must be different, non-null, and non-empty.");
        }
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return float2D;
        }
        int amount = Base.count(source, majorDelimiter, startIndex, endIndex);
        if (amount <= 0) {
            return (float[][])Arrays.copyOf(float2D, 0);
        }
        float[][] splat = (float[][])Arrays.copyOf(float2D, amount);
        int dl = majorDelimiter.length();
        int idx = startIndex;
        for (int i = 0; i < amount - 1; ++i) {
            int n = idx + dl;
            idx = source.indexOf(majorDelimiter, idx + dl);
            splat[i] = this.floatSplit(source, minorDelimiter, n, idx);
        }
        int idx2 = source.indexOf(majorDelimiter, idx + dl);
        splat[amount - 1] = idx2 < 0 || idx2 >= endIndex ? this.floatSplit(source, minorDelimiter, idx + dl, Math.min(source.length(), endIndex)) : this.floatSplit(source, minorDelimiter, idx + dl, idx2);
        return splat;
    }

    public float[][] floatSplit2D(String source, String majorDelimiter, String minorDelimiter) {
        return this.floatSplit2D(source, majorDelimiter, minorDelimiter, 0, source == null ? 0 : source.length());
    }

    public String join(String delimiter, long[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, long[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public String join(String delimiter, int[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, int[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public String join(String delimiter, short[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, short[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public String join(String delimiter, char[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, char[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public String join(String delimiter, byte[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, byte[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public String join(String delimiter, float[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendGeneral(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, float[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendGeneral(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[start]);
        }
        return sb;
    }

    public String join(String delimiter, double[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendGeneral(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoined(StringBuilder sb, String delimiter, double[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendGeneral(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendGeneral(sb, elements[start]);
        }
        return sb;
    }

    public String joinExact(String delimiter, float[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoinedExact(StringBuilder sb, String delimiter, float[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public String joinExact(String delimiter, double[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length << 3);
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb.toString();
    }

    public StringBuilder appendJoinedExact(StringBuilder sb, String delimiter, double[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        this.appendSigned(sb, elements[start]);
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter);
            this.appendSigned(sb, elements[start]);
        }
        return sb;
    }

    public static String readable(int number) {
        return BASE10.signed(number);
    }

    public static StringBuilder appendReadable(StringBuilder builder, int number) {
        return BASE10.appendSigned(builder, number);
    }

    public static String joinReadable(String delimiter, int[] elements) {
        return BASE10.join(delimiter, elements);
    }

    public static StringBuilder appendJoinedReadable(StringBuilder sb, String delimiter, int[] elements) {
        return BASE10.appendJoined(sb, delimiter, elements);
    }

    public static int[] intSplitReadable(String source, String delimiter, int startIndex, int endIndex) {
        return BASE10.intSplit(source, delimiter, startIndex, endIndex);
    }

    public static int[] intSplitReadable(String source, String delimiter) {
        return BASE10.intSplit(source, delimiter);
    }

    public static String readable(long number) {
        int length8Byte = Base.BASE10.length8Byte;
        int base = 10;
        char[] progress = Base.BASE2.progress;
        char[] toEncoded = Base.BASE10.toEncoded;
        int negativeSign = 45;
        int run = length8Byte;
        long sign = number >> -1;
        number = -(number + sign ^ sign);
        while (true) {
            progress[run] = toEncoded[(int)(-(number % 10L))];
            if ((number /= 10L) == 0L) break;
            --run;
        }
        if (sign != 0L) {
            progress[--run] = 45;
        }
        progress[length8Byte + 1] = 76;
        return String.valueOf(progress, run, length8Byte + 2 - run);
    }

    public static StringBuilder appendReadable(StringBuilder builder, long number) {
        int length8Byte = Base.BASE10.length8Byte;
        int base = 10;
        char[] progress = Base.BASE2.progress;
        char[] toEncoded = Base.BASE10.toEncoded;
        int negativeSign = 45;
        int run = length8Byte;
        long sign = number >> -1;
        number = -(number + sign ^ sign);
        while (true) {
            progress[run] = toEncoded[(int)(-(number % 10L))];
            if ((number /= 10L) == 0L) break;
            --run;
        }
        if (sign != 0L) {
            progress[--run] = 45;
        }
        progress[length8Byte + 1] = 76;
        return builder.append(progress, run, length8Byte + 2 - run);
    }

    public static String joinReadable(String delimiter, long[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        Base.appendReadable(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            Base.appendReadable(sb, elements[i]);
        }
        return sb.toString();
    }

    public static StringBuilder appendJoinedReadable(StringBuilder sb, String delimiter, long[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        Base.appendReadable(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            Base.appendReadable(sb, elements[i]);
        }
        return sb;
    }

    public static long[] longSplitReadable(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new long[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new long[]{BASE10.readLong(source, startIndex, endIndex)};
        }
        long[] splat = new long[amount + 1];
        int dl = delimiter.length() + 1;
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(76, idx + dl);
            splat[i] = BASE10.readLong(source, n, idx);
        }
        int idx2 = source.indexOf(76, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? BASE10.readLong(source, idx + dl, Math.min(source.length(), endIndex)) : BASE10.readLong(source, idx + dl, idx2);
        return splat;
    }

    public static long[] longSplitReadable(String source, String delimiter) {
        return Base.longSplitReadable(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public static String readable(double number) {
        return BASE10.general(number);
    }

    public static StringBuilder appendReadable(StringBuilder builder, double number) {
        return BASE10.appendGeneral(builder, number);
    }

    public static String joinReadable(String delimiter, double[] elements) {
        return BASE10.join(delimiter, elements);
    }

    public static StringBuilder appendJoinedReadable(StringBuilder sb, String delimiter, double[] elements) {
        return BASE10.appendJoined(sb, delimiter, elements);
    }

    public static double[] doubleSplitReadable(String source, String delimiter, int startIndex, int endIndex) {
        return BASE10.doubleSplit(source, delimiter, startIndex, endIndex);
    }

    public static double[] doubleSplitReadable(String source, String delimiter) {
        return BASE10.doubleSplit(source, delimiter);
    }

    public static String readable(float number) {
        int i = RyuFloat.general(number, Base.BASE2.progress);
        Base.BASE2.progress[i] = 102;
        return String.valueOf(Base.BASE2.progress, 0, i + 1);
    }

    public static StringBuilder appendReadable(StringBuilder builder, float number) {
        return BASE10.appendGeneral(builder, number).append('f');
    }

    public static String joinReadable(String delimiter, float[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        Base.appendReadable(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            Base.appendReadable(sb, elements[i]);
        }
        return sb.toString();
    }

    public static StringBuilder appendJoinedReadable(StringBuilder sb, String delimiter, float[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        Base.appendReadable(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            Base.appendReadable(sb, elements[i]);
        }
        return sb;
    }

    public static float[] floatSplitReadable(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new float[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new float[]{BASE10.readFloat(source, startIndex, endIndex)};
        }
        float[] splat = new float[amount + 1];
        int dl = delimiter.length() + 1;
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(102, idx + dl);
            splat[i] = BASE10.readFloat(source, n, idx);
        }
        int idx2 = source.indexOf(102, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? BASE10.readFloat(source, idx + dl, Math.min(source.length(), endIndex)) : BASE10.readFloat(source, idx + dl, idx2);
        return splat;
    }

    public static float[] floatSplitReadable(String source, String delimiter) {
        return Base.floatSplitReadable(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public static String readable(char number) {
        switch (number) {
            case '\r': {
                return "'\\r'";
            }
            case '\n': {
                return "'\\n'";
            }
            case '\'': {
                return "'\\''";
            }
            case '\\': {
                return "'\\\\'";
            }
        }
        char[] progress = Base.BASE2.progress;
        char[] toEncoded = Base.BASE16.toEncoded;
        int len = 3;
        for (int i = 0; i <= 3; ++i) {
            int quotient = number >>> 4;
            progress[3 - i + 3] = toEncoded[(number & 0xFFFF) - (quotient << 4)];
            number = (char)quotient;
        }
        progress[1] = 92;
        progress[2] = 117;
        progress[7] = 39;
        progress[0] = 39;
        return String.valueOf(progress, 0, 8);
    }

    public static StringBuilder appendReadable(StringBuilder builder, char number) {
        switch (number) {
            case '\r': {
                return builder.append("'\\r'");
            }
            case '\n': {
                return builder.append("'\\n'");
            }
            case '\'': {
                return builder.append("'\\''");
            }
            case '\\': {
                return builder.append("'\\\\'");
            }
        }
        char[] progress = Base.BASE2.progress;
        char[] toEncoded = Base.BASE16.toEncoded;
        int len = 3;
        for (int i = 0; i <= 3; ++i) {
            int quotient = number >>> 4;
            progress[3 - i + 3] = toEncoded[(number & 0xFFFF) - (quotient << 4)];
            number = (char)quotient;
        }
        progress[1] = 92;
        progress[2] = 117;
        progress[7] = 39;
        progress[0] = 39;
        return builder.append(progress, 0, 8);
    }

    public static String joinReadable(String delimiter, char[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length * 10);
        Base.appendReadable(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            Base.appendReadable(sb, elements[i]);
        }
        return sb.toString();
    }

    public static StringBuilder appendJoinedReadable(StringBuilder sb, String delimiter, char[] elements) {
        if (elements == null || elements.length == 0) {
            return sb;
        }
        Base.appendReadable(sb, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            Base.appendReadable(sb, elements[i]);
        }
        return sb;
    }

    public static char readCharReadable(CharSequence source) {
        return Base.readCharReadable(source, 0, source == null ? 0 : source.length());
    }

    public static char readCharReadable(CharSequence source, int start, int end) {
        int len;
        if (source == null || start < 0 || end <= 2 || end - start <= 2 || (len = source.length()) - start <= 2 || end > len) {
            return '\u0000';
        }
        switch (source.charAt(start + 2)) {
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
        }
        return BASE16.readChar(source, start + 3, end);
    }

    public static char readCharReadable(char[] source, int start, int end) {
        int len;
        if (source == null || start < 0 || end <= 2 || end - start <= 2 || (len = source.length) - start <= 2 || end > len) {
            return '\u0000';
        }
        switch (source[start + 2]) {
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
        }
        return BASE16.readChar(source, start + 3, end);
    }

    public static char[] charSplitReadable(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || delimiter.isEmpty() || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new char[0];
        }
        int amount = Base.count(source, delimiter, startIndex, endIndex);
        if (amount <= 0) {
            return new char[]{Base.readCharReadable(source, startIndex, endIndex)};
        }
        char[] splat = new char[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = Base.readCharReadable(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 || idx2 >= endIndex ? Base.readCharReadable(source, idx + dl, Math.min(source.length(), endIndex)) : Base.readCharReadable(source, idx + dl, idx2);
        return splat;
    }

    public static char[] charSplitReadable(String source, String delimiter) {
        return Base.charSplitReadable(source, delimiter, 0, source == null ? 0 : source.length());
    }

    public static int count(String source, String search, int startIndex, int endIndex) {
        return TextTools.count(source, search, startIndex, endIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Base base = (Base)o;
        if (this.paddingChar != base.paddingChar) {
            return false;
        }
        if (this.positiveSign != base.positiveSign) {
            return false;
        }
        if (this.negativeSign != base.negativeSign) {
            return false;
        }
        if (this.caseInsensitive != base.caseInsensitive) {
            return false;
        }
        return Arrays.equals(this.toEncoded, base.toEncoded);
    }

    public int hashCode() {
        return Hasher.barium.hash(this.toEncoded) + (this.caseInsensitive ? 1225043 : -8) + this.paddingChar * 107 * 107 + this.positiveSign * 107 + this.negativeSign;
    }

    public String toString() {
        return "Base{toEncoded=" + String.valueOf(this.toEncoded) + ", paddingChar=" + this.paddingChar + ", positiveSign=" + this.positiveSign + ", negativeSign=" + this.negativeSign + ", caseInsensitive=" + this.caseInsensitive + ", base=" + this.base + '}';
    }
}

