/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

public final class BitConversion {
    private BitConversion() {
    }

    public static long doubleToLongBits(double value) {
        return Double.doubleToLongBits(value);
    }

    public static long doubleToRawLongBits(double value) {
        return Double.doubleToRawLongBits(value);
    }

    public static long doubleToReversedLongBits(double value) {
        return Long.reverseBytes(Double.doubleToRawLongBits(value));
    }

    public static double reversedLongBitsToDouble(long bits) {
        return Double.longBitsToDouble(Long.reverseBytes(bits));
    }

    public static double longBitsToDouble(long bits) {
        return Double.longBitsToDouble(bits);
    }

    public static int doubleToLowIntBits(double value) {
        return (int)Double.doubleToRawLongBits(value);
    }

    public static int doubleToHighIntBits(double value) {
        return (int)(Double.doubleToRawLongBits(value) >>> 32);
    }

    public static int doubleToMixedIntBits(double value) {
        long l = Double.doubleToRawLongBits(value);
        return (int)(l ^ l >>> 32);
    }

    public static int floatToIntBits(float value) {
        return Float.floatToIntBits(value);
    }

    public static int floatToRawIntBits(float value) {
        return Float.floatToRawIntBits(value);
    }

    public static int floatToReversedIntBits(float value) {
        return Integer.reverseBytes(Float.floatToRawIntBits(value));
    }

    public static float reversedIntBitsToFloat(int bits) {
        return Float.intBitsToFloat(Integer.reverseBytes(bits));
    }

    public static float intBitsToFloat(int bits) {
        return Float.intBitsToFloat(bits);
    }

    public static int lowestOneBit(int num) {
        return num & -num;
    }

    public static long lowestOneBit(long num) {
        return num & -num;
    }

    public static int imul(int left, int right) {
        return left * right;
    }

    public static int getExponent(float num) {
        return Math.getExponent(num);
    }

    public static int getExponent(double num) {
        return Math.getExponent(num);
    }

    public static int countLeadingZeros(int n) {
        return Integer.numberOfLeadingZeros(n);
    }

    public static int countTrailingZeros(int n) {
        return Integer.numberOfTrailingZeros(n);
    }

    public static int countLeadingZeros(long n) {
        return Long.numberOfLeadingZeros(n);
    }

    public static int countTrailingZeros(long n) {
        return Long.numberOfTrailingZeros(n);
    }
}

