/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.BitConversion;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Hasher {
    public final long seed;
    public static final long b0 = -6884282663029611473L;
    public static final long b1 = -1800455987208640293L;
    public static final long b2 = -8161530843051276573L;
    public static final long b3 = 6384245875588680899L;
    public static final long b4 = 2129725606500045391L;
    public static final long b5 = -1493879189771267739L;
    public static final long C = -4710160504952957587L;
    public static final long Q = -3334586728330402083L;
    public static final long R = -7379824689681476987L;
    public static final long S = -8093542602040470137L;
    public static final long T = -218226644805978053L;
    public static final Hasher alpha = new Hasher("alpha");
    public static final Hasher beta = new Hasher("beta");
    public static final Hasher gamma = new Hasher("gamma");
    public static final Hasher delta = new Hasher("delta");
    public static final Hasher epsilon = new Hasher("epsilon");
    public static final Hasher zeta = new Hasher("zeta");
    public static final Hasher eta = new Hasher("eta");
    public static final Hasher theta = new Hasher("theta");
    public static final Hasher iota = new Hasher("iota");
    public static final Hasher kappa = new Hasher("kappa");
    public static final Hasher lambda = new Hasher("lambda");
    public static final Hasher mu = new Hasher("mu");
    public static final Hasher nu = new Hasher("nu");
    public static final Hasher xi = new Hasher("xi");
    public static final Hasher omicron = new Hasher("omicron");
    public static final Hasher pi = new Hasher("pi");
    public static final Hasher rho = new Hasher("rho");
    public static final Hasher sigma = new Hasher("sigma");
    public static final Hasher tau = new Hasher("tau");
    public static final Hasher upsilon = new Hasher("upsilon");
    public static final Hasher phi = new Hasher("phi");
    public static final Hasher chi = new Hasher("chi");
    public static final Hasher psi = new Hasher("psi");
    public static final Hasher omega = new Hasher("omega");
    public static final Hasher alpha_ = new Hasher("ALPHA");
    public static final Hasher beta_ = new Hasher("BETA");
    public static final Hasher gamma_ = new Hasher("GAMMA");
    public static final Hasher delta_ = new Hasher("DELTA");
    public static final Hasher epsilon_ = new Hasher("EPSILON");
    public static final Hasher zeta_ = new Hasher("ZETA");
    public static final Hasher eta_ = new Hasher("ETA");
    public static final Hasher theta_ = new Hasher("THETA");
    public static final Hasher iota_ = new Hasher("IOTA");
    public static final Hasher kappa_ = new Hasher("KAPPA");
    public static final Hasher lambda_ = new Hasher("LAMBDA");
    public static final Hasher mu_ = new Hasher("MU");
    public static final Hasher nu_ = new Hasher("NU");
    public static final Hasher xi_ = new Hasher("XI");
    public static final Hasher omicron_ = new Hasher("OMICRON");
    public static final Hasher pi_ = new Hasher("PI");
    public static final Hasher rho_ = new Hasher("RHO");
    public static final Hasher sigma_ = new Hasher("SIGMA");
    public static final Hasher tau_ = new Hasher("TAU");
    public static final Hasher upsilon_ = new Hasher("UPSILON");
    public static final Hasher phi_ = new Hasher("PHI");
    public static final Hasher chi_ = new Hasher("CHI");
    public static final Hasher psi_ = new Hasher("PSI");
    public static final Hasher omega_ = new Hasher("OMEGA");
    public static final Hasher baal = new Hasher("baal");
    public static final Hasher agares = new Hasher("agares");
    public static final Hasher vassago = new Hasher("vassago");
    public static final Hasher samigina = new Hasher("samigina");
    public static final Hasher marbas = new Hasher("marbas");
    public static final Hasher valefor = new Hasher("valefor");
    public static final Hasher amon = new Hasher("amon");
    public static final Hasher barbatos = new Hasher("barbatos");
    public static final Hasher paimon = new Hasher("paimon");
    public static final Hasher buer = new Hasher("buer");
    public static final Hasher gusion = new Hasher("gusion");
    public static final Hasher sitri = new Hasher("sitri");
    public static final Hasher beleth = new Hasher("beleth");
    public static final Hasher leraje = new Hasher("leraje");
    public static final Hasher eligos = new Hasher("eligos");
    public static final Hasher zepar = new Hasher("zepar");
    public static final Hasher botis = new Hasher("botis");
    public static final Hasher bathin = new Hasher("bathin");
    public static final Hasher sallos = new Hasher("sallos");
    public static final Hasher purson = new Hasher("purson");
    public static final Hasher marax = new Hasher("marax");
    public static final Hasher ipos = new Hasher("ipos");
    public static final Hasher aim = new Hasher("aim");
    public static final Hasher naberius = new Hasher("naberius");
    public static final Hasher glasya_labolas = new Hasher("glasya_labolas");
    public static final Hasher bune = new Hasher("bune");
    public static final Hasher ronove = new Hasher("ronove");
    public static final Hasher berith = new Hasher("berith");
    public static final Hasher astaroth = new Hasher("astaroth");
    public static final Hasher forneus = new Hasher("forneus");
    public static final Hasher foras = new Hasher("foras");
    public static final Hasher asmoday = new Hasher("asmoday");
    public static final Hasher gaap = new Hasher("gaap");
    public static final Hasher furfur = new Hasher("furfur");
    public static final Hasher marchosias = new Hasher("marchosias");
    public static final Hasher stolas = new Hasher("stolas");
    public static final Hasher phenex = new Hasher("phenex");
    public static final Hasher halphas = new Hasher("halphas");
    public static final Hasher malphas = new Hasher("malphas");
    public static final Hasher raum = new Hasher("raum");
    public static final Hasher focalor = new Hasher("focalor");
    public static final Hasher vepar = new Hasher("vepar");
    public static final Hasher sabnock = new Hasher("sabnock");
    public static final Hasher shax = new Hasher("shax");
    public static final Hasher vine = new Hasher("vine");
    public static final Hasher bifrons = new Hasher("bifrons");
    public static final Hasher vual = new Hasher("vual");
    public static final Hasher haagenti = new Hasher("haagenti");
    public static final Hasher crocell = new Hasher("crocell");
    public static final Hasher furcas = new Hasher("furcas");
    public static final Hasher balam = new Hasher("balam");
    public static final Hasher alloces = new Hasher("alloces");
    public static final Hasher caim = new Hasher("caim");
    public static final Hasher murmur = new Hasher("murmur");
    public static final Hasher orobas = new Hasher("orobas");
    public static final Hasher gremory = new Hasher("gremory");
    public static final Hasher ose = new Hasher("ose");
    public static final Hasher amy = new Hasher("amy");
    public static final Hasher orias = new Hasher("orias");
    public static final Hasher vapula = new Hasher("vapula");
    public static final Hasher zagan = new Hasher("zagan");
    public static final Hasher valac = new Hasher("valac");
    public static final Hasher andras = new Hasher("andras");
    public static final Hasher flauros = new Hasher("flauros");
    public static final Hasher andrealphus = new Hasher("andrealphus");
    public static final Hasher kimaris = new Hasher("kimaris");
    public static final Hasher amdusias = new Hasher("amdusias");
    public static final Hasher belial = new Hasher("belial");
    public static final Hasher decarabia = new Hasher("decarabia");
    public static final Hasher seere = new Hasher("seere");
    public static final Hasher dantalion = new Hasher("dantalion");
    public static final Hasher andromalius = new Hasher("andromalius");
    public static final Hasher baal_ = new Hasher("BAAL");
    public static final Hasher agares_ = new Hasher("AGARES");
    public static final Hasher vassago_ = new Hasher("VASSAGO");
    public static final Hasher samigina_ = new Hasher("SAMIGINA");
    public static final Hasher marbas_ = new Hasher("MARBAS");
    public static final Hasher valefor_ = new Hasher("VALEFOR");
    public static final Hasher amon_ = new Hasher("AMON");
    public static final Hasher barbatos_ = new Hasher("BARBATOS");
    public static final Hasher paimon_ = new Hasher("PAIMON");
    public static final Hasher buer_ = new Hasher("BUER");
    public static final Hasher gusion_ = new Hasher("GUSION");
    public static final Hasher sitri_ = new Hasher("SITRI");
    public static final Hasher beleth_ = new Hasher("BELETH");
    public static final Hasher leraje_ = new Hasher("LERAJE");
    public static final Hasher eligos_ = new Hasher("ELIGOS");
    public static final Hasher zepar_ = new Hasher("ZEPAR");
    public static final Hasher botis_ = new Hasher("BOTIS");
    public static final Hasher bathin_ = new Hasher("BATHIN");
    public static final Hasher sallos_ = new Hasher("SALLOS");
    public static final Hasher purson_ = new Hasher("PURSON");
    public static final Hasher marax_ = new Hasher("MARAX");
    public static final Hasher ipos_ = new Hasher("IPOS");
    public static final Hasher aim_ = new Hasher("AIM");
    public static final Hasher naberius_ = new Hasher("NABERIUS");
    public static final Hasher glasya_labolas_ = new Hasher("GLASYA_LABOLAS");
    public static final Hasher bune_ = new Hasher("BUNE");
    public static final Hasher ronove_ = new Hasher("RONOVE");
    public static final Hasher berith_ = new Hasher("BERITH");
    public static final Hasher astaroth_ = new Hasher("ASTAROTH");
    public static final Hasher forneus_ = new Hasher("FORNEUS");
    public static final Hasher foras_ = new Hasher("FORAS");
    public static final Hasher asmoday_ = new Hasher("ASMODAY");
    public static final Hasher gaap_ = new Hasher("GAAP");
    public static final Hasher furfur_ = new Hasher("FURFUR");
    public static final Hasher marchosias_ = new Hasher("MARCHOSIAS");
    public static final Hasher stolas_ = new Hasher("STOLAS");
    public static final Hasher phenex_ = new Hasher("PHENEX");
    public static final Hasher halphas_ = new Hasher("HALPHAS");
    public static final Hasher malphas_ = new Hasher("MALPHAS");
    public static final Hasher raum_ = new Hasher("RAUM");
    public static final Hasher focalor_ = new Hasher("FOCALOR");
    public static final Hasher vepar_ = new Hasher("VEPAR");
    public static final Hasher sabnock_ = new Hasher("SABNOCK");
    public static final Hasher shax_ = new Hasher("SHAX");
    public static final Hasher vine_ = new Hasher("VINE");
    public static final Hasher bifrons_ = new Hasher("BIFRONS");
    public static final Hasher vual_ = new Hasher("VUAL");
    public static final Hasher haagenti_ = new Hasher("HAAGENTI");
    public static final Hasher crocell_ = new Hasher("CROCELL");
    public static final Hasher furcas_ = new Hasher("FURCAS");
    public static final Hasher balam_ = new Hasher("BALAM");
    public static final Hasher alloces_ = new Hasher("ALLOCES");
    public static final Hasher caim_ = new Hasher("CAIM");
    public static final Hasher murmur_ = new Hasher("MURMUR");
    public static final Hasher orobas_ = new Hasher("OROBAS");
    public static final Hasher gremory_ = new Hasher("GREMORY");
    public static final Hasher ose_ = new Hasher("OSE");
    public static final Hasher amy_ = new Hasher("AMY");
    public static final Hasher orias_ = new Hasher("ORIAS");
    public static final Hasher vapula_ = new Hasher("VAPULA");
    public static final Hasher zagan_ = new Hasher("ZAGAN");
    public static final Hasher valac_ = new Hasher("VALAC");
    public static final Hasher andras_ = new Hasher("ANDRAS");
    public static final Hasher flauros_ = new Hasher("FLAUROS");
    public static final Hasher andrealphus_ = new Hasher("ANDREALPHUS");
    public static final Hasher kimaris_ = new Hasher("KIMARIS");
    public static final Hasher amdusias_ = new Hasher("AMDUSIAS");
    public static final Hasher belial_ = new Hasher("BELIAL");
    public static final Hasher decarabia_ = new Hasher("DECARABIA");
    public static final Hasher seere_ = new Hasher("SEERE");
    public static final Hasher dantalion_ = new Hasher("DANTALION");
    public static final Hasher andromalius_ = new Hasher("ANDROMALIUS");
    public static final Hasher hydrogen = new Hasher("hydrogen");
    public static final Hasher helium = new Hasher("helium");
    public static final Hasher lithium = new Hasher("lithium");
    public static final Hasher beryllium = new Hasher("beryllium");
    public static final Hasher boron = new Hasher("boron");
    public static final Hasher carbon = new Hasher("carbon");
    public static final Hasher nitrogen = new Hasher("nitrogen");
    public static final Hasher oxygen = new Hasher("oxygen");
    public static final Hasher fluorine = new Hasher("fluorine");
    public static final Hasher neon = new Hasher("neon");
    public static final Hasher sodium = new Hasher("sodium");
    public static final Hasher magnesium = new Hasher("magnesium");
    public static final Hasher aluminium = new Hasher("aluminium");
    public static final Hasher silicon = new Hasher("silicon");
    public static final Hasher phosphorus = new Hasher("phosphorus");
    public static final Hasher sulfur = new Hasher("sulfur");
    public static final Hasher chlorine = new Hasher("chlorine");
    public static final Hasher argon = new Hasher("argon");
    public static final Hasher potassium = new Hasher("potassium");
    public static final Hasher calcium = new Hasher("calcium");
    public static final Hasher scandium = new Hasher("scandium");
    public static final Hasher titanium = new Hasher("titanium");
    public static final Hasher vanadium = new Hasher("vanadium");
    public static final Hasher chromium = new Hasher("chromium");
    public static final Hasher manganese = new Hasher("manganese");
    public static final Hasher iron = new Hasher("iron");
    public static final Hasher cobalt = new Hasher("cobalt");
    public static final Hasher nickel = new Hasher("nickel");
    public static final Hasher copper = new Hasher("copper");
    public static final Hasher zinc = new Hasher("zinc");
    public static final Hasher gallium = new Hasher("gallium");
    public static final Hasher germanium = new Hasher("germanium");
    public static final Hasher arsenic = new Hasher("arsenic");
    public static final Hasher selenium = new Hasher("selenium");
    public static final Hasher bromine = new Hasher("bromine");
    public static final Hasher krypton = new Hasher("krypton");
    public static final Hasher rubidium = new Hasher("rubidium");
    public static final Hasher strontium = new Hasher("strontium");
    public static final Hasher yttrium = new Hasher("yttrium");
    public static final Hasher zirconium = new Hasher("zirconium");
    public static final Hasher niobium = new Hasher("niobium");
    public static final Hasher molybdenum = new Hasher("molybdenum");
    public static final Hasher technetium = new Hasher("technetium");
    public static final Hasher ruthenium = new Hasher("ruthenium");
    public static final Hasher rhodium = new Hasher("rhodium");
    public static final Hasher palladium = new Hasher("palladium");
    public static final Hasher silver = new Hasher("silver");
    public static final Hasher cadmium = new Hasher("cadmium");
    public static final Hasher indium = new Hasher("indium");
    public static final Hasher tin = new Hasher("tin");
    public static final Hasher antimony = new Hasher("antimony");
    public static final Hasher tellurium = new Hasher("tellurium");
    public static final Hasher iodine = new Hasher("iodine");
    public static final Hasher xenon = new Hasher("xenon");
    public static final Hasher caesium = new Hasher("caesium");
    public static final Hasher barium = new Hasher("barium");
    public static final Hasher lanthanum = new Hasher("lanthanum");
    public static final Hasher cerium = new Hasher("cerium");
    public static final Hasher praseodymium = new Hasher("praseodymium");
    public static final Hasher neodymium = new Hasher("neodymium");
    public static final Hasher promethium = new Hasher("promethium");
    public static final Hasher samarium = new Hasher("samarium");
    public static final Hasher europium = new Hasher("europium");
    public static final Hasher gadolinium = new Hasher("gadolinium");
    public static final Hasher terbium = new Hasher("terbium");
    public static final Hasher dysprosium = new Hasher("dysprosium");
    public static final Hasher holmium = new Hasher("holmium");
    public static final Hasher erbium = new Hasher("erbium");
    public static final Hasher thulium = new Hasher("thulium");
    public static final Hasher ytterbium = new Hasher("ytterbium");
    public static final Hasher lutetium = new Hasher("lutetium");
    public static final Hasher hafnium = new Hasher("hafnium");
    public static final Hasher tantalum = new Hasher("tantalum");
    public static final Hasher tungsten = new Hasher("tungsten");
    public static final Hasher rhenium = new Hasher("rhenium");
    public static final Hasher osmium = new Hasher("osmium");
    public static final Hasher iridium = new Hasher("iridium");
    public static final Hasher platinum = new Hasher("platinum");
    public static final Hasher gold = new Hasher("gold");
    public static final Hasher mercury = new Hasher("mercury");
    public static final Hasher thallium = new Hasher("thallium");
    public static final Hasher lead = new Hasher("lead");
    public static final Hasher bismuth = new Hasher("bismuth");
    public static final Hasher polonium = new Hasher("polonium");
    public static final Hasher astatine = new Hasher("astatine");
    public static final Hasher radon = new Hasher("radon");
    public static final Hasher francium = new Hasher("francium");
    public static final Hasher radium = new Hasher("radium");
    public static final Hasher actinium = new Hasher("actinium");
    public static final Hasher thorium = new Hasher("thorium");
    public static final Hasher protactinium = new Hasher("protactinium");
    public static final Hasher uranium = new Hasher("uranium");
    public static final Hasher neptunium = new Hasher("neptunium");
    public static final Hasher plutonium = new Hasher("plutonium");
    public static final Hasher americium = new Hasher("americium");
    public static final Hasher curium = new Hasher("curium");
    public static final Hasher berkelium = new Hasher("berkelium");
    public static final Hasher californium = new Hasher("californium");
    public static final Hasher einsteinium = new Hasher("einsteinium");
    public static final Hasher fermium = new Hasher("fermium");
    public static final Hasher mendelevium = new Hasher("mendelevium");
    public static final Hasher nobelium = new Hasher("nobelium");
    public static final Hasher lawrencium = new Hasher("lawrencium");
    public static final Hasher rutherfordium = new Hasher("rutherfordium");
    public static final Hasher dubnium = new Hasher("dubnium");
    public static final Hasher seaborgium = new Hasher("seaborgium");
    public static final Hasher bohrium = new Hasher("bohrium");
    public static final Hasher hassium = new Hasher("hassium");
    public static final Hasher meitnerium = new Hasher("meitnerium");
    public static final Hasher darmstadtium = new Hasher("darmstadtium");
    public static final Hasher roentgenium = new Hasher("roentgenium");
    public static final Hasher copernicium = new Hasher("copernicium");
    public static final Hasher nihonium = new Hasher("nihonium");
    public static final Hasher flerovium = new Hasher("flerovium");
    public static final Hasher moscovium = new Hasher("moscovium");
    public static final Hasher livermorium = new Hasher("livermorium");
    public static final Hasher tennessine = new Hasher("tennessine");
    public static final Hasher oganesson = new Hasher("oganesson");
    public static final Hasher hydrogen_ = new Hasher("HYDROGEN");
    public static final Hasher helium_ = new Hasher("HELIUM");
    public static final Hasher lithium_ = new Hasher("LITHIUM");
    public static final Hasher beryllium_ = new Hasher("BERYLLIUM");
    public static final Hasher boron_ = new Hasher("BORON");
    public static final Hasher carbon_ = new Hasher("CARBON");
    public static final Hasher nitrogen_ = new Hasher("NITROGEN");
    public static final Hasher oxygen_ = new Hasher("OXYGEN");
    public static final Hasher fluorine_ = new Hasher("FLUORINE");
    public static final Hasher neon_ = new Hasher("NEON");
    public static final Hasher sodium_ = new Hasher("SODIUM");
    public static final Hasher magnesium_ = new Hasher("MAGNESIUM");
    public static final Hasher aluminium_ = new Hasher("ALUMINIUM");
    public static final Hasher silicon_ = new Hasher("SILICON");
    public static final Hasher phosphorus_ = new Hasher("PHOSPHORUS");
    public static final Hasher sulfur_ = new Hasher("SULFUR");
    public static final Hasher chlorine_ = new Hasher("CHLORINE");
    public static final Hasher argon_ = new Hasher("ARGON");
    public static final Hasher potassium_ = new Hasher("POTASSIUM");
    public static final Hasher calcium_ = new Hasher("CALCIUM");
    public static final Hasher scandium_ = new Hasher("SCANDIUM");
    public static final Hasher titanium_ = new Hasher("TITANIUM");
    public static final Hasher vanadium_ = new Hasher("VANADIUM");
    public static final Hasher chromium_ = new Hasher("CHROMIUM");
    public static final Hasher manganese_ = new Hasher("MANGANESE");
    public static final Hasher iron_ = new Hasher("IRON");
    public static final Hasher cobalt_ = new Hasher("COBALT");
    public static final Hasher nickel_ = new Hasher("NICKEL");
    public static final Hasher copper_ = new Hasher("COPPER");
    public static final Hasher zinc_ = new Hasher("ZINC");
    public static final Hasher gallium_ = new Hasher("GALLIUM");
    public static final Hasher germanium_ = new Hasher("GERMANIUM");
    public static final Hasher arsenic_ = new Hasher("ARSENIC");
    public static final Hasher selenium_ = new Hasher("SELENIUM");
    public static final Hasher bromine_ = new Hasher("BROMINE");
    public static final Hasher krypton_ = new Hasher("KRYPTON");
    public static final Hasher rubidium_ = new Hasher("RUBIDIUM");
    public static final Hasher strontium_ = new Hasher("STRONTIUM");
    public static final Hasher yttrium_ = new Hasher("YTTRIUM");
    public static final Hasher zirconium_ = new Hasher("ZIRCONIUM");
    public static final Hasher niobium_ = new Hasher("NIOBIUM");
    public static final Hasher molybdenum_ = new Hasher("MOLYBDENUM");
    public static final Hasher technetium_ = new Hasher("TECHNETIUM");
    public static final Hasher ruthenium_ = new Hasher("RUTHENIUM");
    public static final Hasher rhodium_ = new Hasher("RHODIUM");
    public static final Hasher palladium_ = new Hasher("PALLADIUM");
    public static final Hasher silver_ = new Hasher("SILVER");
    public static final Hasher cadmium_ = new Hasher("CADMIUM");
    public static final Hasher indium_ = new Hasher("INDIUM");
    public static final Hasher tin_ = new Hasher("TIN");
    public static final Hasher antimony_ = new Hasher("ANTIMONY");
    public static final Hasher tellurium_ = new Hasher("TELLURIUM");
    public static final Hasher iodine_ = new Hasher("IODINE");
    public static final Hasher xenon_ = new Hasher("XENON");
    public static final Hasher caesium_ = new Hasher("CAESIUM");
    public static final Hasher barium_ = new Hasher("BARIUM");
    public static final Hasher lanthanum_ = new Hasher("LANTHANUM");
    public static final Hasher cerium_ = new Hasher("CERIUM");
    public static final Hasher praseodymium_ = new Hasher("PRASEODYMIUM");
    public static final Hasher neodymium_ = new Hasher("NEODYMIUM");
    public static final Hasher promethium_ = new Hasher("PROMETHIUM");
    public static final Hasher samarium_ = new Hasher("SAMARIUM");
    public static final Hasher europium_ = new Hasher("EUROPIUM");
    public static final Hasher gadolinium_ = new Hasher("GADOLINIUM");
    public static final Hasher terbium_ = new Hasher("TERBIUM");
    public static final Hasher dysprosium_ = new Hasher("DYSPROSIUM");
    public static final Hasher holmium_ = new Hasher("HOLMIUM");
    public static final Hasher erbium_ = new Hasher("ERBIUM");
    public static final Hasher thulium_ = new Hasher("THULIUM");
    public static final Hasher ytterbium_ = new Hasher("YTTERBIUM");
    public static final Hasher lutetium_ = new Hasher("LUTETIUM");
    public static final Hasher hafnium_ = new Hasher("HAFNIUM");
    public static final Hasher tantalum_ = new Hasher("TANTALUM");
    public static final Hasher tungsten_ = new Hasher("TUNGSTEN");
    public static final Hasher rhenium_ = new Hasher("RHENIUM");
    public static final Hasher osmium_ = new Hasher("OSMIUM");
    public static final Hasher iridium_ = new Hasher("IRIDIUM");
    public static final Hasher platinum_ = new Hasher("PLATINUM");
    public static final Hasher gold_ = new Hasher("GOLD");
    public static final Hasher mercury_ = new Hasher("MERCURY");
    public static final Hasher thallium_ = new Hasher("THALLIUM");
    public static final Hasher lead_ = new Hasher("LEAD");
    public static final Hasher bismuth_ = new Hasher("BISMUTH");
    public static final Hasher polonium_ = new Hasher("POLONIUM");
    public static final Hasher astatine_ = new Hasher("ASTATINE");
    public static final Hasher radon_ = new Hasher("RADON");
    public static final Hasher francium_ = new Hasher("FRANCIUM");
    public static final Hasher radium_ = new Hasher("RADIUM");
    public static final Hasher actinium_ = new Hasher("ACTINIUM");
    public static final Hasher thorium_ = new Hasher("THORIUM");
    public static final Hasher protactinium_ = new Hasher("PROTACTINIUM");
    public static final Hasher uranium_ = new Hasher("URANIUM");
    public static final Hasher neptunium_ = new Hasher("NEPTUNIUM");
    public static final Hasher plutonium_ = new Hasher("PLUTONIUM");
    public static final Hasher americium_ = new Hasher("AMERICIUM");
    public static final Hasher curium_ = new Hasher("CURIUM");
    public static final Hasher berkelium_ = new Hasher("BERKELIUM");
    public static final Hasher californium_ = new Hasher("CALIFORNIUM");
    public static final Hasher einsteinium_ = new Hasher("EINSTEINIUM");
    public static final Hasher fermium_ = new Hasher("FERMIUM");
    public static final Hasher mendelevium_ = new Hasher("MENDELEVIUM");
    public static final Hasher nobelium_ = new Hasher("NOBELIUM");
    public static final Hasher lawrencium_ = new Hasher("LAWRENCIUM");
    public static final Hasher rutherfordium_ = new Hasher("RUTHERFORDIUM");
    public static final Hasher dubnium_ = new Hasher("DUBNIUM");
    public static final Hasher seaborgium_ = new Hasher("SEABORGIUM");
    public static final Hasher bohrium_ = new Hasher("BOHRIUM");
    public static final Hasher hassium_ = new Hasher("HASSIUM");
    public static final Hasher meitnerium_ = new Hasher("MEITNERIUM");
    public static final Hasher darmstadtium_ = new Hasher("DARMSTADTIUM");
    public static final Hasher roentgenium_ = new Hasher("ROENTGENIUM");
    public static final Hasher copernicium_ = new Hasher("COPERNICIUM");
    public static final Hasher nihonium_ = new Hasher("NIHONIUM");
    public static final Hasher flerovium_ = new Hasher("FLEROVIUM");
    public static final Hasher moscovium_ = new Hasher("MOSCOVIUM");
    public static final Hasher livermorium_ = new Hasher("LIVERMORIUM");
    public static final Hasher tennessine_ = new Hasher("TENNESSINE");
    public static final Hasher oganesson_ = new Hasher("OGANESSON");
    public static final Hasher[] predefined = new Hasher[]{alpha, beta, gamma, delta, epsilon, zeta, eta, theta, iota, kappa, lambda, mu, nu, xi, omicron, pi, rho, sigma, tau, upsilon, phi, chi, psi, omega, alpha_, beta_, gamma_, delta_, epsilon_, zeta_, eta_, theta_, iota_, kappa_, lambda_, mu_, nu_, xi_, omicron_, pi_, rho_, sigma_, tau_, upsilon_, phi_, chi_, psi_, omega_, baal, agares, vassago, samigina, marbas, valefor, amon, barbatos, paimon, buer, gusion, sitri, beleth, leraje, eligos, zepar, botis, bathin, sallos, purson, marax, ipos, aim, naberius, glasya_labolas, bune, ronove, berith, astaroth, forneus, foras, asmoday, gaap, furfur, marchosias, stolas, phenex, halphas, malphas, raum, focalor, vepar, sabnock, shax, vine, bifrons, vual, haagenti, crocell, furcas, balam, alloces, caim, murmur, orobas, gremory, ose, amy, orias, vapula, zagan, valac, andras, flauros, andrealphus, kimaris, amdusias, belial, decarabia, seere, dantalion, andromalius, baal_, agares_, vassago_, samigina_, marbas_, valefor_, amon_, barbatos_, paimon_, buer_, gusion_, sitri_, beleth_, leraje_, eligos_, zepar_, botis_, bathin_, sallos_, purson_, marax_, ipos_, aim_, naberius_, glasya_labolas_, bune_, ronove_, berith_, astaroth_, forneus_, foras_, asmoday_, gaap_, furfur_, marchosias_, stolas_, phenex_, halphas_, malphas_, raum_, focalor_, vepar_, sabnock_, shax_, vine_, bifrons_, vual_, haagenti_, crocell_, furcas_, balam_, alloces_, caim_, murmur_, orobas_, gremory_, ose_, amy_, orias_, vapula_, zagan_, valac_, andras_, flauros_, andrealphus_, kimaris_, amdusias_, belial_, decarabia_, seere_, dantalion_, andromalius_, hydrogen, helium, lithium, beryllium, boron, carbon, nitrogen, oxygen, fluorine, neon, sodium, magnesium, aluminium, silicon, phosphorus, sulfur, chlorine, argon, potassium, calcium, scandium, titanium, vanadium, chromium, manganese, iron, cobalt, nickel, copper, zinc, gallium, germanium, arsenic, selenium, bromine, krypton, rubidium, strontium, yttrium, zirconium, niobium, molybdenum, technetium, ruthenium, rhodium, palladium, silver, cadmium, indium, tin, antimony, tellurium, iodine, xenon, caesium, barium, lanthanum, cerium, praseodymium, neodymium, promethium, samarium, europium, gadolinium, terbium, dysprosium, holmium, erbium, thulium, ytterbium, lutetium, hafnium, tantalum, tungsten, rhenium, osmium, iridium, platinum, gold, mercury, thallium, lead, bismuth, polonium, astatine, radon, francium, radium, actinium, thorium, protactinium, uranium, neptunium, plutonium, americium, curium, berkelium, californium, einsteinium, fermium, mendelevium, nobelium, lawrencium, rutherfordium, dubnium, seaborgium, bohrium, hassium, meitnerium, darmstadtium, roentgenium, copernicium, nihonium, flerovium, moscovium, livermorium, tennessine, oganesson, hydrogen_, helium_, lithium_, beryllium_, boron_, carbon_, nitrogen_, oxygen_, fluorine_, neon_, sodium_, magnesium_, aluminium_, silicon_, phosphorus_, sulfur_, chlorine_, argon_, potassium_, calcium_, scandium_, titanium_, vanadium_, chromium_, manganese_, iron_, cobalt_, nickel_, copper_, zinc_, gallium_, germanium_, arsenic_, selenium_, bromine_, krypton_, rubidium_, strontium_, yttrium_, zirconium_, niobium_, molybdenum_, technetium_, ruthenium_, rhodium_, palladium_, silver_, cadmium_, indium_, tin_, antimony_, tellurium_, iodine_, xenon_, caesium_, barium_, lanthanum_, cerium_, praseodymium_, neodymium_, promethium_, samarium_, europium_, gadolinium_, terbium_, dysprosium_, holmium_, erbium_, thulium_, ytterbium_, lutetium_, hafnium_, tantalum_, tungsten_, rhenium_, osmium_, iridium_, platinum_, gold_, mercury_, thallium_, lead_, bismuth_, polonium_, astatine_, radon_, francium_, radium_, actinium_, thorium_, protactinium_, uranium_, neptunium_, plutonium_, americium_, curium_, berkelium_, californium_, einsteinium_, fermium_, mendelevium_, nobelium_, lawrencium_, rutherfordium_, dubnium_, seaborgium_, bohrium_, hassium_, meitnerium_, darmstadtium_, roentgenium_, copernicium_, nihonium_, flerovium_, moscovium_, livermorium_, tennessine_, oganesson_};
    public static final SeededHashFunction64<boolean[]> booleanArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<byte[]> byteArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<short[]> shortArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<int[]> intArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<long[]> longArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<float[]> floatArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<double[]> doubleArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<char[]> charArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction64<CharSequence> charSequenceHash64 = Hasher::hash64;
    public static final SeededHashFunction64<Object[]> objectArrayHash64 = Hasher::hash64;
    public static final SeededHashFunction<boolean[]> booleanArrayHash = Hasher::hash;
    public static final SeededHashFunction<byte[]> byteArrayHash = Hasher::hash;
    public static final SeededHashFunction<short[]> shortArrayHash = Hasher::hash;
    public static final SeededHashFunction<int[]> intArrayHash = Hasher::hash;
    public static final SeededHashFunction<long[]> longArrayHash = Hasher::hash;
    public static final SeededHashFunction<float[]> floatArrayHash = Hasher::hash;
    public static final SeededHashFunction<double[]> doubleArrayHash = Hasher::hash;
    public static final SeededHashFunction<char[]> charArrayHash = Hasher::hash;
    public static final SeededHashFunction<CharSequence> charSequenceHash = Hasher::hash;
    public static final SeededHashFunction<Object[]> objectArrayHash = Hasher::hash;
    public static final SeededHashFunction64<boolean[]> booleanArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<byte[]> byteArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<short[]> shortArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<int[]> intArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<long[]> longArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<float[]> floatArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<double[]> doubleArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<char[]> charArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<CharSequence> charSequenceHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<Object[]> objectArrayHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<ByteBuffer> byteBufferHashBulk64 = Hasher::hashBulk64;
    public static final SeededHashFunction64<boolean[][]> booleanArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, booleanArrayHashBulk64, data);
    public static final SeededHashFunction64<byte[][]> byteArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, byteArrayHashBulk64, data);
    public static final SeededHashFunction64<short[][]> shortArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, shortArrayHashBulk64, data);
    public static final SeededHashFunction64<int[][]> intArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, intArrayHashBulk64, data);
    public static final SeededHashFunction64<long[][]> longArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, longArrayHashBulk64, data);
    public static final SeededHashFunction64<float[][]> floatArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, floatArrayHashBulk64, data);
    public static final SeededHashFunction64<double[][]> doubleArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, doubleArrayHashBulk64, data);
    public static final SeededHashFunction64<char[][]> charArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, charArrayHashBulk64, data);
    public static final SeededHashFunction64<CharSequence[]> charSequenceArrayHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, charSequenceHashBulk64, data);
    public static final SeededHashFunction64<Object[][]> objectArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, objectArrayHashBulk64, data);
    public static final SeededHashFunction64<ByteBuffer[]> byteBufferArrayHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, byteBufferHashBulk64, data);
    public static final SeededHashFunction64<boolean[][][]> booleanArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, booleanArray2DHashBulk64, data);
    public static final SeededHashFunction64<byte[][][]> byteArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, byteArray2DHashBulk64, data);
    public static final SeededHashFunction64<short[][][]> shortArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, shortArray2DHashBulk64, data);
    public static final SeededHashFunction64<int[][][]> intArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, intArray2DHashBulk64, data);
    public static final SeededHashFunction64<long[][][]> longArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, longArray2DHashBulk64, data);
    public static final SeededHashFunction64<float[][][]> floatArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, floatArray2DHashBulk64, data);
    public static final SeededHashFunction64<double[][][]> doubleArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, doubleArray2DHashBulk64, data);
    public static final SeededHashFunction64<char[][][]> charArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, charArray2DHashBulk64, data);
    public static final SeededHashFunction64<CharSequence[][]> charSequenceArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, charSequenceArrayHashBulk64, data);
    public static final SeededHashFunction64<Object[][][]> objectArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, objectArray2DHashBulk64, data);
    public static final SeededHashFunction64<ByteBuffer[][]> byteBufferArray2DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, byteBufferArrayHashBulk64, data);
    public static final SeededHashFunction64<CharSequence[][][]> charSequenceArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, charSequenceArray2DHashBulk64, data);
    public static final SeededHashFunction64<ByteBuffer[][][]> byteBufferArray3DHashBulk64 = (seed, data) -> Hasher.hashBulk64(seed, byteBufferArray2DHashBulk64, data);
    public static final SeededHashFunction<boolean[]> booleanArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<byte[]> byteArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<short[]> shortArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<int[]> intArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<long[]> longArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<float[]> floatArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<double[]> doubleArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<char[]> charArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<CharSequence> charSequenceHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<Object[]> objectArrayHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<ByteBuffer> byteBufferHashBulk = Hasher::hashBulk;
    public static final SeededHashFunction<boolean[][]> booleanArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, booleanArrayHashBulk, data);
    public static final SeededHashFunction<byte[][]> byteArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, byteArrayHashBulk, data);
    public static final SeededHashFunction<short[][]> shortArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, shortArrayHashBulk, data);
    public static final SeededHashFunction<int[][]> intArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, intArrayHashBulk, data);
    public static final SeededHashFunction<long[][]> longArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, longArrayHashBulk, data);
    public static final SeededHashFunction<float[][]> floatArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, floatArrayHashBulk, data);
    public static final SeededHashFunction<double[][]> doubleArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, doubleArrayHashBulk, data);
    public static final SeededHashFunction<char[][]> charArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, charArrayHashBulk, data);
    public static final SeededHashFunction<CharSequence[]> charSequenceArrayHashBulk = (seed, data) -> Hasher.hashBulk(seed, charSequenceHashBulk, data);
    public static final SeededHashFunction<Object[][]> objectArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, objectArrayHashBulk, data);
    public static final SeededHashFunction<ByteBuffer[]> byteBufferArrayHashBulk = (seed, data) -> Hasher.hashBulk(seed, byteBufferHashBulk, data);
    public static final SeededHashFunction<boolean[][][]> booleanArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, booleanArray2DHashBulk, data);
    public static final SeededHashFunction<byte[][][]> byteArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, byteArray2DHashBulk, data);
    public static final SeededHashFunction<short[][][]> shortArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, shortArray2DHashBulk, data);
    public static final SeededHashFunction<int[][][]> intArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, intArray2DHashBulk, data);
    public static final SeededHashFunction<long[][][]> longArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, longArray2DHashBulk, data);
    public static final SeededHashFunction<float[][][]> floatArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, floatArray2DHashBulk, data);
    public static final SeededHashFunction<double[][][]> doubleArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, doubleArray2DHashBulk, data);
    public static final SeededHashFunction<char[][][]> charArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, charArray2DHashBulk, data);
    public static final SeededHashFunction<CharSequence[][]> charSequenceArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, charSequenceArrayHashBulk, data);
    public static final SeededHashFunction<Object[][][]> objectArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, objectArray2DHashBulk, data);
    public static final SeededHashFunction<ByteBuffer[][]> byteBufferArray2DHashBulk = (seed, data) -> Hasher.hashBulk(seed, byteBufferArrayHashBulk, data);
    public static final SeededHashFunction<CharSequence[][][]> charSequenceArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, charSequenceArray2DHashBulk, data);
    public static final SeededHashFunction<ByteBuffer[][][]> byteBufferArray3DHashBulk = (seed, data) -> Hasher.hashBulk(seed, byteBufferArray2DHashBulk, data);

    public Hasher() {
        this(-4265267296055464877L);
    }

    public Hasher(long seed) {
        this.seed = seed;
    }

    public static long randomize1(long state) {
        state = (state * 7146057691288625177L ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L;
        state = (state ^ state >>> 27) * -5840758589994634535L;
        return state ^ state >>> 25;
    }

    public static long randomize2(long state) {
        state ^= 0xD1B54A32D192ED03L;
        state = (state ^ (state << 39 | state >>> 25) ^ (state << 17 | state >>> 47)) * -7031135171492799847L;
        state = (state ^ state >>> 23 ^ state >>> 51) * -7030854795893499237L;
        return state ^ state >>> 23 ^ state >>> 51;
    }

    public static long randomize3(long state) {
        state ^= 0xABC98388FB8FAC03L;
        state ^= state >>> 32;
        state *= -4710160504952957587L;
        state ^= state >>> 29;
        state *= -4710160504952957587L;
        state ^= state >>> 32;
        return (state *= -4710160504952957587L) ^ state >>> 29;
    }

    public static int randomize1Bounded(long state, int bound) {
        state = (state * 7146057691288625177L ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L;
        state = (state ^ state >>> 27) * -5840758589994634535L;
        bound = (int)((long)bound * ((state ^ state >>> 25) & 0xFFFFFFFFL) >> 32);
        return bound + (bound >>> 31);
    }

    public static int randomize2Bounded(long state, int bound) {
        state ^= 0xD1B54A32D192ED03L;
        state = (state ^ (state << 39 | state >>> 25) ^ (state << 17 | state >>> 47)) * -7031135171492799847L;
        state = (state ^ state >>> 23 ^ state >>> 51) * -7030854795893499237L;
        bound = (int)((long)bound * ((state ^ state >>> 23 ^ state >>> 51) & 0xFFFFFFFFL) >> 32);
        return bound + (bound >>> 31);
    }

    public static int randomize3Bounded(long state, int bound) {
        state ^= 0xABC98388FB8FAC03L;
        state ^= state >>> 32;
        state *= -4710160504952957587L;
        state ^= state >>> 29;
        state *= -4710160504952957587L;
        state ^= state >>> 32;
        bound = (int)((long)bound * (((state *= -4710160504952957587L) ^ state >>> 29) & 0xFFFFFFFFL) >> 32);
        return bound + (bound >>> 31);
    }

    public static float randomize1Float(long state) {
        state = (state * 7146057691288625177L ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L;
        return (float)((state ^ state >>> 27) * -5840758589994634535L >>> 40) * 5.9604645E-8f;
    }

    public static float randomize2Float(long state) {
        state ^= 0xD1B54A32D192ED03L;
        state = (state ^ (state << 39 | state >>> 25) ^ (state << 17 | state >>> 47)) * -7031135171492799847L;
        return (float)((state ^ state >>> 23 ^ state >>> 51) * -7030854795893499237L >>> 40) * 5.9604645E-8f;
    }

    public static float randomize3Float(long state) {
        state ^= 0xABC98388FB8FAC03L;
        state ^= state >>> 32;
        state *= -4710160504952957587L;
        state ^= state >>> 29;
        state *= -4710160504952957587L;
        state ^= state >>> 32;
        return (float)((state *= -4710160504952957587L) >>> 40) * 5.9604645E-8f;
    }

    public static double randomize1Double(long state) {
        state = (state * 7146057691288625177L ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L;
        state = (state ^ state >>> 27) * -5840758589994634535L;
        return (double)((state ^ state >>> 25) & 0x1FFFFFFFFFFFFFL) * (double)1.110223E-16f;
    }

    public static double randomize2Double(long state) {
        state ^= 0xD1B54A32D192ED03L;
        state = (state ^ (state << 39 | state >>> 25) ^ (state << 17 | state >>> 47)) * -7031135171492799847L;
        state = (state ^ state >>> 23 ^ state >>> 51) * -7030854795893499237L;
        return (double)((state ^ state >>> 23) >>> 11) * (double)1.110223E-16f;
    }

    public static double randomize3Double(long state) {
        state ^= 0xABC98388FB8FAC03L;
        state ^= state >>> 32;
        state *= -4710160504952957587L;
        state ^= state >>> 29;
        state *= -4710160504952957587L;
        state ^= state >>> 32;
        return (double)((state *= -4710160504952957587L) >>> 11 ^ state >>> 40) * (double)1.110223E-16f;
    }

    public Hasher(CharSequence seed) {
        this(Hasher.randomize3(Hasher.hash64(1L, seed)));
    }

    public static long mum(long a, long b) {
        long n = a * b;
        return n ^ n >>> 30;
    }

    public static long wow(long a, long b) {
        long n = (a ^ (b << 39 | b >>> 25)) * (b ^ (a << 39 | a >>> 25));
        return n ^ n >>> 32;
    }

    public static long mix(long x) {
        x ^= (x << 23 | x >>> 41) ^ (x << 43 | x >>> 21);
        return (x *= -4710160504952957587L) ^ (x << 11 | x >>> 53) ^ (x << 50 | x >>> 14);
    }

    public static long mixStream(long h, long x) {
        x *= -4710160504952957587L;
        x ^= x >>> 39;
        return (x * -4710160504952957587L + h) * -4710160504952957587L;
    }

    public static long mixStreamBulk(long a, long b, long c, long d) {
        return ((a << 29 | a >>> 35) - c) * -3334586728330402083L + ((b << 29 | b >>> 35) - d) * -7379824689681476987L + ((c << 29 | c >>> 35) - b) * -8093542602040470137L + ((d << 29 | d >>> 35) - a) * -218226644805978053L;
    }

    public static long forward(long x) {
        return x ^ (x << 29 | x >>> 35) ^ (x << 47 | x >>> 17);
    }

    public static long reverse(long x) {
        x ^= x ^ (x << 29 | x >>> 35) ^ (x << 47 | x >>> 17);
        x ^= x ^ (x << 58 | x >>> 6) ^ (x << 30 | x >>> 34);
        x ^= x ^ (x << 52 | x >>> 12) ^ (x << 60 | x >>> 4);
        x ^= x ^ (x << 40 | x >>> 24) ^ (x << 56 | x >>> 8);
        x ^= x ^ (x << 16 | x >>> 48) ^ (x << 48 | x >>> 16);
        return x;
    }

    public long hash64(boolean[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((data[i - 3] ? 2654435769L : 2135587861L) ^ 0xE7037ED1A0B428DBL, (data[i - 2] ? 2654435769L : 2135587861L) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((data[i - 1] ? 2654435769L : 2135587861L) ^ 0x589965CC75374CC3L, (data[i] ? 2654435769L : 2135587861L) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 2: {
                seed = Hasher.mum((data[len - 2] ? 2654435769L : 2135587861L) - seed, 0xA0761D6478BD642FL ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 3: {
                seed = Hasher.mum((data[len - 3] ? 2654435769L : 2135587861L) - seed, 0x8EBC6AF09C88C6E3L ^ (data[len - 2] ? 2654435769L : 2135587861L)) + Hasher.mum(seed ^ 0xEB44ACCAB455D165L, 0x1D8E4E27C47D124FL ^ (long)(data[len - 1] ? -1640531527 : 2135587861));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(byte[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(short[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(char[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(CharSequence data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length());
    }

    public long hash64(CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length());
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data.charAt(i - 3) ^ 0xE7037ED1A0B428DBL, (long)data.charAt(i - 2) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data.charAt(i - 1) ^ 0x589965CC75374CC3L, (long)data.charAt(i) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data.charAt(start + len - 2) - seed, 0xA0761D6478BD642FL ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data.charAt(start + len - 3) - seed, 0x8EBC6AF09C88C6E3L ^ (long)data.charAt(start + len - 2)) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data.charAt(start + len - 1));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(int[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum((long)(data[start + len - 1] >>> 16) - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1] & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum((long)(data[start + len - 1] >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1] & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(int[] data, int length) {
        return this.hash64(data, 0, length);
    }

    public long hash64(long[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= data[i - 3] * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= data[i - 2] * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= data[i - 1] * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= data[i] * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + data[start + len - 2], 0x8EBC6AF09C88C6E3L ^ data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + data[start + len - 3], -8161530843051276573L + data[start + len - 2]) + Hasher.wow(seed + data[start + len - 1], seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(float[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 3]) ^ 0xE7037ED1A0B428DBL, (long)BitConversion.floatToRawIntBits(data[i - 2]) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 1]) ^ 0x589965CC75374CC3L, (long)BitConversion.floatToRawIntBits(data[i]) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)(n >>> 16) - seed, 0x589965CC75374CC3L ^ (long)n & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 2]) - seed, 0xA0761D6478BD642FL ^ (long)BitConversion.floatToRawIntBits(data[start + len - 1]));
                break;
            }
            case 3: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 3]) - seed, 0x8EBC6AF09C88C6E3L ^ (long)BitConversion.floatToRawIntBits(data[start + len - 2])) + Hasher.mum((long)(n >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)n & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(double[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= BitConversion.doubleToRawLongBits(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= BitConversion.doubleToRawLongBits(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= BitConversion.doubleToRawLongBits(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= BitConversion.doubleToRawLongBits(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 3]), -8161530843051276573L + BitConversion.doubleToRawLongBits(data[start + len - 2])) + Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(byte[][] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(byte[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(char[][] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(char[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(float[][] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(float[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(double[][] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(double[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(int[][] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(int[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(long[][] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(long[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(CharSequence[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(CharSequence[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(CharSequence[] ... data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(CharSequence[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(Iterable<? extends CharSequence> data) {
        if (data == null) {
            return 0L;
        }
        long seed = this.seed;
        Iterator<? extends CharSequence> it = data.iterator();
        int len = 0;
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        while (it.hasNext()) {
            ++len;
            a ^= this.hash64(it.next()) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            if (it.hasNext()) {
                ++len;
                b ^= this.hash64(it.next()) * -8161530843051276573L;
                b = (b << 25 | b >>> 39) * 2129725606500045391L;
            }
            if (it.hasNext()) {
                ++len;
                c ^= this.hash64(it.next()) * 6384245875588680899L;
                c = (c << 29 | c >>> 35) * -1493879189771267739L;
            }
            if (it.hasNext()) {
                ++len;
                d ^= this.hash64(it.next()) * 2129725606500045391L;
                d = (d << 31 | d >>> 33) * -1800455987208640293L;
            }
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(List<? extends CharSequence> data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.size());
    }

    public long hash64(List<? extends CharSequence> data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.size()) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.size() - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data.get(i - 3)) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data.get(i - 2)) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data.get(i - 1)) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data.get(i)) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data.get(start + len - 1)));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data.get(start + len - 2)), 0x8EBC6AF09C88C6E3L ^ this.hash64(data.get(start + len - 1)));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data.get(start + len - 3)), -8161530843051276573L + this.hash64(data.get(start + len - 2))) + Hasher.wow(seed + this.hash64(data.get(start + len - 1)), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(Object[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hash64(data, 0, data.length);
    }

    public long hash64(Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public long hash64(Object data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.wow((long)data.hashCode() ^ 0x1D8E4E27C47D124FL, -1493879189771267739L - this.seed) ^ this.seed;
    }

    public int hash(boolean[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((data[i - 3] ? 2654435769L : 2135587861L) ^ 0xE7037ED1A0B428DBL, (data[i - 2] ? 2654435769L : 2135587861L) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((data[i - 1] ? 2654435769L : 2135587861L) ^ 0x589965CC75374CC3L, (data[i] ? 2654435769L : 2135587861L) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 2: {
                seed = Hasher.mum((data[len - 2] ? 2654435769L : 2135587861L) - seed, 0xA0761D6478BD642FL ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 3: {
                seed = Hasher.mum((data[len - 3] ? 2654435769L : 2135587861L) - seed, 0x8EBC6AF09C88C6E3L ^ (data[len - 2] ? 2654435769L : 2135587861L)) + Hasher.mum(seed ^ 0xEB44ACCAB455D165L, 0x1D8E4E27C47D124FL ^ (long)(data[len - 1] ? -1640531527 : 2135587861));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(byte[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(short[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(char[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(CharSequence data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length());
    }

    public int hash(CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length());
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data.charAt(i - 3) ^ 0xE7037ED1A0B428DBL, (long)data.charAt(i - 2) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data.charAt(i - 1) ^ 0x589965CC75374CC3L, (long)data.charAt(i) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data.charAt(start + len - 2) - seed, 0xA0761D6478BD642FL ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data.charAt(start + len - 3) - seed, 0x8EBC6AF09C88C6E3L ^ (long)data.charAt(start + len - 2)) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data.charAt(start + len - 1));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(int[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum((long)(data[start + len - 1] >>> 16) - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1] & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum((long)(data[start + len - 1] >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1] & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(int[] data, int length) {
        return this.hash(data, 0, length);
    }

    public int hash(long[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= data[i - 3] * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= data[i - 2] * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= data[i - 1] * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= data[i] * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + data[start + len - 2], 0x8EBC6AF09C88C6E3L ^ data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + data[start + len - 3], -8161530843051276573L + data[start + len - 2]) + Hasher.wow(seed + data[start + len - 1], seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(float[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 3]) ^ 0xE7037ED1A0B428DBL, (long)BitConversion.floatToRawIntBits(data[i - 2]) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 1]) ^ 0x589965CC75374CC3L, (long)BitConversion.floatToRawIntBits(data[i]) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)(n >>> 16) - seed, 0x589965CC75374CC3L ^ (long)n & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 2]) - seed, 0xA0761D6478BD642FL ^ (long)BitConversion.floatToRawIntBits(data[start + len - 1]));
                break;
            }
            case 3: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 3]) - seed, 0x8EBC6AF09C88C6E3L ^ (long)BitConversion.floatToRawIntBits(data[start + len - 2])) + Hasher.mum((long)(n >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)n & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(double[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= BitConversion.doubleToRawLongBits(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= BitConversion.doubleToRawLongBits(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= BitConversion.doubleToRawLongBits(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= BitConversion.doubleToRawLongBits(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 3]), -8161530843051276573L + BitConversion.doubleToRawLongBits(data[start + len - 2])) + Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(byte[][] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(byte[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(char[][] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(char[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(float[][] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(float[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(double[][] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(double[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(int[][] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(int[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(long[][] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(long[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(CharSequence[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(CharSequence[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(CharSequence[] ... data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(CharSequence[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(Iterable<? extends CharSequence> data) {
        if (data == null) {
            return 0;
        }
        long seed = this.seed;
        Iterator<? extends CharSequence> it = data.iterator();
        int len = 0;
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        while (it.hasNext()) {
            ++len;
            a ^= this.hash64(it.next()) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            if (it.hasNext()) {
                ++len;
                b ^= this.hash64(it.next()) * -8161530843051276573L;
                b = (b << 25 | b >>> 39) * 2129725606500045391L;
            }
            if (it.hasNext()) {
                ++len;
                c ^= this.hash64(it.next()) * 6384245875588680899L;
                c = (c << 29 | c >>> 35) * -1493879189771267739L;
            }
            if (it.hasNext()) {
                ++len;
                d ^= this.hash64(it.next()) * 2129725606500045391L;
                d = (d << 31 | d >>> 33) * -1800455987208640293L;
            }
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(List<? extends CharSequence> data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.size());
    }

    public int hash(List<? extends CharSequence> data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.size()) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.size() - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data.get(i - 3)) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data.get(i - 2)) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data.get(i - 1)) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data.get(i)) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data.get(start + len - 1)));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data.get(start + len - 2)), 0x8EBC6AF09C88C6E3L ^ this.hash64(data.get(start + len - 1)));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data.get(start + len - 3)), -8161530843051276573L + this.hash64(data.get(start + len - 2))) + Hasher.wow(seed + this.hash64(data.get(start + len - 1)), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(Object[] data) {
        if (data == null) {
            return 0;
        }
        return this.hash(data, 0, data.length);
    }

    public int hash(Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long seed = this.seed;
        int len = Math.min(length, data.length - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= this.hash64(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= this.hash64(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= this.hash64(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= this.hash64(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ this.hash64(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + this.hash64(data[start + len - 3]), -8161530843051276573L + this.hash64(data[start + len - 2])) + Hasher.wow(seed + this.hash64(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public int hash(Object data) {
        if (data == null) {
            return 0;
        }
        return (int)(Hasher.mum((long)data.hashCode() ^ 0x8EBC6AF09C88C6E3L, 6384245875588680899L - this.seed) ^ this.seed);
    }

    public static long hash64(long seed, boolean[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((data[i - 3] ? 2654435769L : 2135587861L) ^ 0xE7037ED1A0B428DBL, (data[i - 2] ? 2654435769L : 2135587861L) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((data[i - 1] ? 2654435769L : 2135587861L) ^ 0x589965CC75374CC3L, (data[i] ? 2654435769L : 2135587861L) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 2: {
                seed = Hasher.mum((data[len - 2] ? 2654435769L : 2135587861L) - seed, 0xA0761D6478BD642FL ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 3: {
                seed = Hasher.mum((data[len - 3] ? 2654435769L : 2135587861L) - seed, 0x8EBC6AF09C88C6E3L ^ (data[len - 2] ? 2654435769L : 2135587861L)) + Hasher.mum(seed ^ 0xEB44ACCAB455D165L, 0x1D8E4E27C47D124FL ^ (long)(data[len - 1] ? -1640531527 : 2135587861));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, byte[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, short[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, char[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, CharSequence data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length());
    }

    public static long hash64(long seed, CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= length) {
            return 0L;
        }
        int len = Math.min(length, data.length());
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data.charAt(i - 3) ^ 0xE7037ED1A0B428DBL, (long)data.charAt(i - 2) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data.charAt(i - 1) ^ 0x589965CC75374CC3L, (long)data.charAt(i) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data.charAt(start + len - 2) - seed, 0xA0761D6478BD642FL ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data.charAt(start + len - 3) - seed, 0x8EBC6AF09C88C6E3L ^ (long)data.charAt(start + len - 2)) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data.charAt(start + len - 1));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, int[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum((long)(data[start + len - 1] >>> 16) - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1] & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum((long)(data[start + len - 1] >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1] & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, int[] data, int length) {
        return Hasher.hash64(seed, data, 0, length);
    }

    public static long hash64(long seed, long[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= data[i - 3] * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= data[i - 2] * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= data[i - 1] * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= data[i] * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + data[start + len - 2], 0x8EBC6AF09C88C6E3L ^ data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + data[start + len - 3], -8161530843051276573L + data[start + len - 2]) + Hasher.wow(seed + data[start + len - 1], seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, float[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 3]) ^ 0xE7037ED1A0B428DBL, (long)BitConversion.floatToRawIntBits(data[i - 2]) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 1]) ^ 0x589965CC75374CC3L, (long)BitConversion.floatToRawIntBits(data[i]) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)(n >>> 16) - seed, 0x589965CC75374CC3L ^ (long)n & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 2]) - seed, 0xA0761D6478BD642FL ^ (long)BitConversion.floatToRawIntBits(data[start + len - 1]));
                break;
            }
            case 3: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 3]) - seed, 0x8EBC6AF09C88C6E3L ^ (long)BitConversion.floatToRawIntBits(data[start + len - 2])) + Hasher.mum((long)(n >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)n & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, double[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= BitConversion.doubleToRawLongBits(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= BitConversion.doubleToRawLongBits(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= BitConversion.doubleToRawLongBits(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= BitConversion.doubleToRawLongBits(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 3]), -8161530843051276573L + BitConversion.doubleToRawLongBits(data[start + len - 2])) + Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, byte[][] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, byte[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, char[][] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, char[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, float[][] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, float[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, double[][] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, double[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, int[][] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, int[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, long[][] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, long[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, CharSequence[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, CharSequence[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, CharSequence[] ... data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, CharSequence[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, Iterable<? extends CharSequence> data) {
        if (data == null) {
            return 0L;
        }
        Iterator<? extends CharSequence> it = data.iterator();
        int len = 0;
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        while (it.hasNext()) {
            ++len;
            a ^= Hasher.hash64(seed, it.next()) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            if (it.hasNext()) {
                ++len;
                b ^= Hasher.hash64(seed, it.next()) * -8161530843051276573L;
                b = (b << 25 | b >>> 39) * 2129725606500045391L;
            }
            if (it.hasNext()) {
                ++len;
                c ^= Hasher.hash64(seed, it.next()) * 6384245875588680899L;
                c = (c << 29 | c >>> 35) * -1493879189771267739L;
            }
            if (it.hasNext()) {
                ++len;
                d ^= Hasher.hash64(seed, it.next()) * 2129725606500045391L;
                d = (d << 31 | d >>> 33) * -1800455987208640293L;
            }
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, List<? extends CharSequence> data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.size());
    }

    public static long hash64(long seed, List<? extends CharSequence> data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.size()) {
            return 0L;
        }
        int len = Math.min(length, data.size() - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data.get(i - 3)) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data.get(i - 2)) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data.get(i - 1)) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data.get(i)) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data.get(start + len - 1)));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data.get(start + len - 2)), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data.get(start + len - 1)));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data.get(start + len - 3)), -8161530843051276573L + Hasher.hash64(seed, data.get(start + len - 2))) + Hasher.wow(seed + Hasher.hash64(seed, data.get(start + len - 1)), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, Object[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hash64(seed, data, 0, data.length);
    }

    public static long hash64(long seed, Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45);
    }

    public static long hash64(long seed, Object data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.wow((long)data.hashCode() ^ 0x1D8E4E27C47D124FL, -1493879189771267739L - seed) ^ seed;
    }

    public static int hash(long seed, boolean[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((data[i - 3] ? 2654435769L : 2135587861L) ^ 0xE7037ED1A0B428DBL, (data[i - 2] ? 2654435769L : 2135587861L) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((data[i - 1] ? 2654435769L : 2135587861L) ^ 0x589965CC75374CC3L, (data[i] ? 2654435769L : 2135587861L) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 2: {
                seed = Hasher.mum((data[len - 2] ? 2654435769L : 2135587861L) - seed, 0xA0761D6478BD642FL ^ (data[len - 1] ? 2654435769L : 2135587861L));
                break;
            }
            case 3: {
                seed = Hasher.mum((data[len - 3] ? 2654435769L : 2135587861L) - seed, 0x8EBC6AF09C88C6E3L ^ (data[len - 2] ? 2654435769L : 2135587861L)) + Hasher.mum(seed ^ 0xEB44ACCAB455D165L, 0x1D8E4E27C47D124FL ^ (long)(data[len - 1] ? -1640531527 : 2135587861));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, byte[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, short[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, char[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1]);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, CharSequence data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length());
    }

    public static int hash(long seed, CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= length) {
            return 0;
        }
        int len = Math.min(length, data.length());
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data.charAt(i - 3) ^ 0xE7037ED1A0B428DBL, (long)data.charAt(i - 2) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data.charAt(i - 1) ^ 0x589965CC75374CC3L, (long)data.charAt(i) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum(-1493879189771267739L - seed, 0x589965CC75374CC3L ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data.charAt(start + len - 2) - seed, 0xA0761D6478BD642FL ^ (long)data.charAt(start + len - 1));
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data.charAt(start + len - 3) - seed, 0x8EBC6AF09C88C6E3L ^ (long)data.charAt(start + len - 2)) + Hasher.mum(0xEB44ACCAB455D165L ^ seed, 0x1D8E4E27C47D124FL ^ (long)data.charAt(start + len - 1));
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, int[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)data[i - 3] ^ 0xE7037ED1A0B428DBL, (long)data[i - 2] ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)data[i - 1] ^ 0x589965CC75374CC3L, (long)data[i] ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.mum((long)(data[start + len - 1] >>> 16) - seed, 0x589965CC75374CC3L ^ (long)data[start + len - 1] & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)data[start + len - 2] - seed, 0xA0761D6478BD642FL ^ (long)data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.mum((long)data[start + len - 3] - seed, 0x8EBC6AF09C88C6E3L ^ (long)data[start + len - 2]) + Hasher.mum((long)(data[start + len - 1] >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)data[start + len - 1] & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, int[] data, int length) {
        return Hasher.hash(seed, data, 0, length);
    }

    public static int hash(long seed, long[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= data[i - 3] * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= data[i - 2] * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= data[i - 1] * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= data[i] * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ data[start + len - 1]);
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + data[start + len - 2], 0x8EBC6AF09C88C6E3L ^ data[start + len - 1]);
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + data[start + len - 3], -8161530843051276573L + data[start + len - 2]) + Hasher.wow(seed + data[start + len - 1], seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, float[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            seed = Hasher.mum(Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 3]) ^ 0xE7037ED1A0B428DBL, (long)BitConversion.floatToRawIntBits(data[i - 2]) ^ 0x8EBC6AF09C88C6E3L) - seed, Hasher.mum((long)BitConversion.floatToRawIntBits(data[i - 1]) ^ 0x589965CC75374CC3L, (long)BitConversion.floatToRawIntBits(data[i]) ^ 0x1D8E4E27C47D124FL));
        }
        switch (len & 3) {
            case 0: {
                seed = Hasher.mum(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)(n >>> 16) - seed, 0x589965CC75374CC3L ^ (long)n & 0xFFFFL);
                break;
            }
            case 2: {
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 2]) - seed, 0xA0761D6478BD642FL ^ (long)BitConversion.floatToRawIntBits(data[start + len - 1]));
                break;
            }
            case 3: {
                int n = BitConversion.floatToRawIntBits(data[start + len - 1]);
                seed = Hasher.mum((long)BitConversion.floatToRawIntBits(data[start + len - 3]) - seed, 0x8EBC6AF09C88C6E3L ^ (long)BitConversion.floatToRawIntBits(data[start + len - 2])) + Hasher.mum((long)(n >>> 16) ^ seed, 0x1D8E4E27C47D124FL ^ (long)n & 0xFFFFL);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, double[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= BitConversion.doubleToRawLongBits(data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= BitConversion.doubleToRawLongBits(data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= BitConversion.doubleToRawLongBits(data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= BitConversion.doubleToRawLongBits(data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ BitConversion.doubleToRawLongBits(data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 3]), -8161530843051276573L + BitConversion.doubleToRawLongBits(data[start + len - 2])) + Hasher.wow(seed + BitConversion.doubleToRawLongBits(data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, byte[][] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, byte[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, char[][] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, char[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, float[][] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, float[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, double[][] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, double[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, int[][] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, int[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, long[][] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, long[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, CharSequence[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, CharSequence[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, CharSequence[] ... data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, CharSequence[][] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, Iterable<? extends CharSequence> data) {
        if (data == null) {
            return 0;
        }
        Iterator<? extends CharSequence> it = data.iterator();
        int len = 0;
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        while (it.hasNext()) {
            ++len;
            a ^= Hasher.hash64(seed, it.next()) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            if (it.hasNext()) {
                ++len;
                b ^= Hasher.hash64(seed, it.next()) * -8161530843051276573L;
                b = (b << 25 | b >>> 39) * 2129725606500045391L;
            }
            if (it.hasNext()) {
                ++len;
                c ^= Hasher.hash64(seed, it.next()) * 6384245875588680899L;
                c = (c << 29 | c >>> 35) * -1493879189771267739L;
            }
            if (it.hasNext()) {
                ++len;
                d ^= Hasher.hash64(seed, it.next()) * 2129725606500045391L;
                d = (d << 31 | d >>> 33) * -1800455987208640293L;
            }
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, List<? extends CharSequence> data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.size());
    }

    public static int hash(long seed, List<? extends CharSequence> data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.size()) {
            return 0;
        }
        int len = Math.min(length, data.size() - start);
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data.get(i - 3)) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data.get(i - 2)) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data.get(i - 1)) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data.get(i)) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data.get(start + len - 1)));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data.get(start + len - 2)), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data.get(start + len - 1)));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data.get(start + len - 3)), -8161530843051276573L + Hasher.hash64(seed, data.get(start + len - 2))) + Hasher.wow(seed + Hasher.hash64(seed, data.get(start + len - 1)), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, Object[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hash(seed, data, 0, data.length);
    }

    public static int hash(long seed, Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        long a = seed + 2129725606500045391L;
        long b = a ^ 0x589965CC75374CC3L;
        long c = b - -8161530843051276573L;
        long d = c ^ 0xE7037ED1A0B428DBL;
        int len = Math.min(length, data.length - start);
        for (int i = start + 3; i < len; i += 4) {
            a ^= Hasher.hash64(seed, data[i - 3]) * -1800455987208640293L;
            a = (a << 23 | a >>> 41) * 6384245875588680899L;
            b ^= Hasher.hash64(seed, data[i - 2]) * -8161530843051276573L;
            b = (b << 25 | b >>> 39) * 2129725606500045391L;
            c ^= Hasher.hash64(seed, data[i - 1]) * 6384245875588680899L;
            c = (c << 29 | c >>> 35) * -1493879189771267739L;
            d ^= Hasher.hash64(seed, data[i]) * 2129725606500045391L;
            d = (d << 31 | d >>> 33) * -1800455987208640293L;
            seed += a + b + c + d;
        }
        seed += -1493879189771267739L;
        switch (len & 3) {
            case 0: {
                seed = Hasher.wow(-1800455987208640293L - seed, 2129725606500045391L + seed);
                break;
            }
            case 1: {
                seed = Hasher.wow(seed, 0xE7037ED1A0B428DBL ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 2: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 2]), 0x8EBC6AF09C88C6E3L ^ Hasher.hash64(seed, data[start + len - 1]));
                break;
            }
            case 3: {
                seed = Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 3]), -8161530843051276573L + Hasher.hash64(seed, data[start + len - 2])) + Hasher.wow(seed + Hasher.hash64(seed, data[start + len - 1]), seed ^ 0x589965CC75374CC3L);
            }
        }
        seed = (seed ^ (long)len) * (seed << 16 ^ 0xA0761D6478BD642FL);
        return (int)(seed ^ (seed << 33 | seed >>> 31) ^ (seed << 19 | seed >>> 45));
    }

    public static int hash(long seed, Object data) {
        if (data == null) {
            return 0;
        }
        return (int)(Hasher.mum((long)data.hashCode() ^ 0x8EBC6AF09C88C6E3L, 6384245875588680899L - seed) ^ seed);
    }

    public long hashBulk64(long[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public int hashBulk(long[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(int[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public int hashBulk(int[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(short[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public int hashBulk(short[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(byte[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public int hashBulk(byte[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(float[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i]), BitConversion.floatToRawIntBits(data[i + 1]), BitConversion.floatToRawIntBits(data[i + 2]), BitConversion.floatToRawIntBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i + 4]), BitConversion.floatToRawIntBits(data[i + 5]), BitConversion.floatToRawIntBits(data[i + 6]), BitConversion.floatToRawIntBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.floatToRawIntBits(data[i++]));
        }
        return Hasher.mix(h);
    }

    public int hashBulk(float[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i]), BitConversion.floatToRawIntBits(data[i + 1]), BitConversion.floatToRawIntBits(data[i + 2]), BitConversion.floatToRawIntBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i + 4]), BitConversion.floatToRawIntBits(data[i + 5]), BitConversion.floatToRawIntBits(data[i + 6]), BitConversion.floatToRawIntBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.floatToRawIntBits(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(double[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i]), BitConversion.doubleToRawLongBits(data[i + 1]), BitConversion.doubleToRawLongBits(data[i + 2]), BitConversion.doubleToRawLongBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i + 4]), BitConversion.doubleToRawLongBits(data[i + 5]), BitConversion.doubleToRawLongBits(data[i + 6]), BitConversion.doubleToRawLongBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.doubleToRawLongBits(data[i++]));
        }
        return Hasher.mix(h);
    }

    public int hashBulk(double[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i]), BitConversion.doubleToRawLongBits(data[i + 1]), BitConversion.doubleToRawLongBits(data[i + 2]), BitConversion.doubleToRawLongBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i + 4]), BitConversion.doubleToRawLongBits(data[i + 5]), BitConversion.doubleToRawLongBits(data[i + 6]), BitConversion.doubleToRawLongBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.doubleToRawLongBits(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(char[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public int hashBulk(char[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(boolean[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i] ? -1L : 0L, data[i + 1] ? -1L : 0L, data[i + 2] ? -1L : 0L, data[i + 3] ? -1L : 0L);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4] ? -1L : 0L, data[i + 5] ? -1L : 0L, data[i + 6] ? -1L : 0L, data[i + 7] ? -1L : 0L);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++] ? -1L : 0L);
        }
        return Hasher.mix(h);
    }

    public int hashBulk(boolean[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i] ? -1L : 0L, data[i + 1] ? -1L : 0L, data[i + 2] ? -1L : 0L, data[i + 3] ? -1L : 0L);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4] ? -1L : 0L, data[i + 5] ? -1L : 0L, data[i + 6] ? -1L : 0L, data[i + 7] ? -1L : 0L);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++] ? -1L : 0L);
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(CharSequence data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length());
    }

    public long hashBulk64(CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length()) {
            return 0L;
        }
        int len = Math.min(length, data.length() - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data.charAt(i), data.charAt(i + 1), data.charAt(i + 2), data.charAt(i + 3));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.charAt(i + 4), data.charAt(i + 5), data.charAt(i + 6), data.charAt(i + 7));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data.charAt(i++));
        }
        return Hasher.mix(h);
    }

    public int hashBulk(CharSequence data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length());
    }

    public int hashBulk(CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length()) {
            return 0;
        }
        int len = Math.min(length, data.length() - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data.charAt(i), data.charAt(i + 1), data.charAt(i + 2), data.charAt(i + 3));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.charAt(i + 4), data.charAt(i + 5), data.charAt(i + 6), data.charAt(i + 7));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data.charAt(i++));
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(Object[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(data, 0, data.length);
    }

    public long hashBulk64(Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i]), Objects.hashCode(data[i + 1]), Objects.hashCode(data[i + 2]), Objects.hashCode(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i + 4]), Objects.hashCode(data[i + 5]), Objects.hashCode(data[i + 6]), Objects.hashCode(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, Objects.hashCode(data[i++]));
        }
        return Hasher.mix(h);
    }

    public int hashBulk(Object[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(data, 0, data.length);
    }

    public int hashBulk(Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i]), Objects.hashCode(data[i + 1]), Objects.hashCode(data[i + 2]), Objects.hashCode(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i + 4]), Objects.hashCode(data[i + 5]), Objects.hashCode(data[i + 6]), Objects.hashCode(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, Objects.hashCode(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public long hashBulk64(ByteBuffer data) {
        return this.hashBulk64(data, 0, data.limit());
    }

    public long hashBulk64(ByteBuffer data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.limit()) {
            return 0L;
        }
        int len = Math.min(length, data.limit() - start);
        data.position(start);
        long h = (long)len ^ Hasher.forward(this.seed);
        while (len >= 64) {
            h *= -4710160504952957587L;
            len -= 64;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
        }
        while (len >= 8) {
            len -= 8;
            h = Hasher.mixStream(h, data.getLong());
        }
        switch (len) {
            case 1: {
                h = Hasher.mix(Hasher.mixStream(h, data.get()));
                break;
            }
            case 2: {
                h = Hasher.mix(Hasher.mixStream(h, data.getShort()));
                break;
            }
            case 3: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getShort() ^ (long)data.get() << 16));
                break;
            }
            case 4: {
                h = Hasher.mix(Hasher.mixStream(h, data.getInt()));
                break;
            }
            case 5: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.get() << 32));
                break;
            }
            case 6: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32));
                break;
            }
            case 7: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32 ^ (long)data.get() << 48));
                break;
            }
            default: {
                h = Hasher.mix(h);
            }
        }
        return h;
    }

    public int hashBulk(ByteBuffer data) {
        return this.hashBulk(data, 0, data.limit());
    }

    public int hashBulk(ByteBuffer data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.limit()) {
            return 0;
        }
        int len = Math.min(length, data.limit() - start);
        data.position(start);
        long h = (long)len ^ Hasher.forward(this.seed);
        while (len >= 64) {
            h *= -4710160504952957587L;
            len -= 64;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
        }
        while (len >= 8) {
            len -= 8;
            h = Hasher.mixStream(h, data.getLong());
        }
        switch (len) {
            case 1: {
                h = Hasher.mix(Hasher.mixStream(h, data.get()));
                break;
            }
            case 2: {
                h = Hasher.mix(Hasher.mixStream(h, data.getShort()));
                break;
            }
            case 3: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getShort() ^ (long)data.get() << 16));
                break;
            }
            case 4: {
                h = Hasher.mix(Hasher.mixStream(h, data.getInt()));
                break;
            }
            case 5: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.get() << 32));
                break;
            }
            case 6: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32));
                break;
            }
            case 7: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32 ^ (long)data.get() << 48));
                break;
            }
            default: {
                h = Hasher.mix(h);
            }
        }
        return (int)h;
    }

    public <T> long hashBulk64(HashFunction64<T> function, T[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(function, data, 0, data.length);
    }

    public <T> long hashBulk64(HashFunction64<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash64(data[i]), function.hash64(data[i + 1]), function.hash64(data[i + 2]), function.hash64(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash64(data[i + 4]), function.hash64(data[i + 5]), function.hash64(data[i + 6]), function.hash64(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash64(data[i++]));
        }
        return Hasher.mix(h);
    }

    public <T> long hashBulk64(HashFunction<T> function, T[] data) {
        if (data == null) {
            return 0L;
        }
        return this.hashBulk64(function, data, 0, data.length);
    }

    public <T> long hashBulk64(HashFunction<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash(data[i]), function.hash(data[i + 1]), function.hash(data[i + 2]), function.hash(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash(data[i + 4]), function.hash(data[i + 5]), function.hash(data[i + 6]), function.hash(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash(data[i++]));
        }
        return Hasher.mix(h);
    }

    public <T> int hashBulk(HashFunction64<T> function, T[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(function, data, 0, data.length);
    }

    public <T> int hashBulk(HashFunction64<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash64(data[i]), function.hash64(data[i + 1]), function.hash64(data[i + 2]), function.hash64(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash64(data[i + 4]), function.hash64(data[i + 5]), function.hash64(data[i + 6]), function.hash64(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash64(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public <T> int hashBulk(HashFunction<T> function, T[] data) {
        if (data == null) {
            return 0;
        }
        return this.hashBulk(function, data, 0, data.length);
    }

    public <T> int hashBulk(HashFunction<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(this.seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash(data[i]), function.hash(data[i + 1]), function.hash(data[i + 2]), function.hash(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash(data[i + 4]), function.hash(data[i + 5]), function.hash(data[i + 6]), function.hash(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, long[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, long[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, long[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, int[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, int[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, int[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, short[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, short[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, short[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, byte[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, byte[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, float[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i]), BitConversion.floatToRawIntBits(data[i + 1]), BitConversion.floatToRawIntBits(data[i + 2]), BitConversion.floatToRawIntBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i + 4]), BitConversion.floatToRawIntBits(data[i + 5]), BitConversion.floatToRawIntBits(data[i + 6]), BitConversion.floatToRawIntBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.floatToRawIntBits(data[i++]));
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, float[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, float[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i]), BitConversion.floatToRawIntBits(data[i + 1]), BitConversion.floatToRawIntBits(data[i + 2]), BitConversion.floatToRawIntBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.floatToRawIntBits(data[i + 4]), BitConversion.floatToRawIntBits(data[i + 5]), BitConversion.floatToRawIntBits(data[i + 6]), BitConversion.floatToRawIntBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.floatToRawIntBits(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, double[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i]), BitConversion.doubleToRawLongBits(data[i + 1]), BitConversion.doubleToRawLongBits(data[i + 2]), BitConversion.doubleToRawLongBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i + 4]), BitConversion.doubleToRawLongBits(data[i + 5]), BitConversion.doubleToRawLongBits(data[i + 6]), BitConversion.doubleToRawLongBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.doubleToRawLongBits(data[i++]));
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, double[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, double[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i]), BitConversion.doubleToRawLongBits(data[i + 1]), BitConversion.doubleToRawLongBits(data[i + 2]), BitConversion.doubleToRawLongBits(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(BitConversion.doubleToRawLongBits(data[i + 4]), BitConversion.doubleToRawLongBits(data[i + 5]), BitConversion.doubleToRawLongBits(data[i + 6]), BitConversion.doubleToRawLongBits(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, BitConversion.doubleToRawLongBits(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, char[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, char[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, char[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i], data[i + 1], data[i + 2], data[i + 3]);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++]);
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, boolean[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i] ? -1L : 0L, data[i + 1] ? -1L : 0L, data[i + 2] ? -1L : 0L, data[i + 3] ? -1L : 0L);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4] ? -1L : 0L, data[i + 5] ? -1L : 0L, data[i + 6] ? -1L : 0L, data[i + 7] ? -1L : 0L);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++] ? -1L : 0L);
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, boolean[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, boolean[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data[i] ? -1L : 0L, data[i + 1] ? -1L : 0L, data[i + 2] ? -1L : 0L, data[i + 3] ? -1L : 0L);
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data[i + 4] ? -1L : 0L, data[i + 5] ? -1L : 0L, data[i + 6] ? -1L : 0L, data[i + 7] ? -1L : 0L);
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data[i++] ? -1L : 0L);
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, CharSequence data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length());
    }

    public static long hashBulk64(long seed, CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length()) {
            return 0L;
        }
        int len = Math.min(length, data.length() - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data.charAt(i), data.charAt(i + 1), data.charAt(i + 2), data.charAt(i + 3));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.charAt(i + 4), data.charAt(i + 5), data.charAt(i + 6), data.charAt(i + 7));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data.charAt(i++));
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, CharSequence data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length());
    }

    public static int hashBulk(long seed, CharSequence data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length()) {
            return 0;
        }
        int len = Math.min(length, data.length() - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(data.charAt(i), data.charAt(i + 1), data.charAt(i + 2), data.charAt(i + 3));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.charAt(i + 4), data.charAt(i + 5), data.charAt(i + 6), data.charAt(i + 7));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, data.charAt(i++));
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, Object[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, data, 0, data.length);
    }

    public static long hashBulk64(long seed, Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i]), Objects.hashCode(data[i + 1]), Objects.hashCode(data[i + 2]), Objects.hashCode(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i + 4]), Objects.hashCode(data[i + 5]), Objects.hashCode(data[i + 6]), Objects.hashCode(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, Objects.hashCode(data[i++]));
        }
        return Hasher.mix(h);
    }

    public static int hashBulk(long seed, Object[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, data, 0, data.length);
    }

    public static int hashBulk(long seed, Object[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i]), Objects.hashCode(data[i + 1]), Objects.hashCode(data[i + 2]), Objects.hashCode(data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(Objects.hashCode(data[i + 4]), Objects.hashCode(data[i + 5]), Objects.hashCode(data[i + 6]), Objects.hashCode(data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, Objects.hashCode(data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public static long hashBulk64(long seed, ByteBuffer data) {
        return Hasher.hashBulk64(seed, data, 0, data.limit());
    }

    public static long hashBulk64(long seed, ByteBuffer data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.limit()) {
            return 0L;
        }
        int len = Math.min(length, data.limit() - start);
        data.position(start);
        long h = (long)len ^ Hasher.forward(seed);
        while (len >= 64) {
            h *= -4710160504952957587L;
            len -= 64;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
        }
        while (len >= 8) {
            len -= 8;
            h = Hasher.mixStream(h, data.getLong());
        }
        switch (len) {
            case 1: {
                h = Hasher.mix(Hasher.mixStream(h, data.get()));
                break;
            }
            case 2: {
                h = Hasher.mix(Hasher.mixStream(h, data.getShort()));
                break;
            }
            case 3: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getShort() ^ (long)data.get() << 16));
                break;
            }
            case 4: {
                h = Hasher.mix(Hasher.mixStream(h, data.getInt()));
                break;
            }
            case 5: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.get() << 32));
                break;
            }
            case 6: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32));
                break;
            }
            case 7: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32 ^ (long)data.get() << 48));
                break;
            }
            default: {
                h = Hasher.mix(h);
            }
        }
        return h;
    }

    public static int hashBulk(long seed, ByteBuffer data) {
        return Hasher.hashBulk(seed, data, 0, data.limit());
    }

    public static int hashBulk(long seed, ByteBuffer data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.limit()) {
            return 0;
        }
        int len = Math.min(length, data.limit() - start);
        data.position(start);
        long h = (long)len ^ Hasher.forward(seed);
        while (len >= 64) {
            h *= -4710160504952957587L;
            len -= 64;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(data.getLong(), data.getLong(), data.getLong(), data.getLong());
        }
        while (len >= 8) {
            len -= 8;
            h = Hasher.mixStream(h, data.getLong());
        }
        switch (len) {
            case 1: {
                h = Hasher.mix(Hasher.mixStream(h, data.get()));
                break;
            }
            case 2: {
                h = Hasher.mix(Hasher.mixStream(h, data.getShort()));
                break;
            }
            case 3: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getShort() ^ (long)data.get() << 16));
                break;
            }
            case 4: {
                h = Hasher.mix(Hasher.mixStream(h, data.getInt()));
                break;
            }
            case 5: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.get() << 32));
                break;
            }
            case 6: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32));
                break;
            }
            case 7: {
                h = Hasher.mix(Hasher.mixStream(h, (long)data.getInt() ^ (long)data.getShort() << 32 ^ (long)data.get() << 48));
                break;
            }
            default: {
                h = Hasher.mix(h);
            }
        }
        return (int)h;
    }

    public static <T> long hashBulk64(long seed, SeededHashFunction64<T> function, T[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, function, data, 0, data.length);
    }

    public static <T> long hashBulk64(long seed, SeededHashFunction64<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash64(seed, data[i]), function.hash64(seed, data[i + 1]), function.hash64(seed, data[i + 2]), function.hash64(seed, data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash64(seed, data[i + 4]), function.hash64(seed, data[i + 5]), function.hash64(seed, data[i + 6]), function.hash64(seed, data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash64(seed, data[i++]));
        }
        return Hasher.mix(h);
    }

    public static <T> long hashBulk64(long seed, SeededHashFunction<T> function, T[] data) {
        if (data == null) {
            return 0L;
        }
        return Hasher.hashBulk64(seed, function, data, 0, data.length);
    }

    public static <T> long hashBulk64(long seed, SeededHashFunction<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0L;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash(seed, data[i]), function.hash(seed, data[i + 1]), function.hash(seed, data[i + 2]), function.hash(seed, data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash(seed, data[i + 4]), function.hash(seed, data[i + 5]), function.hash(seed, data[i + 6]), function.hash(seed, data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash(seed, data[i++]));
        }
        return Hasher.mix(h);
    }

    public static <T> int hashBulk(long seed, SeededHashFunction64<T> function, T[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, function, data, 0, data.length);
    }

    public static <T> int hashBulk(long seed, SeededHashFunction64<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash64(seed, data[i]), function.hash64(seed, data[i + 1]), function.hash64(seed, data[i + 2]), function.hash64(seed, data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash64(seed, data[i + 4]), function.hash64(seed, data[i + 5]), function.hash64(seed, data[i + 6]), function.hash64(seed, data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash64(seed, data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public static <T> int hashBulk(long seed, SeededHashFunction<T> function, T[] data) {
        if (data == null) {
            return 0;
        }
        return Hasher.hashBulk(seed, function, data, 0, data.length);
    }

    public static <T> int hashBulk(long seed, SeededHashFunction<T> function, T[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || start >= data.length) {
            return 0;
        }
        int len = Math.min(length, data.length - start);
        long h = (long)len ^ Hasher.forward(seed);
        int i = start;
        while (len >= 8) {
            h *= -4710160504952957587L;
            len -= 8;
            h += Hasher.mixStreamBulk(function.hash(seed, data[i]), function.hash(seed, data[i + 1]), function.hash(seed, data[i + 2]), function.hash(seed, data[i + 3]));
            h = h << 37 | h >>> 27;
            h += Hasher.mixStreamBulk(function.hash(seed, data[i + 4]), function.hash(seed, data[i + 5]), function.hash(seed, data[i + 6]), function.hash(seed, data[i + 7]));
            i += 8;
        }
        while (len >= 1) {
            --len;
            h = Hasher.mixStream(h, function.hash(seed, data[i++]));
        }
        return (int)Hasher.mix(h);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hasher hasher = (Hasher)o;
        return this.seed == hasher.seed;
    }

    public int hashCode() {
        return (int)(this.seed ^ this.seed >>> 32);
    }

    public String toString() {
        return "Hasher{seed=" + this.seed + '}';
    }

    public static interface HashFunction64<T> {
        public long hash64(T var1);
    }

    public static interface HashFunction<T> {
        public int hash(T var1);
    }

    public static interface SeededHashFunction64<T> {
        public long hash64(long var1, T var3);
    }

    public static interface SeededHashFunction<T> {
        public int hash(long var1, T var3);
    }
}

