/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.BitConversion;

public final class RoughMath {
    public static final float FOUR_OVER_PI = 1.2732395f;
    public static final float FOUR_OVER_PI_SQUARED = 0.40528473f;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float PI2_INVERSE = 0.15915494f;

    private RoughMath() {
    }

    public static float pow2Rough(float p) {
        float clip = Math.max(-126.0f, p);
        float z = clip - (float)((int)(clip + 126.0f)) + 126.0f;
        return BitConversion.intBitsToFloat((int)(8388608.0f * (clip + 121.274055f + 27.728024f / (4.8425255f - z) - 1.4901291f * z)));
    }

    public static float pow2Rougher(float p) {
        return BitConversion.intBitsToFloat((int)(8388608.0f * (Math.max(-126.0f, p) + 126.942696f)));
    }

    public static float expRough(float p) {
        float clip = Math.max(-126.0f, p * 1.442695f);
        float z = clip - (float)((int)(clip + 126.0f)) + 126.0f;
        return BitConversion.intBitsToFloat((int)(8388608.0f * (clip + 121.274055f + 27.728024f / (4.8425255f - z) - 1.4901291f * z)));
    }

    public static float expRougher(float p) {
        return BitConversion.intBitsToFloat((int)(8388608.0f * (Math.max(-126.0f, 1.442695f * p) + 126.942696f)));
    }

    public static float log2Rough(float x) {
        int vx = BitConversion.floatToIntBits(x);
        float mx = BitConversion.intBitsToFloat(vx & 0x7FFFFF | 0x3F000000);
        return (float)vx * 1.1920929E-7f - 124.22552f - 1.4980303f * mx - 1.72588f / (0.35208872f + mx);
    }

    public static float logRough(float x) {
        int vx = BitConversion.floatToIntBits(x);
        float mx = BitConversion.intBitsToFloat(vx & 0x7FFFFF | 0x3F000000);
        return ((float)vx * 1.1920929E-7f - 124.22552f - 1.4980303f * mx - 1.72588f / (0.35208872f + mx)) * 0.6931472f;
    }

    public static float log2Rougher(float x) {
        return (float)BitConversion.floatToIntBits(x) * 1.1920929E-7f - 126.942696f;
    }

    public static float logRougher(float x) {
        return (float)BitConversion.floatToIntBits(x) * 8.262958E-8f - 87.98997f;
    }

    public static float sinhRough(float p) {
        return 0.5f * (RoughMath.expRough(p) - RoughMath.expRough(-p));
    }

    public static float sinhRougher(float p) {
        return 0.5f * (RoughMath.expRougher(p) - RoughMath.expRougher(-p));
    }

    public static float coshRough(float p) {
        return 0.5f * (RoughMath.expRough(p) + RoughMath.expRough(-p));
    }

    public static float coshRougher(float p) {
        return 0.5f * (RoughMath.expRougher(p) + RoughMath.expRougher(-p));
    }

    public static float tanhRough(float p) {
        float clip = Math.max(-126.0f, -2.88539f * p);
        float z = clip - (float)((int)(clip + 126.0f)) + 126.0f;
        return -1.0f + 2.0f / (1.0f + BitConversion.intBitsToFloat((int)(8388608.0f * (clip + 121.274055f + 27.728024f / (4.8425255f - z) - 1.4901291f * z))));
    }

    public static float tanhRougher(float p) {
        return -1.0f + 2.0f / (1.0f + BitConversion.intBitsToFloat((int)(8388608.0f * (Math.max(-126.0f, -2.88539f * p) + 126.942696f))));
    }

    public static float logisticRough(float x) {
        float clip = Math.max(-126.0f, x * -1.442695f);
        float z = clip - (float)((int)(clip + 126.0f)) + 126.0f;
        return 1.0f / (1.0f + BitConversion.intBitsToFloat((int)(8388608.0f * (clip + 121.274055f + 27.728024f / (4.8425255f - z) - 1.4901291f * z))));
    }

    public static float logisticRougher(float x) {
        return 1.0f / (1.0f + BitConversion.intBitsToFloat((int)(8388608.0f * (Math.max(-126.0f, -1.442695f * x) + 126.942696f))));
    }

    @Deprecated
    public static float sinRoughLimited(float x) {
        float q = 0.78444487f;
        int p = 1045464791;
        int r = 1014484634;
        int s = 995308055;
        int vx = BitConversion.floatToIntBits(x);
        int sign = vx & Integer.MIN_VALUE;
        float approx = 1.2732395f * x - 0.40528473f * x * BitConversion.intBitsToFloat(vx &= Integer.MAX_VALUE);
        float approxSquared = approx * approx;
        return 0.78444487f * approx + approxSquared * (BitConversion.intBitsToFloat(p |= sign) + approxSquared * (BitConversion.intBitsToFloat(r |= sign) + approxSquared * BitConversion.intBitsToFloat(s |= sign)));
    }

    @Deprecated
    public static float sinRough(float x) {
        float half = x < 0.0f ? -0.5f : 0.5f;
        return RoughMath.sinRoughLimited((half + (float)((int)(x * 0.15915494f))) * ((float)Math.PI * 2) - x);
    }
}

