/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.BitConversion;
import java.math.BigInteger;

final class RyuFloat {
    private static final int FLOAT_MANTISSA_BITS = 23;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_EXPONENT_BITS = 8;
    private static final int FLOAT_EXPONENT_MASK = 255;
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private static final long LOG10_2_DENOMINATOR = 10000000L;
    private static final long LOG10_2_NUMERATOR = (long)(1.0E7 * Math.log10(2.0));
    private static final long LOG10_5_DENOMINATOR = 10000000L;
    private static final long LOG10_5_NUMERATOR = (long)(1.0E7 * Math.log10(5.0));
    private static final long LOG2_5_DENOMINATOR = 10000000L;
    private static final long LOG2_5_NUMERATOR = (long)(1.0E7 * (Math.log(5.0) / Math.log(2.0)));
    private static final int POS_TABLE_SIZE = 47;
    private static final int INV_TABLE_SIZE = 31;
    private static final char[] result = new char[32];
    private static final int POW5_BITCOUNT = 61;
    private static final int POW5_HALF_BITCOUNT = 31;
    private static final int[][] POW5_SPLIT = new int[47][2];
    private static final int POW5_INV_BITCOUNT = 59;
    private static final int POW5_INV_HALF_BITCOUNT = 31;
    private static final int[][] POW5_INV_SPLIT = new int[31][2];

    private RyuFloat() {
    }

    public static String general(float value) {
        int index = RyuFloat.general(value, result, -3, 7);
        return new String(result, 0, index);
    }

    public static StringBuilder appendGeneral(StringBuilder builder, float value) {
        return RyuFloat.appendGeneral(builder, value, result, -3, 7);
    }

    public static StringBuilder appendGeneral(StringBuilder builder, float value, char[] result) {
        return RyuFloat.appendGeneral(builder, value, result, -3, 7);
    }

    public static int general(float value, char[] result) {
        return RyuFloat.general(value, result, -3, 7);
    }

    public static int friendly(float value, char[] result) {
        return RyuFloat.general(value, result, -10, 10);
    }

    public static String friendly(float value) {
        int index = RyuFloat.general(value, result, -10, 10);
        return new String(result, 0, index);
    }

    public static StringBuilder appendFriendly(StringBuilder builder, float value) {
        return RyuFloat.appendGeneral(builder, value, result, -10, 10);
    }

    public static StringBuilder appendFriendly(StringBuilder builder, float value, char[] result) {
        return RyuFloat.appendGeneral(builder, value, result, -10, 10);
    }

    public static StringBuilder appendGeneral(StringBuilder builder, float value, char[] result, int low, int high) {
        int index = RyuFloat.general(value, result, low, high);
        return builder.append(result, 0, index);
    }

    public static int general(float value, char[] result, int low, int high) {
        boolean dmIsTrailingZeros;
        boolean dvIsTrailingZeros;
        boolean dpIsTrailingZeros;
        int e10;
        int dm;
        int dp;
        int dv;
        int q;
        int m2;
        int e2;
        if (Float.isNaN(value)) {
            result[0] = 78;
            result[1] = 97;
            result[2] = 78;
            return 3;
        }
        if (value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY) {
            int idx = 0;
            if (value == Float.NEGATIVE_INFINITY) {
                result[idx++] = 45;
            }
            result[idx++] = 73;
            result[idx++] = 110;
            result[idx++] = 102;
            result[idx++] = 105;
            result[idx++] = 110;
            result[idx++] = 105;
            result[idx++] = 116;
            result[idx++] = 121;
            return idx;
        }
        int bits = BitConversion.floatToIntBits(value);
        if (bits == 0) {
            result[0] = 48;
            result[1] = 46;
            result[2] = 48;
            return 3;
        }
        if (bits == Integer.MIN_VALUE) {
            result[0] = 45;
            result[1] = 48;
            result[2] = 46;
            result[3] = 48;
            return 4;
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean sign = bits < 0;
        boolean even = (m2 & 1) == 0;
        int mv = m2 << 2;
        int mp = (m2 << 2) + 2;
        int mm = (m2 << 2) - ((long)m2 != 0x800000L || ieeeExponent == 1 ? 2 : 1);
        int lastRemovedDigit = 0;
        if ((e2 -= 2) >= 0) {
            q = (int)((long)e2 * LOG10_2_NUMERATOR / 10000000L);
            int k = 59 + RyuFloat.pow5bits(q) - 1;
            int i = -e2 + q + k;
            dv = (int)RyuFloat.mulPow5InvDivPow2(mv, q, i);
            dp = (int)RyuFloat.mulPow5InvDivPow2(mp, q, i);
            dm = (int)RyuFloat.mulPow5InvDivPow2(mm, q, i);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int l = 59 + RyuFloat.pow5bits(q - 1) - 1;
                lastRemovedDigit = (int)(RyuFloat.mulPow5InvDivPow2(mv, q - 1, -e2 + q - 1 + l) % 10L);
            }
            e10 = q;
            dpIsTrailingZeros = RyuFloat.pow5Factor(mp) >= q;
            dvIsTrailingZeros = RyuFloat.pow5Factor(mv) >= q;
            dmIsTrailingZeros = RyuFloat.pow5Factor(mm) >= q;
        } else {
            q = (int)((long)(-e2) * LOG10_5_NUMERATOR / 10000000L);
            int i = -e2 - q;
            int k = RyuFloat.pow5bits(i) - 61;
            int j = q - k;
            dv = (int)RyuFloat.mulPow5divPow2(mv, i, j);
            dp = (int)RyuFloat.mulPow5divPow2(mp, i, j);
            dm = (int)RyuFloat.mulPow5divPow2(mm, i, j);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                j = q - 1 - (RyuFloat.pow5bits(i + 1) - 61);
                lastRemovedDigit = (int)(RyuFloat.mulPow5divPow2(mv, i + 1, j) % 10L);
            }
            e10 = q + e2;
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            dmIsTrailingZeros = (~mm & 1) >= q;
        }
        int dplength = RyuFloat.decimalLength(dp);
        int exp = e10 + dplength - 1;
        boolean scientificNotation = exp < low || exp >= high;
        int removed = 0;
        if (dpIsTrailingZeros && !even) {
            --dp;
        }
        while (!(dp / 10 <= dm / 10 || dp < 100 && scientificNotation)) {
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && even) {
            while (!(dm % 10 != 0 || dp < 100 && scientificNotation)) {
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && (dv & 1) == 0) {
            lastRemovedDigit = 4;
        }
        int output = dv + (dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        int olength = dplength - removed;
        int index = 0;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (int i = 0; i < olength - 1; ++i) {
                int c = output % 10;
                output /= 10;
                result[index + olength - i] = (char)(48 + c);
            }
            result[index] = (char)(48 + output % 10);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
        } else if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (int i = -1; i > exp; --i) {
                result[index++] = 48;
            }
            int current = index;
            for (int i = 0; i < olength; ++i) {
                result[current + olength - i - 1] = (char)(48 + output % 10);
                output /= 10;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i;
            for (i = 0; i < olength; ++i) {
                result[index + olength - i - 1] = (char)(48 + output % 10);
                output /= 10;
            }
            index += olength;
            for (i = olength; i < exp + 1; ++i) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            int current = index + 1;
            for (int i = 0; i < olength; ++i) {
                if (olength - i - 1 == exp) {
                    result[current + olength - i - 1] = 46;
                    --current;
                }
                result[current + olength - i - 1] = (char)(48 + output % 10);
                output /= 10;
            }
            index += olength + 1;
        }
        return index;
    }

    public static String decimal(float value) {
        return RyuFloat.appendDecimal(new StringBuilder(), value, -10000).toString();
    }

    public static String decimal(float value, int lengthLimit) {
        return RyuFloat.appendDecimal(new StringBuilder(), value, lengthLimit).toString();
    }

    public static String decimal(float value, int lengthLimit, int precision) {
        return RyuFloat.appendDecimal(new StringBuilder(), value, lengthLimit, precision).toString();
    }

    public static StringBuilder appendDecimal(StringBuilder builder, float value) {
        return RyuFloat.appendDecimal(builder, value, -10000);
    }

    public static StringBuilder appendDecimal(StringBuilder builder, float value, int lengthLimit) {
        return RyuFloat.appendDecimal(builder, value, lengthLimit, -10000);
    }

    public static StringBuilder appendDecimal(StringBuilder builder, float value, int lengthLimit, int precision) {
        int i;
        int index;
        boolean dmIsTrailingZeros;
        boolean dvIsTrailingZeros;
        boolean dpIsTrailingZeros;
        int e10;
        int dm;
        int dp;
        int dv;
        int q;
        int m2;
        int e2;
        if (Float.isNaN(value)) {
            int startLimiting = builder.length();
            builder.append("NaN");
            if (lengthLimit != -10000) {
                if ((long)startLimiting + (long)lengthLimit < (long)builder.length()) {
                    builder.setLength(startLimiting + lengthLimit);
                } else {
                    while (builder.length() < startLimiting + lengthLimit) {
                        builder.append(' ');
                    }
                }
            }
            return builder;
        }
        if (value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY) {
            int startLimiting = builder.length();
            if (value == Float.NEGATIVE_INFINITY) {
                builder.append("-Infinity");
            } else {
                builder.append("Infinity");
            }
            if (lengthLimit != -10000) {
                if ((long)startLimiting + (long)lengthLimit < (long)builder.length()) {
                    builder.setLength(startLimiting + lengthLimit);
                } else {
                    while (builder.length() < startLimiting + lengthLimit) {
                        builder.append(' ');
                    }
                }
            }
            return builder;
        }
        int bits = BitConversion.floatToIntBits(value);
        if (bits == 0) {
            int startLimiting = builder.length();
            builder.append("0.0");
            if (precision >= 0) {
                int ideal = builder.indexOf(".", startLimiting) + precision;
                while (builder.length() <= ideal) {
                    builder.append('0');
                }
            }
            if (lengthLimit != -10000) {
                if ((long)startLimiting + (long)lengthLimit < (long)builder.length()) {
                    builder.setLength(startLimiting + lengthLimit);
                } else {
                    while (builder.length() < startLimiting + lengthLimit) {
                        builder.append('0');
                    }
                }
            }
            return builder;
        }
        if (bits == Integer.MIN_VALUE) {
            int startLimiting = builder.length();
            builder.append("-0.0");
            if (lengthLimit != -10000) {
                if ((long)startLimiting + (long)lengthLimit < (long)builder.length()) {
                    builder.setLength(startLimiting + lengthLimit);
                } else {
                    while (builder.length() < startLimiting + lengthLimit) {
                        builder.append('0');
                    }
                }
            }
            return builder;
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean sign = bits < 0;
        boolean even = (m2 & 1) == 0;
        int mv = m2 << 2;
        int mp = (m2 << 2) + 2;
        int mm = (m2 << 2) - ((long)m2 != 0x800000L || ieeeExponent == 1 ? 2 : 1);
        int lastRemovedDigit = 0;
        if ((e2 -= 2) >= 0) {
            q = (int)((long)e2 * LOG10_2_NUMERATOR / 10000000L);
            int k = 59 + RyuFloat.pow5bits(q) - 1;
            int i2 = -e2 + q + k;
            dv = (int)RyuFloat.mulPow5InvDivPow2(mv, q, i2);
            dp = (int)RyuFloat.mulPow5InvDivPow2(mp, q, i2);
            dm = (int)RyuFloat.mulPow5InvDivPow2(mm, q, i2);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int l = 59 + RyuFloat.pow5bits(q - 1) - 1;
                lastRemovedDigit = (int)(RyuFloat.mulPow5InvDivPow2(mv, q - 1, -e2 + q - 1 + l) % 10L);
            }
            e10 = q;
            dpIsTrailingZeros = RyuFloat.pow5Factor(mp) >= q;
            dvIsTrailingZeros = RyuFloat.pow5Factor(mv) >= q;
            dmIsTrailingZeros = RyuFloat.pow5Factor(mm) >= q;
        } else {
            q = (int)((long)(-e2) * LOG10_5_NUMERATOR / 10000000L);
            int i3 = -e2 - q;
            int k = RyuFloat.pow5bits(i3) - 61;
            int j = q - k;
            dv = (int)RyuFloat.mulPow5divPow2(mv, i3, j);
            dp = (int)RyuFloat.mulPow5divPow2(mp, i3, j);
            dm = (int)RyuFloat.mulPow5divPow2(mm, i3, j);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                j = q - 1 - (RyuFloat.pow5bits(i3 + 1) - 61);
                lastRemovedDigit = (int)(RyuFloat.mulPow5divPow2(mv, i3 + 1, j) % 10L);
            }
            e10 = q + e2;
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            dmIsTrailingZeros = (~mm & 1) >= q;
        }
        int dplength = RyuFloat.decimalLength(dp);
        int exp = e10 + dplength - 1;
        int removed = 0;
        if (dpIsTrailingZeros && !even) {
            --dp;
        }
        while (dp / 10 > dm / 10) {
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && even) {
            while (dm % 10 == 0) {
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && (dv & 1) == 0) {
            lastRemovedDigit = 4;
        }
        int output = dv + (dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        int olength = dplength - removed;
        int startLimiting = index = builder.length();
        if (sign) {
            builder.append('-');
        }
        if (exp < 0) {
            builder.append("0.");
            int decimalPlaces = precision < 0 ? 127 : precision;
            for (int i4 = -1; i4 > exp && decimalPlaces != 0; --i4, --decimalPlaces) {
                builder.append('0');
            }
            int current = builder.length();
            for (i = 0; i < olength && decimalPlaces != 0; ++i, --decimalPlaces) {
                builder.insert(current, (char)(48 + output % 10));
                output /= 10;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i5;
            index = builder.length();
            for (i5 = 0; i5 < olength; ++i5) {
                builder.insert(index, (char)(48 + output % 10));
                output /= 10;
            }
            for (i5 = olength; i5 < exp + 1; ++i5) {
                builder.append('0');
            }
            builder.append(".0");
        } else {
            int current = builder.length();
            int postDot = precision < 0 ? 127 : exp + precision;
            for (i = 0; i < olength; ++i) {
                if (olength - i - 1 == exp) {
                    builder.insert(current, '.');
                }
                if (olength - i - 1 <= postDot) {
                    builder.insert(current, (char)(48 + output % 10));
                } else {
                    ++removed;
                }
                output /= 10;
            }
        }
        if (precision >= 0) {
            int ideal = builder.indexOf(".", startLimiting) + precision;
            while (builder.length() <= ideal) {
                builder.append('0');
            }
        }
        if (lengthLimit != -10000) {
            while (removed >= -1) {
                builder.append('0');
                --removed;
            }
            if ((long)startLimiting + (long)lengthLimit < (long)builder.length()) {
                builder.setLength(startLimiting + lengthLimit);
            }
        }
        return builder;
    }

    public static String scientific(float value) {
        int index = RyuFloat.scientific(value, result);
        return new String(result, 0, index);
    }

    public static StringBuilder appendScientific(StringBuilder builder, float value) {
        return RyuFloat.appendScientific(builder, value, result);
    }

    public static StringBuilder appendScientific(StringBuilder builder, float value, char[] result) {
        int index = RyuFloat.scientific(value, result);
        return builder.append(result, 0, index);
    }

    public static int scientific(float value, char[] result) {
        boolean dmIsTrailingZeros;
        boolean dvIsTrailingZeros;
        boolean dpIsTrailingZeros;
        int e10;
        int dm;
        int dp;
        int dv;
        int q;
        int m2;
        int e2;
        if (Float.isNaN(value)) {
            result[0] = 78;
            result[1] = 97;
            result[2] = 78;
            return 3;
        }
        if (value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY) {
            int idx = 0;
            if (value == Float.NEGATIVE_INFINITY) {
                result[idx++] = 45;
            }
            result[idx++] = 73;
            result[idx++] = 110;
            result[idx++] = 102;
            result[idx++] = 105;
            result[idx++] = 110;
            result[idx++] = 105;
            result[idx++] = 116;
            result[idx++] = 121;
            return idx;
        }
        int bits = BitConversion.floatToIntBits(value);
        if (bits == 0) {
            result[0] = 48;
            result[1] = 46;
            result[2] = 48;
            result[3] = 69;
            result[4] = 48;
            return 5;
        }
        if (bits == Integer.MIN_VALUE) {
            result[0] = 45;
            result[1] = 48;
            result[2] = 46;
            result[3] = 48;
            result[4] = 69;
            result[5] = 48;
            return 6;
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean sign = bits < 0;
        boolean even = (m2 & 1) == 0;
        int mv = m2 << 2;
        int mp = (m2 << 2) + 2;
        int mm = (m2 << 2) - ((long)m2 != 0x800000L || ieeeExponent == 1 ? 2 : 1);
        int lastRemovedDigit = 0;
        if ((e2 -= 2) >= 0) {
            q = (int)((long)e2 * LOG10_2_NUMERATOR / 10000000L);
            int k = 59 + RyuFloat.pow5bits(q) - 1;
            int i = -e2 + q + k;
            dv = (int)RyuFloat.mulPow5InvDivPow2(mv, q, i);
            dp = (int)RyuFloat.mulPow5InvDivPow2(mp, q, i);
            dm = (int)RyuFloat.mulPow5InvDivPow2(mm, q, i);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int l = 59 + RyuFloat.pow5bits(q - 1) - 1;
                lastRemovedDigit = (int)(RyuFloat.mulPow5InvDivPow2(mv, q - 1, -e2 + q - 1 + l) % 10L);
            }
            e10 = q;
            dpIsTrailingZeros = RyuFloat.pow5Factor(mp) >= q;
            dvIsTrailingZeros = RyuFloat.pow5Factor(mv) >= q;
            dmIsTrailingZeros = RyuFloat.pow5Factor(mm) >= q;
        } else {
            q = (int)((long)(-e2) * LOG10_5_NUMERATOR / 10000000L);
            int i = -e2 - q;
            int k = RyuFloat.pow5bits(i) - 61;
            int j = q - k;
            dv = (int)RyuFloat.mulPow5divPow2(mv, i, j);
            dp = (int)RyuFloat.mulPow5divPow2(mp, i, j);
            dm = (int)RyuFloat.mulPow5divPow2(mm, i, j);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                j = q - 1 - (RyuFloat.pow5bits(i + 1) - 61);
                lastRemovedDigit = (int)(RyuFloat.mulPow5divPow2(mv, i + 1, j) % 10L);
            }
            e10 = q + e2;
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            dmIsTrailingZeros = (~mm & 1) >= q;
        }
        int dplength = RyuFloat.decimalLength(dp);
        int exp = e10 + dplength - 1;
        int removed = 0;
        if (dpIsTrailingZeros && !even) {
            --dp;
        }
        while (dp / 10 > dm / 10 && dp >= 100) {
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && even) {
            while (dm % 10 == 0 && dp >= 100) {
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && (dv & 1) == 0) {
            lastRemovedDigit = 4;
        }
        int output = dv + (dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        int olength = dplength - removed;
        int index = 0;
        if (sign) {
            result[index++] = 45;
        }
        for (int i = 0; i < olength - 1; ++i) {
            int c = output % 10;
            output /= 10;
            result[index + olength - i] = (char)(48 + c);
        }
        result[index] = (char)(48 + output % 10);
        result[index + 1] = 46;
        index += olength + 1;
        if (olength == 1) {
            result[index++] = 48;
        }
        result[index++] = 69;
        if (exp < 0) {
            result[index++] = 45;
            exp = -exp;
        }
        if (exp >= 10) {
            result[index++] = (char)(48 + exp / 10);
        }
        result[index++] = (char)(48 + exp % 10);
        return index;
    }

    private static int pow5bits(int e) {
        return e == 0 ? 1 : (int)(((long)e * LOG2_5_NUMERATOR + 10000000L - 1L) / 10000000L);
    }

    private static int pow5Factor(int value) {
        int count = 0;
        while (value > 0) {
            if (value % 5 != 0) {
                return count;
            }
            value /= 5;
            ++count;
        }
        throw new IllegalArgumentException("" + value);
    }

    private static long mulPow5divPow2(int m, int i, int j) {
        if (j - 31 < 0) {
            throw new IllegalArgumentException();
        }
        long bits0 = (long)m * (long)POW5_SPLIT[i][0];
        long bits1 = (long)m * (long)POW5_SPLIT[i][1];
        return bits0 + (bits1 >> 31) >> j - 31;
    }

    private static long mulPow5InvDivPow2(int m, int q, int j) {
        if (j - 31 < 0) {
            throw new IllegalArgumentException();
        }
        long bits0 = (long)m * (long)POW5_INV_SPLIT[q][0];
        long bits1 = (long)m * (long)POW5_INV_SPLIT[q][1];
        return bits0 + (bits1 >> 31) >> j - 31;
    }

    private static int decimalLength(int v) {
        int length = 10;
        for (int factor = 1000000000; length > 0 && v < factor; factor /= 10, --length) {
        }
        return length;
    }

    static {
        BigInteger mask = BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger maskInv = BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE);
        for (int i = 0; i < 47; ++i) {
            BigInteger pow = BigInteger.valueOf(5L).pow(i);
            int pow5len = pow.bitLength();
            int expectedPow5Bits = RyuFloat.pow5bits(i);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            RyuFloat.POW5_SPLIT[i][0] = pow.shiftRight(pow5len - 61 + 31).intValue();
            RyuFloat.POW5_SPLIT[i][1] = pow.shiftRight(pow5len - 61).and(mask).intValue();
            if (i >= 31) continue;
            int j = pow5len - 1 + 59;
            BigInteger inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);
            RyuFloat.POW5_INV_SPLIT[i][0] = inv.shiftRight(31).intValue();
            RyuFloat.POW5_INV_SPLIT[i][1] = inv.and(maskInv).intValue();
        }
    }
}

