/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

public final class ShapeTools {
    public static final float[][] TETRAHEDRON_VERTICES;
    public static final double[][] TETRAHEDRON_VERTICES_D;
    public static final int[][] TETRAHEDRON_FACES;
    public static final float[][] CUBE_VERTICES;
    public static final double[][] CUBE_VERTICES_D;
    public static final int[][] CUBE_FACES;
    public static final float[][] OCTAHEDRON_VERTICES;
    public static final double[][] OCTAHEDRON_VERTICES_D;
    public static final int[][] OCTAHEDRON_FACES;
    public static final float[][] DODECAHEDRON_VERTICES;
    public static final double[][] DODECAHEDRON_VERTICES_D;
    public static final int[][] DODECAHEDRON_FACES;
    public static final float[][] ICOSAHEDRON_VERTICES;
    public static final double[][] ICOSAHEDRON_VERTICES_D;
    public static final int[][] ICOSAHEDRON_FACES;
    public static final float[][] UNIT_TETRAHEDRON_VERTICES;
    public static final double[][] UNIT_TETRAHEDRON_VERTICES_D;
    public static final float[][] UNIT_CUBE_VERTICES;
    public static final double[][] UNIT_CUBE_VERTICES_D;
    public static final float[][] UNIT_OCTAHEDRON_VERTICES;
    public static final double[][] UNIT_OCTAHEDRON_VERTICES_D;
    public static final float[][] UNIT_DODECAHEDRON_VERTICES;
    public static final double[][] UNIT_DODECAHEDRON_VERTICES_D;
    public static final float[][] UNIT_ICOSAHEDRON_VERTICES;
    public static final double[][] UNIT_ICOSAHEDRON_VERTICES_D;

    private ShapeTools() {
    }

    private static double len2_d(double[] v) {
        return v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
    }

    private static float len2(float[] v) {
        return v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
    }

    private static double len_d(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    private static float len(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    private static double[] nor_d(double[] v) {
        double il = 1.0 / ShapeTools.len_d(v);
        return new double[]{v[0] * il, v[1] * il, v[2] * il};
    }

    private static float[] nor(float[] v) {
        float il = 1.0f / ShapeTools.len(v);
        return new float[]{v[0] * il, v[1] * il, v[2] * il};
    }

    static {
        int i;
        TETRAHEDRON_VERTICES = new float[][]{{-0.5f, 0.0f, -0.35355338f}, {0.5f, 0.0f, -0.35355338f}, {0.0f, -0.5f, 0.35355338f}, {0.0f, 0.5f, 0.35355338f}};
        TETRAHEDRON_VERTICES_D = new double[][]{{-0.5, 0.0, -0.35355339059327373}, {0.5, 0.0, -0.35355339059327373}, {0.0, -0.5, 0.35355339059327373}, {0.0, 0.5, 0.35355339059327373}};
        TETRAHEDRON_FACES = new int[][]{{0, 1, 2}, {0, 1, 3}, {0, 2, 3}, {1, 2, 3}};
        CUBE_VERTICES = new float[][]{{-0.5f, -0.5f, -0.5f}, {-0.5f, -0.5f, 0.5f}, {-0.5f, 0.5f, -0.5f}, {-0.5f, 0.5f, 0.5f}, {0.5f, -0.5f, -0.5f}, {0.5f, -0.5f, 0.5f}, {0.5f, 0.5f, -0.5f}, {0.5f, 0.5f, 0.5f}};
        CUBE_VERTICES_D = new double[][]{{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}};
        CUBE_FACES = new int[][]{{0, 1, 2, 3}, {0, 1, 4, 5}, {2, 3, 6, 7}, {4, 5, 6, 7}, {0, 2, 4, 6}, {1, 3, 5, 7}};
        OCTAHEDRON_VERTICES = new float[][]{{-0.70710677f, 0.0f, 0.0f}, {0.0f, -0.70710677f, 0.0f}, {0.0f, 0.0f, -0.70710677f}, {0.0f, 0.70710677f, 0.0f}, {0.0f, 0.0f, 0.70710677f}, {0.70710677f, 0.0f, 0.0f}};
        OCTAHEDRON_VERTICES_D = new double[][]{{-0.7071067811865475, 0.0, 0.0}, {0.0, -0.7071067811865475, 0.0}, {0.0, 0.0, -0.7071067811865475}, {0.0, 0.7071067811865475, 0.0}, {0.0, 0.0, 0.7071067811865475}, {0.7071067811865475, 0.0, 0.0}};
        OCTAHEDRON_FACES = new int[][]{{0, 1, 2}, {0, 2, 3}, {0, 3, 4}, {0, 1, 4}, {1, 2, 5}, {2, 3, 5}, {3, 4, 5}, {1, 4, 5}};
        DODECAHEDRON_VERTICES = new float[][]{{-0.809017f, -0.809017f, -0.809017f}, {-0.809017f, -0.809017f, 0.809017f}, {-0.809017f, 0.809017f, -0.809017f}, {-0.809017f, 0.809017f, 0.809017f}, {0.809017f, -0.809017f, -0.809017f}, {0.809017f, -0.809017f, 0.809017f}, {0.809017f, 0.809017f, -0.809017f}, {0.809017f, 0.809017f, 0.809017f}, {0.0f, -1.3090171f, -0.5f}, {0.0f, -1.3090171f, 0.5f}, {0.0f, 1.3090171f, -0.5f}, {0.0f, 1.3090171f, 0.5f}, {-0.5f, 0.0f, -1.3090171f}, {0.5f, 0.0f, -1.3090171f}, {-0.5f, 0.0f, 1.3090171f}, {0.5f, 0.0f, 1.3090171f}, {-1.3090171f, -0.5f, 0.0f}, {-1.3090171f, 0.5f, 0.0f}, {1.3090171f, -0.5f, 0.0f}, {1.3090171f, 0.5f, 0.0f}};
        DODECAHEDRON_VERTICES_D = new double[][]{{-0.8090169943749475, -0.8090169943749475, -0.8090169943749475}, {-0.8090169943749475, -0.8090169943749475, 0.8090169943749475}, {-0.8090169943749475, 0.8090169943749475, -0.8090169943749475}, {-0.8090169943749475, 0.8090169943749475, 0.8090169943749475}, {0.8090169943749475, -0.8090169943749475, -0.8090169943749475}, {0.8090169943749475, -0.8090169943749475, 0.8090169943749475}, {0.8090169943749475, 0.8090169943749475, -0.8090169943749475}, {0.8090169943749475, 0.8090169943749475, 0.8090169943749475}, {0.0, -1.3090169943749475, -0.5}, {0.0, -1.3090169943749475, 0.5}, {0.0, 1.3090169943749475, -0.5}, {0.0, 1.3090169943749475, 0.5}, {-0.5, 0.0, -1.3090169943749475}, {0.5, 0.0, -1.3090169943749475}, {-0.5, 0.0, 1.3090169943749475}, {0.5, 0.0, 1.3090169943749475}, {-1.3090169943749475, -0.5, 0.0}, {-1.3090169943749475, 0.5, 0.0}, {1.3090169943749475, -0.5, 0.0}, {1.3090169943749475, 0.5, 0.0}};
        DODECAHEDRON_FACES = new int[][]{{8, 9, 0, 1, 16}, {8, 9, 4, 5, 18}, {10, 11, 2, 3, 17}, {10, 11, 6, 7, 19}, {12, 13, 0, 4, 8}, {12, 13, 2, 6, 10}, {14, 15, 1, 5, 9}, {14, 15, 3, 7, 11}, {16, 17, 0, 2, 12}, {16, 17, 1, 3, 14}, {18, 19, 4, 6, 13}, {18, 19, 5, 7, 15}};
        ICOSAHEDRON_VERTICES = new float[][]{{0.0f, -0.5f, -0.809017f}, {0.0f, 0.5f, 0.809017f}, {0.0f, 0.5f, -0.809017f}, {0.0f, -0.5f, 0.809017f}, {-0.809017f, 0.0f, -0.5f}, {0.809017f, 0.0f, 0.5f}, {-0.809017f, 0.0f, 0.5f}, {0.809017f, 0.0f, -0.5f}, {-0.5f, -0.809017f, 0.0f}, {0.5f, 0.809017f, 0.0f}, {0.5f, -0.809017f, 0.0f}, {-0.5f, 0.809017f, 0.0f}};
        ICOSAHEDRON_VERTICES_D = new double[][]{{0.0, -0.5, -0.8090169943749475}, {0.0, 0.5, 0.8090169943749475}, {0.0, 0.5, -0.8090169943749475}, {0.0, -0.5, 0.8090169943749475}, {-0.8090169943749475, 0.0, -0.5}, {0.8090169943749475, 0.0, 0.5}, {-0.8090169943749475, 0.0, 0.5}, {0.8090169943749475, 0.0, -0.5}, {-0.5, -0.8090169943749475, 0.0}, {0.5, 0.8090169943749475, 0.0}, {0.5, -0.8090169943749475, 0.0}, {-0.5, 0.8090169943749475, 0.0}};
        ICOSAHEDRON_FACES = new int[][]{{0, 2, 4}, {1, 3, 5}, {0, 2, 7}, {1, 3, 6}, {4, 6, 8}, {5, 7, 9}, {4, 6, 11}, {5, 7, 10}, {8, 10, 0}, {9, 11, 1}, {8, 10, 3}, {9, 11, 2}, {0, 8, 4}, {1, 9, 5}, {0, 10, 7}, {1, 11, 6}, {2, 9, 7}, {3, 8, 6}, {2, 11, 4}, {3, 10, 5}};
        UNIT_TETRAHEDRON_VERTICES = new float[TETRAHEDRON_VERTICES.length][];
        UNIT_TETRAHEDRON_VERTICES_D = new double[TETRAHEDRON_VERTICES_D.length][];
        UNIT_CUBE_VERTICES = new float[CUBE_VERTICES.length][];
        UNIT_CUBE_VERTICES_D = new double[CUBE_VERTICES_D.length][];
        UNIT_OCTAHEDRON_VERTICES = new float[OCTAHEDRON_VERTICES.length][];
        UNIT_OCTAHEDRON_VERTICES_D = new double[OCTAHEDRON_VERTICES_D.length][];
        UNIT_DODECAHEDRON_VERTICES = new float[DODECAHEDRON_VERTICES.length][];
        UNIT_DODECAHEDRON_VERTICES_D = new double[DODECAHEDRON_VERTICES_D.length][];
        UNIT_ICOSAHEDRON_VERTICES = new float[ICOSAHEDRON_VERTICES.length][];
        UNIT_ICOSAHEDRON_VERTICES_D = new double[ICOSAHEDRON_VERTICES_D.length][];
        for (i = 0; i < TETRAHEDRON_VERTICES.length; ++i) {
            ShapeTools.UNIT_TETRAHEDRON_VERTICES[i] = ShapeTools.nor(TETRAHEDRON_VERTICES[i]);
            ShapeTools.UNIT_TETRAHEDRON_VERTICES_D[i] = ShapeTools.nor_d(TETRAHEDRON_VERTICES_D[i]);
        }
        for (i = 0; i < CUBE_VERTICES.length; ++i) {
            ShapeTools.UNIT_CUBE_VERTICES[i] = ShapeTools.nor(CUBE_VERTICES[i]);
            ShapeTools.UNIT_CUBE_VERTICES_D[i] = ShapeTools.nor_d(CUBE_VERTICES_D[i]);
        }
        for (i = 0; i < OCTAHEDRON_VERTICES.length; ++i) {
            ShapeTools.UNIT_OCTAHEDRON_VERTICES[i] = ShapeTools.nor(OCTAHEDRON_VERTICES[i]);
            ShapeTools.UNIT_OCTAHEDRON_VERTICES_D[i] = ShapeTools.nor_d(OCTAHEDRON_VERTICES_D[i]);
        }
        for (i = 0; i < DODECAHEDRON_VERTICES.length; ++i) {
            ShapeTools.UNIT_DODECAHEDRON_VERTICES[i] = ShapeTools.nor(DODECAHEDRON_VERTICES[i]);
            ShapeTools.UNIT_DODECAHEDRON_VERTICES_D[i] = ShapeTools.nor_d(DODECAHEDRON_VERTICES_D[i]);
        }
        for (i = 0; i < ICOSAHEDRON_VERTICES.length; ++i) {
            ShapeTools.UNIT_ICOSAHEDRON_VERTICES[i] = ShapeTools.nor(ICOSAHEDRON_VERTICES[i]);
            ShapeTools.UNIT_ICOSAHEDRON_VERTICES_D[i] = ShapeTools.nor_d(ICOSAHEDRON_VERTICES_D[i]);
        }
    }
}

