/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.TextTools;

public final class Stringf {
    private Stringf() {
    }

    public static StringBuilder appendf(String fmt, Object ... args) {
        return Stringf.appendf(new StringBuilder(fmt.length()), fmt, args);
    }

    public static StringBuilder appendf(StringBuilder sb, String fmt, Object ... args) {
        int len = fmt.length();
        int arg = 0;
        for (int i = 0; i < len; ++i) {
            char curr = fmt.charAt(i);
            if (curr == '%') {
                String num;
                if ((curr = fmt.charAt(++i)) == '%') {
                    sb.append('%');
                    continue;
                }
                if (curr == 's') {
                    sb.append(args[arg++].toString());
                    continue;
                }
                if (curr == 'd') {
                    sb.append(((Number)args[arg++]).longValue());
                    continue;
                }
                if (curr == 'f') {
                    double d;
                    Base.BASE10.appendDecimal(sb, d, (d = ((Number)args[arg++]).doubleValue()) < 0.0 ? 6 : 5);
                    continue;
                }
                if (curr == 'x') {
                    sb.append(Base.BASE16.signed(((Number)args[arg++]).longValue()).toLowerCase());
                    continue;
                }
                if (curr == 'X') {
                    Base.BASE16.appendSigned(sb, ((Number)args[arg++]).longValue());
                    continue;
                }
                if (curr == '0') {
                    if ((curr = fmt.charAt(++i)) == 'x') {
                        sb.append(Base.BASE16.unsigned(((Number)args[arg++]).longValue()).toLowerCase());
                        continue;
                    }
                    if (curr == 'X') {
                        Base.BASE16.appendUnsigned(sb, ((Number)args[arg++]).longValue());
                        continue;
                    }
                    int length = Base.BASE10.readInt(fmt, i, len);
                    while ((curr = fmt.charAt(++i)) >= '0' && curr <= '9') {
                    }
                    if (curr == 'x') {
                        sb.append(TextTools.safeSubstring(Base.BASE16.unsigned(((Number)args[arg++]).longValue()), 16 - length, 16).toLowerCase());
                        continue;
                    }
                    if (curr == 'X') {
                        sb.append(TextTools.safeSubstring(Base.BASE16.unsigned(((Number)args[arg++]).longValue()), 16 - length, 16));
                        continue;
                    }
                    if (curr != 'd') continue;
                    num = Base.BASE10.unsigned(((Number)args[arg++]).longValue());
                    sb.append(TextTools.safeSubstring(num, num.length() - length, num.length()));
                    continue;
                }
                if (curr == '.') {
                    if ((curr = fmt.charAt(++i)) == 'f') {
                        Base.BASE10.appendDecimal(sb, ((Number)args[arg++]).doubleValue());
                        continue;
                    }
                    int precision = Base.BASE10.readInt(fmt, i, len);
                    while ((curr = fmt.charAt(++i)) >= '0' && curr <= '9') {
                    }
                    if (curr != 'f') continue;
                    double d = ((Number)args[arg++]).doubleValue();
                    Base.BASE10.appendDecimal(sb, d, -10000, precision);
                    continue;
                }
                if (curr < '1' || curr > '9') continue;
                int length = Base.BASE10.readInt(fmt, i, len);
                while ((curr = fmt.charAt(++i)) >= '0' && curr <= '9') {
                }
                if (curr == 'x') {
                    num = Base.BASE16.signed(((Number)args[arg++]).longValue());
                    sb.append(TextTools.safeSubstring(num, num.length() - length, num.length()).toLowerCase());
                    continue;
                }
                if (curr == 'X') {
                    num = Base.BASE16.signed(((Number)args[arg++]).longValue());
                    sb.append(TextTools.safeSubstring(num, num.length() - length, num.length()));
                    continue;
                }
                if (curr != 'd') continue;
                num = Base.BASE10.signed(((Number)args[arg++]).longValue());
                sb.append(TextTools.safeSubstring(num, num.length() - length, num.length()));
                continue;
            }
            sb.append(curr);
        }
        return sb;
    }

    public static String format(String fmt, Object ... args) {
        return Stringf.appendf(fmt, args).toString();
    }

    public static void printf(String fmt, Object ... args) {
        System.out.print(Stringf.appendf(fmt, args));
    }

    public static void printfn(String fmt, Object ... args) {
        System.out.println(Stringf.appendf(fmt, args));
    }
}

