/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

import java.util.Iterator;

public final class TextTools {
    private TextTools() {
    }

    public static String joinArrays(CharSequence delimiter, char[] ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static StringBuilder appendJoinedArrays(StringBuilder sb, CharSequence delimiter, char[] ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static String joinDense(boolean ... elements) {
        return TextTools.joinDense('1', '0', elements);
    }

    public static String joinDense(char t, char f, boolean ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i] ? t : f);
        }
        return sb.toString();
    }

    public static String joinDense(boolean[] elements, int start, int length) {
        return TextTools.joinDense('1', '0', elements, start, length);
    }

    public static String joinDense(char t, char f, boolean[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        for (int c = 0; c < length && start < elements.length; ++start, ++c) {
            sb.append(elements[start] ? t : f);
        }
        return sb.toString();
    }

    public static StringBuilder appendJoinedDense(StringBuilder sb, boolean ... elements) {
        return TextTools.appendJoinedDense(sb, '1', '0', elements);
    }

    public static StringBuilder appendJoinedDense(StringBuilder sb, char t, char f, boolean ... elements) {
        if (sb == null || elements == null) {
            return sb;
        }
        if (elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i] ? t : f);
        }
        return sb;
    }

    public static StringBuilder appendJoinedDense(StringBuilder sb, boolean[] elements, int start, int length) {
        return TextTools.appendJoinedDense(sb, '1', '0', elements, start, length);
    }

    public static StringBuilder appendJoinedDense(StringBuilder sb, char t, char f, boolean[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        for (int c = 0; c < length && start < elements.length; ++start, ++c) {
            sb.append(elements[start] ? t : f);
        }
        return sb;
    }

    public static boolean[] booleanSplitDense(CharSequence source) {
        return TextTools.booleanSplitDense(source, '1', 0, source.length());
    }

    public static boolean[] booleanSplitDense(CharSequence source, char t) {
        return TextTools.booleanSplitDense(source, t, 0, source.length());
    }

    public static boolean[] booleanSplitDense(CharSequence source, int startIndex, int endIndex) {
        return TextTools.booleanSplitDense(source, '1', startIndex, endIndex);
    }

    public static boolean[] booleanSplitDense(CharSequence source, char t, int startIndex, int endIndex) {
        if (endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new boolean[0];
        }
        endIndex = Math.min(endIndex, source.length());
        int amount = endIndex - startIndex;
        boolean[] splat = new boolean[amount];
        for (int i = 0; i < amount; ++i) {
            if (source.charAt(startIndex++) != t) continue;
            splat[i] = true;
        }
        return splat;
    }

    public static String join(CharSequence delimiter, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        sb.append(elements[0]);
        if (delimiter == null) {
            delimiter = "";
        }
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public String join(CharSequence delimiter, Object[] elements, int start, int length) {
        if (elements == null || elements.length <= start || length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 3);
        sb.append(elements[start]);
        if (delimiter == null) {
            delimiter = "";
        }
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter).append(elements[start]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Iterable<?> elements) {
        if (elements == null) {
            return "";
        }
        Iterator<?> it = elements.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(it.next());
        if (delimiter == null) {
            delimiter = "";
        }
        while (it.hasNext()) {
            sb.append(delimiter).append(it.next());
        }
        return sb.toString();
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, Object[] elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        if (delimiter == null) {
            delimiter = "";
        }
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, Object[] elements, int start, int length) {
        if (sb == null || elements == null || elements.length <= start || length <= 0) {
            return sb;
        }
        sb.append(elements[start]);
        if (delimiter == null) {
            delimiter = "";
        }
        ++start;
        for (int c = 1; c < length && start < elements.length; ++start, ++c) {
            sb.append(delimiter).append(elements[start]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, Iterable<?> elements) {
        if (sb == null || elements == null) {
            return sb;
        }
        Iterator<?> it = elements.iterator();
        if (!it.hasNext()) {
            return sb;
        }
        sb.append(it.next());
        if (delimiter == null) {
            delimiter = "";
        }
        while (it.hasNext()) {
            sb.append(delimiter).append(it.next());
        }
        return sb;
    }

    public static boolean contains(CharSequence text, CharSequence search) {
        return text != null && text.length() != 0 && search != null && search.length() != 0 && TextTools.containsPart(text, search) == search.length();
    }

    public static int containsPart(CharSequence text, CharSequence search) {
        if (text == null || text.length() == 0 || search == null || search.length() == 0) {
            return 0;
        }
        int sl = search.length();
        int tl = text.length() - sl;
        int f = 0;
        char s = search.charAt(0);
        block0: for (int i = 0; i <= tl; ++i) {
            if (text.charAt(i) != s) continue;
            int j = i + 1;
            for (int x = 1; x < sl; ++x) {
                if (text.charAt(j) != search.charAt(x)) {
                    f = Math.max(f, x);
                    continue block0;
                }
                ++j;
            }
            return sl;
        }
        return f;
    }

    public static boolean contains(CharSequence text, char[] search) {
        return text != null && text.length() != 0 && search != null && search.length != 0 && TextTools.containsPart(text, search) == search.length;
    }

    public static int containsPart(CharSequence text, char[] search) {
        if (text == null || text.length() == 0 || search == null || search.length == 0) {
            return 0;
        }
        int sl = search.length;
        int tl = text.length() - sl;
        int f = 0;
        char s = search[0];
        block0: for (int i = 0; i <= tl; ++i) {
            if (text.charAt(i) != s) continue;
            int j = i + 1;
            for (int x = 1; x < sl; ++x) {
                if (text.charAt(j) != search[x]) {
                    f = Math.max(f, x);
                    continue block0;
                }
                ++j;
            }
            return sl;
        }
        return f;
    }

    public static String replace(CharSequence text, CharSequence before, CharSequence after) {
        return text.toString().replace(before, after);
    }

    public static int count(String source, String search) {
        if (source == null || search == null || source.isEmpty() || search.isEmpty()) {
            return 0;
        }
        int amount = 0;
        int idx = -1;
        while ((idx = source.indexOf(search, idx + 1)) >= 0) {
            ++amount;
        }
        return amount;
    }

    public static int count(String source, int searchChar) {
        if (source == null || source.isEmpty()) {
            return 0;
        }
        int amount = 0;
        int idx = -1;
        while ((idx = source.indexOf(searchChar, idx + 1)) >= 0) {
            ++amount;
        }
        return amount;
    }

    public static int count(String source, String search, int startIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = Integer.MAX_VALUE;
        }
        if (source == null || search == null || source.isEmpty() || search.isEmpty() || startIndex < 0 || startIndex >= endIndex) {
            return 0;
        }
        int amount = 0;
        int idx = startIndex - 1;
        int slen = search.length();
        while ((idx = source.indexOf(search, idx + 1)) >= 0 && idx + slen <= endIndex) {
            ++amount;
        }
        return amount;
    }

    public static int count(String source, int searchChar, int startIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = Integer.MAX_VALUE;
        }
        if (source == null || source.isEmpty() || startIndex < 0 || startIndex >= endIndex) {
            return 0;
        }
        int amount = 0;
        int idx = startIndex - 1;
        while ((idx = source.indexOf(searchChar, idx + 1)) >= 0 && idx < endIndex) {
            ++amount;
        }
        return amount;
    }

    public static String safeSubstring(String source, int beginIndex, int endIndex) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > source.length()) {
            endIndex = source.length();
        }
        if (beginIndex >= endIndex) {
            return "";
        }
        return source.substring(beginIndex, endIndex);
    }

    public static String[] split(String source, String delimiter) {
        int amount = TextTools.count(source, delimiter);
        if (amount <= 0) {
            return new String[]{source};
        }
        String[] splat = new String[amount + 1];
        int dl = delimiter.length();
        int idx = -dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = TextTools.safeSubstring(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 ? TextTools.safeSubstring(source, idx + dl, source.length()) : TextTools.safeSubstring(source, idx + dl, idx2);
        return splat;
    }

    public static String[] split(String source, String delimiter, int startIndex, int endIndex) {
        if (source == null || delimiter == null || endIndex <= startIndex || startIndex < 0 || startIndex >= source.length()) {
            return new String[0];
        }
        int amount = TextTools.count(source, delimiter, startIndex, endIndex = Math.min(endIndex, source.length()));
        if (amount <= 0) {
            return new String[]{source.substring(startIndex, endIndex)};
        }
        String[] splat = new String[amount + 1];
        int dl = delimiter.length();
        int idx = startIndex - dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = TextTools.safeSubstring(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 ? TextTools.safeSubstring(source, idx + dl, endIndex) : TextTools.safeSubstring(source, idx + dl, idx2);
        return splat;
    }

    public static String padRight(String text, int minimumLength) {
        if (text.length() < minimumLength) {
            return TextTools.padRightStrict(text, ' ', minimumLength);
        }
        return text;
    }

    public static String padRight(String text, char padChar, int minimumLength) {
        if (text.length() < minimumLength) {
            return TextTools.padRightStrict(text, padChar, minimumLength);
        }
        return text;
    }

    public static String padRightStrict(String text, int totalLength) {
        return TextTools.padRightStrict(text, ' ', totalLength);
    }

    public static String padRightStrict(String text, char padChar, int totalLength) {
        char[] c = new char[totalLength];
        int len = text.length();
        text.getChars(0, Math.min(len, totalLength), c, 0);
        for (int i = len; i < totalLength; ++i) {
            c[i] = padChar;
        }
        return String.valueOf(c);
    }

    public static String padLeft(String text, int minimumLength) {
        if (text.length() < minimumLength) {
            return TextTools.padLeftStrict(text, ' ', minimumLength);
        }
        return text;
    }

    public static String padLeft(String text, char padChar, int minimumLength) {
        if (text.length() < minimumLength) {
            return TextTools.padLeftStrict(text, padChar, minimumLength);
        }
        return text;
    }

    public static String padLeftStrict(String text, int totalLength) {
        return TextTools.padLeftStrict(text, ' ', totalLength);
    }

    public static String padLeftStrict(String text, char padChar, int totalLength) {
        char[] c = new char[totalLength];
        int len = text.length();
        text.getChars(0, Math.min(len, totalLength), c, Math.max(0, totalLength - len));
        for (int i = totalLength - len - 1; i >= 0; --i) {
            c[i] = padChar;
        }
        return String.valueOf(c);
    }

    public static String repeat(CharSequence item, int amount) {
        if (item == null) {
            return null;
        }
        return TextTools.appendRepeated(new StringBuilder(item.length() * amount), item, amount).toString();
    }

    public static StringBuilder appendRepeated(StringBuilder sb, CharSequence item, int amount) {
        if (sb == null || item == null || amount <= 0) {
            return sb;
        }
        for (int i = 0; i < amount; ++i) {
            sb.append(item);
        }
        return sb;
    }
}

