/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.digital;

public final class TrigTools {
    public static final float PI = (float)Math.PI;
    public static final double PI_D = Math.PI;
    public static final float PI_INVERSE = 0.31830987f;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float TAU = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float ETA = 1.5707964f;
    public static final double PI_INVERSE_D = 0.3183098861837907;
    public static final double PI2_D = Math.PI * 2;
    public static final double TAU_D = Math.PI * 2;
    public static final double HALF_PI_D = 1.5707963267948966;
    public static final double ETA_D = 1.5707963267948966;
    public static final float QUARTER_PI = 0.7853982f;
    public static final double QUARTER_PI_D = 0.7853981633974483;
    public static final int TABLE_BITS = 14;
    public static final int TABLE_SIZE = 16384;
    public static final int SIN_TO_COS = 4096;
    public static final int QUARTER_CIRCLE_INDEX = 4096;
    public static final int TABLE_MASK = 16383;
    public static final float radToIndex = 2607.5945f;
    public static final float degToIndex = 45.511112f;
    public static final float turnToIndex = 16384.0f;
    public static final double radToIndexD = 2607.5945876176133;
    public static final double degToIndexD = 45.51111111111111;
    public static final double turnToIndexD = 16384.0;
    public static final double radiansToDegreesD = 57.29577951308232;
    public static final double degreesToRadiansD = Math.PI / 180;
    public static final float radiansToDegrees = 57.29578f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float[] SIN_TABLE = new float[16385];
    public static final double[] SIN_TABLE_D = new double[16385];
    public static final float[] COS_TABLE = new float[16385];
    public static final double[] COS_TABLE_D = new double[16385];

    private TrigTools() {
    }

    public static int radiansToTableIndex(float radians) {
        return (int)(radians * 2607.5945f + 16384.5f) & 0x3FFF;
    }

    public static int degreesToTableIndex(float degrees) {
        return (int)(degrees * 45.511112f + 16384.5f) & 0x3FFF;
    }

    public static int turnsToTableIndex(float turns) {
        return (int)(turns * 16384.0f + 16384.5f) & 0x3FFF;
    }

    public static int radiansToTableIndex(double radians) {
        return (int)(radians * 2607.5945876176133 + 16384.5) & 0x3FFF;
    }

    public static int degreesToTableIndex(double degrees) {
        return (int)(degrees * 45.51111111111111 + 16384.5) & 0x3FFF;
    }

    public static int turnsToTableIndex(double turns) {
        return (int)(turns * 16384.0 + 16384.5) & 0x3FFF;
    }

    public static float sin(float radians) {
        return SIN_TABLE[(int)(radians * 2607.5945f + 16384.5f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return COS_TABLE[(int)(radians * 2607.5945f + 16384.5f) & 0x3FFF];
    }

    public static float tan(float radians) {
        radians *= 0.31830987f;
        radians += 0.5f;
        radians -= (float)((int)((double)radians + 16384.0) - 16384);
        radians -= 0.5f;
        float x2 = (radians *= (float)Math.PI) * radians;
        float x4 = x2 * x2;
        return radians * (0.0010582011f * x4 - 0.11111111f * x2 + 1.0f) / (0.015873017f * x4 - 0.44444445f * x2 + 1.0f);
    }

    public static float sinDeg(float degrees) {
        return SIN_TABLE[(int)(degrees * 45.511112f + 16384.5f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return COS_TABLE[(int)(degrees * 45.511112f + 16384.5f) & 0x3FFF];
    }

    public static float tanDeg(float degrees) {
        degrees *= 0.0055555557f;
        degrees += 0.5f;
        degrees -= (float)((int)((double)degrees + 16384.0) - 16384);
        degrees -= 0.5f;
        float x2 = (degrees *= (float)Math.PI) * degrees;
        float x4 = x2 * x2;
        return degrees * (0.0010582011f * x4 - 0.11111111f * x2 + 1.0f) / (0.015873017f * x4 - 0.44444445f * x2 + 1.0f);
    }

    public static float sinTurns(float turns) {
        return SIN_TABLE[(int)(turns * 16384.0f + 16384.5f) & 0x3FFF];
    }

    public static float cosTurns(float turns) {
        return COS_TABLE[(int)(turns * 16384.0f + 16384.5f) & 0x3FFF];
    }

    public static float tanTurns(float turns) {
        turns += turns;
        turns += 0.5f;
        turns -= (float)((int)((double)turns + 16384.0) - 16384);
        turns -= 0.5f;
        float x2 = (turns *= (float)Math.PI) * turns;
        float x4 = x2 * x2;
        return turns * (0.0010582011f * x4 - 0.11111111f * x2 + 1.0f) / (0.015873017f * x4 - 0.44444445f * x2 + 1.0f);
    }

    public static double sin(double radians) {
        return SIN_TABLE_D[(int)(radians * 2607.5945876176133 + 16384.5) & 0x3FFF];
    }

    public static double cos(double radians) {
        return COS_TABLE_D[(int)(radians * 2607.5945876176133 + 16384.5) & 0x3FFF];
    }

    public static double tan(double radians) {
        radians *= 0.3183098861837907;
        radians += 0.5;
        radians -= Math.floor(radians);
        radians -= 0.5;
        double x2 = (radians *= Math.PI) * radians;
        double x4 = x2 * x2;
        return radians * (0.0010582010582010583 * x4 - 0.1111111111111111 * x2 + 1.0) / (0.015873015873015872 * x4 - 0.4444444444444444 * x2 + 1.0);
    }

    public static double sinDeg(double degrees) {
        return SIN_TABLE_D[(int)(degrees * 45.51111111111111 + 16384.5) & 0x3FFF];
    }

    public static double cosDeg(double degrees) {
        return COS_TABLE_D[(int)(degrees * 45.51111111111111 + 16384.5) & 0x3FFF];
    }

    public static double tanDeg(double degrees) {
        degrees *= 0.005555555555555556;
        degrees += 0.5;
        degrees -= Math.floor(degrees);
        degrees -= 0.5;
        double x2 = (degrees *= Math.PI) * degrees;
        double x4 = x2 * x2;
        return degrees * (0.0010582010582010583 * x4 - 0.1111111111111111 * x2 + 1.0) / (0.015873015873015872 * x4 - 0.4444444444444444 * x2 + 1.0);
    }

    public static double sinTurns(double turns) {
        return SIN_TABLE_D[(int)(turns * 16384.0 + 16384.5) & 0x3FFF];
    }

    public static double cosTurns(double turns) {
        return COS_TABLE_D[(int)(turns * 16384.0 + 16384.5) & 0x3FFF];
    }

    public static double tanTurns(double turns) {
        turns += turns;
        turns += 0.5;
        turns -= Math.floor(turns);
        turns -= 0.5;
        double x2 = (turns *= Math.PI) * turns;
        double x4 = x2 * x2;
        return turns * (0.0010582010582010583 * x4 - 0.1111111111111111 * x2 + 1.0) / (0.015873015873015872 * x4 - 0.4444444444444444 * x2 + 1.0);
    }

    public static float sinSmooth(float radians) {
        int ceil = (int)Math.ceil(radians *= 0.63661975f) & 0xFFFFFFFE;
        float x2 = (radians -= (float)ceil) * radians;
        return radians * (137.9199f + x2 * -35.84f) / (87.802f + x2 * (13.288f + x2)) * (float)(1 - (ceil & 2));
    }

    public static float cosSmooth(float radians) {
        radians = Math.abs(radians * 0.63661975f);
        int floor = (int)radians | 1;
        float x2 = (radians -= (float)floor) * radians;
        return radians * (137.9199f + x2 * -35.84f) / (87.802f + x2 * (13.288f + x2)) * (float)((floor & 2) - 1);
    }

    public static double sinSmooth(double radians) {
        int ceil = (int)Math.ceil(radians *= 0.6366197723675814) & 0xFFFFFFFE;
        double x2 = (radians -= (double)ceil) * radians;
        return radians * (137.9199 + x2 * -35.84) / (87.802 + x2 * (13.288 + x2)) * (double)(1 - (ceil & 2));
    }

    public static double cosSmooth(double radians) {
        radians = Math.abs(radians * 0.6366197723675814);
        int floor = (int)radians | 1;
        double x2 = (radians -= (double)floor) * radians;
        return radians * (137.9199 + x2 * -35.84) / (87.802 + x2 * (13.288 + x2)) * (double)((floor & 2) - 1);
    }

    public static float sinSmoothDeg(float degrees) {
        int ceil = (int)Math.ceil(degrees *= 0.011111111f) & 0xFFFFFFFE;
        float x2 = (degrees -= (float)ceil) * degrees;
        return degrees * (137.9199f + x2 * -35.84f) / (87.802f + x2 * (13.288f + x2)) * (float)(1 - (ceil & 2));
    }

    public static float cosSmoothDeg(float degrees) {
        degrees = Math.abs(degrees * 0.011111111f);
        int floor = (int)degrees | 1;
        float x2 = (degrees -= (float)floor) * degrees;
        return degrees * (137.9199f + x2 * -35.84f) / (87.802f + x2 * (13.288f + x2)) * (float)((floor & 2) - 1);
    }

    public static double sinSmoothDeg(double degrees) {
        int ceil = (int)Math.ceil(degrees *= 0.011111111111111112) & 0xFFFFFFFE;
        double x2 = (degrees -= (double)ceil) * degrees;
        return degrees * (137.9199 + x2 * -35.84) / (87.802 + x2 * (13.288 + x2)) * (double)(1 - (ceil & 2));
    }

    public static double cosSmoothDeg(double degrees) {
        degrees = Math.abs(degrees * 0.011111111111111112);
        int floor = (int)degrees | 1;
        double x2 = (degrees -= (double)floor) * degrees;
        return degrees * (137.9199 + x2 * -35.84) / (87.802 + x2 * (13.288 + x2)) * (double)(1 - (floor & 2));
    }

    public static float sinSmoothTurns(float turns) {
        int ceil = (int)Math.ceil(turns *= 4.0f) & 0xFFFFFFFE;
        float x2 = (turns -= (float)ceil) * turns;
        return turns * (137.9199f + x2 * -35.84f) / (87.802f + x2 * (13.288f + x2)) * (float)(1 - (ceil & 2));
    }

    public static float cosSmoothTurns(float turns) {
        turns = Math.abs(turns * 4.0f);
        int floor = (int)turns | 1;
        float x2 = (turns -= (float)floor) * turns;
        return turns * (137.9199f + x2 * -35.84f) / (87.802f + x2 * (13.288f + x2)) * (float)((floor & 2) - 1);
    }

    public static double sinSmoothTurns(double turns) {
        int ceil = (int)Math.ceil(turns *= 4.0) & 0xFFFFFFFE;
        double x2 = (turns -= (double)ceil) * turns;
        return turns * (137.9199 + x2 * -35.84) / (87.802 + x2 * (13.288 + x2)) * (double)(1 - (ceil & 2));
    }

    public static double cosSmoothTurns(double turns) {
        turns = Math.abs(turns * 4.0);
        int floor = (int)turns | 1;
        double x2 = (turns -= (double)floor) * turns;
        return turns * (137.9199 + x2 * -35.84) / (87.802 + x2 * (13.288 + x2)) * (double)(1 - (floor & 2));
    }

    public static float sinSmoother(float radians) {
        int floor = (int)((radians *= 2607.5945f) + 16384.0f) - 16384;
        int masked = floor & 0x3FFF;
        float from = SIN_TABLE[masked];
        float to = SIN_TABLE[masked + 1];
        return from + (to - from) * (radians - (float)floor);
    }

    public static double sinSmoother(double radians) {
        radians = radians * 2607.5945876176133 + 16384.0;
        int floor = (int)radians;
        int masked = floor & 0x3FFF;
        double from = SIN_TABLE_D[masked];
        double to = SIN_TABLE_D[masked + 1];
        return from + (to - from) * (radians - (double)floor);
    }

    public static float cosSmoother(float radians) {
        radians = Math.abs(radians) * 2607.5945f;
        int floor = (int)radians;
        int masked = floor & 0x3FFF;
        float from = COS_TABLE[masked];
        float to = COS_TABLE[masked + 1];
        return from + (to - from) * (radians - (float)floor);
    }

    public static double cosSmoother(double radians) {
        radians = Math.abs(radians) * 2607.5945876176133;
        int floor = (int)radians;
        int masked = floor & 0x3FFF;
        double from = COS_TABLE_D[masked];
        double to = COS_TABLE_D[masked + 1];
        return from + (to - from) * (radians - (double)floor);
    }

    public static float tanSmoother(float radians) {
        int floor = (int)((double)(radians *= 2607.5945f) + 16384.0) - 16384;
        int masked = floor & 0x3FFF;
        float fromS = SIN_TABLE[masked];
        float toS = SIN_TABLE[masked + 1];
        float fromC = COS_TABLE[masked];
        float toC = COS_TABLE[masked + 1];
        return (fromS + (toS - fromS) * (radians -= (float)floor)) / (fromC + (toC - fromC) * radians);
    }

    public static double tanSmoother(double radians) {
        radians = radians * 2607.5945876176133 + 16384.0;
        int floor = (int)radians;
        int masked = floor & 0x3FFF;
        double fromS = SIN_TABLE_D[masked];
        double toS = SIN_TABLE_D[masked + 1];
        double fromC = COS_TABLE_D[masked];
        double toC = COS_TABLE_D[masked + 1];
        return (fromS + (toS - fromS) * (radians -= (double)floor)) / (fromC + (toC - fromC) * radians);
    }

    public static float sinSmootherDeg(float degrees) {
        int floor = (int)((degrees *= 45.511112f) + 16384.0f) - 16384;
        int masked = floor & 0x3FFF;
        float from = SIN_TABLE[masked];
        float to = SIN_TABLE[masked + 1];
        return from + (to - from) * (degrees - (float)floor);
    }

    public static double sinSmootherDeg(double degrees) {
        degrees = degrees * 45.51111111111111 + 16384.0;
        int floor = (int)degrees;
        int masked = floor & 0x3FFF;
        double from = SIN_TABLE_D[masked];
        double to = SIN_TABLE_D[masked + 1];
        return from + (to - from) * (degrees - (double)floor);
    }

    public static float cosSmootherDeg(float degrees) {
        degrees = Math.abs(degrees) * 45.511112f;
        int floor = (int)degrees;
        int masked = floor & 0x3FFF;
        float from = COS_TABLE[masked];
        float to = COS_TABLE[masked + 1];
        return from + (to - from) * (degrees - (float)floor);
    }

    public static double cosSmootherDeg(double degrees) {
        degrees = Math.abs(degrees) * 45.51111111111111;
        int floor = (int)degrees;
        int masked = floor & 0x3FFF;
        double from = COS_TABLE_D[masked];
        double to = COS_TABLE_D[masked + 1];
        return from + (to - from) * (degrees - (double)floor);
    }

    public static float tanSmootherDeg(float degrees) {
        int floor = (int)((double)(degrees *= 45.511112f) + 16384.0) - 16384;
        int masked = floor & 0x3FFF;
        float fromS = SIN_TABLE[masked];
        float toS = SIN_TABLE[masked + 1];
        float fromC = COS_TABLE[masked];
        float toC = COS_TABLE[masked + 1];
        return (fromS + (toS - fromS) * (degrees -= (float)floor)) / (fromC + (toC - fromC) * degrees);
    }

    public static double tanSmootherDeg(double degrees) {
        degrees = degrees * 45.51111111111111 + 16384.0;
        int floor = (int)degrees;
        int masked = floor & 0x3FFF;
        double fromS = SIN_TABLE_D[masked];
        double toS = SIN_TABLE_D[masked + 1];
        double fromC = COS_TABLE_D[masked];
        double toC = COS_TABLE_D[masked + 1];
        return (fromS + (toS - fromS) * (degrees -= (double)floor)) / (fromC + (toC - fromC) * degrees);
    }

    public static float sinSmootherTurns(float turns) {
        int floor = (int)((turns *= 16384.0f) + 16384.0f) - 16384;
        int masked = floor & 0x3FFF;
        float from = SIN_TABLE[masked];
        float to = SIN_TABLE[masked + 1];
        return from + (to - from) * (turns - (float)floor);
    }

    public static double sinSmootherTurns(double turns) {
        turns = turns * 16384.0 + 16384.0;
        int floor = (int)turns;
        int masked = floor & 0x3FFF;
        double from = SIN_TABLE_D[masked];
        double to = SIN_TABLE_D[masked + 1];
        return from + (to - from) * (turns - (double)floor);
    }

    public static float cosSmootherTurns(float turns) {
        turns = Math.abs(turns) * 16384.0f;
        int floor = (int)turns;
        int masked = floor & 0x3FFF;
        float from = COS_TABLE[masked];
        float to = COS_TABLE[masked + 1];
        return from + (to - from) * (turns - (float)floor);
    }

    public static double cosSmootherTurns(double turns) {
        turns = Math.abs(turns) * 16384.0;
        int floor = (int)turns;
        int masked = floor & 0x3FFF;
        double from = COS_TABLE_D[masked];
        double to = COS_TABLE_D[masked + 1];
        return from + (to - from) * (turns - (double)floor);
    }

    public static float tanSmootherTurns(float turns) {
        int floor = (int)((double)(turns *= 16384.0f) + 16384.0) - 16384;
        int masked = floor & 0x3FFF;
        float fromS = SIN_TABLE[masked];
        float toS = SIN_TABLE[masked + 1];
        float fromC = COS_TABLE[masked];
        float toC = COS_TABLE[masked + 1];
        return (fromS + (toS - fromS) * (turns -= (float)floor)) / (fromC + (toC - fromC) * turns);
    }

    public static double tanSmootherTurns(double turns) {
        turns = turns * 16384.0 + 16384.0;
        int floor = (int)turns;
        int masked = floor & 0x3FFF;
        double fromS = SIN_TABLE_D[masked];
        double toS = SIN_TABLE_D[masked + 1];
        double fromC = COS_TABLE_D[masked];
        double toC = COS_TABLE_D[masked + 1];
        return (fromS + (toS - fromS) * (turns -= (double)floor)) / (fromC + (toC - fromC) * turns);
    }

    public static double atanUnchecked(double i) {
        double n = Math.abs(i);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return Math.signum(i) * (0.7853981633974483 + (0.99997726 * c - 0.33262347 * c3 + 0.19354346 * c5 - 0.11643287 * c7 + 0.05265332 * c9 - 0.0117212 * c11));
    }

    public static double atanUncheckedTurns(double i) {
        double n = Math.abs(i);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return Math.signum(i) * (0.125 + (0.15915132390848943 * c - 0.052938669438878753 * c3 + 0.030803398362108523 * c5 - 0.01853086679887605 * c7 + 0.008380036148199356 * c9 - 0.0018654869189687236 * c11));
    }

    public static double atanUncheckedDeg(double i) {
        double n = Math.abs(i);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return Math.signum(i) * (45.0 + (57.2944766070562 * c - 19.05792099799635 * c3 + 11.089223410359068 * c5 - 6.6711120475953765 * c7 + 3.016813013351768 * c9 - 0.6715752908287405 * c11));
    }

    public static float atan2(float y, float x) {
        float n = y / x;
        if (n != n) {
            n = y == x ? 1.0f : -1.0f;
        } else if (n - n != n - n) {
            x = 0.0f;
        }
        if (x > 0.0f) {
            return (float)TrigTools.atanUnchecked(n);
        }
        if (x < 0.0f) {
            if (y >= 0.0f) {
                return (float)(TrigTools.atanUnchecked(n) + Math.PI);
            }
            return (float)(TrigTools.atanUnchecked(n) - Math.PI);
        }
        if (y > 0.0f) {
            return x + 1.5707964f;
        }
        if (y < 0.0f) {
            return x - 1.5707964f;
        }
        return x + y;
    }

    public static float atan2Deg(float y, float x) {
        float n = y / x;
        if (n != n) {
            n = y == x ? 1.0f : -1.0f;
        } else if (n - n != n - n) {
            x = 0.0f;
        }
        if (x > 0.0f) {
            return (float)TrigTools.atanUncheckedDeg(n);
        }
        if (x < 0.0f) {
            if (y >= 0.0f) {
                return (float)(TrigTools.atanUncheckedDeg(n) + 180.0);
            }
            return (float)(TrigTools.atanUncheckedDeg(n) - 180.0);
        }
        if (y > 0.0f) {
            return x + 90.0f;
        }
        if (y < 0.0f) {
            return x - 90.0f;
        }
        return x + y;
    }

    public static float atan2Deg360(float y, float x) {
        float n = y / x;
        if (n != n) {
            n = y == x ? 1.0f : -1.0f;
        } else if (n - n != n - n) {
            x = 0.0f;
        }
        if (x > 0.0f) {
            if (y >= 0.0f) {
                return (float)TrigTools.atanUncheckedDeg(n);
            }
            return (float)(TrigTools.atanUncheckedDeg(n) + 360.0);
        }
        if (x < 0.0f) {
            return (float)(TrigTools.atanUncheckedDeg(n) + 180.0);
        }
        if (y > 0.0f) {
            return x + 90.0f;
        }
        if (y < 0.0f) {
            return x + 270.0f;
        }
        return x + y;
    }

    public static float atan2Turns(float y, float x) {
        float n = y / x;
        if (n != n) {
            n = y == x ? 1.0f : -1.0f;
        } else if (n - n != n - n) {
            x = 0.0f;
        }
        if (x > 0.0f) {
            if (y >= 0.0f) {
                return (float)TrigTools.atanUncheckedTurns(n);
            }
            return (float)(TrigTools.atanUncheckedTurns(n) + 1.0);
        }
        if (x < 0.0f) {
            return (float)(TrigTools.atanUncheckedTurns(n) + 0.5);
        }
        if (y > 0.0f) {
            return x + 0.25f;
        }
        if (y < 0.0f) {
            return x + 0.75f;
        }
        return x + y;
    }

    public static double atan2(double y, double x) {
        double n = y / x;
        if (n != n) {
            n = y == x ? 1.0 : -1.0;
        } else if (n - n != n - n) {
            x = 0.0;
        }
        if (x > 0.0) {
            return TrigTools.atanUnchecked(n);
        }
        if (x < 0.0) {
            if (y >= 0.0) {
                return TrigTools.atanUnchecked(n) + Math.PI;
            }
            return TrigTools.atanUnchecked(n) - Math.PI;
        }
        if (y > 0.0) {
            return x + 1.5707963267948966;
        }
        if (y < 0.0) {
            return x - 1.5707963267948966;
        }
        return x + y;
    }

    public static double atan2Deg(double y, double x) {
        double n = y / x;
        if (n != n) {
            n = y == x ? 1.0 : -1.0;
        } else if (n - n != n - n) {
            x = 0.0;
        }
        if (x > 0.0) {
            return TrigTools.atanUncheckedDeg(n);
        }
        if (x < 0.0) {
            if (y >= 0.0) {
                return TrigTools.atanUncheckedDeg(n) + 180.0;
            }
            return TrigTools.atanUncheckedDeg(n) - 180.0;
        }
        if (y > 0.0) {
            return x + 90.0;
        }
        if (y < 0.0) {
            return x - 90.0;
        }
        return x + y;
    }

    public static double atan2Deg360(double y, double x) {
        double n = y / x;
        if (n != n) {
            n = y == x ? 1.0 : -1.0;
        } else if (n - n != n - n) {
            x = 0.0;
        }
        if (x > 0.0) {
            if (y >= 0.0) {
                return TrigTools.atanUncheckedDeg(n);
            }
            return TrigTools.atanUncheckedDeg(n) + 360.0;
        }
        if (x < 0.0) {
            return TrigTools.atanUncheckedDeg(n) + 180.0;
        }
        if (y > 0.0) {
            return x + 90.0;
        }
        if (y < 0.0) {
            return x + 270.0;
        }
        return x + y;
    }

    public static double atan2Turns(double y, double x) {
        double n = y / x;
        if (n != n) {
            n = y == x ? 1.0 : -1.0;
        } else if (n - n != n - n) {
            x = 0.0;
        }
        if (x > 0.0) {
            if (y >= 0.0) {
                return TrigTools.atanUncheckedTurns(n);
            }
            return TrigTools.atanUncheckedTurns(n) + 1.0;
        }
        if (x < 0.0) {
            return TrigTools.atanUncheckedTurns(n) + 0.5;
        }
        if (y > 0.0) {
            return x + 0.25;
        }
        if (y < 0.0) {
            return x + 0.75;
        }
        return x + y;
    }

    public static float asin(float a) {
        if (a >= 0.0f) {
            return (float)(1.5707963267948966 - Math.sqrt(1.0 - (double)a) * (1.5707288 + (double)a * (-0.2121144 + (double)a * (0.074261 + (double)a * -0.0187293))));
        }
        return (float)(Math.sqrt(1.0 + (double)a) * (1.5707288 + (double)a * (0.2121144 + (double)a * (0.074261 + (double)a * 0.0187293))) - 1.5707963267948966);
    }

    public static float asinDeg(float a) {
        if (a >= 0.0f) {
            return (float)(90.0 - Math.sqrt(1.0 - (double)a) * (89.99613099964837 + (double)a * (-12.153259893949748 + (double)a * (4.2548418824210055 + (double)a * -1.0731098432343729))));
        }
        return (float)(Math.sqrt(1.0 + (double)a) * (89.99613099964837 + (double)a * (12.153259893949748 + (double)a * (4.2548418824210055 + (double)a * 1.0731098432343729))) - 90.0);
    }

    public static float asinTurns(float a) {
        if (a >= 0.0f) {
            return (float)(0.25 - Math.sqrt(1.0 - (double)a) * (0.24998925277680104 + (double)a * (-0.033759055260971525 + (double)a * (0.011819005228947238 + (double)a * -0.0029808606756510357))));
        }
        return (float)(Math.sqrt(1.0 + (double)a) * (0.24998925277680104 + (double)a * (0.033759055260971525 + (double)a * (0.011819005228947238 + (double)a * 0.0029808606756510357))) - 0.25);
    }

    public static float acos(float a) {
        if (a >= 0.0f) {
            return (float)(Math.sqrt(1.0 - (double)a) * (1.5707288 + (double)a * (-0.2121144 + (double)a * (0.074261 + (double)a * -0.0187293))));
        }
        return (float)(Math.PI - Math.sqrt(1.0 + (double)a) * (1.5707288 + (double)a * (0.2121144 + (double)a * (0.074261 + (double)a * 0.0187293))));
    }

    public static float acosDeg(float a) {
        if (a >= 0.0f) {
            return (float)(Math.sqrt(1.0 - (double)a) * (89.99613099964837 + (double)a * (-12.153259533621753 + (double)a * (4.254842010910525 + (double)a * -1.0731098035209208))));
        }
        return (float)(180.0 - Math.sqrt(1.0 + (double)a) * (89.99613099964837 + (double)a * (12.153259533621753 + (double)a * (4.254842010910525 + (double)a * 1.0731098035209208))));
    }

    public static float acosTurns(float a) {
        if (a >= 0.0f) {
            return (float)(Math.sqrt(1.0 - (double)a) * (0.24998925277680104 + (double)a * (-0.033759055260971525 + (double)a * (0.011819005228947238 + (double)a * -0.0029808606756510357))));
        }
        return (float)(0.5 - Math.sqrt(1.0 + (double)a) * (0.24998925277680104 + (double)a * (0.033759055260971525 + (double)a * (0.011819005228947238 + (double)a * 0.0029808606756510357))));
    }

    public static double asin(double a) {
        if (a >= 0.0) {
            return 1.5707963267948966 - Math.sqrt(1.0 - a) * (1.5707288 + a * (-0.2121144 + a * (0.074261 + a * -0.0187293)));
        }
        return Math.sqrt(1.0 + a) * (1.5707288 + a * (0.2121144 + a * (0.074261 + a * 0.0187293))) - 1.5707963267948966;
    }

    public static double asinDeg(double a) {
        if (a >= 0.0) {
            return 90.0 - Math.sqrt(1.0 - a) * (89.99613099964837 + a * (-12.153259893949748 + a * (4.2548418824210055 + a * -1.0731098432343729)));
        }
        return Math.sqrt(1.0 + a) * (89.99613099964837 + a * (12.153259893949748 + a * (4.2548418824210055 + a * 1.0731098432343729))) - 90.0;
    }

    public static double asinTurns(double a) {
        if (a >= 0.0) {
            return 0.25 - Math.sqrt(1.0 - a) * (0.24998925277680104 + a * (-0.033759055260971525 + a * (0.011819005228947238 + a * -0.0029808606756510357)));
        }
        return Math.sqrt(1.0 + a) * (0.24998925277680104 + a * (0.033759055260971525 + a * (0.011819005228947238 + a * 0.0029808606756510357))) - 0.25;
    }

    public static double acos(double a) {
        if (a >= 0.0) {
            return Math.sqrt(1.0 - a) * (1.5707288 + a * (-0.2121144 + a * (0.074261 + a * -0.0187293)));
        }
        return Math.PI - Math.sqrt(1.0 + a) * (1.5707288 + a * (0.2121144 + a * (0.074261 + a * 0.0187293)));
    }

    public static double acosDeg(double a) {
        if (a >= 0.0) {
            return Math.sqrt(1.0 - a) * (89.99613099964837 + a * (-12.153259533621753 + a * (4.254842010910525 + a * -1.0731098035209208)));
        }
        return 180.0 - Math.sqrt(1.0 + a) * (89.99613099964837 + a * (12.153259533621753 + a * (4.254842010910525 + a * 1.0731098035209208)));
    }

    public static double acosTurns(double a) {
        if (a >= 0.0) {
            return Math.sqrt(1.0 - a) * (0.24998925277680104 + a * (-0.033759055260971525 + a * (0.011819005228947238 + a * -0.0029808606756510357)));
        }
        return 0.5 - Math.sqrt(1.0 + a) * (0.24998925277680104 + a * (0.033759055260971525 + a * (0.011819005228947238 + a * 0.0029808606756510357)));
    }

    public static float atan(float i) {
        double n = Math.min((double)Math.abs(i), Double.MAX_VALUE);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return (float)((double)Math.signum(i) * (0.7853981633974483 + (0.99997726 * c - 0.33262347 * c3 + 0.19354346 * c5 - 0.11643287 * c7 + 0.05265332 * c9 - 0.0117212 * c11)));
    }

    public static float atanDeg(float i) {
        double n = Math.min((double)Math.abs(i), Double.MAX_VALUE);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return (float)((double)Math.signum(i) * (45.0 + (57.2944766070562 * c - 19.05792099799635 * c3 + 11.089223410359068 * c5 - 6.6711120475953765 * c7 + 3.016813013351768 * c9 - 0.6715752908287405 * c11)));
    }

    public static float atanTurns(float i) {
        double n = Math.min((double)Math.abs(i), Double.MAX_VALUE);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return (float)((double)Math.signum(i) * (0.125 + (0.15915132390848943 * c - 0.052938669438878753 * c3 + 0.030803398362108523 * c5 - 0.01853086679887605 * c7 + 0.008380036148199356 * c9 - 0.0018654869189687236 * c11)));
    }

    public static double atan(double i) {
        double n = Math.min(Math.abs(i), Double.MAX_VALUE);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return Math.signum(i) * (0.7853981633974483 + (0.99997726 * c - 0.33262347 * c3 + 0.19354346 * c5 - 0.11643287 * c7 + 0.05265332 * c9 - 0.0117212 * c11));
    }

    public static double atanDeg(double i) {
        double n = Math.min(Math.abs(i), Double.MAX_VALUE);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return Math.signum(i) * (45.0 + (57.2944766070562 * c - 19.05792099799635 * c3 + 11.089223410359068 * c5 - 6.6711120475953765 * c7 + 3.016813013351768 * c9 - 0.6715752908287405 * c11));
    }

    public static double atanTurns(double i) {
        double n = Math.min(Math.abs(i), Double.MAX_VALUE);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return Math.signum(i) * (0.125 + (0.15915132390848943 * c - 0.052938669438878753 * c3 + 0.030803398362108523 * c5 - 0.01853086679887605 * c7 + 0.008380036148199356 * c9 - 0.0018654869189687236 * c11));
    }

    static {
        for (int i = 0; i <= 16384; ++i) {
            double theta = (double)i / 16384.0 * (Math.PI * 2);
            TrigTools.SIN_TABLE_D[i] = Math.sin(theta);
            TrigTools.SIN_TABLE[i] = (float)TrigTools.SIN_TABLE_D[i];
            TrigTools.COS_TABLE_D[i] = Math.cos(theta);
            TrigTools.COS_TABLE[i] = (float)TrigTools.COS_TABLE_D[i];
        }
        TrigTools.SIN_TABLE[0] = 0.0f;
        TrigTools.SIN_TABLE[4096] = 1.0f;
        TrigTools.SIN_TABLE[8192] = 0.0f;
        TrigTools.SIN_TABLE[12288] = -1.0f;
        TrigTools.SIN_TABLE[16384] = 0.0f;
        TrigTools.SIN_TABLE_D[0] = 0.0;
        TrigTools.SIN_TABLE_D[4096] = 1.0;
        TrigTools.SIN_TABLE_D[8192] = 0.0;
        TrigTools.SIN_TABLE_D[12288] = -1.0;
        TrigTools.SIN_TABLE_D[16384] = 0.0;
        TrigTools.COS_TABLE[0] = 1.0f;
        TrigTools.COS_TABLE[4096] = 0.0f;
        TrigTools.COS_TABLE[8192] = -1.0f;
        TrigTools.COS_TABLE[12288] = 0.0f;
        TrigTools.COS_TABLE[16384] = 1.0f;
        TrigTools.COS_TABLE_D[0] = 1.0;
        TrigTools.COS_TABLE_D[4096] = 0.0;
        TrigTools.COS_TABLE_D[8192] = -1.0;
        TrigTools.COS_TABLE_D[12288] = 0.0;
        TrigTools.COS_TABLE_D[16384] = 1.0;
    }
}

