/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Node;

public abstract class Connection<V>
extends Edge<V> {
    Node<V> a;
    Node<V> b;
    float weight;

    Connection() {
    }

    @Override
    void set(Node<V> a, Node<V> b, float weight) {
        this.a = a;
        this.b = b;
        this.setWeight(weight);
    }

    @Override
    Node<V> getInternalNodeA() {
        return this.a;
    }

    @Override
    Node<V> getInternalNodeB() {
        return this.b;
    }

    @Override
    public V getA() {
        return this.a.getObject();
    }

    @Override
    public V getB() {
        return this.b.getObject();
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(float weight) {
        this.weight = weight;
    }

    public Node<V> getNodeA() {
        return this.a;
    }

    public Node<V> getNodeB() {
        return this.b;
    }

    public static class UndirectedConnection<V>
    extends Connection<V> {
        private UndirectedConnection<V> linked;

        @Override
        public boolean hasEndpoints(V u, V v) {
            return this.hasEndpoint(u) && this.hasEndpoint(v);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Connection edge = (Connection)o;
            return this.a.equals(edge.a) && this.b.equals(edge.b) || this.a.equals(edge.b) && this.b.equals(edge.a);
        }

        void link(UndirectedConnection<V> linked) {
            this.linked = linked;
        }

        @Override
        public void setWeight(float weight) {
            this.linked.weight = this.weight = weight;
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }

        public String toString() {
            return "{" + this.a + " <> " + this.b + ", " + this.getWeight() + "}";
        }
    }

    public static class DirectedConnection<V>
    extends Connection<V> {
        @Override
        public boolean hasEndpoints(V u, V v) {
            return this.getA().equals(u) && this.getB().equals(v);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Connection edge = (Connection)o;
            return this.a.equals(edge.a) && this.b.equals(edge.b);
        }

        public int hashCode() {
            return this.a.hashCode() * 107 + this.b.hashCode();
        }

        public String toString() {
            return "{" + this.a + " -> " + this.b + ", " + this.getWeight() + "}";
        }
    }
}

