/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.algorithms.DirectedGraphAlgorithms;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class DirectedGraph<V>
extends Graph<V>
implements Json.Serializable {
    protected final transient DirectedGraphAlgorithms<V> algorithms = new DirectedGraphAlgorithms(this);

    public DirectedGraph() {
    }

    public DirectedGraph(Collection<V> vertices) {
        super(vertices);
    }

    public DirectedGraph(Collection<V> vertices, Collection<Edge<V>> edges, float defaultEdgeWeight) {
        super(vertices, edges, defaultEdgeWeight);
    }

    public DirectedGraph(Graph<V> graph) {
        super(graph);
    }

    @Override
    protected Connection<V> obtainEdge() {
        return new Connection.DirectedConnection();
    }

    @Override
    public DirectedGraph<V> createNew() {
        return new DirectedGraph<V>();
    }

    @Override
    public DirectedGraphAlgorithms<V> algorithms() {
        return this.algorithms;
    }

    public int getOutDegree(V v) {
        Node<V> node = this.getNode(v);
        return node == null ? -1 : node.getOutDegree();
    }

    public int getInDegree(V v) {
        Node<V> node = this.getNode(v);
        return node == null ? -1 : node.getInDegree();
    }

    public Collection<Edge<V>> getInEdges(V v) {
        Node<V> node = this.getNode(v);
        if (node == null) {
            return null;
        }
        return Collections.unmodifiableCollection(node.getInEdges());
    }

    public boolean topologicalSort() {
        return this.nodeMap.topologicalSort();
    }

    public boolean topologicalSort(Collection<V> sortedVertices) {
        sortedVertices.clear();
        boolean success = this.nodeMap.topologicalSort();
        if (success) {
            sortedVertices.addAll(this.nodeMap.vertexSet);
            return true;
        }
        return false;
    }

    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, null);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), null);
            json.writeValue(edge.getB(), null);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex(json.readValue(null, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            Object object = json.readValue(null, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(object, json.readValue(null, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

