/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.DirectedGraph;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gdcrux.PointF2;
import java.util.Collection;
import java.util.Set;

public class Float2DirectedGraph
extends DirectedGraph<PointF2>
implements Json.Serializable {
    public Float2DirectedGraph() {
    }

    public Float2DirectedGraph(Collection<PointF2> vertices) {
        super(vertices);
    }

    public Float2DirectedGraph(Collection<PointF2> vertices, Collection<Edge<PointF2>> edges, float defaultEdgeWeight) {
        super(vertices, edges, defaultEdgeWeight);
    }

    public Float2DirectedGraph(Graph<PointF2> graph) {
        super(graph);
    }

    public Float2DirectedGraph(boolean[][] validGrid, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (!validGrid[x][y]) continue;
                this.addVertex(new PointF2((float)x, (float)y));
            }
        }
    }

    public Float2DirectedGraph(char[][] validGrid, char validChar, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (validGrid[x][y] != validChar) continue;
                this.addVertex(new PointF2((float)x, (float)y));
            }
        }
    }

    public Float2DirectedGraph(float[][] validGrid, float minimumThreshold, float maximumThreshold, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (!(validGrid[x][y] >= minimumThreshold) || !(validGrid[x][y] <= maximumThreshold)) continue;
                this.addVertex(new PointF2((float)x, (float)y));
            }
        }
    }

    @Override
    public Float2DirectedGraph createNew() {
        return new Float2DirectedGraph();
    }

    @Override
    public int hash(PointF2 gp) {
        return gp.hashCode();
    }

    @Override
    public String toString() {
        return "Float2DirectedGraph: { size=" + this.size() + " }";
    }

    @Override
    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, PointF2.class);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), PointF2.class);
            json.writeValue(edge.getB(), PointF2.class);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex((PointF2)json.readValue(PointF2.class, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            PointF2 pointF2 = (PointF2)json.readValue(PointF2.class, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(pointF2, (PointF2)json.readValue(PointF2.class, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

