/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.UndirectedGraph;
import com.github.tommyettinger.gand.utils.Heuristic;
import com.github.tommyettinger.gdcrux.PointF2;
import java.util.Collection;
import java.util.Set;

public class Float2UndirectedGraph
extends UndirectedGraph<PointF2>
implements Json.Serializable {
    public Float2UndirectedGraph() {
    }

    public Float2UndirectedGraph(Collection<PointF2> vertices) {
        super(vertices);
    }

    public Float2UndirectedGraph(Collection<PointF2> vertices, Collection<Edge<PointF2>> edges, float defaultEdgeWeight) {
        super(vertices, edges, defaultEdgeWeight);
    }

    public Float2UndirectedGraph(Graph<PointF2> graph) {
        super(graph);
    }

    public Float2UndirectedGraph(boolean[][] validGrid, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        this.initVertices(validGrid);
    }

    public Float2UndirectedGraph(boolean[][] validGrid, float defaultEdgeWeight, Heuristic<PointF2> heu, boolean permitDiagonal) {
        this(validGrid, defaultEdgeWeight);
        this.initEdges(validGrid.length, validGrid[0].length, defaultEdgeWeight, heu, permitDiagonal);
    }

    public Float2UndirectedGraph(char[][] validGrid, char validChar, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        this.initVertices(validGrid, validChar);
    }

    public Float2UndirectedGraph(char[][] validGrid, char validChar, float defaultEdgeWeight, Heuristic<PointF2> heu, boolean permitDiagonal) {
        this(validGrid, validChar, defaultEdgeWeight);
        this.initEdges(validGrid.length, validGrid[0].length, defaultEdgeWeight, heu, permitDiagonal);
    }

    public Float2UndirectedGraph(float[][] validGrid, float minimumThreshold, float maximumThreshold, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        this.initVertices(validGrid, minimumThreshold, maximumThreshold);
    }

    public Float2UndirectedGraph(float[][] validGrid, float minimumThreshold, float maximumThreshold, float defaultEdgeWeight, Heuristic<PointF2> heu, boolean permitDiagonal) {
        this(validGrid, minimumThreshold, maximumThreshold, defaultEdgeWeight);
        this.initEdges(validGrid.length, validGrid[0].length, defaultEdgeWeight, heu, permitDiagonal);
    }

    @Override
    public Float2UndirectedGraph createNew() {
        return new Float2UndirectedGraph();
    }

    public void initVertices(boolean[][] validGrid) {
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (!validGrid[x][y]) continue;
                this.addVertex(new PointF2((float)x, (float)y));
            }
        }
    }

    public void initVertices(char[][] validGrid, char validChar) {
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (validGrid[x][y] != validChar) continue;
                this.addVertex(new PointF2((float)x, (float)y));
            }
        }
    }

    public void initVertices(float[][] validGrid, float minimumThreshold, float maximumThreshold) {
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (!(validGrid[x][y] >= minimumThreshold) || !(validGrid[x][y] <= maximumThreshold)) continue;
                this.addVertex(new PointF2((float)x, (float)y));
            }
        }
    }

    public void initEdges(int xSize, int ySize, float defaultEdgeWeight, Heuristic<PointF2> heu, boolean permitDiagonal) {
        if (heu == null) {
            heu = (a, b) -> defaultEdgeWeight;
        }
        PointF2 test = new PointF2();
        PointF2 next = new PointF2();
        for (int x = 0; x < xSize; ++x) {
            test.x = x;
            for (int y = 0; y < ySize; ++y) {
                Node nmn;
                test.y = y;
                Node nmt = this.nodeMap.get(test);
                if (nmt == null) continue;
                PointF2 t = (PointF2)nmt.getObject();
                if (permitDiagonal) {
                    next.x = x - 1;
                    next.y = y - 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x + 1;
                    next.y = y - 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x - 1;
                    next.y = y + 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x + 1;
                    next.y = y + 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                }
                next.x = x;
                next.y = y - 1;
                nmn = this.nodeMap.get(next);
                if (nmn != null) {
                    this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                }
                next.x = x - 1;
                next.y = y;
                nmn = this.nodeMap.get(next);
                if (nmn != null) {
                    this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                }
                next.x = x + 1;
                next.y = y;
                nmn = this.nodeMap.get(next);
                if (nmn != null) {
                    this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
                }
                next.x = x;
                next.y = y + 1;
                nmn = this.nodeMap.get(next);
                if (nmn == null) continue;
                this.addEdge(t, (PointF2)nmn.getObject(), heu.getEstimate(test, next));
            }
        }
    }

    @Override
    public int hash(PointF2 gp) {
        return gp.hashCode();
    }

    @Override
    public String toString() {
        return "Float2DirectedGraph: { size=" + this.size() + " }";
    }

    @Override
    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, PointF2.class);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), PointF2.class);
            json.writeValue(edge.getB(), PointF2.class);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex((PointF2)json.readValue(PointF2.class, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            PointF2 pointF2 = (PointF2)json.readValue(PointF2.class, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(pointF2, (PointF2)json.readValue(PointF2.class, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

