/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.DirectedGraph;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gdcrux.PointF3;
import java.util.Collection;
import java.util.Set;

public class Float3DirectedGraph
extends DirectedGraph<PointF3>
implements Json.Serializable {
    public Float3DirectedGraph() {
    }

    public Float3DirectedGraph(Collection<PointF3> vertices) {
        super(vertices);
    }

    public Float3DirectedGraph(Collection<PointF3> vertices, Collection<Edge<PointF3>> edges, float defaultEdgeWeight) {
        super(vertices, edges, defaultEdgeWeight);
    }

    public Float3DirectedGraph(Graph<PointF3> graph) {
        super(graph);
    }

    public Float3DirectedGraph(boolean[][][] validGrid, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int z = 0; z < validGrid.length; ++z) {
            for (int y = 0; y < validGrid[z].length; ++y) {
                for (int x = 0; x < validGrid[z][y].length; ++x) {
                    if (!validGrid[z][y][x]) continue;
                    this.addVertex(new PointF3((float)x, (float)y, (float)z));
                }
            }
        }
    }

    public Float3DirectedGraph(char[][][] validGrid, char validChar, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int z = 0; z < validGrid.length; ++z) {
            for (int y = 0; y < validGrid[z].length; ++y) {
                for (int x = 0; x < validGrid[z][y].length; ++x) {
                    if (validGrid[z][y][x] != validChar) continue;
                    this.addVertex(new PointF3((float)x, (float)y, (float)z));
                }
            }
        }
    }

    public Float3DirectedGraph(float[][][] validGrid, float minimumThreshold, float maximumThreshold, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int z = 0; z < validGrid.length; ++z) {
            for (int y = 0; y < validGrid[z].length; ++y) {
                for (int x = 0; x < validGrid[z][y].length; ++x) {
                    if (!(validGrid[z][y][x] >= minimumThreshold) || !(validGrid[z][y][x] <= maximumThreshold)) continue;
                    this.addVertex(new PointF3((float)x, (float)y, (float)z));
                }
            }
        }
    }

    @Override
    public Float3DirectedGraph createNew() {
        return new Float3DirectedGraph();
    }

    @Override
    public int hash(PointF3 gp) {
        return gp.hashCode();
    }

    @Override
    public String toString() {
        return "Float3DirectedGraph: { size=" + this.size() + " }";
    }

    @Override
    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, PointF3.class);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), PointF3.class);
            json.writeValue(edge.getB(), PointF3.class);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex((PointF3)json.readValue(PointF3.class, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            PointF3 pointF3 = (PointF3)json.readValue(PointF3.class, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(pointF3, (PointF3)json.readValue(PointF3.class, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

