/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.crux.Point2;
import com.github.tommyettinger.crux.PointN;
import com.github.tommyettinger.crux.PointPair;
import com.github.tommyettinger.gand.Path;
import com.github.tommyettinger.gand.ds.IntDeque;
import com.github.tommyettinger.gand.ds.IntList;
import com.github.tommyettinger.gand.ds.ObjectDeque;
import com.github.tommyettinger.gand.ds.ObjectSet;
import com.github.tommyettinger.gand.smoothing.Ortho2DRaycastCollisionDetector;
import com.github.tommyettinger.gand.utils.Choo32Random;
import com.github.tommyettinger.gand.utils.Direction;
import com.github.tommyettinger.gand.utils.GridMetric;
import java.util.Collection;

public abstract class GradientGrid<P extends Point2<P>> {
    public static final float GOAL = 0.0f;
    public static final float FLOOR = 999200.0f;
    public static final float WALL = 999500.0f;
    public static final float DARK = 999800.0f;
    private GridMetric measurement = GridMetric.EUCLIDEAN;
    public float[][] physicalMap;
    public float[][] gradientMap;
    protected int height;
    protected int width;
    public Path<P> path = new Path();
    protected ObjectSet<Point2<?>> blocked;
    public transient boolean cutShort;
    protected IntList goals = new IntList(256);
    protected IntDeque fresh = new IntDeque(256);
    protected final Choo32Random rng = new Choo32Random(40503, 31161, 32586, 31765);
    protected transient int frustration;
    protected final Direction[] dirs = new Direction[9];
    protected boolean initialized;
    protected transient int mappedCount;
    protected int blockingRequirement = 2;
    protected transient float cachedLongerPaths = 1.2f;
    protected final transient ObjectSet<Point2<?>> cachedImpassable = new ObjectSet(32);
    protected transient ObjectSet<Point2<?>> cachedFearSources;
    protected transient float[][] cachedFleeMap;
    protected final transient PointPair<P> workRay = new PointPair(this.acquire(0, 0), this.acquire(1, 0));
    private static final float[][] emptyFloats2D = new float[0][0];

    protected abstract P acquire(int var1, int var2);

    protected P acquire(Point2<?> other) {
        return this.acquire(other.xi(), other.yi());
    }

    protected P workingEdit(int x, int y) {
        return this.acquire(x, y);
    }

    protected P workingEdit(Point2<?> other) {
        return this.workingEdit(other.xi(), other.yi());
    }

    public GradientGrid() {
    }

    public GradientGrid(float[][] level) {
        this(level, GridMetric.EUCLIDEAN);
    }

    public GradientGrid(float[][] level, GridMetric measurement) {
        this.measurement = measurement;
        this.initialize(level);
    }

    public GradientGrid(char[][] level) {
        this(level, GridMetric.EUCLIDEAN);
    }

    public GradientGrid(char[][] level, char alternateWall) {
        this(level, alternateWall, GridMetric.EUCLIDEAN);
    }

    public GradientGrid(char[][] level, GridMetric measurement) {
        this(level, '#', measurement);
    }

    public GradientGrid(char[][] level, char alternateWall, GridMetric measurement) {
        this.measurement = measurement;
        this.initialize(level, alternateWall);
    }

    public GradientGrid<P> initialize(float[][] level) {
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.width = level.length;
        this.height = level[0].length;
        if (this.width != oldWidth || this.height != oldHeight) {
            this.gradientMap = new float[this.width][this.height];
            this.physicalMap = new float[this.width][this.height];
        }
        for (int x = 0; x < this.width; ++x) {
            System.arraycopy(level[x], 0, this.gradientMap[x], 0, this.height);
            System.arraycopy(level[x], 0, this.physicalMap[x], 0, this.height);
        }
        if (this.blocked == null) {
            this.blocked = new ObjectSet(32);
        } else {
            this.blocked.clear();
        }
        this.initialized = true;
        return this;
    }

    public GradientGrid<P> initialize(char[][] level) {
        return this.initialize(level, '#');
    }

    public GradientGrid<P> initialize(char[][] level, char alternateWall) {
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.width = level.length;
        this.height = level[0].length;
        if (this.width != oldWidth || this.height != oldHeight) {
            this.gradientMap = new float[this.width][this.height];
            this.physicalMap = new float[this.width][this.height];
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                float t;
                this.gradientMap[x][y] = t = level[x][y] == alternateWall ? 999500.0f : 999200.0f;
                this.physicalMap[x][y] = t;
            }
        }
        if (this.blocked == null) {
            this.blocked = new ObjectSet(32);
        } else {
            this.blocked.clear();
        }
        this.initialized = true;
        return this;
    }

    public int encode(Point2<?> point) {
        return point.yi() << 16 | point.xi() & 0xFFFF;
    }

    public int encode(int x, int y) {
        return y << 16 | x & 0xFFFF;
    }

    public Point2<?> decode(Point2<?> changing, int encoded) {
        return changing.seti(encoded & 0xFFFF, encoded >>> 16);
    }

    public int decodeX(int encoded) {
        return encoded & 0xFFFF;
    }

    public int decodeY(int encoded) {
        return encoded >>> 16;
    }

    public void resetMap() {
        if (!this.initialized) {
            return;
        }
        for (int x = 0; x < this.width; ++x) {
            System.arraycopy(this.physicalMap[x], 0, this.gradientMap[x], 0, this.height);
        }
    }

    public void reset() {
        this.resetMap();
        this.goals.clear();
        this.path.clear();
        this.fresh.clear();
        this.frustration = 0;
    }

    public void setGoal(int x, int y) {
        if (!this.initialized || x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        if (this.physicalMap[x][y] > 999200.0f) {
            return;
        }
        this.goals.add(this.encode(x, y));
        this.gradientMap[x][y] = 0.0f;
    }

    public void setGoal(Point2<?> pt) {
        this.setGoal(pt.xi(), pt.yi());
    }

    public void setGoals(Iterable<? extends Point2<?>> pts) {
        if (!this.initialized) {
            return;
        }
        for (Point2<?> c : pts) {
            this.setGoal(c);
        }
    }

    public void setGoals(Point2<?>[] pts) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < pts.length; ++i) {
            this.setGoal(pts[i]);
        }
    }

    public void setOccupied(int x, int y) {
        if (!this.initialized || x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        this.gradientMap[x][y] = 999500.0f;
    }

    public void resetCell(int x, int y) {
        if (!this.initialized || x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        this.gradientMap[x][y] = this.physicalMap[x][y];
    }

    public void resetCell(Point2<?> pt) {
        if (!this.initialized || !GradientGrid.isWithin(pt, this.width, this.height)) {
            return;
        }
        this.gradientMap[pt.xi()][pt.yi()] = this.physicalMap[pt.xi()][pt.yi()];
    }

    public void clearGoals() {
        if (!this.initialized) {
            return;
        }
        int sz = this.goals.size();
        for (int i = 0; i < sz; ++i) {
            int t = this.goals.pop();
            this.resetCell(this.decodeX(t), this.decodeY(t));
        }
    }

    protected void setFresh(int x, int y, float counter) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height || this.gradientMap[x][y] < counter) {
            return;
        }
        this.gradientMap[x][y] = counter;
        this.fresh.addFirst(this.encode(x, y));
    }

    protected void setFresh(Point2<?> pt, float counter) {
        if (!GradientGrid.isWithin(pt, this.width, this.height) || this.gradientMap[pt.xi()][pt.yi()] < counter) {
            return;
        }
        this.gradientMap[pt.xi()][pt.yi()] = counter;
        this.fresh.addFirst(this.encode(pt));
    }

    public float[][] scan() {
        return this.scan(null);
    }

    public float[][] scan(Iterable<? extends Point2<?>> impassable) {
        this.scan(null, impassable);
        float[][] gradientClone = new float[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] != 999200.0f) continue;
                this.gradientMap[x][y] = 999800.0f;
            }
            System.arraycopy(this.gradientMap[x], 0, gradientClone[x], 0, this.height);
        }
        return gradientClone;
    }

    public void scan(Point2<?> start, Iterable<? extends Point2<?>> impassable) {
        this.scan(start, impassable, false);
    }

    public void scan(Point2<?> start, Iterable<? extends Point2<?>> impassable, boolean nonZeroOptimum) {
        Direction[] moveDirs;
        if (!this.initialized) {
            return;
        }
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                this.gradientMap[pt.xi()][pt.yi()] = 999500.0f;
            }
        }
        this.fresh.clear();
        this.fresh.addAll(this.goals);
        for (int i = 0; i < this.goals.size(); ++i) {
            int dec = this.goals.get(i);
            this.gradientMap[this.decodeX((int)dec)][this.decodeY((int)dec)] = 0.0f;
        }
        if (nonZeroOptimum) {
            float currentLowest = 999000.0f;
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (!(this.gradientMap[x][y] <= 999200.0f)) continue;
                    if (this.gradientMap[x][y] < currentLowest) {
                        currentLowest = this.gradientMap[x][y];
                        this.fresh.clear();
                        this.fresh.add(this.encode(x, y));
                        continue;
                    }
                    if (this.gradientMap[x][y] != currentLowest) continue;
                    this.fresh.add(this.encode(x, y));
                }
            }
        }
        int numAssigned = this.fresh.size();
        this.mappedCount = this.goals.size();
        Direction[] directionArray = moveDirs = this.measurement == GridMetric.MANHATTAN ? Direction.CARDINALS : Direction.OUTWARDS;
        while (numAssigned > 0) {
            int fsz;
            numAssigned = 0;
            for (int ci = fsz = this.fresh.size(); ci > 0; --ci) {
                int cen = this.fresh.removeLast();
                int cenX = this.decodeX(cen);
                int cenY = this.decodeY(cen);
                float dist = this.gradientMap[cenX][cenY];
                for (int d = 0; d < moveDirs.length; ++d) {
                    int adjX = cenX + moveDirs[d].deltaX;
                    int adjY = cenY + moveDirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || this.width <= adjX || this.height <= adjY || d >= 4 && this.blockingRequirement > 0 && (this.gradientMap[adjX][cenY] > 999200.0f ? 1 : 0) + (this.gradientMap[cenX][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    float h = this.measurement.heuristic(moveDirs[d]);
                    float cs = dist + h;
                    if (!(this.gradientMap[adjX][adjY] <= 999200.0f) || !(cs < this.gradientMap[adjX][adjY])) continue;
                    this.setFresh(adjX, adjY, cs);
                    ++numAssigned;
                    ++this.mappedCount;
                    if (start == null || start.xi() != adjX || start.yi() != adjY) continue;
                    if (impassable != null) {
                        for (Point2<?> pt : impassable) {
                            if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                            this.gradientMap[pt.xi()][pt.yi()] = this.physicalMap[pt.xi()][pt.yi()];
                        }
                    }
                    return;
                }
            }
        }
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                this.gradientMap[pt.xi()][pt.yi()] = this.physicalMap[pt.xi()][pt.yi()];
            }
        }
    }

    public float[][] partialScan(int limit) {
        return this.partialScan(limit, null);
    }

    public float[][] partialScan(int limit, Iterable<? extends Point2<?>> impassable) {
        this.partialScan(null, limit, impassable);
        float[][] gradientClone = new float[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] != 999200.0f) continue;
                this.gradientMap[x][y] = 999800.0f;
            }
            System.arraycopy(this.gradientMap[x], 0, gradientClone[x], 0, this.height);
        }
        return gradientClone;
    }

    public void partialScan(Point2<?> start, int limit, Iterable<? extends Point2<?>> impassable) {
        this.partialScan(start, limit, impassable, false);
    }

    public void partialScan(Point2<?> start, int limit, Iterable<? extends Point2<?>> impassable, boolean nonZeroOptimum) {
        if (!this.initialized || limit <= 0) {
            return;
        }
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                this.gradientMap[pt.xi()][pt.yi()] = 999500.0f;
            }
        }
        this.fresh.clear();
        this.fresh.addAll(this.goals);
        for (int i = 0; i < this.goals.size(); ++i) {
            int dec = this.goals.get(i);
            this.gradientMap[this.decodeX((int)dec)][this.decodeY((int)dec)] = 0.0f;
        }
        if (nonZeroOptimum) {
            float currentLowest = 999000.0f;
            if (start == null) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        if (!(this.gradientMap[x][y] <= 999200.0f)) continue;
                        if (this.gradientMap[x][y] < currentLowest) {
                            currentLowest = this.gradientMap[x][y];
                            this.fresh.clear();
                            this.fresh.add(this.encode(x, y));
                            continue;
                        }
                        if (this.gradientMap[x][y] != currentLowest) continue;
                        this.fresh.add(this.encode(x, y));
                    }
                }
            } else {
                int x0 = Math.max(0, start.xi() - limit);
                int x1 = Math.min(start.xi() + limit + 1, this.width);
                int y0 = Math.max(0, start.yi() - limit);
                int y1 = Math.min(start.yi() + limit + 1, this.height);
                for (int x = x0; x < x1; ++x) {
                    for (int y = y0; y < y1; ++y) {
                        if (!(this.gradientMap[x][y] <= 999200.0f)) continue;
                        if (this.gradientMap[x][y] < currentLowest) {
                            currentLowest = this.gradientMap[x][y];
                            this.fresh.clear();
                            this.fresh.add(this.encode(x, y));
                            continue;
                        }
                        if (this.gradientMap[x][y] != currentLowest) continue;
                        this.fresh.add(this.encode(x, y));
                    }
                }
            }
        }
        int numAssigned = this.fresh.size();
        this.mappedCount = this.goals.size();
        Direction[] moveDirs = this.measurement == GridMetric.MANHATTAN ? Direction.CARDINALS : Direction.OUTWARDS;
        int iter = 0;
        while (numAssigned > 0 && iter++ < limit) {
            int fsz;
            numAssigned = 0;
            for (int ci = fsz = this.fresh.size(); ci > 0; --ci) {
                int cen = this.fresh.removeLast();
                int cenX = this.decodeX(cen);
                int cenY = this.decodeY(cen);
                float dist = this.gradientMap[cenX][cenY];
                for (int d = 0; d < moveDirs.length; ++d) {
                    int adjX = cenX + moveDirs[d].deltaX;
                    int adjY = cenY + moveDirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || this.width <= adjX || this.height <= adjY || d >= 4 && this.blockingRequirement > 0 && (this.gradientMap[adjX][cenY] > 999200.0f ? 1 : 0) + (this.gradientMap[cenX][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    float h = this.measurement.heuristic(moveDirs[d]);
                    float cs = dist + h;
                    if (!(this.gradientMap[adjX][adjY] <= 999200.0f) || !(cs < this.gradientMap[adjX][adjY])) continue;
                    this.setFresh(adjX, adjY, cs);
                    ++numAssigned;
                    ++this.mappedCount;
                    if (start == null || start.xi() != adjX || start.yi() != adjY) continue;
                    if (impassable != null) {
                        for (Point2<?> pt : impassable) {
                            if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                            this.gradientMap[pt.xi()][pt.yi()] = this.physicalMap[pt.xi()][pt.yi()];
                        }
                    }
                    return;
                }
            }
        }
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                this.gradientMap[pt.xi()][pt.yi()] = this.physicalMap[pt.xi()][pt.yi()];
            }
        }
    }

    public float[][] scan(Iterable<? extends Point2<?>> impassable, int size) {
        this.scan(null, impassable, size);
        float[][] gradientClone = new float[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] != 999200.0f) continue;
                this.gradientMap[x][y] = 999800.0f;
            }
            System.arraycopy(this.gradientMap[x], 0, gradientClone[x], 0, this.height);
        }
        return gradientClone;
    }

    public void scan(Point2<?> start, Iterable<? extends Point2<?>> impassable, int size) {
        Direction[] moveDirs;
        if (!this.initialized) {
            return;
        }
        float[][] gradientClone = GradientGrid.copy(this.gradientMap);
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                this.gradientMap[pt.xi()][pt.yi()] = 999500.0f;
            }
        }
        for (int xx = size; xx < this.width; ++xx) {
            for (int yy = size; yy < this.height; ++yy) {
                if (!(this.gradientMap[xx][yy] > 999200.0f)) continue;
                int xs = xx;
                for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                    int ys = yy;
                    for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                        gradientClone[xs][ys] = 999500.0f;
                    }
                }
            }
        }
        block5: for (int i = 0; i < this.goals.size(); ++i) {
            int dec = this.goals.get(i);
            int xs = this.decodeX(dec);
            for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                int ys = this.decodeY(dec);
                for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                    if (this.physicalMap[xs][ys] > 999200.0f) continue block5;
                    gradientClone[xs][ys] = 0.0f;
                }
            }
        }
        float currentLowest = 999000.0f;
        this.fresh.clear();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(gradientClone[x][y] <= 999200.0f)) continue;
                if (gradientClone[x][y] < currentLowest) {
                    currentLowest = gradientClone[x][y];
                    this.fresh.clear();
                    this.fresh.add(this.encode(x, y));
                    continue;
                }
                if (gradientClone[x][y] != currentLowest) continue;
                this.fresh.add(this.encode(x, y));
            }
        }
        int numAssigned = this.fresh.size();
        this.mappedCount = this.goals.size();
        Direction[] directionArray = moveDirs = this.measurement == GridMetric.MANHATTAN ? Direction.CARDINALS : Direction.OUTWARDS;
        while (numAssigned > 0) {
            int fsz;
            numAssigned = 0;
            for (int ci = fsz = this.fresh.size(); ci > 0; --ci) {
                int cen = this.fresh.removeLast();
                int cenX = this.decodeX(cen);
                int cenY = this.decodeY(cen);
                float dist = gradientClone[cenX][cenY];
                for (int d = 0; d < moveDirs.length; ++d) {
                    int adjX = cenX + moveDirs[d].deltaX;
                    int adjY = cenY + moveDirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || this.width <= adjX || this.height <= adjY || d >= 4 && this.blockingRequirement > 0 && (gradientClone[adjX][cenY] > 999200.0f ? 1 : 0) + (gradientClone[cenX][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    float h = this.measurement.heuristic(moveDirs[d]);
                    float cs = dist + h;
                    if (!(gradientClone[adjX][adjY] <= 999200.0f) || !(cs < gradientClone[adjX][adjY])) continue;
                    this.setFresh(adjX, adjY, cs);
                    ++numAssigned;
                    ++this.mappedCount;
                    if (start == null || start.xi() != adjX || start.yi() != adjY) continue;
                    if (impassable != null) {
                        for (Point2<?> pt : impassable) {
                            if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                            int xs = pt.xi();
                            for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                                int ys = pt.yi();
                                for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                                    gradientClone[xs][ys] = this.physicalMap[xs][ys];
                                }
                            }
                        }
                    }
                    this.gradientMap = gradientClone;
                    return;
                }
            }
        }
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                int xs = pt.xi();
                for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                    int ys = pt.yi();
                    for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                        gradientClone[xs][ys] = this.physicalMap[xs][ys];
                    }
                }
            }
        }
        this.gradientMap = gradientClone;
    }

    public float[][] partialScan(int limit, Iterable<? extends Point2<?>> impassable, int size) {
        this.partialScan(limit, null, impassable, size);
        float[][] gradientClone = new float[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] != 999200.0f) continue;
                this.gradientMap[x][y] = 999800.0f;
            }
            System.arraycopy(this.gradientMap[x], 0, gradientClone[x], 0, this.height);
        }
        return gradientClone;
    }

    public void partialScan(int limit, Point2<?> start, Iterable<? extends Point2<?>> impassable, int size) {
        if (!this.initialized || limit <= 0) {
            return;
        }
        float[][] gradientClone = GradientGrid.copy(this.gradientMap);
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                this.gradientMap[pt.xi()][pt.yi()] = 999500.0f;
            }
        }
        for (int xx = size; xx < this.width; ++xx) {
            for (int yy = size; yy < this.height; ++yy) {
                if (!(this.gradientMap[xx][yy] > 999200.0f)) continue;
                int xs = xx;
                for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                    int ys = yy;
                    for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                        gradientClone[xs][ys] = 999500.0f;
                    }
                }
            }
        }
        block5: for (int i = 0; i < this.goals.size(); ++i) {
            int dec = this.goals.get(i);
            int xs = this.decodeX(dec);
            for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                int ys = this.decodeY(dec);
                for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                    if (this.physicalMap[xs][ys] > 999200.0f) continue block5;
                    gradientClone[xs][ys] = 0.0f;
                }
            }
        }
        float currentLowest = 999000.0f;
        this.fresh.clear();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(gradientClone[x][y] <= 999200.0f)) continue;
                if (gradientClone[x][y] < currentLowest) {
                    currentLowest = gradientClone[x][y];
                    this.fresh.clear();
                    this.fresh.add(this.encode(x, y));
                    continue;
                }
                if (gradientClone[x][y] != currentLowest) continue;
                this.fresh.add(this.encode(x, y));
            }
        }
        int numAssigned = this.fresh.size();
        this.mappedCount = this.goals.size();
        Direction[] moveDirs = this.measurement == GridMetric.MANHATTAN ? Direction.CARDINALS : Direction.OUTWARDS;
        int iter = 0;
        while (numAssigned > 0 && iter++ < limit) {
            int fsz;
            numAssigned = 0;
            for (int ci = fsz = this.fresh.size(); ci > 0; --ci) {
                int cen = this.fresh.removeLast();
                int cenX = this.decodeX(cen);
                int cenY = this.decodeY(cen);
                float dist = gradientClone[cenX][cenY];
                for (int d = 0; d < moveDirs.length; ++d) {
                    int adjX = cenX + moveDirs[d].deltaX;
                    int adjY = cenY + moveDirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || this.width <= adjX || this.height <= adjY || d >= 4 && this.blockingRequirement > 0 && (gradientClone[adjX][cenY] > 999200.0f ? 1 : 0) + (gradientClone[cenX][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    float h = this.measurement.heuristic(moveDirs[d]);
                    float cs = dist + h;
                    if (!(gradientClone[adjX][adjY] <= 999200.0f) || !(cs < gradientClone[adjX][adjY])) continue;
                    this.setFresh(adjX, adjY, cs);
                    ++numAssigned;
                    ++this.mappedCount;
                    if (start == null || start.xi() != adjX || start.yi() != adjY) continue;
                    if (impassable != null) {
                        for (Point2<?> pt : impassable) {
                            if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                            int xs = pt.xi();
                            for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                                int ys = pt.yi();
                                for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                                    gradientClone[xs][ys] = this.physicalMap[xs][ys];
                                }
                            }
                        }
                    }
                    this.gradientMap = gradientClone;
                    return;
                }
            }
        }
        if (impassable != null) {
            for (Point2<?> pt : impassable) {
                if (pt == null || !GradientGrid.isWithin(pt, this.width, this.height)) continue;
                int xs = pt.xi();
                for (int xi = 0; xi < size && xs >= 0; --xs, ++xi) {
                    int ys = pt.yi();
                    for (int yi = 0; yi < size && ys >= 0; --ys, ++yi) {
                        gradientClone[xs][ys] = this.physicalMap[xs][ys];
                    }
                }
            }
        }
        this.gradientMap = gradientClone;
    }

    public ObjectDeque<P> findPath(int length, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<? extends Point2<?>> targets) {
        return this.findPath(length, -1, impassable, onlyPassable, start, targets);
    }

    public ObjectDeque<P> findPath(int length, int scanLimit, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<? extends Point2<?>> targets) {
        return this.findPath(null, length, scanLimit, impassable, onlyPassable, start, targets);
    }

    public ObjectDeque<P> findPath(ObjectDeque<P> buffer, int length, int scanLimit, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<? extends Point2<?>> targets) {
        this.path.clear();
        if (!this.initialized || length <= 0) {
            this.cutShort = true;
            if (buffer == null) {
                return new ObjectDeque();
            }
            return buffer;
        }
        if (impassable == null) {
            this.blocked.clear();
        } else if (impassable != this.blocked) {
            this.blocked.clear();
            this.blocked.addAll((Collection<Point2<?>>)impassable);
        }
        if (onlyPassable != null && length == 1) {
            this.blocked.addAll(onlyPassable);
        }
        this.resetMap();
        this.setGoals(targets);
        if (this.goals.isEmpty()) {
            this.cutShort = true;
            if (buffer == null) {
                return new ObjectDeque();
            }
            return buffer;
        }
        if (scanLimit <= 0 || scanLimit < length) {
            this.scan(start, this.blocked);
        } else {
            this.partialScan(start, scanLimit, this.blocked);
        }
        Object currentPos = this.workingEdit(start.xi(), start.yi());
        float paidLength = 0.0f;
        this.rng.setState(start.xi(), start.yi(), targets.size(), this.blocked.size());
        do {
            if (this.frustration > 500) {
                this.path.clear();
            } else {
                int y;
                currentPos = (Point2)currentPos.cpy();
                float best = this.gradientMap[currentPos.xi()][currentPos.yi()];
                this.shuffleDirs();
                int choice = 0;
                for (int d = 0; d <= this.measurement.directionCount(); ++d) {
                    int adjX = currentPos.xi() + this.dirs[d].deltaX;
                    int adjY = currentPos.yi() + this.dirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || adjX >= this.width || adjY >= this.height || this.dirs[d].isDiagonal() && this.blockingRequirement > 0 && (this.gradientMap[adjX][currentPos.yi()] > 999200.0f ? 1 : 0) + (this.gradientMap[currentPos.xi()][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    P workPt = this.workingEdit(adjX, adjY);
                    if (!(this.gradientMap[adjX][adjY] < best) || this.blocked.contains(workPt) || this.dirs[choice] != Direction.NONE && this.path.contains(workPt)) continue;
                    best = this.gradientMap[adjX][adjY];
                    choice = d;
                }
                int x = currentPos.xi();
                if (best >= this.gradientMap[x][y = currentPos.yi()] || this.physicalMap[x + this.dirs[choice].deltaX][y + this.dirs[choice].deltaY] > 999200.0f) {
                    this.cutShort = true;
                    this.frustration = 0;
                    if (buffer == null) {
                        return new ObjectDeque<P>(this.path);
                    }
                    buffer.addAll((Collection<P>)this.path);
                    return buffer;
                }
                currentPos = currentPos.seti(x + this.dirs[choice].deltaX, y + this.dirs[choice].deltaY);
                this.path.add(currentPos);
                paidLength += 1.0f;
                if (!(paidLength > (float)length - 1.0f)) continue;
                if (onlyPassable != null && onlyPassable.contains(currentPos)) {
                    ++this.frustration;
                    this.blocked.add((Point2<?>)currentPos);
                    return this.findPath(buffer, length, scanLimit, this.blocked, onlyPassable, start, targets);
                }
            }
            break;
        } while (this.gradientMap[currentPos.xi()][currentPos.yi()] != 0.0f);
        this.cutShort = false;
        this.frustration = 0;
        this.goals.clear();
        if (buffer == null) {
            return new ObjectDeque<P>(this.path);
        }
        buffer.addAll((Collection<P>)this.path);
        return buffer;
    }

    public ObjectDeque<P> findAttackPath(int moveLength, int preferredRange, Collection<? extends Point2<?>> impassable, boolean los, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<? extends Point2<?>> targets) {
        return this.findAttackPath(moveLength, preferredRange, preferredRange, los, impassable, onlyPassable, start, targets);
    }

    public ObjectDeque<P> findAttackPath(int moveLength, int minPreferredRange, int maxPreferredRange, boolean los, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<? extends Point2<?>> targets) {
        return this.findAttackPath(null, moveLength, minPreferredRange, maxPreferredRange, los, impassable, onlyPassable, start, targets);
    }

    public ObjectDeque<P> findAttackPath(ObjectDeque<P> buffer, int moveLength, int minPreferredRange, int maxPreferredRange, boolean los, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<? extends Point2<?>> targets) {
        int y;
        int x;
        if (!this.initialized || moveLength <= 0) {
            this.cutShort = true;
            if (buffer == null) {
                return new ObjectDeque();
            }
            return buffer;
        }
        if (minPreferredRange < 0) {
            minPreferredRange = 0;
        }
        if (maxPreferredRange < minPreferredRange) {
            maxPreferredRange = minPreferredRange;
        }
        this.path.clear();
        if (impassable == null) {
            this.blocked.clear();
        } else if (impassable != this.blocked) {
            this.blocked.clear();
            this.blocked.addAll((Collection<Point2<?>>)impassable);
        }
        if (onlyPassable != null && moveLength == 1) {
            this.blocked.addAll(onlyPassable);
        }
        this.resetMap();
        for (Point2<?> goal : targets) {
            this.setGoal(goal);
        }
        if (this.goals.isEmpty()) {
            this.cutShort = true;
            if (buffer == null) {
                return new ObjectDeque();
            }
            return buffer;
        }
        GridMetric mess = this.measurement;
        if (this.measurement == GridMetric.EUCLIDEAN) {
            this.measurement = GridMetric.CHEBYSHEV;
        }
        this.scan(null, this.blocked);
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] != 999200.0f) continue;
                this.gradientMap[x][y] = 999800.0f;
            }
        }
        this.goals.clear();
        for (x = 0; x < this.width; ++x) {
            block4: for (y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] == 999500.0f || this.gradientMap[x][y] == 999800.0f) continue;
                if (this.gradientMap[x][y] >= (float)minPreferredRange && this.gradientMap[x][y] <= (float)maxPreferredRange) {
                    this.workRay.a = ((Point2)this.workRay.a).seti(x, y);
                    for (Point2<?> goal : targets) {
                        if (los && Ortho2DRaycastCollisionDetector.collides(this.workRay.set((PointN)((Point2)this.workRay.a), (PointN)((Point2)this.workRay.b).seti(goal.xi(), goal.yi())), this::wallQuery)) continue;
                        this.setGoal(x, y);
                        this.gradientMap[x][y] = 0.0f;
                        continue block4;
                    }
                }
                this.gradientMap[x][y] = 999200.0f;
            }
        }
        this.measurement = mess;
        this.scan(null, this.blocked);
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (this.gradientMap[x][y] != 999200.0f) continue;
                this.gradientMap[x][y] = 999800.0f;
            }
        }
        if (this.gradientMap[start.xi()][start.yi()] <= 0.0f) {
            this.cutShort = false;
            this.frustration = 0;
            this.goals.clear();
            if (buffer == null) {
                return new ObjectDeque<P>(this.path);
            }
            buffer.addAll((Collection<P>)this.path);
            return buffer;
        }
        Object currentPos = this.workingEdit(start);
        float paidLength = 0.0f;
        this.rng.setState(start.xi(), start.yi(), targets.size(), this.blocked.size());
        do {
            if (this.frustration > 500) {
                this.path.clear();
            } else {
                int y2;
                currentPos = (Point2)currentPos.cpy();
                float best = this.gradientMap[currentPos.xi()][currentPos.yi()];
                this.shuffleDirs();
                int choice = 0;
                for (int d = 0; d <= this.measurement.directionCount(); ++d) {
                    int adjX = currentPos.xi() + this.dirs[d].deltaX;
                    int adjY = currentPos.yi() + this.dirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || adjX >= this.width || adjY >= this.height || this.dirs[d].isDiagonal() && this.blockingRequirement > 0 && (this.gradientMap[adjX][currentPos.yi()] > 999200.0f ? 1 : 0) + (this.gradientMap[currentPos.xi()][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    P workPt = this.workingEdit(adjX, adjY);
                    if (!(this.gradientMap[adjX][adjY] < best) || this.blocked.contains(workPt) || this.dirs[choice] != Direction.NONE && this.path.contains(workPt)) continue;
                    best = this.gradientMap[adjX][adjY];
                    choice = d;
                }
                int x2 = currentPos.xi();
                if (best >= this.gradientMap[x2][y2 = currentPos.yi()] || this.physicalMap[x2 + this.dirs[choice].deltaX][y2 + this.dirs[choice].deltaY] > 999200.0f) {
                    this.cutShort = true;
                    this.frustration = 0;
                    if (buffer == null) {
                        return new ObjectDeque<P>(this.path);
                    }
                    buffer.addAll((Collection<P>)this.path);
                    return buffer;
                }
                currentPos = currentPos.seti(x2 + this.dirs[choice].deltaX, y2 + this.dirs[choice].deltaY);
                this.path.add(currentPos);
                paidLength += 1.0f;
                if (!(paidLength > (float)moveLength - 1.0f)) continue;
                if (onlyPassable != null && onlyPassable.contains(currentPos)) {
                    ++this.frustration;
                    this.blocked.add((Point2<?>)currentPos);
                    return this.findAttackPath(buffer, moveLength, minPreferredRange, maxPreferredRange, los, this.blocked, onlyPassable, start, targets);
                }
            }
            break;
        } while (this.gradientMap[currentPos.xi()][currentPos.yi()] != 0.0f);
        this.cutShort = false;
        this.frustration = 0;
        this.goals.clear();
        if (buffer == null) {
            return new ObjectDeque<P>(this.path);
        }
        buffer.addAll((Collection<P>)this.path);
        return buffer;
    }

    public ObjectDeque<P> findFleePath(int length, float preferLongerPaths, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<Point2<?>> fearSources) {
        return this.findFleePath(null, length, -1, preferLongerPaths, impassable, onlyPassable, start, fearSources);
    }

    public ObjectDeque<P> findFleePath(int length, int scanLimit, float preferLongerPaths, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<Point2<?>> fearSources) {
        return this.findFleePath(null, length, scanLimit, preferLongerPaths, impassable, onlyPassable, start, fearSources);
    }

    public ObjectDeque<P> findFleePath(ObjectDeque<P> buffer, int length, int scanLimit, float preferLongerPaths, Collection<? extends Point2<?>> impassable, Collection<? extends Point2<?>> onlyPassable, Point2<?> start, Collection<Point2<?>> fearSources) {
        block27: {
            if (!this.initialized || length <= 0) {
                this.cutShort = true;
                if (buffer == null) {
                    return new ObjectDeque();
                }
                return buffer;
            }
            this.path.clear();
            if (fearSources == null || fearSources.isEmpty()) {
                this.cutShort = true;
                if (buffer == null) {
                    return new ObjectDeque();
                }
                return buffer;
            }
            if (impassable == null) {
                this.blocked.clear();
            } else if (impassable != this.blocked) {
                this.blocked.clear();
                this.blocked.addAll((Collection<Point2<?>>)impassable);
            }
            if (onlyPassable != null && length == 1) {
                this.blocked.addAll(onlyPassable);
            }
            if (preferLongerPaths == this.cachedLongerPaths && this.blocked.equals(this.cachedImpassable) && this.cachedFearSources != null && this.cachedFearSources.equals(fearSources)) {
                this.gradientMap = this.cachedFleeMap;
            } else {
                int y;
                int x;
                this.cachedLongerPaths = preferLongerPaths;
                this.cachedImpassable.clear();
                this.cachedImpassable.addAll(this.blocked);
                if (this.cachedFearSources == null) {
                    this.cachedFearSources = new ObjectSet(fearSources);
                } else {
                    this.cachedFearSources.clear();
                    this.cachedFearSources.ensureCapacity(fearSources.size());
                    this.cachedFearSources.addAll(fearSources);
                }
                this.resetMap();
                this.setGoals(fearSources);
                if (this.goals.isEmpty()) {
                    this.cutShort = true;
                    if (buffer == null) {
                        return new ObjectDeque();
                    }
                    return buffer;
                }
                this.cachedFleeMap = scanLimit <= 0 || scanLimit < length ? this.scan(this.blocked) : this.partialScan(scanLimit, this.blocked);
                for (x = 0; x < this.gradientMap.length; ++x) {
                    for (y = 0; y < this.gradientMap[x].length; ++y) {
                        float[] fArray = this.gradientMap[x];
                        int n = y;
                        fArray[n] = fArray[n] * (this.gradientMap[x][y] >= 999200.0f ? 1.0f : -preferLongerPaths);
                    }
                }
                if (scanLimit <= 0 || scanLimit < length) {
                    this.scan(null, this.blocked, true);
                    for (x = 0; x < this.width; ++x) {
                        for (y = 0; y < this.height; ++y) {
                            if (this.gradientMap[x][y] != 999200.0f) continue;
                            this.gradientMap[x][y] = 999800.0f;
                        }
                        System.arraycopy(this.gradientMap[x], 0, this.cachedFleeMap[x], 0, this.height);
                    }
                } else {
                    this.cachedFleeMap = this.partialScan(scanLimit, this.blocked);
                }
            }
            Object currentPos = this.workingEdit(start);
            float paidLength = 0.0f;
            this.rng.setState(start.xi(), start.yi(), fearSources.size(), this.blocked.size());
            do {
                Point2 last;
                if (this.frustration > 500) {
                    this.path.clear();
                    break block27;
                }
                currentPos = (Point2)currentPos.cpy();
                float best = this.gradientMap[currentPos.xi()][currentPos.yi()];
                this.shuffleDirs();
                int choice = 0;
                for (int d = 0; d <= this.measurement.directionCount(); ++d) {
                    int adjX = currentPos.xi() + this.dirs[d].deltaX;
                    int adjY = currentPos.yi() + this.dirs[d].deltaY;
                    if (adjX < 0 || adjY < 0 || adjX >= this.width || adjY >= this.height || this.dirs[d].isDiagonal() && this.blockingRequirement > 0 && (this.gradientMap[adjX][currentPos.yi()] > 999200.0f ? 1 : 0) + (this.gradientMap[currentPos.xi()][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                    P workPt = this.workingEdit(adjX, adjY);
                    if (!(this.gradientMap[adjX][adjY] < best) || this.blocked.contains(workPt) || this.dirs[choice] != Direction.NONE && this.path.contains(workPt)) continue;
                    best = this.gradientMap[adjX][adjY];
                    choice = d;
                }
                if (best >= this.gradientMap[start.xi()][start.yi()] || this.physicalMap[currentPos.xi() + this.dirs[choice].deltaX][currentPos.yi() + this.dirs[choice].deltaY] > 999200.0f) {
                    this.cutShort = true;
                    this.frustration = 0;
                    if (buffer == null) {
                        return new ObjectDeque<P>(this.path);
                    }
                    buffer.addAll((Collection<P>)this.path);
                    return buffer;
                }
                currentPos = currentPos.seti(currentPos.xi() + this.dirs[choice].deltaX, currentPos.yi() + this.dirs[choice].deltaY);
                if (!this.path.isEmpty() && this.gradientMap[(last = (Point2)this.path.peekLast()).xi()][last.yi()] <= this.gradientMap[currentPos.xi()][currentPos.yi()]) break block27;
                this.path.add(currentPos);
            } while (!((paidLength += 1.0f) > (float)length - 1.0f));
            if (onlyPassable != null && onlyPassable.contains(currentPos)) {
                ++this.frustration;
                this.blocked.add((Point2<?>)currentPos);
                return this.findFleePath(buffer, length, scanLimit, preferLongerPaths, this.blocked, onlyPassable, start, fearSources);
            }
        }
        this.cutShort = false;
        this.frustration = 0;
        this.goals.clear();
        if (buffer == null) {
            return new ObjectDeque<P>(this.path);
        }
        buffer.addAll((Collection<P>)this.path);
        return buffer;
    }

    public ObjectDeque<P> findPathPreScanned(Point2<?> target) {
        return this.findPathPreScanned(null, target);
    }

    public ObjectDeque<P> findPathPreScanned(ObjectDeque<P> buffer, Point2<?> target) {
        this.path.clear();
        if (!this.initialized || this.goals == null || this.goals.isEmpty()) {
            if (buffer == null) {
                return new ObjectDeque();
            }
            return buffer;
        }
        Object currentPos = this.acquire(target);
        if (!(this.gradientMap[currentPos.xi()][currentPos.yi()] <= 999200.0f)) {
            if (buffer == null) {
                return new ObjectDeque();
            }
            return buffer;
        }
        this.path.add(currentPos);
        this.rng.setState(target.xi(), target.yi(), 12345, 6789);
        do {
            currentPos = (Point2)currentPos.cpy();
            float best = this.gradientMap[currentPos.xi()][currentPos.yi()];
            this.shuffleDirs();
            int choice = 0;
            for (int d = 0; d <= this.measurement.directionCount(); ++d) {
                int adjX = currentPos.xi() + this.dirs[d].deltaX;
                int adjY = currentPos.yi() + this.dirs[d].deltaY;
                if (adjX < 0 || adjY < 0 || adjX >= this.width || adjY >= this.height || this.dirs[d].isDiagonal() && this.blockingRequirement > 0 && (this.gradientMap[adjX][currentPos.yi()] > 999200.0f ? 1 : 0) + (this.gradientMap[currentPos.xi()][adjY] > 999200.0f ? 1 : 0) >= this.blockingRequirement) continue;
                P workPt = this.workingEdit(adjX, adjY);
                if (!(this.gradientMap[adjX][adjY] < best) || this.blocked.contains(workPt) || this.dirs[choice] != Direction.NONE && this.path.contains(workPt)) continue;
                best = this.gradientMap[adjX][adjY];
                choice = d;
            }
            if (best >= this.gradientMap[currentPos.xi()][currentPos.yi()] || this.physicalMap[currentPos.xi() + this.dirs[choice].deltaX][currentPos.yi() + this.dirs[choice].deltaY] > 999200.0f) {
                this.cutShort = true;
                if (buffer == null) {
                    return new ObjectDeque<P>(this.path);
                }
                buffer.addAll((Collection<P>)this.path);
                return buffer;
            }
            currentPos = currentPos.seti(currentPos.xi() + this.dirs[choice].deltaX, currentPos.yi() + this.dirs[choice].deltaY);
            this.path.addFirst(currentPos);
        } while (this.gradientMap[currentPos.xi()][currentPos.yi()] != 0.0f);
        this.cutShort = false;
        if (buffer == null) {
            return new ObjectDeque<P>(this.path);
        }
        buffer.addAll((Collection<P>)this.path);
        return buffer;
    }

    public int getMappedCount() {
        return this.mappedCount;
    }

    public int getBlockingRequirement() {
        return this.blockingRequirement;
    }

    public void setBlockingRequirement(int blockingRequirement) {
        this.blockingRequirement = Math.min(Math.max(blockingRequirement, 0), 2);
    }

    protected void shuffleDirs() {
        switch (this.measurement) {
            case MANHATTAN: {
                for (int i = 3; i > 0; --i) {
                    int r = (i + 1) * (this.rng.nextInt() & 0xFFFF) >>> 16;
                    Direction t = this.dirs[r];
                    this.dirs[r] = this.dirs[i];
                    this.dirs[i] = t;
                }
                break;
            }
            case CHEBYSHEV: {
                for (int i = 7; i > 0; --i) {
                    int r = (i + 1) * (this.rng.nextInt() & 0xFFFF) >>> 16;
                    Direction t = this.dirs[r];
                    this.dirs[r] = this.dirs[i];
                    this.dirs[i] = t;
                }
                break;
            }
            default: {
                Direction t;
                int r;
                for (int i = 3; i > 0; --i) {
                    r = (i + 1) * (this.rng.nextInt() & 0xFFFF) >>> 16;
                    t = this.dirs[r];
                    this.dirs[r] = this.dirs[i];
                    this.dirs[i] = t;
                }
                for (int j = 7; j > 4; --j) {
                    r = 4 + ((j - 3) * (this.rng.nextInt() & 0xFFFF) >>> 16);
                    t = this.dirs[r];
                    this.dirs[r] = this.dirs[j];
                    this.dirs[j] = t;
                }
            }
        }
    }

    public static boolean isWithin(int x, int y, int width, int height) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public static boolean isWithin(Point2<?> pt, int width, int height) {
        return pt.xi() >= 0 && pt.xi() < width && pt.yi() >= 0 && pt.yi() < height;
    }

    public static float[][] copy(float[][] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 1) {
            return emptyFloats2D;
        }
        float[][] target = new float[source.length][];
        for (int i = 0; i < source.length; ++i) {
            int len = source[i].length;
            target[i] = new float[len];
            System.arraycopy(source[i], 0, target[i], 0, len);
        }
        return target;
    }

    protected boolean wallQuery(int gx, int gy) {
        return GradientGrid.isWithin(gx, gy, this.width, this.height) && this.physicalMap[gx][gy] == 999500.0f;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public GridMetric getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(GridMetric measurement) {
        this.measurement = measurement;
        if (measurement == GridMetric.MANHATTAN) {
            System.arraycopy(Direction.CARDINALS, 0, this.dirs, 0, 4);
            this.dirs[4] = Direction.NONE;
        } else {
            System.arraycopy(Direction.OUTWARDS, 0, this.dirs, 0, 8);
            this.dirs[8] = Direction.NONE;
        }
    }
}

