/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Internals;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.NodeMap;
import com.github.tommyettinger.gand.algorithms.Algorithms;
import com.github.tommyettinger.gand.ds.ObjectDeque;
import com.github.tommyettinger.gand.ds.ObjectOrderedSet;
import com.github.tommyettinger.gand.utils.Errors;
import com.github.tommyettinger.gand.utils.GwtIncompatible;
import com.github.tommyettinger.gand.utils.ObjectPredicate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public abstract class Graph<V>
implements Externalizable {
    final NodeMap<V> nodeMap;
    protected final ObjectOrderedSet<Connection<V>> edgeSet;
    protected final transient Internals<V> internals = new Internals(this);
    protected float defaultEdgeWeight = 1.0f;

    protected Graph() {
        this.nodeMap = new NodeMap(this);
        this.edgeSet = new ObjectOrderedSet();
    }

    protected Graph(Collection<V> vertices) {
        this();
        for (V v : vertices) {
            this.addVertex(v);
        }
    }

    protected Graph(Collection<V> vertices, Collection<Edge<V>> edges, float defaultEdgeWeight) {
        this.nodeMap = new NodeMap(this);
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        this.edgeSet = new ObjectOrderedSet(edges.size());
        for (V v : vertices) {
            this.addVertex(v);
        }
        for (Edge edge : edges) {
            this.addEdge(edge);
        }
    }

    protected Graph(Graph<V> graph) {
        this.nodeMap = new NodeMap(this);
        this.setDefaultEdgeWeight(graph.getDefaultEdgeWeight());
        Set<Connection<V>> edges = graph.getEdges();
        this.edgeSet = new ObjectOrderedSet(edges.size());
        Set<V> vertices = graph.getVertices();
        for (V v : vertices) {
            this.addVertex(v);
        }
        for (Edge edge : edges) {
            this.addEdge(edge.getA(), edge.getB(), edge.getWeight());
        }
    }

    abstract Connection<V> obtainEdge();

    public abstract Graph<V> createNew();

    public abstract Algorithms<V> algorithms();

    public boolean addVertex(V v) {
        return this.nodeMap.put(v) != null;
    }

    public void addVertices(Collection<V> vertices) {
        for (V v : vertices) {
            this.addVertex(v);
        }
    }

    @SafeVarargs
    public final void addVertices(V ... vertices) {
        for (V v : vertices) {
            this.addVertex(v);
        }
    }

    public boolean removeVertex(V v) {
        Node<V> existing = this.nodeMap.remove(v);
        if (existing == null) {
            return false;
        }
        this.disconnect(existing);
        return true;
    }

    public void disconnect(V v) {
        Node<V> existing = this.nodeMap.get(v);
        if (existing == null) {
            Errors.throwVertexNotInGraphVertexException(false);
        }
        this.disconnect(existing);
    }

    protected void disconnect(Node<V> node) {
        int i;
        for (i = node.getOutEdges().size() - 1; i >= 0; --i) {
            this.removeConnection(node, node.getOutEdges().get((int)i).b);
        }
        if (node.getInEdges() != null) {
            for (i = node.getInEdges().size() - 1; i >= 0; --i) {
                this.removeConnection(node.getInEdges().get((int)i).a, node);
            }
        }
        node.disconnect();
    }

    public void removeVertices(Collection<V> vertices) {
        for (V v : vertices) {
            this.removeVertex(v);
        }
    }

    public void removeVertexIf(ObjectPredicate<V> predicate) {
        Set<V> existing = this.getVertices();
        ObjectDeque vertices = new ObjectDeque(existing.size());
        for (Object v : existing) {
            if (!predicate.test(v)) continue;
            vertices.add(v);
        }
        this.removeVertices(vertices);
    }

    public Connection<V> addEdge(V v, V w) {
        return this.addEdge(v, w, this.getDefaultEdgeWeight());
    }

    public Connection<V> addEdge(Edge<V> edge) {
        this.addVertex(edge.getA());
        this.addVertex(edge.getB());
        return this.addEdge(edge.getA(), edge.getB(), edge.getWeight());
    }

    public Connection<V> addEdge(V v, V w, float weight) {
        if (v == null || w == null) {
            Errors.throwNullVertexException();
        }
        if (v.equals(w)) {
            Errors.throwSameVertexException();
        }
        Node<V> a = this.getNode(v);
        Node<V> b = this.getNode(w);
        if (a == null || b == null) {
            Errors.throwVertexNotInGraphVertexException(true);
        }
        return this.addConnection(a, b, weight);
    }

    public boolean removeEdge(V v, V w) {
        Node<V> a = this.getNode(v);
        Node<V> b = this.getNode(w);
        if (a == null || b == null) {
            Errors.throwVertexNotInGraphVertexException(true);
        }
        return this.removeConnection(a, b);
    }

    public boolean removeEdge(Edge<V> edge) {
        return this.removeConnection(edge.getInternalNodeA(), edge.getInternalNodeB());
    }

    public void removeEdges(Collection<? extends Edge<V>> edges) {
        for (Edge<V> e : edges) {
            this.removeConnection(e.getInternalNodeA(), e.getInternalNodeB());
        }
    }

    public void removeEdgeIf(ObjectPredicate<Edge<V>> predicate) {
        Set<Connection<V>> existing = this.getEdges();
        ObjectDeque<Edge> edges = new ObjectDeque<Edge>(existing.size());
        for (Edge edge : existing) {
            if (!predicate.test(edge)) continue;
            edges.add(edge);
        }
        this.removeEdges(edges);
    }

    public void removeAllEdges() {
        for (Node<V> v : this.getNodes()) {
            v.disconnect();
        }
        this.edgeSet.clear();
    }

    public void removeAllVertices() {
        this.edgeSet.clear();
        this.nodeMap.clear();
    }

    public void clear() {
        this.removeAllVertices();
    }

    public void sortVertices(Comparator<V> comparator) {
        this.nodeMap.sort(comparator);
    }

    public void sortEdges(Comparator<Connection<V>> comparator) {
        this.edgeSet.order().sort(comparator);
    }

    public int hash(V v) {
        int h = v.hashCode();
        return h ^ (h << 23 | h >>> 9) ^ (h << 7 | h >>> 25);
    }

    Connection<V> addConnection(Node<V> a, Node<V> b) {
        Connection<V> e = a.getEdge(b);
        return e != null ? e : this.addConnection(a, b, this.getDefaultEdgeWeight());
    }

    Connection<V> addConnection(Node<V> a, Node<V> b, float weight) {
        Connection<V> e = a.getEdge(b);
        if (e == null) {
            e = this.obtainEdge();
            e.set(a, b, weight);
            a.addEdge(e);
            this.edgeSet.add(e);
        } else {
            e.setWeight(weight);
        }
        return e;
    }

    boolean removeConnection(Node<V> a, Node<V> b) {
        return this.removeConnection(a, b, true);
    }

    boolean removeConnection(Node<V> a, Node<V> b, boolean removeFromMap) {
        Connection<V> e = a.removeEdge(b);
        if (e == null) {
            return false;
        }
        if (removeFromMap) {
            this.edgeSet.remove(e);
        }
        return true;
    }

    public boolean contains(V v) {
        return this.nodeMap.contains(v);
    }

    public Edge<V> getEdge(V v, V w) {
        Connection<V> edge;
        Node<V> a = this.getNode(v);
        Node<V> b = this.getNode(w);
        if (a == null || b == null) {
            Errors.throwVertexNotInGraphVertexException(true);
        }
        if ((edge = this.getEdge(a, b)) == null) {
            return null;
        }
        return edge;
    }

    public boolean edgeExists(V v, V w) {
        Node<V> a = this.getNode(v);
        Node<V> b = this.getNode(w);
        if (a == null || b == null) {
            Errors.throwVertexNotInGraphVertexException(true);
        }
        return this.connectionExists(a, b);
    }

    public Collection<Edge<V>> getEdges(V v) {
        Node<V> node = this.getNode(v);
        if (node == null) {
            return null;
        }
        return Collections.unmodifiableCollection(node.getOutEdges());
    }

    public Set<Connection<V>> getEdges() {
        return Collections.unmodifiableSet(this.edgeSet);
    }

    public Set<V> getVertices() {
        return this.nodeMap.vertexSet;
    }

    public V getStoredVertex(V vertex) {
        Node<V> node = this.getNode(vertex);
        if (node == null) {
            return null;
        }
        return node.getObject();
    }

    public boolean isDirected() {
        return true;
    }

    public int size() {
        return this.nodeMap.size;
    }

    public int getEdgeCount() {
        return this.edgeSet.size();
    }

    public Internals<V> internals() {
        return this.internals;
    }

    public float getDefaultEdgeWeight() {
        return this.defaultEdgeWeight;
    }

    public void setDefaultEdgeWeight(float defaultEdgeWeight) {
        this.defaultEdgeWeight = defaultEdgeWeight;
    }

    public boolean isConnected() {
        return this.numberOfComponents() == 1;
    }

    public int numberOfComponents() {
        for (Node<V> node : this.getNodes()) {
            node.setSeen(false);
        }
        int[] visited = new int[]{0};
        int components = 0;
        Iterator<V> iter = this.getVertices().iterator();
        while (iter.hasNext() && visited[0] < this.size()) {
            V n = iter.next();
            if (this.nodeMap.get(n).isSeen()) continue;
            ++components;
            this.algorithms().depthFirstSearch(n, v -> {
                visited[0] = visited[0] + 1;
            });
        }
        return components;
    }

    public ArrayList<Graph<V>> getComponents() {
        for (Node<V> node : this.getNodes()) {
            node.setSeen(false);
        }
        int[] visited = new int[]{0};
        ArrayList<Graph<V>> components = new ArrayList<Graph<V>>(16);
        Iterator<V> iter = this.getVertices().iterator();
        while (iter.hasNext() && visited[0] < this.size()) {
            V n = iter.next();
            if (this.nodeMap.get(n).isSeen()) continue;
            Graph comp = this.createNew();
            this.algorithms().depthFirstSearch(n, v -> {
                comp.addVertex(v.vertex());
                comp.edgeSet.addAll(v.neighbors());
                visited[0] = visited[0] + 1;
            });
            components.add(comp);
        }
        return components;
    }

    public Graph<V> largestComponent() {
        for (Node<V> node : this.getNodes()) {
            node.setSeen(false);
        }
        int[] visited = new int[]{0};
        Iterator<V> iter = this.getVertices().iterator();
        Graph<V> best = null;
        while (iter.hasNext() && visited[0] < this.size()) {
            V n = iter.next();
            if (this.nodeMap.get(n).isSeen()) continue;
            Graph work = this.createNew();
            this.algorithms().depthFirstSearch(n, v -> {
                work.addVertex(v.vertex());
                work.edgeSet.addAll(v.neighbors());
                visited[0] = visited[0] + 1;
            });
            if (best != null && work.size() <= best.size()) continue;
            if (work.size() >= this.size() - visited[0]) {
                return work;
            }
            best = work;
        }
        if (best == null) {
            best = this.createNew();
        }
        return best;
    }

    Node<V> getNode(V v) {
        return this.nodeMap.get(v);
    }

    Collection<Node<V>> getNodes() {
        return this.nodeMap.nodeCollection;
    }

    boolean connectionExists(Node<V> u, Node<V> v) {
        return u.getEdge(v) != null;
    }

    Connection<V> getEdge(Node<V> a, Node<V> b) {
        return a.getEdge(b);
    }

    @Override
    @GwtIncompatible
    public void writeExternal(ObjectOutput out) throws IOException {
        Set<V> vertices = this.getVertices();
        out.writeInt(vertices.size());
        for (V vertex : vertices) {
            out.writeObject(vertex);
        }
        Set<Connection<V>> edges = this.getEdges();
        out.writeInt(edges.size());
        for (Edge edge : edges) {
            out.writeObject(edge.getA());
            out.writeObject(edge.getB());
            out.writeFloat(edge.getWeight());
        }
    }

    @Override
    @GwtIncompatible
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.removeAllVertices();
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            this.addVertex(in.readObject());
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            this.addEdge(in.readObject(), in.readObject(), in.readFloat());
        }
    }

    public String toString() {
        return (this.isDirected() ? "Directed" : "Undirected") + " graph with " + this.size() + " vertices and " + this.getEdgeCount() + " edges";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Graph graph = (Graph)o;
        if (!this.nodeMap.vertexSet.equals(graph.nodeMap.vertexSet)) {
            return false;
        }
        return this.edgeSet.equals(graph.edgeSet);
    }

    public int hashCode() {
        int result = this.nodeMap.hashCode();
        result = 31 * result + this.edgeSet.hashCode();
        return result;
    }
}

