/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.UndirectedGraph;
import com.github.tommyettinger.gand.utils.Heuristic;
import com.github.tommyettinger.gdcrux.PointI2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class Int2UndirectedGraph
extends UndirectedGraph<PointI2>
implements Json.Serializable {
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;

    @Override
    public boolean addVertex(PointI2 gridPoint2) {
        if (super.addVertex(gridPoint2)) {
            this.maxX = Math.max(this.maxX, gridPoint2.x + 1);
            this.maxY = Math.max(this.maxY, gridPoint2.y + 1);
            return true;
        }
        return false;
    }

    public Int2UndirectedGraph() {
    }

    public Int2UndirectedGraph(Collection<PointI2> vertices) {
        this(vertices, (Collection<Edge<PointI2>>)Collections.emptyList(), 1.0f);
    }

    public Int2UndirectedGraph(Collection<PointI2> vertices, Collection<Edge<PointI2>> edges, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (PointI2 pointI2 : vertices) {
            this.addVertex(pointI2);
        }
        for (Edge edge : edges) {
            this.addEdge(edge);
        }
    }

    public Int2UndirectedGraph(Graph<PointI2> graph) {
        this.setDefaultEdgeWeight(graph.getDefaultEdgeWeight());
        Set<Connection<PointI2>> edges = graph.getEdges();
        Set<PointI2> vertices = graph.getVertices();
        for (PointI2 pointI2 : vertices) {
            this.addVertex(pointI2);
        }
        for (Edge edge : edges) {
            this.addEdge((PointI2)edge.getA(), (PointI2)edge.getB(), edge.getWeight());
        }
    }

    public Int2UndirectedGraph(boolean[][] validGrid, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (!validGrid[x][y]) continue;
                this.addVertex(new PointI2(x, y));
            }
        }
    }

    public Int2UndirectedGraph(char[][] validGrid, char validChar, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (validGrid[x][y] != validChar) continue;
                this.addVertex(new PointI2(x, y));
            }
        }
    }

    public Int2UndirectedGraph(float[][] validGrid, float minimumThreshold, float maximumThreshold, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int x = 0; x < validGrid.length; ++x) {
            for (int y = 0; y < validGrid[x].length; ++y) {
                if (!(validGrid[x][y] >= minimumThreshold) || !(validGrid[x][y] <= maximumThreshold)) continue;
                this.addVertex(new PointI2(x, y));
            }
        }
    }

    public void connectAdjacent(Heuristic<PointI2> heu, boolean permitDiagonal) {
        PointI2 test = new PointI2();
        PointI2 next = new PointI2();
        if (heu == null) {
            heu = (a, b) -> this.getDefaultEdgeWeight();
        }
        for (int x = 0; x < this.maxX; ++x) {
            test.x = x;
            for (int y = 0; y < this.maxY; ++y) {
                Node nmn;
                test.y = y;
                Node nmt = this.nodeMap.get(test);
                if (nmt == null) continue;
                PointI2 t = (PointI2)nmt.getObject();
                if (permitDiagonal) {
                    next.x = x - 1;
                    next.y = y - 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x + 1;
                    next.y = y - 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x - 1;
                    next.y = y + 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x + 1;
                    next.y = y + 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                    }
                }
                next.x = x;
                next.y = y - 1;
                nmn = this.nodeMap.get(next);
                if (nmn != null) {
                    this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                }
                next.x = x - 1;
                next.y = y;
                nmn = this.nodeMap.get(next);
                if (nmn != null) {
                    this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                }
                next.x = x + 1;
                next.y = y;
                nmn = this.nodeMap.get(next);
                if (nmn != null) {
                    this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
                }
                next.x = x;
                next.y = y + 1;
                nmn = this.nodeMap.get(next);
                if (nmn == null) continue;
                this.addEdge(t, (PointI2)nmn.getObject(), heu.getEstimate(test, next));
            }
        }
    }

    @Override
    public Int2UndirectedGraph createNew() {
        return new Int2UndirectedGraph();
    }

    @Override
    public int hash(PointI2 gp) {
        return gp.hashCode();
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public char[] show() {
        if (this.maxX == Integer.MIN_VALUE || this.maxY == Integer.MIN_VALUE) {
            return new char[0];
        }
        int w5 = this.maxX * 5;
        int len = w5 * this.maxY;
        char[] cs = new char[len];
        Arrays.fill(cs, '#');
        for (int i = 4; i < cs.length; i += 5) {
            cs[i] = (i + 1) % w5 == 0 ? 10 : 32;
        }
        int rid = this.algorithms.lastRunID();
        for (Node nc : this.nodeMap.nodeCollection) {
            if (nc == null || nc.getLastRunID() != rid || (double)nc.getDistance() >= 9999.5) continue;
            int d = (int)((double)nc.getDistance() + 0.5);
            int x = ((PointI2)nc.getObject()).x * 5;
            int y = ((PointI2)nc.getObject()).y;
            cs[len - w5 - y * w5 + x] = d >= 1000 ? (int)(48 + d / 1000) : 32;
            cs[len - w5 - y * w5 + x + 1] = d >= 100 ? (int)(48 + d / 100 % 10) : 32;
            cs[len - w5 - y * w5 + x + 2] = d >= 10 ? (int)(48 + d / 10 % 10) : 32;
            cs[len - w5 - y * w5 + x + 3] = (char)(48 + d % 10);
        }
        return cs;
    }

    public char[] show(boolean showEdges) {
        if (!showEdges) {
            return this.show();
        }
        if (this.maxX == Integer.MIN_VALUE || this.maxY == Integer.MIN_VALUE) {
            return new char[0];
        }
        int w6 = this.maxX * 6;
        int len = w6 * this.maxY * 2 - w6;
        char[] cs = new char[len];
        Arrays.fill(cs, '#');
        for (int i = 4; i < cs.length; i += 6) {
            cs[i] = 32;
            cs[i + 1] = (i + 2) % w6 == 0 ? 10 : 32;
        }
        int rid = this.algorithms.lastRunID();
        for (Node nc : this.nodeMap.nodeCollection) {
            if (nc == null || nc.getLastRunID() != rid || (double)nc.getDistance() >= 9999.5) continue;
            int d = (int)((double)nc.getDistance() + 0.5);
            int x = ((PointI2)nc.getObject()).x * 6;
            int y = ((PointI2)nc.getObject()).y * 2;
            cs[len - w6 - y * w6 + x] = d >= 1000 ? (int)(48 + d / 1000) : 32;
            cs[len - w6 - y * w6 + x + 1] = d >= 100 ? (int)(48 + d / 100 % 10) : 32;
            cs[len - w6 - y * w6 + x + 2] = d >= 10 ? (int)(48 + d / 10 % 10) : 32;
            cs[len - w6 - y * w6 + x + 3] = (char)(48 + d % 10);
            for (Connection edge : nc.getOutEdges()) {
                PointI2 other;
                PointI2 pointI2 = other = edge.getA() == nc.getObject() ? (PointI2)edge.getB() : (PointI2)edge.getA();
                if (other.x < ((PointI2)nc.getObject()).x && other.y == ((PointI2)nc.getObject()).y) {
                    cs[len - w6 - y * w6 + x - 1] = 8592;
                    continue;
                }
                if (other.x > ((PointI2)nc.getObject()).x && other.y == ((PointI2)nc.getObject()).y) {
                    cs[len - w6 - y * w6 + x + 4] = 8594;
                    continue;
                }
                if (other.x == ((PointI2)nc.getObject()).x && other.y < ((PointI2)nc.getObject()).y) {
                    cs[len - y * w6 + x + 1] = 8595;
                    continue;
                }
                if (other.x == ((PointI2)nc.getObject()).x && other.y > ((PointI2)nc.getObject()).y) {
                    cs[len - w6 - w6 - y * w6 + x + 2] = 8593;
                    continue;
                }
                if (other.x < ((PointI2)nc.getObject()).x && other.y > ((PointI2)nc.getObject()).y) {
                    cs[len - w6 - w6 - y * w6 + x] = 8598;
                    continue;
                }
                if (other.x > ((PointI2)nc.getObject()).x && other.y > ((PointI2)nc.getObject()).y) {
                    cs[len - w6 - w6 - y * w6 + x + 3] = 8599;
                    continue;
                }
                if (other.x < ((PointI2)nc.getObject()).x && other.y < ((PointI2)nc.getObject()).y) {
                    cs[len - y * w6 + x - 1] = 8601;
                    continue;
                }
                if (other.x <= ((PointI2)nc.getObject()).x || other.y >= ((PointI2)nc.getObject()).y) continue;
                cs[len - y * w6 + x + 4] = 8600;
            }
        }
        return cs;
    }

    @Override
    public String toString() {
        return "Int2UndirectedGraph: {\n" + String.valueOf(this.show()) + "\n}";
    }

    public String toString(boolean showEdges) {
        return "Int2UndirectedGraph: {\n" + String.valueOf(this.show(showEdges)) + "\n}";
    }

    @Override
    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, PointI2.class);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), PointI2.class);
            json.writeValue(edge.getB(), PointI2.class);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex((PointI2)json.readValue(PointI2.class, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            PointI2 pointI2 = (PointI2)json.readValue(PointI2.class, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(pointI2, (PointI2)json.readValue(PointI2.class, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

