/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.UndirectedGraph;
import com.github.tommyettinger.gand.utils.Heuristic;
import com.github.tommyettinger.gdcrux.PointI3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class Int3UndirectedGraph
extends UndirectedGraph<PointI3>
implements Json.Serializable {
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    @Override
    public boolean addVertex(PointI3 gridPoint3) {
        if (super.addVertex(gridPoint3)) {
            this.maxX = Math.max(this.maxX, gridPoint3.x + 1);
            this.maxY = Math.max(this.maxY, gridPoint3.y + 1);
            this.maxZ = Math.max(this.maxZ, gridPoint3.z + 1);
            return true;
        }
        return false;
    }

    public Int3UndirectedGraph() {
    }

    public Int3UndirectedGraph(Collection<PointI3> vertices) {
        this(vertices, (Collection<Edge<PointI3>>)Collections.emptyList(), 1.0f);
    }

    public Int3UndirectedGraph(Collection<PointI3> vertices, Collection<Edge<PointI3>> edges, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (PointI3 pointI3 : vertices) {
            this.addVertex(pointI3);
        }
        for (Edge edge : edges) {
            this.addEdge(edge);
        }
    }

    public Int3UndirectedGraph(Graph<PointI3> graph) {
        this.setDefaultEdgeWeight(graph.getDefaultEdgeWeight());
        Set<Connection<PointI3>> edges = graph.getEdges();
        Set<PointI3> vertices = graph.getVertices();
        for (PointI3 pointI3 : vertices) {
            this.addVertex(pointI3);
        }
        for (Edge edge : edges) {
            this.addEdge((PointI3)edge.getA(), (PointI3)edge.getB(), edge.getWeight());
        }
    }

    public Int3UndirectedGraph(boolean[][][] validGrid, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int z = 0; z < validGrid.length; ++z) {
            for (int y = 0; y < validGrid[z].length; ++y) {
                for (int x = 0; x < validGrid[z][y].length; ++x) {
                    if (!validGrid[z][y][x]) continue;
                    this.addVertex(new PointI3(x, y, z));
                }
            }
        }
    }

    public Int3UndirectedGraph(char[][][] validGrid, char validChar, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int z = 0; z < validGrid.length; ++z) {
            for (int y = 0; y < validGrid[z].length; ++y) {
                for (int x = 0; x < validGrid[z][y].length; ++x) {
                    if (validGrid[z][y][x] != validChar) continue;
                    this.addVertex(new PointI3(x, y, z));
                }
            }
        }
    }

    public Int3UndirectedGraph(float[][][] validGrid, float minimumThreshold, float maximumThreshold, float defaultEdgeWeight) {
        this.setDefaultEdgeWeight(defaultEdgeWeight);
        for (int z = 0; z < validGrid.length; ++z) {
            for (int y = 0; y < validGrid[z].length; ++y) {
                for (int x = 0; x < validGrid[z][y].length; ++x) {
                    if (!(validGrid[z][y][x] >= minimumThreshold) || !(validGrid[z][y][x] <= maximumThreshold)) continue;
                    this.addVertex(new PointI3(x, y, z));
                }
            }
        }
    }

    public void connectAdjacent(Heuristic<PointI3> heu, boolean permitDiagonal) {
        PointI3 test = new PointI3();
        PointI3 next = new PointI3();
        if (heu == null) {
            heu = (a, b) -> this.getDefaultEdgeWeight();
        }
        for (int x = 0; x < this.maxX; ++x) {
            test.x = x;
            for (int y = 0; y < this.maxY; ++y) {
                test.y = y;
                for (int z = 0; z < this.maxZ; ++z) {
                    Node nmn;
                    test.z = z;
                    Node nmt = this.nodeMap.get(test);
                    if (nmt == null) continue;
                    PointI3 t = (PointI3)nmt.getObject();
                    if (permitDiagonal) {
                        next.x = x - 1;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x - 1;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.z = z - 1;
                        next.x = x - 1;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x - 1;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x - 1;
                        next.y = y;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.z = z + 1;
                        next.x = x - 1;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x - 1;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x;
                        next.y = y - 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x - 1;
                        next.y = y;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x + 1;
                        next.y = y;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                        next.x = x;
                        next.y = y + 1;
                        nmn = this.nodeMap.get(next);
                        if (nmn != null) {
                            this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                        }
                    }
                    next.x = x;
                    next.y = y;
                    next.z = z - 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.z = z + 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.z = z;
                    next.x = x;
                    next.y = y - 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x - 1;
                    next.y = y;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x + 1;
                    next.y = y;
                    nmn = this.nodeMap.get(next);
                    if (nmn != null) {
                        this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                    }
                    next.x = x;
                    next.y = y + 1;
                    nmn = this.nodeMap.get(next);
                    if (nmn == null) continue;
                    this.addEdge(t, (PointI3)nmn.getObject(), heu.getEstimate(test, next));
                }
            }
        }
    }

    @Override
    public Int3UndirectedGraph createNew() {
        return new Int3UndirectedGraph();
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @Override
    public int hash(PointI3 gp) {
        return gp.hashCode();
    }

    public char[] show() {
        int i;
        if (this.maxX == Integer.MIN_VALUE || this.maxY == Integer.MIN_VALUE || this.maxZ == Integer.MIN_VALUE) {
            return new char[0];
        }
        int w5 = this.maxX * 5;
        int hw = w5 * this.maxY;
        char[] cs = new char[(hw + 1) * this.maxZ];
        Arrays.fill(cs, '#');
        for (i = 4; i < hw; i += 5) {
            cs[i] = (i + 1) % w5 == 0 ? 10 : 32;
        }
        cs[hw] = 10;
        for (i = 1; i < this.maxZ; ++i) {
            System.arraycopy(cs, 0, cs, (hw + 1) * i, hw + 1);
        }
        int rid = this.algorithms.lastRunID();
        for (Node nc : this.nodeMap.nodeCollection) {
            if (nc == null || nc.getLastRunID() != rid || (double)nc.getDistance() >= 9999.5) continue;
            int d = (int)((double)nc.getDistance() + 0.5);
            int x = ((PointI3)nc.getObject()).x * 5;
            int y = ((PointI3)nc.getObject()).y;
            int z = ((PointI3)nc.getObject()).z;
            int i2 = z * (hw + 1) + y * w5 + x;
            cs[i2] = d >= 1000 ? (int)(48 + d / 1000) : 32;
            cs[i2 + 1] = d >= 100 ? (int)(48 + d / 100 % 10) : 32;
            cs[i2 + 2] = d >= 10 ? (int)(48 + d / 10 % 10) : 32;
            cs[i2 + 3] = (char)(48 + d % 10);
        }
        return cs;
    }

    @Override
    public String toString() {
        return "Int3UndirectedGraph: {\n" + String.valueOf(this.show()) + "\n}";
    }

    @Override
    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, PointI3.class);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), PointI3.class);
            json.writeValue(edge.getB(), PointI3.class);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex((PointI3)json.readValue(PointI3.class, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            PointI3 pointI3 = (PointI3)json.readValue(PointI3.class, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(pointI3, (PointI3)json.readValue(PointI3.class, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

