/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.ObjectMap;
import com.github.tommyettinger.gand.Connection;
import java.util.ArrayList;
import java.util.Objects;

public class Node<V> {
    private final V object;
    protected ObjectMap<Node<V>, Connection<V>> neighbors = new ObjectMap(8, 0.5f);
    protected ArrayList<Connection<V>> outEdges = new ArrayList(8);
    protected ArrayList<Connection<V>> inEdges;
    public final int mapHash;
    Node<V> nextInOrder = null;
    Node<V> prevInOrder = null;
    Node<V> nextInBucket = null;
    private boolean processed;
    private boolean seen;
    private float distance;
    private float estimate;
    private Node<V> prev;
    private Connection<V> connection;
    private int index;
    private int lastRunID = -1;
    public int heapIndex;
    public float heapValue;

    public Node(V v, boolean trackInEdges, int objectHash) {
        this.object = v;
        this.mapHash = objectHash;
        if (trackInEdges) {
            this.setInEdges(new ArrayList<Connection<V>>(8));
        }
    }

    Connection<V> getEdge(Node<V> v) {
        return (Connection)this.neighbors.get(v);
    }

    void addEdge(Connection<V> edge) {
        Node<V> to = edge.getNodeB();
        this.neighbors.put(to, edge);
        this.getOutEdges().add(edge);
        if (to.getInEdges() != null) {
            to.getInEdges().add(edge);
        }
    }

    Connection<V> removeEdge(Node<V> v) {
        Connection edge = (Connection)this.neighbors.remove(v);
        if (edge == null) {
            return null;
        }
        this.getOutEdges().remove(edge);
        if (v.getInEdges() != null) {
            v.getInEdges().remove(edge);
        }
        return edge;
    }

    public ArrayList<Connection<V>> getConnections() {
        return this.getOutEdges();
    }

    public V getObject() {
        return this.object;
    }

    public int getInDegree() {
        return this.getInEdges() == null ? this.getOutDegree() : this.getInEdges().size();
    }

    public int getOutDegree() {
        return this.getOutEdges().size();
    }

    public void disconnect() {
        this.neighbors.clear();
        this.getOutEdges().clear();
        if (this.getInEdges() != null) {
            this.getInEdges().clear();
        }
    }

    public boolean resetAlgorithmAttribs(int runID) {
        if (runID == this.getLastRunID()) {
            return false;
        }
        this.setProcessed(false);
        this.setPrev(null);
        this.setConnection(null);
        this.setDistance(Float.MAX_VALUE);
        this.setEstimate(0.0f);
        this.setIndex(0);
        this.setSeen(false);
        this.setLastRunID(runID);
        return true;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isSeen() {
        return this.seen;
    }

    public void setSeen(boolean seen) {
        this.seen = seen;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getEstimate() {
        return this.estimate;
    }

    public void setEstimate(float estimate) {
        this.estimate = estimate;
    }

    public Node<V> getPrev() {
        return this.prev;
    }

    public void setPrev(Node<V> prev) {
        this.prev = prev;
    }

    public Connection<V> getConnection() {
        return this.connection;
    }

    public void setConnection(Connection<V> connection) {
        this.connection = connection;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getLastRunID() {
        return this.lastRunID;
    }

    public void setLastRunID(int lastRunID) {
        this.lastRunID = lastRunID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.object, node.object);
    }

    public int hashCode() {
        return this.mapHash;
    }

    public String toString() {
        return "[" + this.object + "]";
    }

    public ArrayList<Connection<V>> getOutEdges() {
        return this.outEdges;
    }

    public void setOutEdges(ArrayList<Connection<V>> outEdges) {
        this.outEdges = outEdges;
    }

    public ArrayList<Connection<V>> getInEdges() {
        return this.inEdges;
    }

    public void setInEdges(ArrayList<Connection<V>> inEdges) {
        this.inEdges = inEdges;
    }
}

