/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.NodeMap;
import com.github.tommyettinger.gand.utils.Errors;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

class NodeCollection<V>
extends AbstractCollection<Node<V>> {
    NodeMap<V> nodeMap;

    NodeCollection(NodeMap<V> nodeMap) {
        this.nodeMap = nodeMap;
    }

    @Override
    public int size() {
        return this.nodeMap.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.nodeMap.contains(o);
    }

    @Override
    public Iterator<Node<V>> iterator() {
        return new NodeMap.NodeIterator<V>(this.nodeMap);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.nodeMap.size];
        int index = 0;
        for (int i = 0; i < this.nodeMap.table.length; ++i) {
            Node node = this.nodeMap.table[i];
            while (node != null) {
                array[index++] = node.getObject();
                node = node.nextInBucket;
            }
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.nodeMap.size) {
            array = Arrays.copyOf(array, this.nodeMap.size);
        }
        int index = 0;
        for (int i = 0; i < this.nodeMap.table.length; ++i) {
            Node node = this.nodeMap.table[i];
            while (node != null) {
                array[index++] = node.getObject();
                node = node.nextInBucket;
            }
        }
        return array;
    }

    @Override
    public boolean add(Node<V> v) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean remove(Object o) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Node<V>> collection) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public void clear() {
        Errors.throwModificationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeCollection that = (NodeCollection)o;
        return Objects.equals(this.nodeMap, that.nodeMap);
    }

    @Override
    public int hashCode() {
        return this.nodeMap != null ? this.nodeMap.hashCode() : 0;
    }
}

