/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.NodeCollection;
import com.github.tommyettinger.gand.VertexSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

class NodeMap<V> {
    final Graph<V> graph;
    Node<V>[] table;
    Node<V> head;
    Node<V> tail;
    int size = 0;
    int occupiedBuckets = 0;
    static final int MIN_TABLE_LENGTH = 32;
    static final float RESIZE_THRESHOLD = 0.7f;
    int threshold = 22;
    VertexSet<V> vertexSet;
    NodeCollection<V> nodeCollection;
    Node<V> cursor;

    public NodeMap(Graph<V> graph) {
        this.graph = graph;
        this.table = new Node[32];
        this.vertexSet = new VertexSet(this);
        this.nodeCollection = new NodeCollection(this);
    }

    Node<V> get(Object v) {
        int hash = this.graph.hash(v);
        int i = this.getIndex(hash);
        Node<V> bucketHead = this.table[i];
        if (bucketHead == null) {
            return null;
        }
        Node<V> currentNode = bucketHead;
        while (currentNode != null) {
            if (v.equals(currentNode.getObject())) {
                return currentNode;
            }
            currentNode = currentNode.nextInBucket;
        }
        return null;
    }

    boolean contains(Object v) {
        return this.get(v) != null;
    }

    Node<V> put(V v) {
        this.checkLength(1);
        int hash = this.graph.hash(v);
        int i = this.getIndex(hash);
        Node<V> bucketHead = this.table[i];
        if (bucketHead == null) {
            bucketHead = new Node<V>(v, this.graph.isDirected(), hash);
            this.table[i] = bucketHead;
            ++this.size;
            ++this.occupiedBuckets;
            this.addToList(bucketHead);
            return bucketHead;
        }
        Node<V> currentNode = bucketHead;
        Node<V> previousNode = null;
        while (currentNode != null) {
            if (v.equals(currentNode.getObject())) {
                return null;
            }
            previousNode = currentNode;
            currentNode = currentNode.nextInBucket;
        }
        currentNode = new Node<V>(v, this.graph.isDirected(), hash);
        previousNode.nextInBucket = currentNode;
        ++this.size;
        this.addToList(currentNode);
        return currentNode;
    }

    void addToList(Node<V> node) {
        if (this.head == null) {
            this.head = node;
            this.tail = node;
            return;
        }
        node.prevInOrder = this.tail;
        this.tail.nextInOrder = node;
        this.tail = node;
    }

    void insertIntoList(Node<V> v, Node<V> at, boolean before) {
        if (before) {
            v.nextInOrder = at;
            v.prevInOrder = at.prevInOrder;
            at.prevInOrder = v;
            if (v.prevInOrder != null) {
                v.prevInOrder.nextInOrder = v;
            } else {
                this.head = v;
            }
        } else {
            v.prevInOrder = at;
            v.nextInOrder = at.nextInOrder;
            at.nextInOrder = v;
            if (v.nextInOrder != null) {
                v.nextInOrder.prevInOrder = v;
            } else {
                this.tail = v;
            }
        }
    }

    void insertIntoListAfter(Node<V> v, Node<V> at) {
        this.insertIntoList(v, at, false);
    }

    void insertIntoListBefore(Node<V> v, Node<V> at) {
        this.insertIntoList(v, at, true);
    }

    Node<V> remove(V v) {
        int hash = this.graph.hash(v);
        int i = this.getIndex(hash);
        Node<V> currentNode = this.table[i];
        if (currentNode != null && v.equals(currentNode.getObject())) {
            this.table[i] = currentNode.nextInBucket;
            --this.size;
            this.removeFromList(currentNode);
            return currentNode;
        }
        Node<V> previousNode = null;
        while (currentNode != null) {
            if (v.equals(currentNode.getObject())) {
                if (previousNode != null) {
                    previousNode.nextInBucket = currentNode.nextInBucket;
                }
                --this.size;
                this.removeFromList(currentNode);
                return currentNode;
            }
            previousNode = currentNode;
            currentNode = currentNode.nextInBucket;
        }
        return null;
    }

    void removeFromList(Node<V> node) {
        if (this.head == node) {
            this.head = node.nextInOrder;
            if (this.head != null) {
                this.head.prevInOrder = null;
            }
            return;
        }
        if (this.tail == node) {
            this.tail = node.prevInOrder;
            if (this.tail != null) {
                this.tail.nextInOrder = null;
            }
            return;
        }
        node.prevInOrder.nextInOrder = node.nextInOrder;
        node.nextInOrder.prevInOrder = node.prevInOrder;
    }

    boolean checkLength(int sizeChange) {
        if (this.size + sizeChange > this.threshold) {
            this.occupiedBuckets = 0;
            int newLength = 2 * this.table.length;
            Node<V>[] oldTable = this.table;
            Node[] newTable = new Node[newLength];
            for (int i = 0; i < oldTable.length; ++i) {
                if (oldTable[i] == null) continue;
                Node<V> tail1 = null;
                Node<V> tail2 = null;
                Node<V> current = oldTable[i];
                while (current != null) {
                    int newIndex = current.mapHash & newLength - 1;
                    if (newIndex == i) {
                        if (tail1 == null) {
                            newTable[newIndex] = current;
                            ++this.occupiedBuckets;
                        } else {
                            tail1.nextInBucket = current;
                        }
                        tail1 = current;
                    } else {
                        if (tail2 == null) {
                            newTable[newIndex] = current;
                            ++this.occupiedBuckets;
                        } else {
                            tail2.nextInBucket = current;
                        }
                        tail2 = current;
                    }
                    Node next = current.nextInBucket;
                    current.nextInBucket = null;
                    current = next;
                }
            }
            this.threshold = (int)(0.7f * (float)newLength);
            this.table = newTable;
            return true;
        }
        return false;
    }

    void clear() {
        this.table = new Node[this.table.length];
        this.size = 0;
        this.occupiedBuckets = 0;
        this.head = null;
        this.tail = null;
    }

    int getIndex(int hash) {
        return hash & this.table.length - 1;
    }

    void sort(Comparator<V> comparator) {
        if (this.size < 2) {
            return;
        }
        this.head = this.mergeSort(this.head, comparator);
        Iterator<Node<V>> iterator = this.nodeCollection.iterator();
        Node<V> node = null;
        Node<V> prev = null;
        while (iterator.hasNext()) {
            node = iterator.next();
            node.prevInOrder = prev;
            prev = node;
        }
        this.tail = node;
    }

    Node<V> mergeSort(Node<V> h, Comparator<V> comparator) {
        if (h == null || h.nextInOrder == null) {
            return h;
        }
        Node<V> middle = this.getMiddle(h);
        Node middleNext = middle.nextInOrder;
        middle.nextInOrder = null;
        Node<V> left = this.mergeSort(h, comparator);
        Node right = this.mergeSort(middleNext, comparator);
        Node<V> newHead = this.sortedMerge(left, right, comparator);
        return newHead;
    }

    Node<V> sortedMerge(Node<V> a, Node<V> b, Comparator<V> comparator) {
        Node<V> newHead;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (comparator.compare(a.getObject(), b.getObject()) < 0) {
            newHead = a;
            newHead.nextInOrder = this.sortedMerge(a.nextInOrder, b, comparator);
        } else {
            newHead = b;
            newHead.nextInOrder = this.sortedMerge(a, b.nextInOrder, comparator);
        }
        return newHead;
    }

    Node<V> getMiddle(Node<V> head) {
        if (head == null) {
            return null;
        }
        Node<V> slow = head;
        Node<V> fast = head;
        while (fast.nextInOrder != null && fast.nextInOrder.nextInOrder != null) {
            slow = slow.nextInOrder;
            fast = fast.nextInOrder.nextInOrder;
        }
        return slow;
    }

    boolean topologicalSort() {
        if (this.size < 2 || this.graph.getEdgeCount() < 1) {
            return true;
        }
        this.cursor = this.tail;
        boolean success = true;
        while (success && this.cursor != null) {
            success = this.recursiveTopologicalSort(this.cursor, this.graph.algorithms().requestRunID());
        }
        this.cursor = null;
        return success;
    }

    private boolean recursiveTopologicalSort(Node<V> v, int runID) {
        v.resetAlgorithmAttribs(runID);
        if (v.isProcessed()) {
            return true;
        }
        if (v.isSeen()) {
            return false;
        }
        v.setSeen(true);
        ArrayList<Connection<V>> outEdges = v.getOutEdges();
        for (Connection<V> e : outEdges) {
            if (this.recursiveTopologicalSort(e.getNodeB(), runID)) continue;
            return false;
        }
        v.setSeen(false);
        v.setProcessed(true);
        if (this.cursor != v) {
            this.removeFromList(v);
            this.insertIntoListAfter(v, this.cursor);
        } else {
            this.cursor = this.cursor.prevInOrder;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NodeMap - size: ");
        sb.append(this.size);
        sb.append(", table length: ");
        sb.append(this.table.length);
        sb.append(", occupiedBuckets: ");
        sb.append(this.occupiedBuckets);
        sb.append("\n");
        sb.append("--------------");
        sb.append("\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(i);
            sb.append("]  ");
            Node<V> node = this.table[i];
            while (node != null) {
                sb.append(node);
                if (node.nextInBucket != null) {
                    sb.append(" -> ");
                }
                node = node.nextInBucket;
            }
            sb.append("\n");
        }
        return sb.append("--------------").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMap nodeMap = (NodeMap)o;
        if (this.size != nodeMap.size) {
            return false;
        }
        if (this.table.length != nodeMap.table.length) {
            return false;
        }
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) {
                if (nodeMap.table[i] == null) continue;
                return false;
            }
            if (nodeMap.table[i] == null) {
                return false;
            }
            if (this.table[i].equals(nodeMap.table[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.size;
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            result ^= this.table[i].hashCode();
        }
        return result;
    }

    static class NodeIterator<V>
    implements Iterator<Node<V>> {
        final NodeMap<V> nodeMap;
        Node<V> current;

        NodeIterator(NodeMap<V> nodeMap) {
            this.nodeMap = nodeMap;
            this.current = nodeMap.head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node<V> next() {
            if (this.hasNext()) {
                Node<V> next = this.current;
                this.current = this.current.nextInOrder;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("You cannot modify this list - use the Graph object.");
        }
    }
}

