/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.gand.ds.ObjectDeque;
import java.util.Collection;

public class Path<V>
extends ObjectDeque<V>
implements Json.Serializable {
    public static final Path EMPTY_PATH = new Path(0, false);
    private float length = 0.0f;

    public Path() {
    }

    public Path(int capacity) {
        super(capacity);
    }

    public Path(int capacity, boolean resize) {
        super(capacity);
        if (resize) {
            this.size = capacity;
        }
    }

    public Path(Collection<? extends V> coll) {
        super(coll);
    }

    public Path(ObjectDeque<? extends V> deque) {
        super(deque);
    }

    public Path(Path<? extends V> path) {
        super(path);
        this.length = path.length;
    }

    public Path(V[] a) {
        super(a);
    }

    public Path(V[] a, int offset, int count) {
        super(a, offset, count);
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Path path = (Path)o;
        return Float.compare(this.length, path.length) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.length != 0.0f ? NumberUtils.floatToIntBits((float)this.length) : 0);
        return result;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[|length=" + this.length + "]";
        }
        Object[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        sb.append("|length=").append(this.length).append(']');
        return sb.toString();
    }

    @Override
    public String toString(String separator) {
        if (this.size == 0) {
            return "|length=" + this.length;
        }
        Object[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(separator).append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        return sb.append("|length=").append(this.length).toString();
    }

    @Override
    public void write(Json json) {
        json.writeArrayStart("items");
        for (int i = 0; i < this.size; ++i) {
            json.writeValue(this.get(i), null);
        }
        json.writeArrayEnd();
        json.writeValue("len", (Object)Float.valueOf(this.length));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.clear();
        JsonValue value = jsonData.child;
        while (value != null) {
            this.add(json.readValue(null, value));
            value = value.next;
        }
        this.setLength(jsonData.next.asFloat());
    }

    public static <T> Path<T> with(T item) {
        Path path = new Path();
        path.add(item);
        return path;
    }

    @SafeVarargs
    public static <T> Path<T> with(T ... items) {
        return new Path<T>((V[])items);
    }
}

