/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.gand.Int2UndirectedGraph;
import com.github.tommyettinger.gand.Path;
import com.github.tommyettinger.gand.ds.ObjectOrderedSet;
import com.github.tommyettinger.gand.ds.ObjectSet;
import com.github.tommyettinger.gand.utils.FlowRandom;
import com.github.tommyettinger.gdcrux.PointI2;
import java.util.Collection;
import java.util.Random;

public class TwistedLineI2 {
    public Random random;
    public Int2UndirectedGraph graph;
    public final transient Path<PointI2> lastPath;
    private final transient PointI2[] dirs = new PointI2[]{new PointI2(1, 0), new PointI2(0, 1), new PointI2(-1, 0), new PointI2(0, -1)};
    private final transient ObjectOrderedSet<PointI2> frontier = new ObjectOrderedSet();
    private final transient ObjectSet<PointI2> done = new ObjectSet();
    private final transient PointI2 tempPt = new PointI2();

    public TwistedLineI2() {
        this(null, new PointI2[]{new PointI2(0, 0), new PointI2(1, 0)}, 0.0f);
    }

    public TwistedLineI2(Random random, PointI2[] traversable) {
        this(random, traversable, 0.0f);
    }

    public TwistedLineI2(Random random, PointI2[] traversable, float relaxation) {
        this.graph = new Int2UndirectedGraph();
        this.random = random == null ? new FlowRandom() : random;
        this.lastPath = new Path();
        this.reinitialize(traversable, relaxation);
    }

    public void reinitialize(PointI2[] traversable, float relaxation) {
        this.graph.removeAllVertices();
        this.graph.addVertices(traversable);
        PointI2 start = traversable[this.random.nextInt(traversable.length)];
        this.frontier.clear();
        this.done.clear();
        this.frontier.add(start);
        while (!this.frontier.isEmpty()) {
            PointI2 v;
            PointI2 dir;
            int j;
            float cost = 1.0f;
            PointI2 p = this.frontier.getAt(this.frontier.size() - 1);
            if (this.random.nextFloat() >= relaxation) {
                this.shuffle(this.dirs);
                for (j = 0; j < this.dirs.length; ++j) {
                    dir = this.dirs[j];
                    this.tempPt.set(p).add(dir);
                    v = this.graph.getStoredVertex(this.tempPt);
                    if (v == null || this.done.contains(v) || !this.frontier.add(v)) continue;
                    this.graph.addEdge(p, v, cost);
                    cost = 1024.0f;
                }
            } else {
                for (j = 0; j < this.dirs.length; ++j) {
                    dir = this.dirs[j];
                    this.tempPt.set(p).add(dir);
                    v = this.graph.getStoredVertex(this.tempPt);
                    if (v == null || this.done.contains(v)) continue;
                    this.frontier.add(v);
                    this.graph.addEdge(p, v, 1.0f);
                }
            }
            this.done.add(p);
            this.frontier.remove(p);
        }
    }

    public void randomize(float relaxation) {
        if (this.graph.getVertices().isEmpty()) {
            return;
        }
        this.graph.removeAllEdges();
        this.frontier.clear();
        this.done.clear();
        this.frontier.add((PointI2)this.graph.getVertices().iterator().next());
        while (!this.frontier.isEmpty()) {
            PointI2 v;
            PointI2 dir;
            int j;
            float cost = 1.0f;
            PointI2 p = this.frontier.getAt(this.frontier.size() - 1);
            if (this.random.nextFloat() >= relaxation) {
                this.shuffle(this.dirs);
                for (j = 0; j < this.dirs.length; ++j) {
                    dir = this.dirs[j];
                    this.tempPt.set(p).add(dir);
                    v = this.graph.getStoredVertex(this.tempPt);
                    if (v == null || this.done.contains(v) || !this.frontier.add(v)) continue;
                    this.graph.addEdge(p, v, cost);
                    cost = 1024.0f;
                }
            } else {
                for (j = 0; j < this.dirs.length; ++j) {
                    dir = this.dirs[j];
                    this.tempPt.set(p).add(dir);
                    v = this.graph.getStoredVertex(this.tempPt);
                    if (v == null || this.done.contains(v)) continue;
                    this.frontier.add(v);
                    this.graph.addEdge(p, v, 1.0f);
                }
            }
            this.done.add(p);
            this.frontier.remove(p);
        }
    }

    public Path<PointI2> line(PointI2 start, PointI2 end) {
        this.lastPath.clear();
        this.lastPath.addAll(this.graph.algorithms().findShortestPath(start, end, PointI2::dst));
        return this.lastPath;
    }

    public Collection<PointI2> line(Collection<PointI2> path, PointI2 start, PointI2 end) {
        path.addAll(this.graph.algorithms().findShortestPath(start, end, PointI2::dst));
        return path;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random == null ? new FlowRandom() : random;
    }

    public Path<PointI2> getLastPath() {
        return this.lastPath;
    }

    protected <T> void shuffle(T[] items) {
        int offset = 0;
        int length = items.length;
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = offset + this.random.nextInt(i + 1 - offset);
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }
}

