/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.algorithms.UndirectedGraphAlgorithms;
import java.util.Collection;
import java.util.Set;

public class UndirectedGraph<V>
extends Graph<V>
implements Json.Serializable {
    protected final transient UndirectedGraphAlgorithms<V> algorithms = new UndirectedGraphAlgorithms(this);

    public UndirectedGraph() {
    }

    public UndirectedGraph(Collection<V> vertices) {
        super(vertices);
    }

    public UndirectedGraph(Collection<V> vertices, Collection<Edge<V>> edges, float defaultEdgeWeight) {
        super(vertices, edges, defaultEdgeWeight);
    }

    public UndirectedGraph(Graph<V> graph) {
        super(graph);
    }

    @Override
    protected Connection.UndirectedConnection<V> obtainEdge() {
        return new Connection.UndirectedConnection();
    }

    @Override
    Connection<V> addConnection(Node<V> a, Node<V> b, float weight) {
        Connection e = a.getEdge(b);
        if (e == null) {
            Connection e1 = this.obtainEdge();
            Connection e2 = this.obtainEdge();
            ((Connection.UndirectedConnection)e1).link(e2);
            ((Connection.UndirectedConnection)e2).link(e1);
            e1.set(a, b, weight);
            e2.set(b, a, weight);
            a.addEdge(e1);
            b.addEdge(e2);
            this.edgeSet.add(e1);
            e = e1;
        } else {
            e.setWeight(weight);
        }
        return e;
    }

    @Override
    Connection<V> addConnection(Node<V> a, Node<V> b) {
        Connection<V> e = a.getEdge(b);
        return e != null ? this.edgeSet.get(e) : this.addConnection(a, b, this.getDefaultEdgeWeight());
    }

    @Override
    boolean removeConnection(Node<V> a, Node<V> b) {
        Connection<V> e = a.removeEdge(b);
        if (e == null) {
            return false;
        }
        b.removeEdge(a);
        this.edgeSet.remove(e);
        return true;
    }

    @Override
    Connection<V> getEdge(Node<V> a, Node<V> b) {
        Connection<V> edge = a.getEdge(b);
        return edge == null ? null : this.edgeSet.get(edge);
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public UndirectedGraph<V> createNew() {
        return new UndirectedGraph<V>();
    }

    @Override
    public UndirectedGraphAlgorithms<V> algorithms() {
        return this.algorithms;
    }

    public int getDegree(V v) {
        Node<V> node = this.getNode(v);
        return node == null ? -1 : node.getOutDegree();
    }

    public void write(Json json) {
        Set vertices = this.getVertices();
        json.writeArrayStart("v");
        for (Object vertex : vertices) {
            json.writeValue(vertex, null);
        }
        json.writeArrayEnd();
        Set edges = this.getEdges();
        json.writeArrayStart("e");
        for (Edge edge : edges) {
            json.writeValue(edge.getA(), null);
            json.writeValue(edge.getB(), null);
            json.writeValue((Object)Float.valueOf(edge.getWeight()), Float.TYPE);
        }
        json.writeArrayEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        this.removeAllVertices();
        JsonValue entry = jsonData.getChild("v");
        while (entry != null) {
            this.addVertex(json.readValue(null, entry));
            entry = entry.next;
        }
        entry = jsonData.getChild("e");
        while (entry != null) {
            Object object = json.readValue(null, entry);
            JsonValue jsonValue = entry.next;
            entry = jsonValue;
            entry = entry.next;
            this.addEdge(object, json.readValue(null, jsonValue), entry.asFloat());
            entry = entry.next;
        }
    }
}

