/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand;

import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.NodeMap;
import com.github.tommyettinger.gand.utils.Errors;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

class VertexSet<V>
extends AbstractSet<V> {
    final NodeMap<V> nodeMap;

    VertexSet(NodeMap<V> nodeMap) {
        this.nodeMap = nodeMap;
    }

    @Override
    public int size() {
        return this.nodeMap.size;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeMap.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return o != null && this.nodeMap.contains(o);
    }

    @Override
    public Iterator<V> iterator() {
        return new VertexIterator<V>(this.nodeMap);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.nodeMap.size];
        int index = 0;
        Node node = this.nodeMap.head;
        while (node != null) {
            array[index++] = node.getObject();
            node = node.nextInOrder;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.nodeMap.size) {
            array = Arrays.copyOf(array, this.nodeMap.size);
        }
        int index = 0;
        Node node = this.nodeMap.head;
        while (node != null) {
            array[index++] = node.getObject();
            node = node.nextInOrder;
        }
        return array;
    }

    @Override
    public boolean add(V v) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean remove(Object o) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Errors.throwModificationException();
        return false;
    }

    @Override
    public void clear() {
        Errors.throwModificationException();
    }

    static class VertexIterator<V>
    implements Iterator<V> {
        private final NodeMap.NodeIterator<V> nodeIterator;

        VertexIterator(NodeMap<V> nodeMap) {
            this.nodeIterator = new NodeMap.NodeIterator<V>(nodeMap);
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public V next() {
            return ((Node)this.nodeIterator.next()).getObject();
        }

        @Override
        public void remove() {
            Errors.throwModificationException();
        }
    }
}

