/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.algorithms;

import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.Path;
import com.github.tommyettinger.gand.algorithms.Algorithm;
import com.github.tommyettinger.gand.algorithms.AlgorithmPath;
import com.github.tommyettinger.gand.algorithms.BinaryHeap;
import com.github.tommyettinger.gand.algorithms.SearchStep;
import com.github.tommyettinger.gand.utils.Heuristic;
import com.github.tommyettinger.gand.utils.SearchProcessor;
import java.util.ArrayList;

public class AStarSearch<V>
extends Algorithm<V> {
    private Heuristic<V> heuristic;
    private SearchProcessor<V> processor;
    private SearchStep<V> step = new SearchStep();
    private final BinaryHeap heap;
    private Node<V> start;
    private Node<V> target;
    private Node<V> u;
    private Node<V> end;
    private Path<V> path;

    protected AStarSearch(int id, Node<V> start, Node<V> target, Heuristic<V> heuristic, SearchProcessor<V> processor) {
        super(id);
        this.start = start;
        this.target = target;
        this.heuristic = heuristic;
        this.processor = processor;
        this.heap = new BinaryHeap();
        start.resetAlgorithmAttribs(id);
        start.setDistance(0.0f);
        this.heap.add(start);
    }

    @Override
    public boolean update() {
        if (this.isFinished()) {
            return true;
        }
        this.u = this.heap.pop();
        if (!this.u.isProcessed()) {
            if (this.processor != null && this.u.getIndex() > 0) {
                this.step.prepare(this.u);
                this.processor.accept(this.step);
                if (this.step.terminate) {
                    this.heap.clear();
                    return true;
                }
                if (this.step.ignore) {
                    return this.isFinished();
                }
            }
            this.u.setProcessed(true);
            if (this.u == this.target) {
                this.heap.clear();
                this.end = this.u;
                return true;
            }
            ArrayList<Connection<V>> outEdges = this.u.getOutEdges();
            for (Connection<V> e : outEdges) {
                float newDistance;
                Node<V> v = e.getNodeB();
                v.resetAlgorithmAttribs(this.id);
                if (v.isProcessed() || !((newDistance = this.u.getDistance() + e.getWeight()) < v.getDistance())) continue;
                v.setDistance(newDistance);
                v.setPrev(this.u);
                v.setConnection(e);
                if (this.heuristic != null && !v.isSeen()) {
                    v.setEstimate(this.heuristic.getEstimate(v.getObject(), this.target.getObject()));
                }
                if (!v.isSeen()) {
                    this.heap.add(v, v.getDistance() + v.getEstimate());
                } else {
                    this.heap.setValue(v, v.getDistance() + v.getEstimate());
                }
                v.setIndex(this.u.getIndex() + 1);
                v.setSeen(true);
            }
        }
        return this.isFinished();
    }

    @Override
    public boolean isFinished() {
        return this.heap.size == 0;
    }

    public Path<V> getPath() {
        if (!this.isFinished()) {
            return null;
        }
        if (this.path == null) {
            this.path = this.end != null ? new AlgorithmPath<V>(this.end) : Path.EMPTY_PATH;
        }
        return this.path;
    }

    Node<V> getEnd() {
        return this.end;
    }

    private Node<V> aStarSearch(Node<V> start, Node<V> target, Heuristic<V> heuristic, SearchProcessor<V> processor) {
        SearchStep step;
        start.resetAlgorithmAttribs(this.id);
        start.setDistance(0.0f);
        this.heap.add(start);
        SearchStep searchStep = step = processor != null ? new SearchStep() : null;
        while (this.heap.size != 0) {
            Node u = this.heap.pop();
            if (u == target) {
                this.heap.clear();
                return u;
            }
            if (u.isProcessed()) continue;
            if (processor != null && u.getIndex() > 0) {
                step.prepare(u);
                processor.accept(step);
                if (step.terminate) {
                    this.heap.clear();
                    return null;
                }
                if (step.ignore) continue;
            }
            u.setProcessed(true);
            ArrayList outEdges = u.getOutEdges();
            for (Connection e : outEdges) {
                float newDistance;
                Node v = e.getNodeB();
                v.resetAlgorithmAttribs(this.id);
                if (v.isProcessed() || !((newDistance = u.getDistance() + e.getWeight()) < v.getDistance())) continue;
                v.setDistance(newDistance);
                v.setPrev(u);
                v.setConnection(e);
                if (heuristic != null && !v.isSeen()) {
                    v.setEstimate(heuristic.getEstimate(v.getObject(), target.getObject()));
                }
                if (!v.isSeen()) {
                    this.heap.add(v, v.getDistance() + v.getEstimate());
                } else {
                    this.heap.setValue(v, v.getDistance() + v.getEstimate());
                }
                v.setIndex(u.getIndex() + 1);
                v.setSeen(true);
            }
        }
        this.heap.clear();
        return null;
    }
}

