/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.algorithms;

import com.github.tommyettinger.gand.Graph;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.Path;
import com.github.tommyettinger.gand.algorithms.AStarSearch;
import com.github.tommyettinger.gand.algorithms.BreadthFirstSearch;
import com.github.tommyettinger.gand.algorithms.CycleDetector;
import com.github.tommyettinger.gand.algorithms.DepthFirstSearch;
import com.github.tommyettinger.gand.utils.Errors;
import com.github.tommyettinger.gand.utils.Heuristic;
import com.github.tommyettinger.gand.utils.SearchProcessor;

public abstract class Algorithms<V> {
    protected final transient Graph<V> graph;
    private final transient int[] runID = new int[]{-1};

    Algorithms(Graph<V> graph) {
        this.graph = graph;
    }

    public int lastRunID() {
        return this.runID[0];
    }

    public int requestRunID() {
        this.runID[0] = this.runID[0] + 1;
        return this.runID[0];
    }

    public Path<V> findShortestPath(V start, V target) {
        return this.findShortestPath(start, target, null, null);
    }

    public Path<V> findShortestPath(V start, V target, SearchProcessor<V> processor) {
        return this.findShortestPath(start, target, null, processor);
    }

    public Path<V> findShortestPath(V start, V target, Heuristic<V> heuristic) {
        return this.findShortestPath(start, target, heuristic, null);
    }

    public Path<V> findShortestPath(V start, V target, Heuristic<V> heuristic, SearchProcessor<V> processor) {
        AStarSearch<V> search = this.newAstarSeach(start, target, heuristic, processor);
        search.finish();
        return search.getPath();
    }

    public AStarSearch<V> newAstarSeach(V start, V target, Heuristic<V> heuristic, SearchProcessor<V> processor) {
        Node<V> startNode = this.graph.internals().getNode(start);
        Node<V> targetNode = this.graph.internals().getNode(target);
        if (startNode == null || targetNode == null) {
            Errors.throwVertexNotInGraphVertexException(true);
        }
        return new AStarSearch<V>(this.requestRunID(), startNode, targetNode, heuristic, processor);
    }

    public float findMinimumDistance(V start, V target) {
        return this.findMinimumDistance(start, target, null);
    }

    public float findMinimumDistance(V start, V target, Heuristic<V> heuristic) {
        AStarSearch<V> search = this.newAstarSeach(start, target, heuristic, null);
        search.finish();
        if (search.getEnd() == null) {
            return Float.MAX_VALUE;
        }
        return search.getEnd().getDistance();
    }

    public boolean isConnected(V start, V target) {
        return this.findMinimumDistance(start, target) < Float.MAX_VALUE;
    }

    public void breadthFirstSearch(V v, SearchProcessor<V> processor) {
        Node<V> node = this.graph.internals().getNode(v);
        if (node == null) {
            Errors.throwVertexNotInGraphVertexException(false);
        }
        new BreadthFirstSearch<V>(this.requestRunID(), node, processor).finish();
    }

    public void depthFirstSearch(V v, SearchProcessor<V> processor) {
        Node<V> node = this.graph.internals().getNode(v);
        if (node == null) {
            Errors.throwVertexNotInGraphVertexException(false);
        }
        new DepthFirstSearch<V>(this.requestRunID(), node, processor).finish();
    }

    public void dijkstraSearch(V v, SearchProcessor<V> processor) {
        Node<V> node = this.graph.internals().getNode(v);
        if (node == null) {
            Errors.throwVertexNotInGraphVertexException(false);
        }
        new AStarSearch<V>(this.requestRunID(), node, null, null, processor).finish();
    }

    public boolean containsCycle() {
        return new CycleDetector<V>(this.requestRunID(), this.graph).containsCycle();
    }
}

