/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.algorithms;

import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.gand.Node;

class BinaryHeap {
    public int size;
    protected Node[] nodes;

    public BinaryHeap() {
        this(16);
    }

    public BinaryHeap(int capacity) {
        this.nodes = new Node[capacity];
    }

    public Node add(Node node) {
        if (this.size == this.nodes.length) {
            Node[] newNodes = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        node.heapIndex = this.size;
        this.nodes[this.size] = node;
        this.up(this.size++);
        return node;
    }

    public Node add(Node node, float value) {
        node.heapValue = value;
        return this.add(node);
    }

    public boolean contains(Node node, boolean identity) {
        if (identity) {
            for (Node n : this.nodes) {
                if (n != node) continue;
                return true;
            }
        } else {
            for (Node other : this.nodes) {
                if (!other.equals(node)) continue;
                return true;
            }
        }
        return false;
    }

    public Node peek() {
        return this.nodes[0];
    }

    public Node pop() {
        Node[] nodes = this.nodes;
        Node removed = nodes[0];
        nodes[0] = nodes[--this.size];
        nodes[this.size] = null;
        if (this.size > 0) {
            this.down(0);
        }
        return removed;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Node[] nodes = this.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            nodes[i] = null;
        }
        this.size = 0;
    }

    public void setValue(Node node, float value) {
        float oldValue = node.heapValue;
        node.heapValue = value;
        if (value < oldValue) {
            this.up(node.heapIndex);
        } else {
            this.down(node.heapIndex);
        }
    }

    private void up(int index) {
        Node[] nodes = this.nodes;
        Node node = nodes[index];
        float value = node.heapValue;
        while (index > 0) {
            int parentIndex = index - 1 >> 1;
            Node parent = nodes[parentIndex];
            if (!(value < parent.heapValue)) break;
            nodes[index] = parent;
            parent.heapIndex = index;
            index = parentIndex;
        }
        nodes[index] = node;
        node.heapIndex = index;
    }

    private void down(int index) {
        int leftIndex;
        Node[] nodes = this.nodes;
        int size = this.size;
        Node node = nodes[index];
        float value = node.heapValue;
        while ((leftIndex = 1 + (index << 1)) < size) {
            float rightValue;
            Node rightNode;
            int rightIndex = leftIndex + 1;
            Node leftNode = nodes[leftIndex];
            float leftValue = leftNode.heapValue;
            if (rightIndex >= size) {
                rightNode = null;
                rightValue = Float.MAX_VALUE;
            } else {
                rightNode = nodes[rightIndex];
                rightValue = rightNode.heapValue;
            }
            if (leftValue < rightValue) {
                if (leftValue == value || leftValue > value) break;
                nodes[index] = leftNode;
                leftNode.heapIndex = index;
                index = leftIndex;
                continue;
            }
            if (rightValue == value || rightValue > value) break;
            nodes[index] = rightNode;
            rightNode.heapIndex = index;
            index = rightIndex;
        }
        nodes[index] = node;
        node.heapIndex = index;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryHeap)) {
            return false;
        }
        BinaryHeap other = (BinaryHeap)obj;
        if (other.size != this.size) {
            return false;
        }
        Node[] nodes1 = this.nodes;
        Node[] nodes2 = other.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (nodes1[i].heapValue == nodes2[i].heapValue) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + NumberUtils.floatToIntBits((float)this.nodes[i].heapValue);
        }
        return h;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node[] nodes = this.nodes;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(nodes[0].heapValue);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(nodes[i].heapValue);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

