/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.algorithms;

import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.algorithms.Algorithm;
import com.github.tommyettinger.gand.algorithms.SearchStep;
import com.github.tommyettinger.gand.ds.ObjectDeque;
import com.github.tommyettinger.gand.utils.SearchProcessor;
import java.util.ArrayList;

public class DepthFirstSearch<V>
extends Algorithm<V> {
    private SearchProcessor<V> processor;
    private SearchStep<V> step = new SearchStep();
    private final ObjectDeque<Node<V>> queue;

    public DepthFirstSearch(int id, Node<V> start, SearchProcessor<V> processor) {
        super(id);
        this.processor = processor;
        this.queue = new ObjectDeque();
        start.resetAlgorithmAttribs(id);
        this.queue.add(start);
        start.setSeen(true);
    }

    @Override
    public boolean update() {
        if (this.isFinished()) {
            return true;
        }
        Node<V> v = this.queue.pollFirst();
        if (this.processor != null) {
            this.step.prepare(v);
            this.processor.accept(this.step);
            if (this.step.terminate) {
                this.queue.clear();
                return true;
            }
            if (this.step.ignore) {
                return this.isFinished();
            }
        }
        ArrayList<Connection<V>> outEdges = v.getOutEdges();
        for (Connection<V> e : outEdges) {
            Node<V> w = e.getNodeB();
            w.resetAlgorithmAttribs(this.id);
            if (w.isSeen()) continue;
            w.setIndex(v.getIndex() + 1);
            w.setDistance(v.getDistance() + e.getWeight());
            w.setConnection(e);
            w.setSeen(true);
            this.queue.addFirst(w);
        }
        return this.isFinished();
    }

    @Override
    public boolean isFinished() {
        return this.queue.isEmpty();
    }
}

