/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.algorithms;

import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.UndirectedGraph;
import com.github.tommyettinger.gand.algorithms.Algorithm;
import com.github.tommyettinger.gand.ds.ObjectDeque;

public class MinimumWeightSpanningTree<V>
extends Algorithm<V> {
    private UndirectedGraph<V> spanningTree;
    private ObjectDeque<Connection<V>> edgeQueue;
    private int finishAt;

    protected MinimumWeightSpanningTree(int id, UndirectedGraph<V> graph, boolean minSpanningTree) {
        super(id);
        this.spanningTree = graph.createNew();
        this.spanningTree.addVertices(graph.getVertices());
        this.edgeQueue = new ObjectDeque(graph.internals().getConnections());
        if (minSpanningTree) {
            this.edgeQueue.sort((a, b) -> NumberUtils.floatToIntBits((float)(a.getWeight() - b.getWeight() + 0.0f)));
        } else {
            this.edgeQueue.sort((a, b) -> NumberUtils.floatToIntBits((float)(b.getWeight() - a.getWeight() + 0.0f)));
        }
        this.finishAt = graph.isConnected() ? graph.size() - 1 : -1;
    }

    @Override
    public boolean update() {
        if (this.isFinished()) {
            return true;
        }
        Connection<V> edge = this.edgeQueue.poll();
        if (this.doesEdgeCreateCycle(edge.getNodeA(), edge.getNodeB(), this.id)) {
            return false;
        }
        this.spanningTree.addEdge(edge.getA(), edge.getB(), edge.getWeight());
        return this.isFinished();
    }

    private void unionByRank(Node<V> rootU, Node<V> rootV) {
        if (rootU.getIndex() < rootV.getIndex()) {
            rootU.setPrev(rootV);
        } else {
            rootV.setPrev(rootU);
            if (rootU.getIndex() == rootV.getIndex()) {
                rootU.setIndex(rootU.getIndex() + 1);
            }
        }
    }

    private Node<V> find(Node<V> node) {
        if (node.equals(node.getPrev())) {
            return node;
        }
        return this.find(node.getPrev());
    }

    private Node<V> pathCompressionFind(Node<V> node) {
        if (node.equals(node.getPrev())) {
            return node;
        }
        Node<V> parentNode = this.find(node.getPrev());
        node.setPrev(parentNode);
        return parentNode;
    }

    private boolean doesEdgeCreateCycle(Node<V> u, Node<V> v, int runID) {
        Node<V> rootV;
        Node<V> rootU;
        if (u.resetAlgorithmAttribs(runID)) {
            u.setPrev(u);
        }
        if (v.resetAlgorithmAttribs(runID)) {
            v.setPrev(v);
        }
        if ((rootU = this.pathCompressionFind(u)).equals(rootV = this.pathCompressionFind(v))) {
            return true;
        }
        this.unionByRank(rootU, rootV);
        return false;
    }

    @Override
    public boolean isFinished() {
        return this.finishAt < 0 ? this.edgeQueue.isEmpty() : this.spanningTree.getEdgeCount() == this.finishAt;
    }

    public UndirectedGraph<V> getSpanningTree() {
        return this.spanningTree;
    }
}

