/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.algorithms;

import com.github.tommyettinger.gand.Connection;
import com.github.tommyettinger.gand.Edge;
import com.github.tommyettinger.gand.Node;
import com.github.tommyettinger.gand.Path;
import com.github.tommyettinger.gand.algorithms.AlgorithmPath;
import java.util.ArrayList;

public class SearchStep<V> {
    boolean terminate;
    boolean ignore;
    Node<V> node;
    int count = -1;

    SearchStep() {
    }

    void prepare(Node<V> node) {
        this.node = node;
        this.terminate = false;
        this.ignore = false;
        ++this.count;
    }

    public void terminate() {
        this.terminate = true;
    }

    public void ignore() {
        this.ignore = true;
    }

    public V vertex() {
        return this.node.getObject();
    }

    public Edge<V> edge() {
        return this.node.getConnection();
    }

    public V previous() {
        return this.node.getConnection().getA();
    }

    public int depth() {
        return this.node.getIndex();
    }

    public float distance() {
        return this.node.getDistance();
    }

    public int count() {
        return this.count;
    }

    public ArrayList<Connection<V>> neighbors() {
        return this.node.getOutEdges();
    }

    public Path<V> createPath() {
        return new AlgorithmPath<V>(this.node);
    }
}

