/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.ds;

import com.github.tommyettinger.gand.utils.IntConsumer;
import com.github.tommyettinger.gand.utils.IntIterator;
import com.github.tommyettinger.gand.utils.IntPredicate;

public interface IntCollection {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean notEmpty() {
        return this.size() != 0;
    }

    public boolean add(int var1);

    public boolean remove(int var1);

    public boolean contains(int var1);

    default public boolean addAll(IntCollection other) {
        IntIterator it = other.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            changed |= this.add(it.nextInt());
        }
        return changed;
    }

    default public boolean addAll(int[] array) {
        return this.addAll(array, 0, array.length);
    }

    default public boolean addAll(int[] array, int offset, int length) {
        boolean changed = false;
        int i = offset;
        for (int n = 0; n < length && i < array.length; ++i, ++n) {
            changed |= this.add(array[i]);
        }
        return changed;
    }

    default public boolean removeAll(IntCollection other) {
        IntIterator it = other.iterator();
        int originalSize = this.size();
        while (it.hasNext()) {
            int item = it.nextInt();
            IntIterator me = this.iterator();
            while (me.hasNext()) {
                if (me.nextInt() != item) continue;
                me.remove();
            }
        }
        return originalSize != this.size();
    }

    default public boolean removeAll(int[] array) {
        return this.removeAll(array, 0, array.length);
    }

    default public boolean removeAll(int[] array, int offset, int length) {
        int originalSize = this.size();
        int i = offset;
        for (int n = 0; n < length && i < array.length; ++i, ++n) {
            int item = array[i];
            IntIterator me = this.iterator();
            while (me.hasNext()) {
                if (me.nextInt() != item) continue;
                me.remove();
            }
        }
        return originalSize != this.size();
    }

    default public boolean removeEach(IntCollection other) {
        IntIterator it = other.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            changed |= this.remove(it.nextInt());
        }
        return changed;
    }

    default public boolean removeEach(int[] array) {
        return this.removeEach(array, 0, array.length);
    }

    default public boolean removeEach(int[] array, int offset, int length) {
        boolean changed = false;
        int i = offset;
        for (int n = 0; n < length && i < array.length; ++i, ++n) {
            changed |= this.remove(array[i]);
        }
        return changed;
    }

    default public boolean containsAll(IntCollection other) {
        IntIterator it = other.iterator();
        while (it.hasNext()) {
            if (this.contains(it.nextInt())) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(int[] array) {
        return this.containsAll(array, 0, array.length);
    }

    default public boolean containsAll(int[] array, int offset, int length) {
        int i = offset;
        for (int n = 0; n < length && i < array.length; ++i, ++n) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAny(IntCollection other) {
        IntIterator it = other.iterator();
        while (it.hasNext()) {
            if (!this.contains(it.nextInt())) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(int[] array) {
        return this.containsAny(array, 0, array.length);
    }

    default public boolean containsAny(int[] array, int offset, int length) {
        int i = offset;
        for (int n = 0; n < length && i < array.length; ++i, ++n) {
            if (!this.contains(array[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean removeIf(IntPredicate filter) {
        boolean removed = false;
        IntIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextInt())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    default public boolean retainAll(IntCollection other) {
        boolean changed = false;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            if (other.contains(it.nextInt())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    public IntIterator iterator();

    public void clear();

    public int hashCode();

    public boolean equals(Object var1);

    default public int[] toArray() {
        int sz = this.size();
        int[] receiver = new int[sz];
        IntIterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            receiver[i++] = it.nextInt();
        }
        return receiver;
    }

    default public int[] toArray(int[] receiver) {
        int sz = this.size();
        if (receiver.length < sz) {
            receiver = new int[sz];
        }
        IntIterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            receiver[i++] = it.nextInt();
        }
        return receiver;
    }

    default public void forEach(IntConsumer action) {
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            action.accept(it.nextInt());
        }
    }

    default public int first() {
        IntIterator it = this.iterator();
        if (it.hasNext()) {
            return it.nextInt();
        }
        throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
    }

    default public boolean areEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntCollection)) {
            return false;
        }
        IntCollection pc = (IntCollection)other;
        if (this.size() != pc.size()) {
            return false;
        }
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            if (!pc.contains(it.nextInt())) continue;
            return false;
        }
        return true;
    }
}

