/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.ds;

import com.github.tommyettinger.gand.ds.IntCollection;
import com.github.tommyettinger.gand.utils.IntComparator;
import com.github.tommyettinger.gand.utils.IntComparators;
import com.github.tommyettinger.gand.utils.IntIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class IntDeque
implements IntCollection {
    protected int defaultValue = -1;
    protected int[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    protected transient IntDequeIterator iterator1;
    protected transient IntDequeIterator iterator2;
    protected transient IntDequeIterator descendingIterator1;
    protected transient IntDequeIterator descendingIterator2;

    public IntDeque() {
        this(16);
    }

    public IntDeque(int initialSize) {
        this.values = new int[initialSize];
    }

    public IntDeque(IntCollection coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public IntDeque(IntDeque deque) {
        this.values = Arrays.copyOf(deque.values, deque.values.length);
        this.size = deque.size;
        this.head = deque.head;
        this.tail = deque.tail;
        this.defaultValue = deque.defaultValue;
    }

    public IntDeque(int[] a) {
        this.tail = a.length;
        this.values = Arrays.copyOf(a, this.tail);
        this.size = this.tail;
    }

    public IntDeque(int[] a, int offset, int count) {
        this.values = Arrays.copyOfRange(a, offset, offset + count);
        this.tail = count;
        this.size = count;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addLast(int item) {
        int[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        if (this.tail == values.length) {
            this.tail = 0;
        }
        values[this.tail++] = item;
        ++this.size;
    }

    public void addFirst(int item) {
        int[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        int head = this.head;
        if (--head == -1) {
            head = values.length - 1;
        }
        values[head] = item;
        this.head = head;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        int[] newArray = new int[Math.max(1, newSize)];
        if (head < tail) {
            System.arraycopy(values, head, newArray, 0, tail - head);
        } else if (this.size > 0) {
            int rest = values.length - head;
            System.arraycopy(values, head, newArray, 0, rest);
            System.arraycopy(values, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public int removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("IntDeque is empty.");
        }
        int[] values = this.values;
        int result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public int removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("IntDeque is empty.");
        }
        int[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        int result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public boolean offerFirst(int t) {
        int oldSize = this.size;
        this.addFirst(t);
        return oldSize != this.size;
    }

    public boolean offerLast(int t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public int pollFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        int[] values = this.values;
        int result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public int pollLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        int[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        int result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public int getFirst() {
        return this.first();
    }

    public int getLast() {
        return this.last();
    }

    public int peekFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        return this.values[this.head];
    }

    public int peekLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        int[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public boolean removeFirstOccurrence(int o) {
        return this.removeValue(o);
    }

    public boolean removeLastOccurrence(int o) {
        return this.removeLastValue(o);
    }

    @Override
    public boolean add(int t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public boolean add(int index, int item) {
        int oldSize = this.size;
        if (index <= 0) {
            this.addFirst(item);
        } else if (index >= oldSize) {
            this.addLast(item);
        } else {
            int[] values = this.values;
            if (this.size == values.length) {
                this.resize(values.length << 1);
                values = this.values;
            }
            if (this.head < this.tail) {
                if ((index += this.head) >= values.length) {
                    index -= values.length;
                }
                System.arraycopy(values, index, values, (index + 1) % values.length, this.tail - index);
                values[index] = item;
                ++this.tail;
                if (this.tail > values.length) {
                    this.tail = 1;
                }
            } else if (this.head + index < values.length) {
                System.arraycopy(values, this.head, values, this.head - 1, index);
                values[this.head - 1 + index] = item;
                --this.head;
            } else {
                System.arraycopy(values, this.head + (index -= values.length - 1), values, this.head + index + 1, this.tail - this.head - index);
                values[this.head + index] = item;
                ++this.tail;
            }
            ++this.size;
        }
        return oldSize != this.size;
    }

    public boolean insert(int index, int element) {
        return this.add(index, element);
    }

    public boolean offer(int t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public int remove() {
        return this.removeFirst();
    }

    public int poll() {
        return this.pollFirst();
    }

    public int element() {
        return this.first();
    }

    public int peek() {
        return this.peekFirst();
    }

    public void push(int t) {
        this.addFirst(t);
    }

    public int pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(int o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean contains(int o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] toArray() {
        int[] next = new int[this.size];
        if (this.head < this.tail) {
            System.arraycopy(this.values, this.head, next, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.values, this.head, next, 0, this.size - this.head);
            System.arraycopy(this.values, 0, next, this.size - this.head, this.tail);
        }
        return next;
    }

    public void truncate(int newSize) {
        newSize = Math.max(0, newSize);
        if (this.size() > newSize) {
            if (this.head < this.tail) {
                this.tail -= this.size() - newSize;
                this.size = newSize;
            } else if (this.head + newSize < this.values.length) {
                this.tail = this.head + newSize;
                this.size = newSize;
            } else {
                this.tail -= this.size() - newSize;
                this.size = newSize;
            }
        }
    }

    public int indexOf(int value) {
        if (this.size == 0) {
            return -1;
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = head; i < tail; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            int n = values.length;
            for (i = head; i < n; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
            for (i = 0; i < tail; ++i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        if (this.size == 0) {
            return -1;
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = tail - 1; i >= head; --i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            for (i = tail - 1; i >= 0; --i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
            for (i = values.length - 1; i >= head; --i) {
                if (values[i] != value) continue;
                return i - head;
            }
        }
        return -1;
    }

    public boolean removeValue(int value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public boolean removeLastValue(int value) {
        int index = this.lastIndexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public int removeAt(int index) {
        int value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int[] values = this.values;
        int head = this.head++;
        int tail = this.tail--;
        index += head;
        if (head < tail) {
            value = values[index];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
        } else if (index >= values.length) {
            value = values[index -= values.length];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
            --this.tail;
        } else {
            value = values[index];
            System.arraycopy(values, head, values, head + 1, index - head);
            if (this.head == values.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int first() {
        if (this.size == 0) {
            throw new NoSuchElementException("IntDeque is empty.");
        }
        return this.values[this.head];
    }

    public int last() {
        if (this.size == 0) {
            throw new NoSuchElementException("IntDeque is empty.");
        }
        int[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public int get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        int[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        return values[i];
    }

    public int set(int index, int item) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        int[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        int old = values[i];
        values[i] = item;
        return old;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    @Override
    public IntDequeIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new IntDequeIterator(this);
            this.iterator2 = new IntDequeIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public IntDequeIterator descendingIterator() {
        if (this.descendingIterator1 == null || this.descendingIterator2 == null) {
            this.descendingIterator1 = new IntDequeIterator(this, true);
            this.descendingIterator2 = new IntDequeIterator(this, true);
        }
        if (!this.descendingIterator1.valid) {
            this.descendingIterator1.reset();
            this.descendingIterator1.valid = true;
            this.descendingIterator2.valid = false;
            return this.descendingIterator1;
        }
        this.descendingIterator2.reset();
        this.descendingIterator2.valid = true;
        this.descendingIterator1.valid = false;
        return this.descendingIterator2;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(separator).append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int size = this.size;
        int[] values = this.values;
        int backingLength = values.length;
        int index = this.head;
        int hash = size + 1;
        for (int s = 0; s < size; ++s) {
            int value = values[index];
            hash *= 421;
            hash += value;
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntDeque)) {
            return false;
        }
        IntDeque q = (IntDeque)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        int[] myValues = this.values;
        int myBackingLength = myValues.length;
        int[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            int myValue = myValues[myIndex];
            int itsValue = itsValues[itsIndex];
            if (myValue != itsValue) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    public void swap(int first, int second) {
        int s;
        if (first < 0) {
            throw new IndexOutOfBoundsException("first index can't be < 0: " + first);
        }
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first index can't be >= size: " + first + " >= " + this.size);
        }
        if (second < 0) {
            throw new IndexOutOfBoundsException("second index can't be < 0: " + second);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second index can't be >= size: " + second + " >= " + this.size);
        }
        int f = this.head + first;
        int[] values = this.values;
        if (f >= values.length) {
            f -= values.length;
        }
        if ((s = this.head + second) >= values.length) {
            s -= values.length;
        }
        int fv = values[f];
        values[f] = values[s];
        values[s] = fv;
    }

    public void reverse() {
        int[] values = this.values;
        int len = values.length;
        int n = this.size >> 1;
        int b = 0;
        for (int t = this.size - 1; b <= n && b != t; ++b, --t) {
            int s;
            int f = this.head + b;
            if (f >= len) {
                f -= len;
            }
            if ((s = this.head + t) >= len) {
                s -= len;
            }
            int fv = values[f];
            values[f] = values[s];
            values[s] = fv;
        }
    }

    public void sort() {
        if (this.head <= this.tail) {
            Arrays.sort(this.values, this.head, this.tail);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            Arrays.sort(this.values, 0, this.size);
            this.tail = this.size;
            this.head = 0;
        }
    }

    public void sort(IntComparator c) {
        if (this.head <= this.tail) {
            IntComparators.sort(this.values, this.head, this.tail, c);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            IntComparators.sort(this.values, 0, this.size, c);
            this.tail = this.size;
            this.head = 0;
        }
    }

    public int random(Random random) {
        if (this.size <= 0) {
            throw new NoSuchElementException("IntDeque is empty.");
        }
        return this.get(random.nextInt(this.size));
    }

    public static IntDeque with(int item) {
        IntDeque deque = new IntDeque();
        deque.add(item);
        return deque;
    }

    public static IntDeque with(int ... items) {
        return new IntDeque(items);
    }

    public static class IntDequeIterator
    implements IntIterator {
        protected int index;
        protected int latest = -1;
        protected IntDeque deque;
        protected boolean valid = true;
        private final int direction;

        public IntDequeIterator(IntDeque deque) {
            this(deque, false);
        }

        public IntDequeIterator(IntDeque deque, boolean descendingOrder) {
            this.deque = deque;
            this.direction = descendingOrder ? -1 : 1;
        }

        public IntDequeIterator(IntDeque deque, int index, boolean descendingOrder) {
            if (index < 0 || index >= deque.size()) {
                throw new IndexOutOfBoundsException("IntDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.deque = deque;
            this.index = index;
            this.direction = descendingOrder ? -1 : 1;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index;
            this.index += this.direction;
            return this.deque.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == 1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == -1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        public int previousInt() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index -= this.direction;
            return this.deque.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(int t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.set(this.latest, t);
        }

        public void add(int t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.insert(this.index, t);
            this.index += this.direction;
            this.latest = -1;
        }

        public void reset() {
            this.index = this.deque.size - 1 & this.direction >> 31;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.deque.size()) {
                throw new IndexOutOfBoundsException("IntDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public IntDequeIterator iterator() {
            return this;
        }
    }
}

