/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.ds;

public final class Utilities {
    public static final float defaultLoadFactor = 0.5f;
    public static final Object neverIdentical = new Object();

    private Utilities() {
    }

    public static float getDefaultLoadFactor() {
        return 0.5f;
    }

    public static int tableSize(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + capacity);
        }
        int tableSize = 1 << -Integer.numberOfLeadingZeros(Math.max(2, (int)Math.ceil((float)capacity / loadFactor)) - 1);
        if (tableSize > 0x40000000 || tableSize < 0) {
            throw new IllegalArgumentException("The required capacity is too large: " + capacity);
        }
        return tableSize;
    }
}

