/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.smoothing;

import com.github.tommyettinger.crux.Point2;
import com.github.tommyettinger.crux.PointPair;
import com.github.tommyettinger.gand.smoothing.RaycastCollisionDetector;
import com.github.tommyettinger.gand.utils.IntIntPredicate;

public class Bresenham2DRaycastCollisionDetector<P extends Point2<P>>
implements RaycastCollisionDetector<P> {
    private final IntIntPredicate predicate;

    public Bresenham2DRaycastCollisionDetector(IntIntPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean collides(PointPair<P> ray) {
        return Bresenham2DRaycastCollisionDetector.collides(ray, this.predicate);
    }

    public static <P extends Point2<P>> boolean collides(PointPair<P> ray, IntIntPredicate predicate) {
        int tmp;
        boolean steep;
        int x0 = (int)(((Point2)ray.a).x() + 0.5f);
        int y0 = (int)(((Point2)ray.a).y() + 0.5f);
        int x1 = (int)(((Point2)ray.b).x() + 0.5f);
        int y1 = (int)(((Point2)ray.b).y() + 0.5f);
        boolean bl = steep = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        if (steep) {
            tmp = x0;
            x0 = y0;
            y0 = tmp;
            tmp = x1;
            x1 = y1;
            y1 = tmp;
        }
        if (x0 > x1) {
            tmp = x0;
            x0 = x1;
            x1 = tmp;
            tmp = y0;
            y0 = y1;
            y1 = tmp;
        }
        int deltax = x1 - x0;
        int deltay = Math.abs(y1 - y0);
        int error = 0;
        int y = y0;
        int ystep = y0 < y1 ? 1 : -1;
        for (int x = x0; x <= x1; ++x) {
            if (steep ? !predicate.test(y, x) : !predicate.test(x, y)) {
                return true;
            }
            if ((error += deltay) + error < deltax) continue;
            y += ystep;
            error -= deltax;
        }
        return false;
    }
}

