/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.smoothing;

import com.github.tommyettinger.crux.Point3;
import com.github.tommyettinger.crux.PointPair;
import com.github.tommyettinger.gand.smoothing.RaycastCollisionDetector;
import com.github.tommyettinger.gand.utils.IntIntIntPredicate;

public class Bresenham3DRaycastCollisionDetector<P extends Point3<P>>
implements RaycastCollisionDetector<P> {
    private final IntIntIntPredicate predicate;

    public Bresenham3DRaycastCollisionDetector(IntIntIntPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean collides(PointPair<P> ray) {
        return Bresenham3DRaycastCollisionDetector.collides(ray, this.predicate);
    }

    public static <P extends Point3<P>> boolean collides(PointPair<P> ray, IntIntIntPredicate predicate) {
        int x0 = (int)(((Point3)ray.a).x() + 0.5f);
        int y0 = (int)(((Point3)ray.a).y() + 0.5f);
        int z0 = (int)(((Point3)ray.a).z() + 0.5f);
        int x1 = (int)(((Point3)ray.b).x() + 0.5f);
        int y1 = (int)(((Point3)ray.b).y() + 0.5f);
        int z1 = (int)(((Point3)ray.b).z() + 0.5f);
        int dx = x1 - x0;
        int dy = y1 - y0;
        int dz = z1 - z0;
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        int az = Math.abs(dz);
        ax <<= 1;
        ay <<= 1;
        az <<= 1;
        int signx = dx >> 31 | -dx >>> 31;
        int signy = dy >> 31 | -dy >>> 31;
        int signz = dz >> 31 | -dz >>> 31;
        int x = x0;
        int y = y0;
        int z = z0;
        if (ax >= Math.max(ay, az)) {
            int deltay = ay - (ax >> 1);
            int deltaz = az - (ax >> 1);
            while (x != x1) {
                if (!predicate.test(x, y, z)) {
                    return true;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ax;
                }
                x += signx;
                deltay += ay;
                deltaz += az;
            }
        } else if (ay >= Math.max(ax, az)) {
            int deltax = ax - (ay >> 1);
            int deltaz = az - (ay >> 1);
            while (y != y1) {
                if (!predicate.test(x, y, z)) {
                    return true;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= ay;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ay;
                }
                y += signy;
                deltax += ax;
                deltaz += az;
            }
        } else {
            int deltax = ax - (az >> 1);
            int deltay = ay - (az >> 1);
            while (z != z1) {
                if (!predicate.test(x, y, z)) {
                    return true;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= az;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= az;
                }
                z += signz;
                deltax += ax;
                deltay += ay;
            }
        }
        return false;
    }
}

