/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.smoothing;

import com.github.tommyettinger.crux.Point2;
import com.github.tommyettinger.crux.PointPair;
import com.github.tommyettinger.gand.smoothing.RaycastCollisionDetector;
import com.github.tommyettinger.gand.utils.IntIntPredicate;

public class Ortho2DRaycastCollisionDetector<P extends Point2<P>>
implements RaycastCollisionDetector<P> {
    private final IntIntPredicate predicate;

    public Ortho2DRaycastCollisionDetector(IntIntPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean collides(PointPair<P> ray) {
        return Ortho2DRaycastCollisionDetector.collides(ray, this.predicate);
    }

    public static <P extends Point2<P>> boolean collides(PointPair<P> ray, IntIntPredicate predicate) {
        int startX = (int)(((Point2)ray.a).x() + 0.5f);
        int startY = (int)(((Point2)ray.a).y() + 0.5f);
        int targetX = (int)(((Point2)ray.b).x() + 0.5f);
        int targetY = (int)(((Point2)ray.b).y() + 0.5f);
        int dx = targetX - startX;
        int dy = targetY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int x = startX;
        int y = startY;
        if (startX == targetX && startY == targetY) {
            return false;
        }
        int ix = 0;
        int iy = 0;
        while (ix <= nx || iy <= ny) {
            if (x == targetX && y == targetY) {
                return false;
            }
            if (!predicate.test(x, y)) {
                return true;
            }
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                x += signX;
                ++ix;
                continue;
            }
            y += signY;
            ++iy;
        }
        return false;
    }
}

