/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.smoothing;

import com.github.tommyettinger.crux.Point3;
import com.github.tommyettinger.crux.PointPair;
import com.github.tommyettinger.gand.smoothing.RaycastCollisionDetector;
import com.github.tommyettinger.gand.utils.IntIntIntPredicate;

public class Ortho3DRaycastCollisionDetector<P extends Point3<P>>
implements RaycastCollisionDetector<P> {
    private final IntIntIntPredicate predicate;

    public Ortho3DRaycastCollisionDetector(IntIntIntPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean collides(PointPair<P> ray) {
        return Ortho3DRaycastCollisionDetector.collides(ray, this.predicate);
    }

    public static <P extends Point3<P>> boolean collides(PointPair<P> ray, IntIntIntPredicate predicate) {
        int startX = (int)(((Point3)ray.a).x() + 0.5f);
        int startY = (int)(((Point3)ray.a).y() + 0.5f);
        int startZ = (int)(((Point3)ray.a).z() + 0.5f);
        int targetX = (int)(((Point3)ray.b).x() + 0.5f);
        int targetY = (int)(((Point3)ray.b).y() + 0.5f);
        int targetZ = (int)(((Point3)ray.b).z() + 0.5f);
        int dx = targetX - startX;
        int dy = targetY - startY;
        int dz = targetZ - startZ;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        int nz = Math.abs(dz);
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int signZ = dz >> 31 | 1;
        int x = startX;
        int y = startY;
        int z = startZ;
        if (startX == targetX && startY == targetY && startZ == targetZ) {
            return false;
        }
        int ix = 0;
        int iy = 0;
        int iz = 0;
        while (ix <= nx || iy <= ny || iz <= nz) {
            if (x == targetX && y == targetY && z == targetZ) {
                return false;
            }
            if (!predicate.test(x, y, z)) {
                return true;
            }
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                if ((1 + ix + ix) * nz < (1 + iz + iz) * nx) {
                    x += signX;
                    ++ix;
                    continue;
                }
                z += signZ;
                ++iz;
                continue;
            }
            if ((1 + iy + iy) * nz < (1 + iz + iz) * ny) {
                y += signY;
                ++iy;
                continue;
            }
            z += signZ;
            ++iz;
        }
        return false;
    }
}

