/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.smoothing;

import com.badlogic.gdx.utils.TimeUtils;
import com.github.tommyettinger.crux.PointN;
import com.github.tommyettinger.crux.PointPair;
import com.github.tommyettinger.gand.Path;
import com.github.tommyettinger.gand.smoothing.PathSmootherRequest;
import com.github.tommyettinger.gand.smoothing.RaycastCollisionDetector;

public class PathSmoother<V extends PointN<V>> {
    public static final long TIME_TOLERANCE = 100L;
    RaycastCollisionDetector<V> raycastCollisionDetector;
    PointPair<V> ray;

    public PathSmoother(RaycastCollisionDetector<V> raycastCollisionDetector) {
        this.raycastCollisionDetector = raycastCollisionDetector;
    }

    public int smoothPath(Path<V> path) {
        int inputIndex;
        int inputPathLength = path.size();
        if (inputPathLength <= 2) {
            return 0;
        }
        if (this.ray == null) {
            PointN vec = (PointN)path.getFirst();
            this.ray = new PointPair(vec.cpy(), vec.cpy());
        }
        int outputIndex = 1;
        for (inputIndex = 2; inputIndex < inputPathLength; ++inputIndex) {
            this.ray.a.set((PointN)path.get(outputIndex - 1));
            this.ray.b.set((PointN)path.get(inputIndex));
            boolean collides = this.raycastCollisionDetector.collides(this.ray);
            if (!collides) continue;
            path.swap(outputIndex, inputIndex - 1);
            ++outputIndex;
        }
        path.swap(outputIndex, inputIndex - 1);
        path.truncate(outputIndex + 1);
        return inputIndex - outputIndex - 1;
    }

    public boolean smoothPath(PathSmootherRequest<V> request, long timeToRun) {
        long lastTime = TimeUtils.nanoTime();
        Path path = request.path;
        int inputPathLength = path.size();
        if (inputPathLength <= 2) {
            return true;
        }
        if (request.isNew) {
            request.isNew = false;
            if (this.ray == null) {
                PointN vec = (PointN)request.path.getFirst();
                this.ray = new PointPair(vec.cpy(), vec.cpy());
            }
            request.outputIndex = 1;
            request.inputIndex = 2;
        }
        while (request.inputIndex < inputPathLength) {
            long currentTime = TimeUtils.nanoTime();
            if ((timeToRun -= currentTime - lastTime) <= 100L) {
                return false;
            }
            this.ray.a.set((PointN)path.get(request.outputIndex - 1));
            this.ray.b.set((PointN)path.get(request.inputIndex));
            boolean collided = this.raycastCollisionDetector.collides(this.ray);
            if (collided) {
                path.swap(request.outputIndex, request.inputIndex - 1);
                ++request.outputIndex;
            }
            ++request.inputIndex;
            lastTime = currentTime;
        }
        path.swap(request.outputIndex, request.inputIndex - 1);
        path.truncate(request.outputIndex + 1);
        return true;
    }
}

