/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.utils.Compatibility;
import com.github.tommyettinger.gand.utils.GwtIncompatible;
import com.github.tommyettinger.gdcrux.Distributor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Random;

public class Choo32Random
extends Random
implements Json.Serializable,
Externalizable {
    protected int stateA;
    protected int stateB;
    protected int stateC;
    protected int stateD;

    public Choo32Random() {
        this((int)((Math.random() - 0.5) * 4.294967296E9), (int)((Math.random() - 0.5) * 4.294967296E9), (int)((Math.random() - 0.5) * 4.294967296E9), (int)((Math.random() - 0.5) * 4.294967296E9));
    }

    public Choo32Random(long seed) {
        super(seed);
        this.setSeed(seed);
    }

    public Choo32Random(int seed) {
        super(seed);
        this.setSeed(seed);
    }

    public Choo32Random(int stateA, int stateB, int stateC, int stateD) {
        super(stateA);
        this.stateA = stateA;
        this.stateB = stateB;
        this.stateC = stateC;
        this.stateD = stateD;
    }

    public int getStateCount() {
        return 4;
    }

    public int getSelectedState(int selection) {
        switch (selection) {
            case 0: {
                return this.stateA;
            }
            case 1: {
                return this.stateB;
            }
            case 2: {
                return this.stateC;
            }
        }
        return this.stateD;
    }

    public void setSelectedState(int selection, int value) {
        switch (selection) {
            case 0: {
                this.stateA = value;
                break;
            }
            case 1: {
                this.stateB = value;
                break;
            }
            case 2: {
                this.stateC = value;
                break;
            }
            default: {
                this.stateD = value;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
        int a = (int)seed ^ 0xDB4F0B91;
        int b = (int)(seed >>> 16) ^ 0xBBE05633;
        int c = (int)(seed >>> 32) ^ 0xA0F2EC75;
        int d = (int)(seed >>> 48) ^ 0x89E18285;
        a = Compatibility.imul(a ^ a >>> 16, 569420461);
        a = Compatibility.imul(a ^ a >>> 15, 1935289751);
        this.stateA = a ^ a >>> 15;
        b = Compatibility.imul(b ^ b >>> 16, 569420461);
        b = Compatibility.imul(b ^ b >>> 15, 1935289751);
        this.stateB = b ^ b >>> 15;
        c = Compatibility.imul(c ^ c >>> 16, 569420461);
        c = Compatibility.imul(c ^ c >>> 15, 1935289751);
        this.stateC = c ^ c >>> 15;
        d = Compatibility.imul(d ^ d >>> 16, 569420461);
        d = Compatibility.imul(d ^ d >>> 15, 1935289751);
        this.stateD = d ^ d >>> 15;
    }

    public void setSeed(int seed) {
        int a = seed ^ 0xDB4F0B91;
        int b = (seed << 8 | seed >>> 24) ^ 0xBBE05633;
        int c = (seed << 16 | seed >>> 16) ^ 0xA0F2EC75;
        int d = (seed << 24 | seed >>> 8) ^ 0x89E18285;
        a = Compatibility.imul(a ^ a >>> 16, 569420461);
        a = Compatibility.imul(a ^ a >>> 15, 1935289751);
        this.stateA = a ^ a >>> 15;
        b = Compatibility.imul(b ^ b >>> 16, 569420461);
        b = Compatibility.imul(b ^ b >>> 15, 1935289751);
        this.stateB = b ^ b >>> 15;
        c = Compatibility.imul(c ^ c >>> 16, 569420461);
        c = Compatibility.imul(c ^ c >>> 15, 1935289751);
        this.stateC = c ^ c >>> 15;
        d = Compatibility.imul(d ^ d >>> 16, 569420461);
        d = Compatibility.imul(d ^ d >>> 15, 1935289751);
        this.stateD = d ^ d >>> 15;
    }

    public int getStateA() {
        return this.stateA;
    }

    public void setStateA(int stateA) {
        this.stateA = stateA;
    }

    public int getStateB() {
        return this.stateB;
    }

    public void setStateB(int stateB) {
        this.stateB = stateB;
    }

    public int getStateC() {
        return this.stateC;
    }

    public void setStateC(int stateC) {
        this.stateC = stateC;
    }

    public int getStateD() {
        return this.stateD;
    }

    public void setStateD(int stateD) {
        this.stateD = stateD;
    }

    public void setState(int stateA, int stateB, int stateC, int stateD) {
        this.stateA = stateA;
        this.stateB = stateB;
        this.stateC = stateC;
        this.stateD = stateD;
    }

    @Override
    public long nextLong() {
        int fa = this.stateA;
        int fb = this.stateB;
        int fc = this.stateC;
        int fd = this.stateD;
        int ga = fb - fc;
        int gb = fa ^ fd;
        int gc = fb << fa | fb >>> -fa;
        int gd = fd + -1380601499;
        int hi = ga + gb + gc + gd;
        hi = Compatibility.imul(hi ^ hi >>> 15, 1935289751);
        this.stateA = gb - gc | 0;
        this.stateB = ga ^ gd;
        this.stateC = gb << ga | gb >>> -ga;
        this.stateD = gd + -1380601499 | 0;
        int lo = this.stateA + this.stateB + this.stateC + this.stateD;
        lo = Compatibility.imul(lo ^ lo >>> 15, 1935289751);
        return (long)(hi ^ hi >>> 16) << 32 ^ (long)(lo ^ lo >>> 16);
    }

    public long previousLong() {
        int ga = this.stateA;
        int gb = this.stateB;
        int gc = this.stateC;
        int gd = this.stateD;
        int lo = ga + gb + gc + gd;
        lo = Compatibility.imul(lo ^ lo >>> 15, 1935289751);
        int fd = gd - -1380601499;
        int fa = gb ^ fd;
        int fb = gc >>> fa | gc << -fa;
        int fc = fb - ga;
        int hi = fa + fb + fc + fd;
        hi = Compatibility.imul(hi ^ hi >>> 15, 1935289751);
        this.stateD = fd - -1380601499 | 0;
        this.stateA = fb ^ this.stateD;
        this.stateB = fc >>> this.stateA | fc << -this.stateA;
        this.stateC = this.stateB - fa | 0;
        return (long)(lo ^ lo >>> 16) ^ (long)(hi ^ hi >>> 16) << 32;
    }

    public int previousInt() {
        int ga = this.stateA;
        int gb = this.stateB;
        int gc = this.stateC;
        int gd = this.stateD;
        int res = ga + gb + gc + gd;
        res = Compatibility.imul(res ^ res >>> 15, 1935289751);
        this.stateD = gd - -1380601499 | 0;
        this.stateA = gb ^ this.stateD;
        this.stateB = gc >>> this.stateA | gc << -this.stateA;
        this.stateC = this.stateB - ga | 0;
        return res ^ res >>> 16;
    }

    @Override
    public int next(int bits) {
        int fa = this.stateA;
        int fb = this.stateB;
        int fc = this.stateC;
        int fd = this.stateD;
        this.stateA = fb - fc | 0;
        this.stateB = fa ^ fd;
        this.stateC = fb << fa | fb >>> -fa;
        this.stateD = fd + -1380601499 | 0;
        int res = this.stateA + this.stateB + this.stateC + this.stateD;
        res = Compatibility.imul(res ^ res >>> 15, 1935289751);
        return (res ^ res >>> 16) >>> 32 - bits;
    }

    @Override
    public int nextInt() {
        int fa = this.stateA;
        int fb = this.stateB;
        int fc = this.stateC;
        int fd = this.stateD;
        this.stateA = fb - fc | 0;
        this.stateB = fa ^ fd;
        this.stateC = fb << fa | fb >>> -fa;
        this.stateD = fd + -1380601499 | 0;
        int res = this.stateA + this.stateB + this.stateC + this.stateD;
        res = Compatibility.imul(res ^ res >>> 15, 1935289751);
        return res ^ res >>> 16;
    }

    @Override
    public int nextInt(int bound) {
        return (int)((long)bound * ((long)this.nextInt() & 0xFFFFFFFFL) >> 32) & ~(bound >> 31);
    }

    public int nextSignedInt(int outerBound) {
        outerBound = (int)((long)outerBound * ((long)this.nextInt() & 0xFFFFFFFFL) >> 32);
        return outerBound + (outerBound >>> 31);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            int r = this.nextInt();
            int n = Math.min(bytes.length - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)r;
                r >>>= 8;
            }
        }
    }

    @Override
    public long nextLong(long inner, long outer) {
        long randLow = (long)this.nextInt() & 0xFFFFFFFFL;
        long randHigh = (long)this.nextInt() & 0xFFFFFFFFL;
        if (inner >= outer) {
            return inner;
        }
        long bound = outer - inner;
        long boundLow = bound & 0xFFFFFFFFL;
        long boundHigh = bound >>> 32;
        return inner + (randHigh * boundLow >>> 32) + (randLow * boundHigh >>> 32) + randHigh * boundHigh;
    }

    public long nextSignedLong(long inner, long outer) {
        if (outer < inner) {
            long t = outer;
            outer = inner + 1L;
            inner = t + 1L;
        }
        long bound = outer - inner;
        long randLow = (long)this.nextInt() & 0xFFFFFFFFL;
        long randHigh = (long)this.nextInt() & 0xFFFFFFFFL;
        long boundLow = bound & 0xFFFFFFFFL;
        long boundHigh = bound >>> 32;
        return inner + (randHigh * boundLow >>> 32) + (randLow * boundHigh >>> 32) + randHigh * boundHigh;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        return Distributor.normal((long)this.nextLong());
    }

    public String serializeToString() {
        return this.stateA + "~" + this.stateB + "~" + this.stateC + "~" + this.stateD;
    }

    public Choo32Random deserializeFromString(String data) {
        if (data == null || data.length() < 7) {
            return this;
        }
        int tilde = data.indexOf(126);
        this.stateA = Integer.parseInt(data.substring(0, tilde));
        int n = tilde + 1;
        tilde = data.indexOf(126, tilde + 1);
        this.stateB = Integer.parseInt(data.substring(n, tilde));
        int n2 = tilde + 1;
        tilde = data.indexOf(126, tilde + 1);
        this.stateC = Integer.parseInt(data.substring(n2, tilde));
        this.stateD = Integer.parseInt(data.substring(tilde + 1));
        return this;
    }

    public float nextInclusiveFloat() {
        return (float)(0x1000001L * ((long)this.nextInt() & 0xFFFFFFFFL) >> 32) * 5.9604645E-8f;
    }

    public Choo32Random copy() {
        return new Choo32Random(this.stateA, this.stateB, this.stateC, this.stateD);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Choo32Random that = (Choo32Random)o;
        return this.stateA == that.stateA && this.stateB == that.stateB && this.stateC == that.stateC && this.stateD == that.stateD;
    }

    public String toString() {
        return "Choo32Random{stateA=" + this.stateA + ", stateB=" + this.stateB + ", stateC=" + this.stateC + ", stateD=" + this.stateD + "}";
    }

    public void write(Json json) {
        json.writeObjectStart("choo");
        json.writeValue("a", (Object)this.stateA);
        json.writeValue("b", (Object)this.stateB);
        json.writeValue("c", (Object)this.stateC);
        json.writeValue("d", (Object)this.stateD);
        json.writeObjectEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        jsonData = jsonData.get("choo");
        this.stateA = jsonData.getInt("a");
        this.stateB = jsonData.getInt("b");
        this.stateC = jsonData.getInt("c");
        this.stateD = jsonData.getInt("d");
    }

    @Override
    @GwtIncompatible
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.stateA);
        out.writeInt(this.stateB);
        out.writeInt(this.stateC);
        out.writeInt(this.stateD);
    }

    @Override
    @GwtIncompatible
    public void readExternal(ObjectInput in) throws IOException {
        this.stateA = in.readInt();
        this.stateB = in.readInt();
        this.stateC = in.readInt();
        this.stateD = in.readInt();
    }
}

