/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.crux.Point2;

public enum Direction {
    UP(0, 1),
    DOWN(0, -1),
    LEFT(-1, 0),
    RIGHT(1, 0),
    UP_LEFT(-1, 1),
    UP_RIGHT(1, 1),
    DOWN_LEFT(-1, -1),
    DOWN_RIGHT(1, -1),
    NONE(0, 0);

    public static final Direction[] CARDINALS;
    public static final Direction[] CARDINALS_CLOCKWISE;
    public static final Direction[] CARDINALS_COUNTERCLOCKWISE;
    public static final Direction[] DIAGONALS;
    public static final Direction[] OUTWARDS;
    public static final Direction[] CLOCKWISE;
    public static final Direction[] COUNTERCLOCKWISE;
    public final int deltaX;
    public final int deltaY;

    public static Direction getDirection(float x, float y) {
        if (x == 0.0f && y == 0.0f) {
            return NONE;
        }
        return COUNTERCLOCKWISE[(int)(MathUtils.atan2Deg360((float)y, (float)x) * 0.022222223f + 6.5f) & 7];
    }

    public static Direction getCardinalDirection(int x, int y) {
        if ((x | y) == 0) {
            return NONE;
        }
        return CARDINALS_COUNTERCLOCKWISE[(int)(MathUtils.atan2Deg360((float)y, (float)x) * 0.011111111f + 3.5f) & 3];
    }

    public static Direction toGoTo(Point2<?> from, Point2<?> to) {
        return Direction.getDirection(to.x() - from.x(), to.y() - from.y());
    }

    public boolean isDiagonal() {
        return (this.deltaX & this.deltaY) != 0;
    }

    public boolean isCardinal() {
        return (this.deltaX + this.deltaY & 1) == 1;
    }

    private Direction(int x, int y) {
        this.deltaX = x;
        this.deltaY = y;
    }

    static {
        CARDINALS = new Direction[]{UP, DOWN, LEFT, RIGHT};
        CARDINALS_CLOCKWISE = new Direction[]{UP, RIGHT, DOWN, LEFT};
        CARDINALS_COUNTERCLOCKWISE = new Direction[]{UP, LEFT, DOWN, RIGHT};
        DIAGONALS = new Direction[]{UP_LEFT, UP_RIGHT, DOWN_LEFT, DOWN_RIGHT};
        OUTWARDS = new Direction[]{UP, DOWN, LEFT, RIGHT, UP_LEFT, UP_RIGHT, DOWN_LEFT, DOWN_RIGHT};
        CLOCKWISE = new Direction[]{UP, UP_RIGHT, RIGHT, DOWN_RIGHT, DOWN, DOWN_LEFT, LEFT, UP_LEFT};
        COUNTERCLOCKWISE = new Direction[]{UP, UP_LEFT, LEFT, DOWN_LEFT, DOWN, DOWN_RIGHT, RIGHT, UP_RIGHT};
    }
}

