/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.utils.GwtIncompatible;
import com.github.tommyettinger.gdcrux.Distributor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Random;

public class FlowRandom
extends Random
implements Json.Serializable,
Externalizable {
    public long stateA;
    public long stateB;

    private static long seedFromMath() {
        return (long)((Math.random() - 0.5) * 4.503599627370496E15) ^ (long)((Math.random() - 0.5) * 1.8446744073709552E19);
    }

    public FlowRandom() {
        this.stateA = FlowRandom.seedFromMath();
        this.stateB = FlowRandom.seedFromMath();
    }

    public FlowRandom(long seed) {
        super(seed);
        this.setSeed(seed);
    }

    public FlowRandom(long stateA, long stateB) {
        super(stateA);
        this.stateA = stateA;
        this.stateB = stateB;
    }

    public void setState(long stateA, long stateB) {
        this.stateA = stateA;
        this.stateB = stateB;
    }

    @Override
    public void setSeed(long seed) {
        this.stateA = seed;
        this.stateB = seed ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long nextLong() {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return x ^ x >>> 27;
    }

    @Override
    public int next(int bits) {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return (int)(x ^ x >>> 27) >>> 32 - bits;
    }

    @Override
    public int nextInt() {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return (int)(x ^ x >>> 27);
    }

    @Override
    public int nextInt(int bound) {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return (int)((long)bound * ((x ^ x >>> 27) & 0xFFFFFFFFL) >> 32) & ~(bound >> 31);
    }

    @Override
    public boolean nextBoolean() {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        return ((x = (x ^ x >>> 33) * 2047365380309298741L) ^ x >>> 27) < 0L;
    }

    @Override
    public float nextFloat() {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return (float)(x >>> 40) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return (double)((x ^ x >>> 27) >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        long x = this.stateA += -3335678366873096957L;
        long y = this.stateB += -8306560040656073257L;
        x = (x ^ (y << 37 | y >>> 27)) * 4357703544722667091L;
        x = (x ^ x >>> 33) * 2047365380309298741L;
        return Distributor.normal((long)(x ^ x >>> 27));
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            long r = this.nextLong();
            long n = Math.min(bytes.length - i, 8);
            while (n-- > 0L) {
                bytes[i++] = (byte)r;
                r >>>= 8;
            }
        }
    }

    public String serializeToString() {
        return this.stateA + "~" + this.stateB;
    }

    public FlowRandom deserializeFromString(String data) {
        if (data == null || data.length() < 3) {
            return this;
        }
        int tilde = data.indexOf(126);
        this.stateA = Long.parseLong(data.substring(0, tilde));
        this.stateB = Long.parseLong(data.substring(tilde + 1));
        return this;
    }

    public FlowRandom copy() {
        return new FlowRandom(this.stateA, this.stateB);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowRandom random = (FlowRandom)o;
        if (this.stateA != random.stateA) {
            return false;
        }
        return this.stateB == random.stateB;
    }

    public int hashCode() {
        int result = (int)(this.stateA ^ this.stateA >>> 32);
        result = 31 * result + (int)(this.stateB ^ this.stateB >>> 32);
        return result;
    }

    public String toString() {
        return "FlowRandom{stateA=" + this.stateA + ", stateB=" + this.stateB + '}';
    }

    public void write(Json json) {
        json.writeObjectStart("flow");
        json.writeValue("a", (Object)this.stateA);
        json.writeValue("b", (Object)this.stateB);
        json.writeObjectEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        jsonData = jsonData.get("flow");
        this.stateA = jsonData.getLong("a");
        this.stateB = jsonData.getLong("b");
    }

    @Override
    @GwtIncompatible
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.stateA);
        out.writeLong(this.stateB);
    }

    @Override
    @GwtIncompatible
    public void readExternal(ObjectInput in) throws IOException {
        this.stateA = in.readLong();
        this.stateB = in.readLong();
    }
}

